import { TMapMngr, TFclt } from "/js/vworld/map-mngr.js";
import { LayerType, LayerIndex, EditLinkColor } from "/js/vworld/map-const.js";
import { apiGet } from "/js/utils/restApi.js";

let _mapManager     = null;
let _selectFcltNmbr = null;
let _managerData    = [];
const _lyrIdx       = LayerIndex.Vds;
const _lyrType      = LayerType.LINK;
const _lyrLinkIdx   = LayerIndex.Link1;
const _pageName     = 'VDS 검지기 관리';
const _vdsCtrlMap   = new Map()
const _selObjMap    = new Map();
let _prevLinkId = null;
class TSelObj {
    constructor(ID, COORDX, COORDY) {
        this.id = ID;
        this.coordX = COORDX;
        this.coordY = COORDY;
    }
}

//우측 섹션 관련
let _listTable       = null;
let ctlrSelBtn       = null;
let linkBtn          = null;
let linkId           = null;
let ctlrMngmNmbr     = null;
let dtctNmbr         = null;
let istlLane         = null;
let minSped          = null;
let maxSped          = null;
let minTfvl          = null;
let maxTfvl          = null;
let minOcpyRate      = null;
let maxOcpyRate      = null;
let vdsDtctNm        = null;
let dtctTypeCd       = null;
let saveBtn          = null;
let cancleBtn        = null;
let idArr            = [];
let dtcdTypeArr      = [];

// 모달 관련
let modalData        = [];
let vdsCtrlInfoTable = null;

const _updateColumns ={
    chnl_nmbr: null,
    ctlr_mngm_nmbr: null,
    del_yn: "N",
    det_nmbr: null,
    dtct_nmbr: null,
    dtct_type_cd: null,
    dtct_vald_dstc: 0,
    istl_lane: 0,
    link_id: 0,
    max_ocpy_rate: 0,
    max_sped: 0,
    max_tfvl: 0,
    mdvh_lwlm_lngt: 0,
    mdvh_uplm_lngt: 0,
    min_ocpy_rate: 0,
    min_sped: 0,
    min_tfvl: 0,
    snst: 0,
    stln_dstc: 0,
    use_yn: 'Y',
    vds_dtct_nm: null,
  }

//공통
let _apiUri        = '/api/Vds/manager/dtct';
const pageMsg        = '검지기'
const inputArr = [
    ctlrMngmNmbr = {
        no       : false,
        box      : null,
        option   : 100,
        readOnly : true,
        must     : true,
        label    : "제어기번호",
        column   : "ctlr_mngm_nmbr",
        max      : 20,
    },
    dtctNmbr = {
        no       : false,
        box      : null,
        option   : 240,
        readOnly : false,
        must     : true,
        id       : true,
        label    : "검지기번호",
        column   : "dtct_nmbr",
        max      : 8,
    },
    istlLane = {
        no       : true,
        box      : null,
        option   : 240,
        readOnly : false,
        must     : true,
        label    : "설치차로",
        format   : "#",
        column   : "istl_lane",
        min      : 1,
        max      : 99,
    },
    vdsDtctNm= {
        box      : null,
        option   : 240,
        readOnly : false,
        must     : true,
        label    : "검지기명칭",
        column   : "vds_dtct_nm",
        max      : 40,
    },
    linkId = {
        no       : true,
        box      : null,
        option   : 100,
        readOnly : true,
        must     : true,
        label    : "링크ID",
        column   : "link_id",
        format   : "#",
        min      : 0,
        max      : null,
    },
    minSped = {
        no       : true,
        box      : null,
        option   : 110,
        readOnly : false,
        baseVal  : '0',
        column   : "min_sped",
        format   : "#0",
        must     : true,
        label    : "최저속도[km/h]",
        and      : "가",
        min      : 0,
        max      : 160,
    },
    maxSped = {
        no       : true,
        box      : null,
        option   : 110,
        readOnly : false,
        baseVal  : '160',
        column   : "max_sped",
        format   : "#0",
        must     : true,
        label    : "최고속도[km/h]",
        min      : 0,
        max      : 160,
    },
    minTfvl = {
        no       : true,
        box      : null,
        option   : 110,
        readOnly : false,
        baseVal  : '0',
        column   : "min_tfvl",
        format   : "#0",
        must     : true,
        label    : "최소교통량",
        and      : "이",
        min      : 0,
        max      : 100,
    },
    maxTfvl = {
        no       : true,
        box      : null,
        option   : 110,
        readOnly : false,
        baseVal  : '100',
        column   : "max_tfvl",
        format   : "#0",
        must     : true,
        label    : "최대교통량",
        min      : 0,
        max      : 100,
    },
    minOcpyRate = {
        no       : true,
        box      : null,
        option   : 110,
        readOnly : false,
        baseVal  : '0',
        column   : "min_ocpy_rate",
        format   : '#0.##',
        must     : true,
        label    : "최소점유율",
        and      : "이",
        min      : 0,
        max      : 100,
    },
    maxOcpyRate = {
        no       : true,
        box      : null,
        option   : 110,
        readOnly : false,
        baseVal  : '100',
        column   : "max_ocpy_rate",
        format   : "#0.##",
        must     : true,
        label    : "최대점유율",
        min      : 0,
        max      : 100,
    },
]

dtctTypeCd = {
    box      : null,
    option   : 240,
    readOnly : false,
    column   : "dtct_type_cd",
    max      : 5,
}

const infoBtnArr = [
    ctlrSelBtn = {
        class    : 'ctlr-sel-btn',
        text     : '제어기 선택',
        box      : null,
        option   : 110,
        disabled : true,
        mehtod   : function(){
            $(".modal-background").css('display','flex')
            
            vdsCtrlInfoTable.refresh().done(()=>{
                vdsCtrlInfoTable.clearSelection();
                vdsCtrlInfoTable.option('focusedRowIndex', 0);
            });
        }
    },
    linkBtn = {
        class   : 'link-btn',
        text     : '링크 선택',
        box      : null,
        option   : 110,
        disabled : true,
    },
    {
        class   : 'trust-opt-btn',
        text     : '기본값 셋팅',
        box      : null,
        option   : 110,
        disabled : true,
        mehtod   : function(){
            inputArr.map((item)=>{
                if(item.baseVal){
                    item.box.option('value', item.baseVal);
                }
            })
        }
    },
]

const btnArr    = [
    {
        class       : "edit-btn",
        box         : null,
        option      : 80,
        visible     : true,
        disabled    : true,
        dbdsb       : false,
        edit        : {
            click   : {
                visible  : false,
                disabled : false,
            },
            cancle : {
                visible  : true,
                disabled : false,
            }
        },
        add         : {
            click   : {
                visible  : false,
                disabled : false,
            },
            selected : {
                visible  : true,
                disabled : false,
            }
            ,
            unSelected : {
                visible  : true,
                disabled : true,
            },
        }
        ,
        addvsb      : false,
        icon        : "edit",
        text        : "편집",
        method      : function(){
            editEvent();
        }
    },
    cancleBtn = {
        class       : "cancle-btn",
        box         : null,
        option      : 80,
        visible     : false,
        disabled    : false,
        dbdsb       : false,
        edit        : {
            click   : {
                visible  : true,
                disabled : false,
            },
            cancle : {
                visible  : false,
                disabled : false,
            }
        },
        add         : {
            click   : {
                visible  : true,
                disabled : false,
            },
            selected : {
                visible  : false,
                disabled : false,
            }
            ,
            unSelected : {
                visible  : false,
                disabled : false,
            },
        },
        addvsb      : true,
        icon        : "close",
        text        : "취소",
    },
    {
        class       : "add-btn",
        box         : null,
        option      : 80,
        disabled    : false,
        visible     : true,
        edit        : {
            click   : {
                visible  : true,
                disabled : true,
            },
            cancle : {
                visible  : true,
                disabled : false,
            }
        },
        add         : {
            click   : {
                visible  : true,
                disabled : true,
            },
            selected : {
                visible  : true,
                disabled : false,
            }
            ,
            unSelected : {
                visible  : true,
                disabled : false,
            },
        },
        dbdsb       : false,
        adddsb      : true,
        icon        : "plus",
        text        : "추가",
        method      : function(){
            addEvent();
        }
    },
    {
        class       : "del-btn",
        box         : null,
        option      : 80,
        disabled    : true,
        visible     : true,
        edit        : {
            click   : {
                visible  : true,
                disabled : true,
            },
            cancle : {
                visible  : true,
                disabled : false,
            }
        },
        add         : {
            click   : {
                visible  : true,
                disabled : true,
            },
            selected : {
                visible  : true,
                disabled : false,
            }
            ,
            unSelected : {
                visible  : true,
                disabled : true,
            },
        },
        dbdsb       : false,
        adddsb      : true,
        icon        : "minus",
        text        : "삭제",
        method      : function(){
            confirmMessage(pageMsg 
                + " ID : " 
                + _listTable.getSelectedRowsData()[0].dtct_nmbr 
                + "<br>선택하신 " 
                + pageMsg 
                + " 정보를 삭제하시겠습니까?").done((yes)=>{
                    if (yes === true){
                        const selectedData = _listTable.getSelectedRowsData()[0];
                        const ctlrNum = selectedData.ctlr_mngm_nmbr;
                        const dtctNum = selectedData.dtct_nmbr;
                        const result = deleteData(_apiUri, dtctNum);
                        if (result > 0) {
                            delResultMsg(pageMsg);
                            boxInit();
                            buttonReset('add','unSelected');
                            _listTable.option('focusedRowKey', null);
                            _managerData = refresh( _listTable, _managerData, _apiUri);
                            updateIcon();
                            const ctlrArr = _vdsCtrlMap.get(ctlrNum + '_obj');
                            if (ctlrArr) {
                                let delIdx = ctlrArr.findIndex((item)=> item.dtct_nmbr === dtctNum);
                                ctlrArr.splice(delIdx, 1);
                                _vdsCtrlMap.set(ctlrNum + '_obj', ctlrArr);
                                if (ctlrArr.length === 0) {
                                    _vdsCtrlMap.delete(ctlrNum + '_obj');
                                }
                            }
                            if (_prevLinkId !== null) {
                                _mapManager.updateEditLink(_lyrLinkIdx, _prevLinkId, 0, true);    
                                _prevLinkId = null;
                            }
                        }
                        //return alertError( pageMsg+' 정보가 삭제되지 않았습니다.')
                    }
                });
        }
    },
    saveBtn = {
        class       : "save-btn",
        box         : null,
        option      : 80,
        disabled    : true,
        dbdsb       : true,
        edit        : {
            click   : {
                visible  : true,
                disabled : false,
            },
            cancle : {
                visible  : true,
                disabled : true,
            }
        },
        add         : {
            click   : {
                visible  : true,
                disabled : false,
            },
            selected : {
                visible  : true,
                disabled : true,
            }
            ,
            unSelected : {
                visible  : true,
                disabled : true,
            },
        },
        adddsb      : false,
        visible     : true,
        icon        : "save",
        text        : "저장",
    },
   
]

const vdsInfoModal = $(`
<div class="modal-background">
    <div class="modal-container b0">
        <div class="b0">
            <div class="modal-title-box">
                <div>VDS 제어기 정보</div>
                <div>
                    <div class="modal-cancle"></div>
                </div>
            </div>
            <div class="vds-ctrl-info">
                <div class="vds-ctrl-info-box b0">
                    <div class="serve-title">제어기 목록</div>
                    <div>
                        <div class="vds-ctrl-info-table"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>`
)

const modalCancleBtn = $(vdsInfoModal).children().eq(0).children().eq(0).children().eq(0).children().eq(1).children().eq(0)
const modalTableDiv = $(vdsInfoModal).children().eq(0).children().eq(0).children().eq(1).children().eq(0).children().eq(1).children().eq(0)
$(()=>{
   
    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton("instance")
    
    //텍스트 박스 화면 세팅
    inputArr.map((item)=>{
            if(item.no){
                item.box = $("." + item.column).dxNumberBox({
                    width       : item.option,
                    stylingMode : 'outlined',
                    readOnly    : true,
                    min         : item.min,
                    max         : item.max,
                    format      : item.format,
                    value       : null,
                    height      : 27,
                }).dxNumberBox("instance");
    
                if(item.method){
                    item.box.on("change",item.method);
                }
                if(item.value){
                    item.box.option("value",item.value);
                }
                return false;
            }

            item.box = $("." + item.column).dxTextBox({
                width       : item.option,
                stylingMode : 'outlined',
                readOnly    : true,
                maxLength   : item.max,
                height      : 27,
            }).dxTextBox("instance");
            
            if(item.method){
                item.box.on("valueChanged",item.method);
            }
            
            if(item.value){
                item.box.option("value",item.value);
            }
          
           
    })

    infoBtnArr.map((item)=>{
        item.box = $('.' + item.class).dxButton({
            width       : item.option,
            text        : item.text,
            stylingMode : 'outlined',
            disabled    : true,
            height      : 27,
            onClick(){
                if(item.mehtod){
                    item.mehtod();
                }
            }
        }).dxButton('instance')
    })

    //버튼 박스 화면 세팅
    btnArr.map((item)=>{
        item.box = $("." + item.class).dxButton({
            icon              : item.icon,
            width             : item.option,
            text              : item.text,
            visible           : item.visible,
            disabled          : item.disabled,
            focusStateEnabled : false,
            stylingMode       : 'outlined',
            onClick(){
                if(item.method){
                    item.method();
                }
            }
        }).dxButton("instance")
    })

    //방향 셀렉트
    dtctTypeCd.box = $('.' + dtctTypeCd.column).dxSelectBox({
        items       : null,
        stylingMode : 'outlined',
        width       : 240,
        height      : 27.5,
        readOnly    : true,
        displayExpr : 'dtct_type_desc',
        valueExpr   : 'dtct_type_cd',
    }).dxSelectBox('instance');

    $('body').append(vdsInfoModal);
    vdsInfoModal.css('display','none');

    //모달 창 닫기 
    $(modalCancleBtn).dxButton({
        icon : 'close',
        stylingMode: 'text',
        onClick(){
            vdsInfoModal.css('display','none');
        }
    })

    //제어기 선택 테이블
    vdsCtrlInfoTable = $(modalTableDiv).width("100%").height("100%").dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        focusedRowEnabled       : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode: 'single',
        },
        keyExpr : 'ctlr_mngm_nmbr',
        headerFilter: {
            visible: true,
        },
        scrolling: {
            mode: 'virtual',
        },
        columns:[
                    {
                        dataField    : "ctlr_mngm_nmbr",
                        caption      : "관리번호",
                        cssClass     : 'padding-ctrl',
                        sortIndex    : 0,
                        sortOrder    : 'asc',
                        alignment    : "center",
                    },
                    {
                        dataField    : "lctn",
                        caption      : "제어기 위치명",
                        cssClass     : 'padding-ctrl',
                        width        : 250,
                        alignment    : "center",
                        cellTemplate(c,e) {
                            c.css('text-align', 'left');
                            c.text(e.displayValue);
                        }
                    },
                    {
                        dataField    : "trmn_ip",
                        caption      : "제어기 IP",
                        cssClass     : 'padding-ctrl',
                        alignment    : "center",
                        cellTemplate(c,e) {
                            c.css('text-align', 'left');
                            c.text(e.displayValue);
                        }
                    },
                    {
                        dataField    : "trmn_port",
                        caption      : "PORT",
                        cssClass     : 'padding-ctrl',
                        alignment    : "center",
                    },
                    {
                        dataField    : "x_crdn",
                        caption      : "X좌표",
                        cssClass     : 'padding-ctrl',
                        alignment    : "center",
                    },
                    {
                        dataField    : "y_crdn",
                        caption      : "Y좌표",
                        cssClass     : 'padding-ctrl',
                        alignment    : "center",
                    },
                    
        ],
        onRowDblClick(e){
            const _selectFcltNmbr = e.data.ctlr_mngm_nmbr;
            ctlrMngmNmbr.box.option('value', _selectFcltNmbr);
            e.component.refresh().done(()=>{
                vdsCtrlInfoTable.clearSelection();
                e.component.option('focusedRowKey', null);
                
                const objArr = _vdsCtrlMap.get(_selectFcltNmbr + '_obj');
                if (objArr) {
                    objArr.sort(function(a,b){
                       return a['dtct_nmbr'] > b['dtct_nmbr'] ? -1 : 1;
                    });
                    
                    selectFcltObject(_selectFcltNmbr);
                    if (objArr[0].link_id) {
                        if (_prevLinkId !== null) {
                            _mapManager.updateEditLink(_lyrLinkIdx, _prevLinkId, 0, true);
                        }
                        _prevLinkId = objArr[0].link_id;
                        setValue(linkId.box, _prevLinkId);
                        _mapManager.updateEditLink(_lyrLinkIdx, _prevLinkId, 1, true);
                        //linkBtnClick
                    }
                    const dtctNm = (Number(objArr[0].dtct_nmbr) + 1).toString();
                    
                    let zero = '';
                    for(let ii = 0; ii < 8 - dtctNm.length ; ii++){
                        zero += '0';
                    }
                
                    setValue(dtctNmbr.box, zero + dtctNm );
                    setValue(istlLane.box, Number(objArr[0].istl_lane) + 1 );
                }
                else {
                    let ctlrNum = e.data.ctlr_mngm_nmbr;
                    const dtctNm = ctlrNum.substring(4, ctlrNum.length) + '0001';
                    if (_prevLinkId !== null) {
                        _mapManager.updateEditLink(_lyrLinkIdx, _prevLinkId, 0, true);
                        _prevLinkId = null;
                    }
                    setValue(linkId.box, _prevLinkId);
                    setValue(dtctNmbr.box, dtctNm );
                    setValue(istlLane.box, 1);
                    _mapManager.selectPos(e.data.x_crdn, e.data.y_crdn);
                }
                
            },()=>{
                   $(".modal-background").css('display','none');
                }
            );
        }
    }).dxDataGrid("instance");
   
     //
     _listTable = $(".dtct-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        focusedRowEnabled       : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode: 'single',
        },
        keyExpr : 'dtct_nmbr',
        
        headerFilter: {
            visible: true,
        },
        scrolling: {
            mode: 'virtual',
        },
        columns:[
                    {
                        dataField    : "ctlr_mngm_nmbr",
                        caption      : "제어기번호",
                        cssClass     : 'padding-ctrl',
                        alignment    : "center",
                    },
                    {
                        dataField    : "dtct_nmbr",
                        caption      : "검지기 ID",
                        cssClass     : 'padding-ctrl',
                        sortIndex    : 0,
                        sortOrder    : 'asc',
                        alignment    : "center",
                    },
                    {
                        dataField    : "istl_lane",
                        caption      : "차로",
                        cssClass     : 'padding-ctrl',
                        alignment    : "center",
                    },
                    {
                        dataField    : "vds_dtct_nm",
                        caption      : "제어기 위치",
                        cssClass     : 'padding-ctrl',
                        alignment    : "center",
                        cellTemplate(c,e){
                            c.css('text-align','left')
                            return c.text(e.displayValue);
                        }
                    },
                    
        ],
        onRowDblClick(e){
            _selectFcltNmbr = e.data.ctlr_mngm_nmbr;
            inputArr.map((item)=>{
                setValue(item.box, e.data[item.column]);
            });
            
            btnArr.map((item) =>{
                item.box.option("disabled", item.dbdsb)
            });
            
            setValue(dtctTypeCd.box, e.data.dtct_type_cd);
            
            if (_prevLinkId !== null) {
                _mapManager.updateEditLink(_lyrLinkIdx, _prevLinkId, 0, true);
            }

            _prevLinkId = e.data.link_id;
            _mapManager.updateEditLink(_lyrLinkIdx, e.data.link_id, 2, true);

            selectFcltObject(_selectFcltNmbr);
        }
    }).dxDataGrid("instance");
    doMap();

})

function editEvent(){
    cancleBtn.box.off('click');
    cancleBtn.box.on('click', () => editCancle());

    eventOn('edit');
    
    buttonReset('add', 'click');

    saveBtn.box.off('click');
    saveBtn.box.on('click', () => saveEvent('edit'));
}

function saveEvent(type){
    for (let input of inputArr) {
        const box   = input.box;
        const value = getValue(box);
        const must  = input.must;
        let   max   = input.max;
        if (input.type === 'number') {
            max = input.max.length;
        }
        const label = input.label;
        const empty = nullChecker(value) === "";
        if (empty) {
            if (must) {
                return alertWarning('필수 항목을 입력해주세요. [ ' + label +' ]', null, box);
            }
        }
        else {
            if (max && getByteLength(value) > max) {
                return alertWarning(max + ' 바이트 이내로 입력해주세요. [ ' + label +' ]', null, box);
            }
            if (input.id && idArr.includes(value) && !type) {
                return alertWarning('검지기번호 : ' + value + '<br>이미 사용중인 검지기번호입니다. 다시 입력해주세요.', null, box);
            }
        }
    }
    const trustArr = [
        [
            minSped,
            maxSped
        ],
        [
            minTfvl,
            maxTfvl
        ],
        [
            minOcpyRate,
            maxOcpyRate
        ],
    ];
    for (let trust of trustArr) {
        const min    = trust[0];
        const max    = trust[1];
        const minVal = getValue(min.box);
        const maxVal = getValue(max.box);
        if (minVal > maxVal) {
            return alertWarning( min.label + ' ' + min.and + ' ' + max.label + ' 보다 큽니다. 다시 입력해주세요', null, max.box);
        }
    }

    let updateData = {..._updateColumns}
    
    if (type === 'edit') {
        const rowData = _listTable.getSelectedRowsData()[0];
        for (let key in updateData) {
            updateData[key] = rowData[key];
        }
    }

    inputArr.map((item)=>{
        if(item.column && nullChecker(item.box.option("value")) !== "") updateData[item.column] = item.box.option("value");
    })

    updateData.dtct_type_cd = getValue(dtctTypeCd.box);
    let result = postInsertUpdate(_apiUri + "/" + encodeURIComponent(updateData.dtct_nmbr), updateData);
    if (result > 0) {
        
        insResultMsg(pageMsg)
        
        _managerData = refresh(_listTable, _managerData, _apiUri);
        idArr = [];
        if(!_vdsCtrlMap.get(updateData.ctlr_mngm_nmbr + '_obj')) {
            _vdsCtrlMap.set(updateData.ctlr_mngm_nmbr + '_obj', new Array());
        }

        _vdsCtrlMap.get(updateData.ctlr_mngm_nmbr + '_obj').push(updateData);

        if (_managerData.length > 0) {
            _managerData.map((item)=>{
                idArr.push(item.dtct_nmbr);
            })
        }

        eventCancel();
        updateIcon();

        _listTable.clearSelection();
        
        _listTable.refresh().done(function(){
            _listTable.selectRows(updateData.dtct_nmbr).done(()=>{
                _listTable.option('focusedRowKey', updateData.dtct_nmbr);
                const link_id = updateData.link_id;
                if (_prevLinkId !== null) {
                    _mapManager.updateEditLink(_lyrLinkIdx, _prevLinkId, 0, true);
                }
                //현재 링크 색상 변경
                _mapManager.updateEditLink(_lyrLinkIdx, link_id, 2, true);
                _prevLinkId = link_id;
                buttonReset('add','selected');
            });
        })
    }
    //alertError('VDS 검지기 정보가 저장되지 않았습니다.')
    
}

function editCancle(){
    eventCancel();
    boxPull();
    buttonReset( 'edit', 'cancle' );
}

function addCancle(){
   
    eventCancel();

    if(_listTable.getSelectedRowsData().length > 0){
        boxPull();
        buttonReset('add','selected');
        return 
    }

    boxInit();
    buttonReset('add','unSelected');

}

function addEvent(){
    
    eventOn();
    boxInit();
    cancleBtn.box.off('click');
    cancleBtn.box.on('click', () => addCancle());
    buttonReset('add','click');
 
    saveBtn.box.off('click');
    saveBtn.box.on('click', () =>saveEvent());
    if (_prevLinkId !== null) {
        _mapManager.updateEditLink(_lyrLinkIdx, _prevLinkId, 0, true);
        _prevLinkId = null;
    }
    
}

//리스트에 선택된 데이터 가져오기
function boxPull(){
    //선택 row 데이터
    let selectedRow = _listTable.getSelectedRowsData()[0]
    
    //텍스트 상자에 값 입력
    inputArr.map((item)=>{
        item.box.option('value', selectedRow[item.column]);
    });

    //이전에 선택된 링크가 있다면 색상 변경
    const link_id = getValue(linkId.box);
    if (_prevLinkId !== null) {
        _mapManager.updateEditLink(_lyrLinkIdx, _prevLinkId, 0, true);
    }
    //현재 링크 색상 변경
    _mapManager.updateEditLink(_lyrLinkIdx, link_id, 2, true);
    _prevLinkId = link_id;
    _selectFcltNmbr = getValue(ctlrMngmNmbr.box);
    
    //선택된 VDS 위치로 이동
    selectFcltObject(_selectFcltNmbr);
}

function boxInit(){
    inputArr.map((item)=>{
            if(item.value) return item.box.option('value', item.value);
            item.box.option("value", ''); 
    })

    dtcdTypeArr = dtctTypeCd.box.option('items');
    
    if(dtcdTypeArr.length > 0){
        dtctTypeCd.box.option('value', dtcdTypeArr[0].dtct_type_cd);
    }
}

function buttonReset(eventName, option){
    btnArr.map((item)=>{
        item.box.option( 'visible', item[eventName][option].visible   );
        item.box.option( 'disabled', item[eventName][option].disabled );
    })
}

function eventCancel(){
    const link_id = getValue(linkId.box);
    if (link_id) {
        _prevLinkId = link_id;
    }

    dsblOffBtn(_listTable);

    dtctTypeCd.box.option('readOnly', true);
    
    inputArr.map((item)=>{
        item.box.option("readOnly", true);
    });
    
    infoBtnArr.map((item)=>{
        dsblOnBtn(item.box);
    });

    if (_prevLinkId !== null) {
        _mapManager.updateEditLink(_lyrLinkIdx, _prevLinkId, 0, true);
        _prevLinkId = null;
    }

    _mapManager.onSelectObjFunc = null;
}

function eventOn(type){
    
    dsblOnBtn(_listTable);

    inputArr.map((item)=>{
        item.box.option("readOnly", item.readOnly);
    });

    infoBtnArr.map((item)=>{
        dsblOffBtn(item.box);
    });

    if (type === 'edit') {
        dtctNmbr.box.option('readOnly', true);
        dsblOnBtn(ctlrSelBtn.box);
    }

    dtctTypeCd.box.option('readOnly', false);
    
    linkBtn.box.on('click', () => linkBtnClick());
}


function vailableAlert(box, msg){
    if(nullChecker(box.box.option('value')) === ""){
        box.box.focus();
        alertWarning(msg, null, box.box);
        return false;
    }
    return true;
}


/**
 * 지도 인터페이스 함수........
 */
 function doMap() {
    _mapManager = new TMapMngr("traf-hs-map", "tooltip");
    _mapManager.setEditMode(_lyrIdx, true);
    _mapManager.showLayer(_lyrIdx, true);
    _mapManager.showFcltObjectText(_lyrIdx, true);
    _mapManager.onFcltDragEndFunc = onFcltDragEndFunc; // 객체(시설물) 편집시 객체 이동후 좌표 반환
    _mapManager.onMouseClickFunc = onMouseClickFunc; // 객체 마우스 클릭 이벤트 반환
    _mapManager.onSelectObjFunc = null; // 객체 선택 이벤트 반환
    _mapManager.setLayerVisible(_lyrLinkIdx, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19);
    _mapManager.setEditMode(_lyrLinkIdx, true);
    _mapManager.setSelectMode(true);
    _mapManager.setZoom(15);

    fetchBaseData();
    fetchMapIconBar($('.map-bar'), _mapManager, _lyrIdx, _pageName);
    _mapManager.toggleBaseMap(true);
    getData( _apiUri, _managerData);
    _listTable.option('dataSource', _managerData[0]);
    if(_managerData.length > 0){
        _managerData[0].map((item) => {
            idArr.push(item.dtct_nmbr)
            if(!_vdsCtrlMap.get(item.ctlr_mngm_nmbr + '_obj')){
                _vdsCtrlMap.set(item.ctlr_mngm_nmbr + '_obj', new Array());
            }
            _vdsCtrlMap.get(item.ctlr_mngm_nmbr + '_obj').push(item);
        })
    }
}


function onSelectObjFunc(ALyrIdx, ALyrName, ANmbr, ACoordX, ACoordY, X, Y) {
    
    if (ALyrIdx != _lyrLinkIdx) {
        return;
    }
    let selObj = _selObjMap.get(ANmbr);
    if (!selObj) {
        selObj = new TSelObj(ANmbr, ACoordX.toFixed(8), ACoordY.toFixed(8));
    }
    else {
        // 기존 데이터의 x,y 좌표만 업데이트 수행
        selObj = new TSelObj(ANmbr, ACoordX.toFixed(8), ACoordY.toFixed(8));
        _selObjMap.set(ANmbr, selObj);
        return;
    }

    _selObjMap.forEach((obj) => {
        _mapManager.updateEditLink(_lyrLinkIdx, obj.id, 0, false);
    });

    _selObjMap.clear();
    selObj.link_color = 1; 
    
    setValue(linkId.box, ANmbr);
    _selObjMap.set(ANmbr, selObj);
    _mapManager.updateEditLink(_lyrLinkIdx, ANmbr, selObj.link_color, true);
};

async function fetchBaseData() {
    console.time("***** fetchBaseData: ");
    let data;
    let vrtx;
    let dtctCd;
    let vdsListData;
    const node  = apiGet("/api/database/node/list"); // 노드정보 요청
    data        = apiGet("/api/database/link/list"); // 링크정보 요청
    vrtx        = apiGet("/api/manage/main/map/vrtx/link/1");
    dtctCd      = apiGet( _apiUri + '/dtct-type');
    vdsListData = apiGet('/api/vds/manager/info');

  
    Promise.all([node, data, vrtx, dtctCd, vdsListData])
        .then((results) => Promise.all(results.map((r) => r.json())))
        .then((values) => {
            
            /**
             * 맵세팅
             */
            _mapManager.makeLayer(LayerIndex.Node, values[0]);
            _mapManager.makeTrafficObject(_lyrType, values[1]);
            _mapManager.makeLayer(_lyrLinkIdx, values[2]);
            
            /**
             * 방향 코드 세팅
             */
            dtctTypeCd.box.option('items', values[3]);
            if (values[3].length > 0) {
                setValue(dtctTypeCd.box, values[3][0].dtct_type_cd);
            }

            /** 
             * vds 좌표 맵 세팅
             */
            vdsCtrlInfoTable.option('dataSource', values[4]);
            if( values[4].length >  0){
                values[4].map((obj)=>{
                    if(!_vdsCtrlMap.get(obj.ctlr_mngm_nmbr)){
                        _vdsCtrlMap.set(obj.ctlr_mngm_nmbr, {coordX : obj.x_crdn, coordY : obj.y_crdn});
                    }
                })
            }
            updateIcon();
            console.log(`BaseData, NODE(${values[0].length}), LINK/IFSC(${values[1].length}), VRTX(${values[2].length})`);
        })
        .catch((err) => {
            console.error(`Error in fetchBaseData ${err}`);
        })
        .finally(() => console.timeEnd("***** fetchBaseData: "));
}

function onFcltDragEndFunc(ALyrIdx, ALyrName, ANmbr, ACoordX, ACoordY) {
    if (ALyrIdx != _lyrIdx) {
        return;
    }
    if (ANmbr === _selectFcltNmbr) {
        cctvX.box.option("value", ACoordX.toFixed(7));
        cctvY.box.option("value", ACoordY.toFixed(7));
    }
    console.log(`onFcltDragEndFunc, ${ALyrIdx}, ${ALyrName}, ${ANmbr}, ${ACoordX}, ${ACoordY}`);
}

function onMouseClickFunc(ALyrIdx, ALyrName, ANmbr, ACoordX, ACoordY, X, Y) {
    if (ALyrIdx != _lyrIdx) {
        return;
    }
    console.log(`onMouseClickFunc, ${ALyrIdx}, ${ALyrName}, ${ANmbr}, ${ACoordX}, ${ACoordY}, ${X}, ${Y}`);
    const obj = _mapManager.findLayerObject(ALyrIdx, ANmbr);
    if (!obj) {
        return;
    }
}

/**
 * 지도에 시설물 객체 정보를 그린다.
 */
 function updateIcon() {
    // 기존 객체를 모두 삭제한다.
    _mapManager.removeLayerObject(_lyrIdx);

    // 시설물 객체를 지도에 그린다.
    const objs = new Array();
    _managerData[0].forEach((obj) => {
        const item = new TFclt(obj.ctlr_mngm_nmbr, obj.vds_dtct_nm, _vdsCtrlMap.get(obj.ctlr_mngm_nmbr).coordX, _vdsCtrlMap.get(obj.ctlr_mngm_nmbr).coordY);
        objs.push(item);
    });

    _mapManager.initFcltObject(_lyrIdx, objs);
}
function selectFcltObject(ANmbr) {
    _mapManager.selectLayerObject(_lyrIdx, ANmbr);
}
function editFcltObject(ANmbr, AIsEdit) {
    _mapManager.editFcltObject(_lyrIdx, ANmbr, AIsEdit, AIsEdit ? "1" : "0");
}
function deleteFcltObject(ANmbr) {
    _mapManager.deleteFcltObject(_lyrIdx, ANmbr);
    _selectFcltNmbr = null;
}
function addFcltObject(ANmbr) {
    _mapManager.createFcltObject(_lyrIdx, ANmbr, "New", "New", "1" /*아이콘색결정,시설물유형_N.png*/ /*, x_crdn, y_crdn*/);
}

function linkBtnClick(){
    if (_prevLinkId !== null) {
        _mapManager.updateEditLink(_lyrLinkIdx, _prevLinkId, 0, true);
        _prevLinkId = null;
        setValue(linkId.box, null);
    }
    _mapManager.onSelectObjFunc = onSelectObjFunc;
}