//우측 섹션 관련
let dstlData      = [];
let dstlTable     = null;
let dstlChart     = null;

//좌측 섹션 관련
let termSelect       = null;
let termStartDate    = null;
let termStartTIme    = null;
let termEndDate      = null;
let termEndTIme      = null;
let termSearchBtn    = null;
let dstlListTable    = null;
let dstlListData     = [];

//시간 세팅
let endDate          = new Date();
let startDate        = new Date().setDate(new Date().getDate()-1);

//차트 관련
let series           = [];
let xAxis            = [];
let _pageName         = 'VDS-검지기 소통정보 통계';
let pageMsg          = 'VDS-검지기'

//공통 uri
let commouUri        = '/api/vds/statistics/dtct-traf';

//chart series
series = [
        {
            id   : 'tfvl',
            name : '교통량(대)',
            color: 'rgb(247, 163, 92)',
            data : [],
        },
        {
            id   : 'avrg_sped',
            name : '평균 속도(km/h)',
            color: 'rgb(124, 181, 236)',
            data : [],
        },
]

getData('/api/Vds/manager/dtct', dstlListData)
$(()=>{
  
    //기간 셀렉트박스
    termSelect = $('.select-box').dxSelectBox({
        items       : ['15분 통계','시간 통계(1시간)','일 통계(1일)','월 통계(1개월)'],
        width       : 250,
        height      : 28,
        stylingMode : "outlined",
        value       : '15분 통계',
        onItemClick(e){
            termSearchBtn.off('click');
            switch (e.itemData) {
                case '15분 통계':
                    timeBoxFormmat( 170, 'yyyy년 MM월 dd일', true, '/15m' );
                    timeInit();
                    break;
                case '시간 통계(1시간)':
                    timeBoxFormmat( 170, 'yyyy년 MM월 dd일', true, '/hh' );
                    timeInit();
                    break;
                case '일 통계(1일)':
                    timeBoxFormmat( 250, 'yyyy년 MM월 dd일', false, '/dd' );
                    timeInit();
                    break;
                case '월 통계(1개월)':
                    timeBoxFormmat( 250, 'yyyy년 MM월', false, '/mn' );
                    timeInit();
                    break;
            
                default:
                    break;
            }
        }
    }).dxSelectBox('instance');
    
    //기간 검색시작일시 년월일
    termStartDate =  $('.strt-date').dxDateBox({
        type                : 'date',
        value               : startDate,
        width               : 170,
        height              : '28px',
        stylingMode         : 'outlined',
        displayFormat       : 'yyyy년 MM월 dd일',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000년 00월 00일',
    }).dxDateBox('instance');
    
    //기간 검색시작일시 시간
    termStartTIme =  $('.strt-time').dxDateBox({
        type                : 'time',
        value               : new Date().getTime(),
        width               : '75px',
        height              : '28px',
        interval            : 60,
        stylingMode         :'outlined',
        displayFormat       : 'HH 시',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00 시',
    }).dxDateBox('instance');
    
    //기간 검색종료일시 년월일
    termEndDate =  $('.end-date').dxDateBox({
        type                : 'date',
        value               : endDate,
        width               : '170px',
        height              : '28px',
        stylingMode         :'outlined',
        displayFormat       : 'yyyy년 MM월 dd일',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000년 00월 00일',
    }).dxDateBox('instance');
    
    //기간 검색종료일시 시간
    termEndTIme =  $('.end-time').dxDateBox({
        type                : 'time',
        value               : new Date().getTime(),
        width               : '75px',
        height              : '28px',
        interval            : 60,
        stylingMode         :'outlined',
        displayFormat       : 'HH 시',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00 시',
    }).dxDateBox('instance');
    
    //기간 조회 버튼
    termSearchBtn = $('.search-btn').dxButton({
        stylingMode:'outlined',
        text:'조회',
        icon:'refresh',
        width: '80px',
    }).dxButton("instance").on('click', () => dstlEvent( '/15m' ));
    
    //차트 이지미 저장 버튼
    $(".export-button").dxButton({
        stylingMode : 'outlined',
        text        : '차트 저장',
        icon        : 'export',
        height      : '40px',
        width       : '110px',
        onClick(){
            if( dstlData.length <= 0 || dstlData[0].length <= 0 ){
                alertWarning("저장하실 차트 데이터가 없습니다.");
                return false;
            }
            confirmMessage(_pageName + " 차트를 파일로 저장 하시겠습니까?").done((yes)=>{
                if (yes) {
                    dstlChart.exportChartLocal({
                        filename:  _pageName + "_"+ + excellTime()
                    });
                }
            })
        }
    })

    //차트 변경 버튼
    $(".chart-change").dxMenu({
        dataSource: chartDataSource,
        hideSubmenuOnMouseLeave: true,
        cssClass:'menu-border',
        height: 40,
        showFirstSubmenuMode: {
            name: "onClick",
            delay: { show: 0, hide: 100 },
        },
        displayExpr: "name",
        submenuDirection: "auto",
        visible: true,
        onItemClick(info){
            const item = info.itemData;
            if(item.type){
                const dataSource = [...info.component.option('dataSource')]
                dataSource[0].name = item.name
                dataSource[0].icon = item.type
                info.component.option('dataSource', dataSource);
                dstlChart.update({
                    chart: {
                        type: item.type,
                    }
                })
            }
        }
    }).dxMenu("instance");
    
    //가공데이터 차트
    dstlChart = Highcharts.chart('traffic-chart', {
        chart: {
            type: 'line',
            height: 343,
            backgroundColor: '#3f3f4b',
            zoomType: 'x',
            events: {
                load: function() {
                }
            },
        },
        title: {
            text: null
        },
        xAxis: {
            categories: null,
            title: {
                text: '통계시각',
                style:{
                    color:'#fff',
                }
            },
            labels:{
                style:{
                    color:'#fff',
                }
            }
        },
        
        yAxis: {
            min: 0,
            title: null,
            labels: {
                overflow: 'justify',
                style:{
                    color: '#fff',
                },
                format: '{value:,.0f}'
            },
        },
        plotOptions: {
            bar: {
                dataLabels: {
                    enabled: true
                }
            },
            series: {
                lineWidth: 2
            }
        },
        legend: {
            layout: 'vertical',
            align: 'right',
            verticalAlign: 'top',
            floating: false,
            y: 50,
            borderWidth: 1,
            itemStyle:{
                color:'#fff',
            },
            backgroundColor:
                Highcharts.defaultOptions.legend.backgroundColor || '#525260',
            shadow: true,
            borderColor:'#534b4b',
        },
        exporting: {
            chartOptions: { // specific options for the exported image
                plotOptions: {
                    series: {
                        dataLabels: {
                            enabled: true
                        }
                    }
                }
            },
            enabled: false,
            fallbackToExportServer: false,
        },
        credits : {
            enabled : false
        },
        series : series
    });

    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton("instance")
    
     //소통정보통계 테이블
    dstlTable = $(".traffic-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode: 'single',
        },
        keyExpr : ['dtct_nmbr', 'stat_dt'],
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible: true,
        },
        grouping: {
            autoExpandAll: true,
        },
        scrolling: {
            mode: 'virtual',
        },
        groupPanel:{
            visible: true,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        export:{
            enabled: true,
            texts: {
                exportAll:"엑셀 파일",
            },
        },
        sorting:{
            showSortIndexes : false,
        },
        columns : [
            {
                caption   : "기본 정보",
                alignment : "center",
                columns:[
                    {
                        dataField    : "dtct_nmbr",
                        caption      : "검지기 ID",
                        alignment    : "center",
                        sortIndex    : 2,
                        sortOrder    : 'asc',
                    },
                    {
                        dataField    : "istl_lane",
                        caption      : "차선",
                        alignment    : "center",
                    },
                    {
                        dataField    : "vds_dtct_nm",
                        caption      : "검지기 명",
                        alignment    : "center",
                        cellTemplate(c,e){
                            c.css('text-align', 'left');
                            c.text(e.displayValue);
                        }
                    },
                    {
                        dataField    : "stat_dt",
                        caption      : "통계시각",
                        alignment    : "center",
                        sortIndex    : 1, 
                        sortOrder    : "asc",
                    },

                ]
                
            },   
            {
                caption   : "통계 정보",
                alignment : "center",
                columns:[
                    {
                        dataField    : "tfvl",
                        caption      : "교통량(대)",
                        alignment    : "center",
                        format       : '#,###,##0',
                    },
                    {
                        dataField    : "avrg_sped",
                        caption      : "평균 속도(Km/h)",
                        alignment    : "center",
                    },
                    {
                        dataField    : "avrg_ocpy_rate",
                        caption      : "평균 점유율(%)",
                        alignment    : "center",
                    },

                ]
                
            },   
           
        ],
        onExporting(e){
            gridExcellExporting(e, _pageName);
        },
        
    }).dxDataGrid("instance");
    
    //리스트 테이블
    dstlListTable = $(".dstl-list-table").width('100%').height('100%').dxDataGrid({
        dataSource              : dstlListData[0],
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode: 'multiple',
            showCheckBoxesMode:"onClick"
        },
        keyExpr : 'dtct_nmbr',
        paging: {
            enabled: false,
            pageSize: 1000,
        },
        headerFilter: {
            visible: true,
        },
        grouping: {
            autoExpandAll: true,
        },
        scrolling: {
            mode: 'standard',
        },
        columns : [
                    {
                        dataField    : "ctlr_mngm_nmbr",
                        caption      : "제어기",
                        alignment    : "center",
                        groupIndex   : 0,
                        groupCellTemplate(c,e){
                            if(e.data.items){
                                let name = e.data.items[0].vds_dtct_nm
                                for(idx in e.data.items){
                                    if(e.data.items[idx].vds_dtct_nm !== name){
                                        let temp = name.substring(0,name.indexOf("("))
                                        name = temp+"(양방향)"
                                        break;
                                    }
                                }
                                c.text("제어기 : ["+e.data.key+"] " + name);
                                return c;
                            }
                            let name = e.data.collapsedItems[0].vds_dtct_nm
                                for(idx in e.data.collapsedItems){
                                    if(e.data.collapsedItems[idx].vds_dtct_nm !== name){
                                        let temp = name.substring(0, name.indexOf("("))
                                        name = temp+"(양방향)"
                                        break;
                                    }
                                }
                                c.text("제어기 : ["+e.data.key+"] " + name);
                                return c;
                        }
                    },
                    {
                        dataField    : "dtct_nmbr",
                        caption      : "검지기 번호",
                        alignment    : "center",
                    },
                    {
                        dataField    : "istl_lane",
                        caption      : "설치차로",
                        sortOrder    : "asc",
                        alignment    : "center",
                    },
                    {
                        dataField    : "vds_dtct_nm",
                        caption      : "검지기 명",
                        alignment    : "center",
                        cellTemplate(c,e){
                            c.css('text-align','left');
                            c.text(e.displayValue)
                        }
                    },
        ],
        
    }).dxDataGrid("instance");
    
})


//구간별 데이터 세팅
function dstlEvent( uri ) {
    let tableData        = dstlListTable.getSelectedRowsData();
    let FROM_DT          = null;
    let TO_DT            = null;
    let id               = "";
    let formatTimeLength = null;
    let updateData       = {};
    const strtDtVal      = termStartDate.option('value');
    const strtTmVal      = termStartTIme.option('value');
    const endDtVal       = termEndDate.option('value');
    const endTmVal       = termEndTIme.option('value');

    if( tableData.length <= 0 ) return notSelectMsg(pageMsg);

    //조건 체크에 따른 시간 포맷
    switch (uri) {
        case '/15m' :
            if ( !validationCheck( termStartDate, termEndDate, termStartTIme, termEndTIme )) return false;
            FROM_DT = getDate( strtDtVal, strtTmVal).substring(0, 10);
            TO_DT   = getDate(endDtVal, endTmVal).substring(0, 10);
            formatTimeLength = 16;
            break;
        case '/hh' :
            if ( !validationCheck( termStartDate, termEndDate, termStartTIme, termEndTIme )) return false;
            FROM_DT = getDate( strtDtVal, strtTmVal).substring(0, 10);
            TO_DT   = getDate(endDtVal, endTmVal).substring(0, 10);
            formatTimeLength = 16;
            break;
        case '/dd' :
            if ( !validationCheck( termStartDate, termEndDate )) return false;
            FROM_DT = dateFormmater(new Date(strtDtVal));
            TO_DT   = dateFormmater(new Date(endDtVal));
            formatTimeLength = 13;
            break;
        case '/mn' :
            if ( !validationCheck( termStartDate, termEndDate )) return false;
            FROM_DT = dateFormmater(new Date(strtDtVal)).substring(0, 6);
            TO_DT   = dateFormmater(new Date(endDtVal)).substring(0, 6);
            formatTimeLength = 7;
            break;
        default:
            break;
    };
    
    
    if( FROM_DT > TO_DT ){
        termStartDate.focus();
        alertWarning('검색 시작 시각이 검색 종료 시각보다 큽니다.', null, termStartDate);
        return false;
    };
    for(idx in tableData){
        id += tableData[idx].dtct_nmbr + ","
    }
    updateData[ 'FROM_DT' ] = FROM_DT;
    updateData[ 'TO_DT' ]   = TO_DT;
    updateData[ 'id' ]      = id.slice(0,-1)
    finalEvent( commouUri + uri, updateData, formatTimeLength );
}

//테이블 및 차트 세팅
function finalEvent( uri, updateData, formatTimeLength ){
    dstlData = [];
    xAxis      = [];

    //getData( uri, dstlData, updateData );
    getDataAsync( uri, (jsonData)=>{
        dstlData = jsonData;
        
        for (let idx in series) {
            series[idx].data = [];
        }

        if (dstlData.length > 0) {
            dstlData.map((item)=>{
                if(item.stat_dt){
                    item.stat_dt = getParseDateTime(item.stat_dt).substring(0, formatTimeLength);
                }
                xAxis.push(item.stat_dt)
                for(idx in series){
                    series[idx].data.push(item[series[idx].id])
                }
            })
        }
        
        dstlTable.option( 'dataSource', dstlData );
    
        dstlChart.update({
            xAxis :{
                categories: xAxis
            },
            series:series
        })
        
        pageNation(dstlChart, xAxis);
        selResultMsg(dstlData);
    }, null, updateData );
   
}

function timeInit(){
    termStartDate.option( 'value', startDate );
    termEndDate.option( 'value', endDate );
    termStartTIme.option( 'value', new Date().getTime());
    termEndTIme.option( 'value', new Date().getTime());
}

function timeBoxFormmat( width, format, visible, url ){
    termStartDate.option( 'width', width );
    termStartDate.option( 'displayFormat', format );
    termEndDate.option( 'width', width);
    termEndDate.option( 'displayFormat', format );
    termStartTIme.option( 'visible', visible);
    termEndTIme.option( 'visible', visible);
    termSearchBtn.on( 'click', () => dstlEvent( url ) );
}