let nodeData        = [];
let modalContent    = null;
let searchBtn       = null;
let modalCancleBtn  = null;
let cancleBtn       = null;
let nodeTable       = null;
const _apiUri       = '/api/database/node/list';
const _pageName      = '노드 정보';

$(()=>{
    //모달창 바디에 넣기
    $("body").append(modalDiv);
    $(".modal-title").prepend($("<div>노드 정보 수정</div>"));
    $(".modal-background").css("display",'none');
    
    //모달 x 버튼
    modalCancleBtn = $(".modal-cancle").dxButton({
        stylingMode:'text',
        icon:'close',
        onClick(){
            $(".modal-background").css("display",'none');
        }
    })

    //모달 폼
    modalContent = $(".modal-content").dxForm({
        formData:null,
        minColWidth:200,
        labelLocation:'left',
        items:[{
            caption:'노드 정보',
            itemType: 'group',
            items:[{
                dataField: '노드_ID',
                disabled: true,
                editorOptions: {
                    width:'300px',
                    stylingMode: 'outlined',
            }
            },{
            dataField: '명칭',         
            editorOptions: {
                width:'300px',
                stylingMode: 'outlined',
            },
        },] 
    }]
    }).dxForm("instance");

    //모달 저장 버튼
    $(".modal-save-Btn").dxButton({
        stylingMode:'outlined',
        text:'저장',
        icon:'save',
        onClick(){
            const node_id      = modalContent.option().formData.노드_ID;
            const node_name    = modalContent.option().formData.명칭;
            const input        = modalContent.getEditor('명칭');
            const frontContent = '노드 ID : ' + node_id + '<br>';
            if (nullChecker(node_name) === "") {
                return alertWarning(frontContent + '명칭을 입력해주세요', null, input);
            }
            else if (node_name === nodeTable.getSelectedRowsData()[0].node_name) {
                return alertWarning(frontContent + '변경 된 사항이 없습니다.', null, input);
            }
            else if (getByteLength(node_name) > 100) {
                return alertWarning(frontContent + '명칭을 100 바이트 이내로 입력해주세요.', null, input)
            }
            confirmMessage(frontContent + "노드 정보를 수정하시겠습니까?").done((yes) => {
                if (yes === true) {
                    let result = putUpdate('/api/database/node/name/' + encodeURIComponent(node_id), {node_name:node_name});
                    if ( result > 0){
                        nodeData=[];
                        getData(_apiUri, nodeData);
                        nodeTable.option('dataSource', nodeData[0]);
                        $(".modal-background").css("display", "none");
                        return alertConfirm('노드 ID : ' + node_id + "<br>노드 정보를 수정하였습니다.");
                    }
                }
            });

        },
    })

    //모달 취소 버튼
    $('.modal-cancle-Btn').dxButton({
        stylingMode: 'outlined',
        text: '취소',
        icon: 'close',
        onClick() {
            $('.modal-background').css('display', 'none');
        },
    });

    //상단 조회 버튼
    searchBtn = $(".select-button").dxButton({
        stylingMode:'outlined',
        text:'조회',
        icon:'refresh',
        height:'30px',
        width: '80px',
        onClick(){
            fetchListData();
        }
    })

    //상단 닫기 버튼
    cancleBtn = $(".cancle-button").dxButton({
        stylingMode:'outlined',
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        onClick(){
            window.close();
        }
    })

    //노드 테이블
    nodeTable = $('.node-table')
        .width('100%')
        .height('100%')
        .dxDataGrid({
            dataSource: nodeData[0],
            allowColumnReordering: true,
            showColumnLines: true,
            allowColumnResizing: true,
            showBorders: true,
            rowAlternationEnabled: true,
            columnAutoWidth: true,
            focusedRowEnabled: true,
            noDataText: '표출할 정보가 없습니다.',
            keyExpr: 'node_id',
            selection: {
                mode: 'single',
            },
            filterRow: {
                visible: true,
                applyFilter: "auto",
                showOperationChooser:false,
            },
            headerFilter: {
                visible: true,
            },
            grouping: {
                autoExpandAll: true,
            },
            groupPanel: {
                visible: true,
                emptyPanelText: '그룹 지을 항목을 여기에 끌어다 놓으세요',
            },
            export: {
                enabled: true,
                texts: {
                    exportAll: '엑셀 파일',
                },
            },
            paging: {
                pageSize : 1000,
            },
            onExporting(e) {
                gridExcellExporting(e, _pageName);
            },
            columns: [
                {
                    dataField: 'node_id',
                    caption: 'ID',
                    alignment: 'center',
                    dataType : 'string',
                    width: '100px',
                    sortIndex: 0,
                    sortOrder: 'asc',
                },
                {
                    dataField: 'node_type_desc',
                    caption: '유형',
                    alignment: 'center',
                    cellTemplate(c, e) {
                        let result = nullChecker(e.data.node_type_desc);
                        return $('<div style="text-align: left; padding-left: 10px;">' + result + '</div>');
                    },
                },
                {
                    dataField: 'node_name',
                    caption: '명칭',
                    alignment: 'center',
                    cellTemplate(c, e) {
                        let result = nullChecker(e.data.node_name);
                        return $('<div style="text-align: left; padding-left: 10px;">' + result + '</div>');
                    },
                },
                {
                    dataField: 'turn_p_desc',
                    caption: '회전 제한',
                    alignment: 'center',
                },
                {
                    dataField: 'rmrk',
                    caption: '비고',
                    alignment: 'center',
                },
                {
                    dataField: 'x_crdn',
                    caption: '위치 X',
                    alignment: 'center',
                },
                {
                    dataField: 'y_crdn',
                    caption: '위치 Y',
                    alignment: 'center',
                },
            ],
            onRowDblClick(e) {
                $('.modal-background').css('display', 'flex');
                modalContent.updateData('노드_ID', e.data.node_id);
                modalContent.updateData('명칭', e.data.node_name);
            },
        })
        .dxDataGrid('instance');
    
    //하단 수정 버튼
    $(".edit-btn").dxButton({
        text:'수정',
        icon:'edit',
        stylingMode:'outlined',
        onClick(){
            if(nodeTable.getSelectedRowsData().length > 0){
                $(".modal-background").css("display",'flex');
                 let selectVal = nodeTable.getSelectedRowsData()[0];
                 modalContent.updateData('노드_ID',selectVal.node_id);
                 modalContent.updateData('명칭',selectVal.node_name);
            }
        }
    })
    
    fetchListData();
})

function fetchListData(){
    getDataAsync(_apiUri, (jsonData)=>{
        nodeTable.option('dataSource', jsonData);
    });
}