/*
 Highstock JS v10.1.0 (2022-04-29)

 Highcharts Stock as a plugin for Highcharts

 (c) 2010-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(I){a(I);a.Highcharts=I;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function I(a,u,y,m){a.hasOwnProperty(u)||(a[u]=m.apply(null,y),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:u,module:a[u]}})))}a=a?a._modules:{};I(a,"Core/Axis/OrdinalAxis.js",
[a["Core/Axis/Axis.js"],a["Core/Globals.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,u,y,m){var g=m.addEvent,A=m.correctFloat,E=m.css,x=m.defined,b=m.error,t=m.pick,d=m.timeUnits,M=[],l;(function(l){function H(f,e,c,p,n,h,v){void 0===n&&(n=[]);void 0===h&&(h=0);var w={},P=this.options.tickPixelInterval,Q=this.chart.time,B=[],C,z,k=0,q=[],l=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!n||3>n.length||"undefined"===typeof e)return Q.getTimeTicks.apply(Q,arguments);
var t=n.length;for(C=0;C<t;C++){var F=C&&n[C-1]>c;n[C]<e&&(k=C);if(C===t-1||n[C+1]-n[C]>5*h||F){if(n[C]>l){for(z=Q.getTimeTicks(f,n[k],n[C],p);z.length&&z[0]<=l;)z.shift();z.length&&(l=z[z.length-1]);B.push(q.length);q=q.concat(z)}k=C+1}if(F)break}if(z){z=z.info;if(v&&z.unitRange<=d.hour){C=q.length-1;for(k=1;k<C;k++)if(Q.dateFormat("%d",q[k])!==Q.dateFormat("%d",q[k-1])){w[q[k]]="day";var r=!0}r&&(w[q[0]]="day");z.higherRanks=w}z.segmentStarts=B;q.info=z}else b(12,!1,this.chart);if(v&&x(P)){z=q.length;
Q=[];k=[];C=void 0;for(r=z;r--;)B=this.translate(q[r]),C&&(k[r]=C-B),Q[r]=C=B;k.sort();k=k[Math.floor(k.length/2)];k<.6*P&&(k=null);r=q[z-1]>c?z-1:z;for(C=void 0;r--;)B=Q[r],z=Math.abs(C-B),C&&z<.8*P&&(null===k||z<.8*k)?(w[q[r]]&&!w[q[r+1]]?(z=r+1,C=B):z=r,q.splice(z,1)):C=B}return q}function J(f){var e=this.ordinal.positions;if(!e)return f;var c=e.length-1;if(0>f)f=e[0];else if(f>c)f=e[c];else{c=Math.floor(f);var p=f-c}return"undefined"!==typeof p&&"undefined"!==typeof e[c]?e[c]+(p?p*(e[c+1]-e[c]):
0):f}function K(f){var e=this.ordinal,c=e.positions;if(!c)return f;var p=(f-(this.old?this.old.min:this.min))*(this.old?this.old.transA:this.transA)+this.minPixelPadding;0<p&&p<this.left+this.len||(e.extendedOrdinalPositions||(e.extendedOrdinalPositions=e.getExtendedPositions()),c=e.extendedOrdinalPositions);if(c&&c.length){f=e.getIndexOfPoint(p,c);e=A(f%1);if(0<=f&&f<c.length-1)return c[Math.floor(f)]+e*(c[Math.ceil(f)]-c[Math.floor(f)]);e=c.length;p=c[0];c=c[e-1];var n=(c-p)/(e-1);return 0>f?p+
n*f:c+n*(f-e)}return f}function r(f,e){var c=l.Additions.findIndexOf(f,e,!0);return f[c]===e?c:c+(e-f[c])/(f[c+1]-f[c])}function a(){this.ordinal||(this.ordinal=new l.Additions(this))}function m(){this.isXAxis&&x(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&x(this.userMin)&&(this.min+=this.options.overscroll))}function F(){this.horiz&&
!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)}function S(){this.ordinal&&(this.ordinal.beforeSetTickPositions(),this.tickInterval=this.ordinal.postProcessTickInterval(this.tickInterval))}function k(f){var e=this.xAxis[0],c=e.options.overscroll,p=f.originalEvent.chartX,n=this.options.chart.panning,h=!1;if(n&&"y"!==n.type&&e.options.ordinal&&e.series.length){var v=this.mouseDownX,w=e.getExtremes(),P=w.dataMax,Q=w.min,B=w.max,C=this.hoverPoints,
z=e.closestPointRange||e.ordinal&&e.ordinal.overscrollPointsRange;v=(v-p)/(e.translationSlope*(e.ordinal.slope||z));z=e.ordinal.getExtendedPositions();z={ordinal:{positions:z,extendedOrdinalPositions:z}};var k=e.index2val,q=e.val2lin,d=void 0,l=d=void 0,r=void 0;z.ordinal.positions?1<Math.abs(v)&&(C&&C.forEach(function(h){h.setState()}),0>v?(l=z,r=e.ordinal.positions?e:z):(l=e.ordinal.positions?e:z,r=z),d=r.ordinal.positions,P>d[d.length-1]&&d.push(P),this.fixedRange=B-Q,d=e.navigatorAxis.toFixedRange(void 0,
void 0,k.apply(l,[q.apply(l,[Q,!0])+v]),k.apply(r,[q.apply(r,[B,!0])+v])),d.min>=Math.min(w.dataMin,Q)&&d.max<=Math.max(P,B)+c&&e.setExtremes(d.min,d.max,!0,!1,{trigger:"pan"}),this.mouseDownX=p,E(this.container,{cursor:"move"})):h=!0}else h=!0;h||n&&/y/.test(n.type)?c&&(e.max=e.dataMax+c):f.preventDefault()}function O(){var f=this.xAxis;f&&f.options.ordinal&&(delete f.ordinal.index,delete f.ordinal.extendedOrdinalPositions)}function q(f,e){var c=this.ordinal,p=c.positions,n=c.slope,h=c.extendedOrdinalPositions;
if(!p)return f;var v=p.length;if(p[0]<=f&&p[v-1]>=f)f=r(p,f);else{h||(h=c.getExtendedPositions&&c.getExtendedPositions(),c.extendedOrdinalPositions=h);if(!h||!h.length)return f;v=h.length;n||(n=(h[v-1]-h[0])/v);p=r(h,p[0]);f>=h[0]&&f<=h[v-1]?f=r(h,f)-p:f<h[0]?(f=h[0]-f,f=-p-f/n):(f-=h[v-1],f=f/n+v-p)}return e?f:n*(f||0)+c.offset}l.compose=function(f,e,c){if(-1===M.indexOf(f)){M.push(f);var p=f.prototype;p.getTimeTicks=H;p.index2val=J;p.lin2val=K;p.val2lin=q;p.ordinal2lin=p.val2lin;g(f,"afterInit",
a);g(f,"foundExtremes",m);g(f,"afterSetScale",F);g(f,"initialAxisTranslation",S)}-1===M.indexOf(c)&&(M.push(c),g(c,"pan",k));-1===M.indexOf(e)&&(M.push(e),g(e,"updatedData",O));return f};var G=function(){function f(e){this.index={};this.axis=e}f.prototype.beforeSetTickPositions=function(){var e=this.axis,c=e.ordinal,p=e.getExtremes(),n=p.min,h=p.max,v=e.isXAxis&&!!e.options.breaks;p=e.options.ordinal;var w=e.chart.options.chart.ignoreHiddenSeries,f,k,B=[],C=Number.MAX_VALUE,z=!1;if(p||v){e.series.forEach(function(h,
c){f=[];if(!(w&&!1===h.visible||!1===h.takeOrdinalPosition&&!v)&&(B=B.concat(h.processedXData),q=B.length,B.sort(function(h,c){return h-c}),C=Math.min(C,t(h.closestPointRange,C)),q)){for(c=0;c<q-1;)B[c]!==B[c+1]&&f.push(B[c+1]),c++;f[0]!==B[0]&&f.unshift(B[0]);B=f}});var q=B.length;if(2<q){var d=B[1]-B[0];for(k=q-1;k--&&!z;)B[k+1]-B[k]!==d&&(z=!0);!e.options.keepOrdinalPadding&&(B[0]-n>d||h-B[B.length-1]>d)&&(z=!0)}else e.options.overscroll&&(2===q?C=B[1]-B[0]:1===q?(C=e.options.overscroll,B=[B[0],
B[0]+C]):C=c.overscrollPointsRange);z||e.forceOrdinal?(e.options.overscroll&&(c.overscrollPointsRange=C,B=B.concat(c.getOverscrollPositions())),c.positions=B,d=e.ordinal2lin(Math.max(n,B[0]),!0),k=Math.max(e.ordinal2lin(Math.min(h,B[B.length-1]),!0),1),c.slope=h=(h-n)/(k-d),c.offset=n-d*h):(c.overscrollPointsRange=t(e.closestPointRange,c.overscrollPointsRange),c.positions=e.ordinal.slope=c.offset=void 0)}e.isOrdinal=p&&z;c.groupIntervalFactor=null};f.findIndexOf=function(e,c,p){for(var n=0,h=e.length-
1,v;n<h;)v=Math.ceil((n+h)/2),e[v]<=c?n=v:h=v-1;return e[n]===c?n:p?n:-1};f.prototype.getExtendedPositions=function(){var e=this,c=e.axis,p=c.constructor.prototype,n=c.chart,h=c.series[0].currentDataGrouping,v=h?h.count+h.unitName:"raw",w=c.options.overscroll,f=c.getExtremes(),k=void 0,B=e.index;B||(B=e.index={});if(!B[v]){var C={series:[],chart:n,forceOrdinal:!1,getExtremes:function(){return{min:f.dataMin,max:f.dataMax+w}},getGroupPixelWidth:p.getGroupPixelWidth,getTimeTicks:p.getTimeTicks,options:{ordinal:!0},
ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:p.ordinal2lin,getIndexOfPoint:p.getIndexOfPoint,val2lin:p.val2lin};C.ordinal.axis=C;c.series.forEach(function(c){k={xAxis:C,xData:c.xData.slice(),chart:n,destroyGroupedData:u.noop,getProcessedData:y.prototype.getProcessedData,applyGrouping:y.prototype.applyGrouping};k.xData=k.xData.concat(e.getOverscrollPositions());k.options={dataGrouping:h?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,
approximation:"open",units:[[h.unitName,[h.count]]]}:{enabled:!1}};C.series.push(k);c.processData.apply(k)});k.closestPointRange!==k.basePointRange&&k.currentDataGrouping&&(C.forceOrdinal=!0);c.ordinal.beforeSetTickPositions.apply({axis:C});B[v]=C.ordinal.positions}return B[v]};f.prototype.getGroupIntervalFactor=function(e,c,p){p=p.processedXData;var n=p.length,h=[];var v=this.groupIntervalFactor;if(!v){for(v=0;v<n-1;v++)h[v]=p[v+1]-p[v];h.sort(function(h,c){return h-c});h=h[Math.floor(n/2)];e=Math.max(e,
p[0]);c=Math.min(c,p[n-1]);this.groupIntervalFactor=v=n*h/(c-e)}return v};f.prototype.getIndexOfPoint=function(e,c){var p=this.axis,n=this.positions?this.positions[0]:0,h=p.series[0].points&&p.series[0].points[0]&&p.series[0].points[0].plotX||p.minPixelPadding;1<p.series.length&&p.series.forEach(function(c){c.points&&x(c.points[0])&&x(c.points[0].plotX)&&c.points[0].plotX<h&&(h=c.points[0].plotX)});e=(e-h)/(p.translationSlope*(this.slope||p.closestPointRange||this.overscrollPointsRange));return f.findIndexOf(c,
n)+e};f.prototype.getOverscrollPositions=function(){var e=this.axis,c=e.options.overscroll,p=this.overscrollPointsRange,n=[],h=e.dataMax;if(x(p))for(;h<=e.dataMax+c;)h+=p,n.push(h);return n};f.prototype.postProcessTickInterval=function(e){var c=this.axis,p=this.slope;return p?c.options.breaks?c.closestPointRange||e:e/(p/c.closestPointRange):e};return f}();l.Additions=G})(l||(l={}));return l});I(a,"Series/DataModifyComposition.js",[a["Core/Axis/Axis.js"],a["Core/Series/Point.js"],a["Core/Series/Series.js"],
a["Core/Utilities.js"]],function(a,u,y,m){var g=u.prototype.tooltipFormatter,A=m.addEvent,E=m.arrayMax,x=m.arrayMin,b=m.correctFloat,t=m.defined,d=m.isArray,M=m.isNumber,l=m.isString,K=m.pick,H;(function(J){function a(e,c,p){this.isXAxis||(this.series.forEach(function(n){"compare"===e&&"boolean"!==typeof c?n.setCompare(c,!1):"cumulative"!==e||l(c)||n.setCumulative(c,!1)}),K(p,!0)&&this.chart.redraw())}function r(e){var c=this,p=c.series.chart.numberFormatter,n=function(h){e=e.replace("{point."+h+
"}",(0<c[h]&&"change"===h?"+":"")+p(c[h],K(c.series.tooltipOptions.changeDecimals,2)))};t(c.change)&&n("change");t(c.cumulativeSum)&&n("cumulativeSum");return g.apply(this,[e])}function H(){var e=this.options.compare;if("percent"===e||"value"===e||this.options.cumulative){var c=new f(this);"percent"===e||"value"===e?c.initCompare(e):c.initCumulative()}this.dataModify=c}function m(e){e=e.dataExtremes;var c=e.activeYData;if(this.dataModify&&e){var p=void 0;this.options.compare?p=[this.dataModify.modifyValue(e.dataMin),
this.dataModify.modifyValue(e.dataMax)]:this.options.cumulative&&d(c)&&2<=c.length&&(p=f.getCumulativeExtremes(c));p&&(e.dataMin=x(p),e.dataMax=E(p))}}function F(e,c){this.options.compare=this.userOptions.compare=e;this.update({},K(c,!0));!this.dataModify||"value"!==e&&"percent"!==e?this.points.forEach(function(c){delete c.change}):this.dataModify.initCompare(e)}function S(){if(this.xAxis&&this.processedYData&&this.dataModify){var e=this.processedXData,c=this.processedYData,p=c.length,n=!0===this.options.compareStart?
0:1,h=-1,v;this.pointArrayMap&&(h=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y"));for(v=0;v<p-n;v++){var w=c[v]&&-1<h?c[v][h]:c[v];if(M(w)&&0!==w&&e[v+n]>=(this.xAxis.min||0)){this.dataModify.compareValue=w;break}}}}function k(e,c){this.setModifier("compare",e,c)}function O(e,c){e=K(e,!1);this.options.cumulative=this.userOptions.cumulative=e;this.update({},K(c,!0));this.dataModify?this.dataModify.initCumulative():this.points.forEach(function(c){delete c.cumulativeSum})}
function q(e,c){this.setModifier("cumulative",e,c)}var G=[];J.compose=function(e,c,p){if(-1===G.indexOf(e)){G.push(e);var n=e.prototype;n.setCompare=F;n.setCumulative=O;A(e,"afterInit",H);A(e,"afterGetExtremes",m);A(e,"afterProcessData",S)}-1===G.indexOf(c)&&(G.push(c),c=c.prototype,c.setCompare=k,c.setModifier=a,c.setCumulative=q);-1===G.indexOf(p)&&(G.push(p),p.prototype.tooltipFormatter=r);return e};var f=function(){function e(c){this.series=c}e.prototype.modifyValue=function(){return 0};e.getCumulativeExtremes=
function(c){var e=Infinity,n=-Infinity;c.reduce(function(h,c){c=h+c;e=Math.min(e,c,h);n=Math.max(n,c,h);return c});return[e,n]};e.prototype.initCompare=function(c){this.modifyValue=function(e,n){null===e&&(e=0);var h=this.compareValue;return"undefined"!==typeof e&&"undefined"!==typeof h?(e="value"===c?e-h:e/h*100-(100===this.series.options.compareBase?0:100),"undefined"!==typeof n&&(n=this.series.points[n])&&(n.change=e),e):0}};e.prototype.initCumulative=function(){this.modifyValue=function(c,e){null===
c&&(c=0);if(void 0!==c&&void 0!==e){var n=0<e?this.series.points[e-1]:null;n&&n.cumulativeSum&&(c=b(n.cumulativeSum+c));if(e=this.series.points[e])e.cumulativeSum=c;return c}return 0}};return e}();J.Additions=f})(H||(H={}));"";return H});I(a,"Core/Axis/BrokenAxis.js",[a["Extensions/Stacking.js"],a["Core/Utilities.js"]],function(a,u){var y=u.addEvent,m=u.find,g=u.fireEvent,A=u.isArray,E=u.isNumber,x=u.pick,b;(function(t){function d(){"undefined"!==typeof this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,
!1)}function b(){this.brokenAxis&&this.brokenAxis.hasBreaks&&(this.options.ordinal=!1)}function l(){var d=this.brokenAxis;if(d&&d.hasBreaks){for(var r=this.tickPositions,k=this.tickPositions.info,l=[],q=0;q<r.length;q++)d.isInAnyBreak(r[q])||l.push(r[q]);this.tickPositions=l;this.tickPositions.info=k}}function K(){this.brokenAxis||(this.brokenAxis=new L(this))}function H(){var d=this.options.connectNulls,r=this.points,k=this.xAxis,l=this.yAxis;if(this.isDirty)for(var q=r.length;q--;){var b=r[q],f=
!(null===b.y&&!1===d)&&(k&&k.brokenAxis&&k.brokenAxis.isInAnyBreak(b.x,!0)||l&&l.brokenAxis&&l.brokenAxis.isInAnyBreak(b.y,!0));b.visible=f?!1:!1!==b.options.visible}}function J(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,x(this.pointArrayMap,["y"]))}function D(d,r){var k=this,l=k.points,q,b,f,e;if(d&&d.brokenAxis&&d.brokenAxis.hasBreaks){var c=d.brokenAxis;r.forEach(function(p){q=c&&c.breakArray||[];b=d.isXAxis?d.min:x(k.options.threshold,d.min);l.forEach(function(c){e=x(c["stack"+
p.toUpperCase()],c[p]);q.forEach(function(h){if(E(b)&&E(e)){f=!1;if(b<h.from&&e>h.to||b>h.from&&e<h.from)f="pointBreak";else if(b<h.from&&e>h.from&&e<h.to||b>h.from&&e>h.to&&e<h.from)f="pointInBreak";f&&g(d,f,{point:c,brk:h})}})})})}}function r(){var d=this.currentDataGrouping,r=d&&d.gapSize;d=this.points.slice();var k=this.yAxis,l=this.options.gapSize,q=d.length-1,b;if(l&&0<q)for("value"!==this.options.gapUnit&&(l*=this.basePointRange),r&&r>l&&r>=this.basePointRange&&(l=r),b=void 0;q--;)b&&!1!==
b.visible||(b=d[q+1]),r=d[q],!1!==b.visible&&!1!==r.visible&&(b.x-r.x>l&&(b=(r.x+b.x)/2,d.splice(q+1,0,{isNull:!0,x:b}),k.stacking&&this.options.stacking&&(b=k.stacking.stacks[this.stackKey][b]=new a(k,k.options.stackLabels,!1,b,this.stack),b.total=0)),b=r);return this.getGraphPath(d)}var R=[];t.compose=function(t,a){-1===R.indexOf(t)&&(R.push(t),t.keepProps.push("brokenAxis"),y(t,"init",K),y(t,"afterInit",d),y(t,"afterSetTickPositions",l),y(t,"afterSetOptions",b));if(-1===R.indexOf(a)){R.push(a);
var k=a.prototype;k.drawBreaks=D;k.gappedPath=r;y(a,"afterGeneratePoints",H);y(a,"afterRender",J)}return t};var L=function(){function d(d){this.hasBreaks=!1;this.axis=d}d.isInBreak=function(d,k){var b=d.repeat||Infinity,q=d.from,r=d.to-d.from;k=k>=q?(k-q)%b:b-(q-k)%b;return d.inclusive?k<=r:k<r&&0!==k};d.lin2Val=function(b){var k=this.brokenAxis;k=k&&k.breakArray;if(!k||!E(b))return b;var r;for(r=0;r<k.length;r++){var q=k[r];if(q.from>=b)break;else q.to<b?b+=q.len:d.isInBreak(q,b)&&(b+=q.len)}return b};
d.val2Lin=function(b){var k=this.brokenAxis;k=k&&k.breakArray;if(!k||!E(b))return b;var r=b,q;for(q=0;q<k.length;q++){var l=k[q];if(l.to<=b)r-=l.len;else if(l.from>=b)break;else if(d.isInBreak(l,b)){r-=b-l.from;break}}return r};d.prototype.findBreakAt=function(d,k){return m(k,function(k){return k.from<d&&d<k.to})};d.prototype.isInAnyBreak=function(b,k){var r=this.axis,q=r.options.breaks||[],l=q.length,f;if(l&&E(b)){for(;l--;)if(d.isInBreak(q[l],b)){var e=!0;f||(f=x(q[l].showPoints,!r.isXAxis))}var c=
e&&k?e&&!f:e}return c};d.prototype.setBreaks=function(b,k){var r=this,q=r.axis,l=A(b)&&!!b.length;q.isDirty=r.hasBreaks!==l;r.hasBreaks=l;q.options.breaks=q.userOptions.breaks=b;q.forceRedraw=!0;q.series.forEach(function(f){f.isDirty=!0});l||q.val2lin!==d.val2Lin||(delete q.val2lin,delete q.lin2val);l&&(q.userOptions.ordinal=!1,q.lin2val=d.lin2Val,q.val2lin=d.val2Lin,q.setExtremes=function(f,e,c,p,n){if(r.hasBreaks){for(var h=this.options.breaks||[],v;v=r.findBreakAt(f,h);)f=v.to;for(;v=r.findBreakAt(e,
h);)e=v.from;e<f&&(e=f)}q.constructor.prototype.setExtremes.call(this,f,e,c,p,n)},q.setAxisTranslation=function(){q.constructor.prototype.setAxisTranslation.call(this);r.unitLength=void 0;if(r.hasBreaks){var f=q.options.breaks||[],e=[],c=[],p=x(q.pointRangePadding,0),n=0,h,v=q.userMin||q.min,w=q.userMax||q.max,b;f.forEach(function(c){h=c.repeat||Infinity;E(v)&&E(w)&&(d.isInBreak(c,v)&&(v+=c.to%h-v%h),d.isInBreak(c,w)&&(w-=w%h-c.from%h))});f.forEach(function(c){B=c.from;h=c.repeat||Infinity;if(E(v)&&
E(w)){for(;B-h>v;)B-=h;for(;B<v;)B+=h;for(b=B;b<w;b+=h)e.push({value:b,move:"in"}),e.push({value:b+c.to-c.from,move:"out",size:c.breakSize})}});e.sort(function(h,c){return h.value===c.value?("in"===h.move?0:1)-("in"===c.move?0:1):h.value-c.value});var k=0;var B=v;e.forEach(function(h){k+="in"===h.move?1:-1;1===k&&"in"===h.move&&(B=h.value);0===k&&E(B)&&(c.push({from:B,to:h.value,len:h.value-B-(h.size||0)}),n+=h.value-B-(h.size||0))});r.breakArray=c;E(v)&&E(w)&&E(q.min)&&(r.unitLength=w-v-n+p,g(q,
"afterBreaks"),q.staticScale?q.transA=q.staticScale:r.unitLength&&(q.transA*=(w-q.min+p)/r.unitLength),p&&(q.minPixelPadding=q.transA*(q.minPointOffset||0)),q.min=v,q.max=w)}});x(k,!0)&&q.chart.redraw()};return d}();t.Additions=L})(b||(b={}));return b});I(a,"masters/modules/broken-axis.src.js",[a["Core/Globals.js"],a["Core/Axis/BrokenAxis.js"]],function(a,u){u.compose(a.Axis,a.Series)});I(a,"Extensions/DataGrouping.js",[a["Core/Axis/Axis.js"],a["Core/Axis/DateTimeAxis.js"],a["Core/FormatUtilities.js"],
a["Core/Globals.js"],a["Core/Series/Point.js"],a["Core/Series/Series.js"],a["Core/Tooltip.js"],a["Core/DefaultOptions.js"],a["Core/Utilities.js"]],function(a,u,y,m,g,A,E,x,b){var t=y.format,d=A.prototype;y=b.addEvent;var M=b.arrayMax,l=b.arrayMin,K=b.correctFloat,H=b.defined,J=b.error,D=b.extend,r=b.isNumber,R=b.merge,L=b.pick;"";var F=m.approximations={sum:function(f){var e=f.length;if(!e&&f.hasNulls)var c=null;else if(e)for(c=0;e--;)c+=f[e];return c},average:function(f){var e=f.length;f=F.sum(f);
r(f)&&e&&(f=K(f/e));return f},averages:function(){var f=[];[].forEach.call(arguments,function(e){f.push(F.average(e))});return"undefined"===typeof f[0]?void 0:f},open:function(f){return f.length?f[0]:f.hasNulls?null:void 0},high:function(f){return f.length?M(f):f.hasNulls?null:void 0},low:function(f){return f.length?l(f):f.hasNulls?null:void 0},close:function(f){return f.length?f[f.length-1]:f.hasNulls?null:void 0},hlc:function(f,e,c){f=F.high(f);e=F.low(e);c=F.close(c);if(r(f)||r(e)||r(c))return[f,
e,c]},ohlc:function(f,e,c,p){f=F.open(f);e=F.high(e);c=F.low(c);p=F.close(p);if(r(f)||r(e)||r(c)||r(p))return[f,e,c,p]},range:function(f,e){f=F.low(f);e=F.high(e);if(r(f)||r(e))return[f,e];if(null===f&&null===e)return null}};b=function(f,e,c,p){var n=this,h=n.data,v=n.options&&n.options.data,w=[],d=[],b=[],B=f.length,k=!!e,z=[],l=n.pointArrayMap,q=l&&l.length,t=["x"].concat(l||["y"]),a=this.options.dataGrouping&&this.options.dataGrouping.groupAll,J=0,K=0,D;p="function"===typeof p?p:F[p]?F[p]:F[n.getDGApproximation&&
n.getDGApproximation()||"average"];q?l.forEach(function(){z.push([])}):z.push([]);var M=q||1;for(D=0;D<=B&&!(f[D]>=c[0]);D++);for(D;D<=B;D++){for(;"undefined"!==typeof c[J+1]&&f[D]>=c[J+1]||D===B;){var g=c[J];n.dataGroupInfo={start:a?K:n.cropStart+K,length:z[0].length};var x=p.apply(n,z);n.pointClass&&!H(n.dataGroupInfo.options)&&(n.dataGroupInfo.options=R(n.pointClass.prototype.optionsToObject.call({series:n},n.options.data[n.cropStart+K])),t.forEach(function(h){delete n.dataGroupInfo.options[h]}));
"undefined"!==typeof x&&(w.push(g),d.push(x),b.push(n.dataGroupInfo));K=D;for(g=0;g<M;g++)z[g].length=0,z[g].hasNulls=!1;J+=1;if(D===B)break}if(D===B)break;if(l){g=n.options.dataGrouping&&n.options.dataGrouping.groupAll?D:n.cropStart+D;x=h&&h[g]||n.pointClass.prototype.applyOptions.apply({series:n},[v[g]]);var m=void 0;for(g=0;g<q;g++)m=x[l[g]],r(m)?z[g].push(m):null===m&&(z[g].hasNulls=!0)}else g=k?e[D]:null,r(g)?z[0].push(g):null===g&&(z[0].hasNulls=!0)}return{groupedXData:w,groupedYData:d,groupMap:b}};
var N={approximations:F,groupData:b},k=d.generatePoints,O={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y",
"%Y","-%Y"]}},q={line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},hlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},G=m.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];d.getDGApproximation=function(){return this.is("arearange")?
"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")?"sum":"average"};d.groupData=b;d.applyGrouping=function(f){var e=this.chart,c=this.options.dataGrouping,p=!1!==this.allowDG&&c&&L(c.enabled,e.options.isStock),n=this.visible||!e.options.chart.ignoreHiddenSeries,h,v=this.currentDataGrouping,w=!1;p&&!this.requireSorting&&(this.requireSorting=w=!0);f=!1===!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!f)||!p;w&&(this.requireSorting=!1);if(!f){this.destroyGroupedData();
p=c.groupAll?this.xData:this.processedXData;var b=c.groupAll?this.yData:this.processedYData;f=e.plotSizeX;w=this.xAxis;var k=w.options.ordinal,B=this.groupPixelWidth;if(B&&p&&p.length){this.isDirty=h=!0;this.points=null;var C=w.getExtremes();var z=C.min;C=C.max;k=k&&w.ordinal&&w.ordinal.getGroupIntervalFactor(z,C,this)||1;f=w.getTimeTicks(u.Additions.prototype.normalizeTimeTickInterval(B*(C-z)/f*k,c.units||G),Math.min(z,p[0]),Math.max(C,p[p.length-1]),w.options.startOfWeek,p,this.closestPointRange);
B=d.groupData.apply(this,[p,b,f,c.approximation]);p=B.groupedXData;b=B.groupedYData;k=0;c&&c.smoothed&&p.length&&(c.firstAnchor="firstPoint",c.anchor="middle",c.lastAnchor="lastPoint",J(32,!1,e,{"dataGrouping.smoothed":"use dataGrouping.anchor"}));e=p;var l=this.options.dataGrouping;z=this.currentDataGrouping&&this.currentDataGrouping.gapSize;if(l&&this.xData&&z&&this.groupMap){var q=e.length-1;var t=l.anchor;var a=L(l.firstAnchor,t);l=L(l.lastAnchor,t);if(t&&"start"!==t){var D=z*{middle:.5,end:1}[t];
for(t=e.length-1;t--&&0<t;)e[t]+=D}if(a&&"start"!==a&&this.xData[0]>=e[0]){t=this.groupMap[0].start;D=this.groupMap[0].length;var K=void 0;r(t)&&r(D)&&(K=t+(D-1));e[0]={middle:e[0]+.5*z,end:e[0]+z,firstPoint:this.xData[0],lastPoint:K&&this.xData[K]}[a]}l&&"start"!==l&&z&&e[q]>=C-z&&(C=this.groupMap[this.groupMap.length-1].start,e[q]={middle:e[q]+.5*z,end:e[q]+z,firstPoint:C&&this.xData[C],lastPoint:this.xData[this.xData.length-1]}[l])}for(C=1;C<f.length;C++)f.info.segmentStarts&&-1!==f.info.segmentStarts.indexOf(C)||
(k=Math.max(f[C]-f[C-1],k));C=f.info;C.gapSize=k;this.closestPointRange=f.info.totalRange;this.groupMap=B.groupMap;if(n){n=p;if(H(n[0])&&r(w.min)&&r(w.dataMin)&&n[0]<w.min){if(!H(w.options.min)&&w.min<=w.dataMin||w.min===w.dataMin)w.min=Math.min(n[0],w.min);w.dataMin=Math.min(n[0],w.dataMin)}if(H(n[n.length-1])&&r(w.max)&&r(w.dataMax)&&n[n.length-1]>w.max){if(!H(w.options.max)&&r(w.dataMax)&&w.max>=w.dataMax||w.max===w.dataMax)w.max=Math.max(n[n.length-1],w.max);w.dataMax=Math.max(n[n.length-1],w.dataMax)}}c.groupAll&&
(this.allGroupedData=b,c=this.cropData(p,b,w.min,w.max,1),p=c.xData,b=c.yData,this.cropStart=c.start);this.processedXData=p;this.processedYData=b}else this.groupMap=null;this.hasGroupedData=h;this.currentDataGrouping=C;this.preventGraphAnimation=(v&&v.totalRange)!==(C&&C.totalRange)}};d.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(f,e){f&&(this.groupedData[e]=f.destroy?f.destroy():null)},this),this.groupedData.length=0)};d.generatePoints=function(){k.apply(this);
this.destroyGroupedData();this.groupedData=this.hasGroupedData?this.points:null};a.prototype.applyGrouping=function(f){var e=this,c=e.series;c.forEach(function(c){c.groupPixelWidth=void 0});c.forEach(function(c){c.groupPixelWidth=e.getGroupPixelWidth&&e.getGroupPixelWidth();c.groupPixelWidth&&(c.hasProcessed=!0);c.applyGrouping(!!f.hasExtemesChanged)})};a.prototype.getGroupPixelWidth=function(){var f=this.series,e=f.length,c,p=0,n=!1,h;for(c=e;c--;)(h=f[c].options.dataGrouping)&&(p=Math.max(p,L(h.groupPixelWidth,
O.groupPixelWidth)));for(c=e;c--;)if(h=f[c].options.dataGrouping)if(e=(f[c].processedXData||f[c].data).length,f[c].groupPixelWidth||e>this.chart.plotSizeX/p||e&&h.forced)n=!0;return n?p:0};a.prototype.setDataGrouping=function(f,e){var c;e=L(e,!0);f||(f={forced:!1,units:null});if(this instanceof a)for(c=this.series.length;c--;)this.series[c].update({dataGrouping:f},!1);else this.chart.options.series.forEach(function(c){c.dataGrouping="boolean"===typeof f?f:R(f,c.dataGrouping)});this.ordinal&&(this.ordinal.slope=
void 0);e&&this.chart.redraw()};y(a,"postProcessData",a.prototype.applyGrouping);y(g,"update",function(){if(this.dataGroup)return J(24,!1,this.series.chart),!1});y(E,"headerFormatter",function(f){var e=this.chart,c=e.time,p=f.labelConfig,n=p.series,h=n.tooltipOptions,v=n.options.dataGrouping,w=h.xDateFormat,d=n.xAxis,b=h[f.isFooter?"footerFormat":"headerFormat"];if(d&&"datetime"===d.options.type&&v&&r(p.key)){var k=n.currentDataGrouping;v=v.dateTimeLabelFormats||O.dateTimeLabelFormats;if(k)if(h=v[k.unitName],
1===k.count)w=h[0];else{w=h[1];var l=h[2]}else!w&&v&&d.dateTime&&(w=d.dateTime.getXDateFormat(p.x,h.dateTimeLabelFormats));w=c.dateFormat(w,p.key);l&&(w+=c.dateFormat(l,p.key+k.totalRange-1));n.chart.styledMode&&(b=this.styledModeFormat(b));f.text=t(b,{point:D(p.point,{key:w}),series:n},e);f.preventDefault()}});y(A,"destroy",d.destroyGroupedData);y(A,"afterSetOptions",function(f){f=f.options;var e=this.type,c=this.chart.options.plotOptions,p=x.defaultOptions.plotOptions[e].dataGrouping,n=this.useCommonDataGrouping&&
O;if(c&&(q[e]||n)){p||(p=R(O,q[e]));var h=this.chart.rangeSelector;f.dataGrouping=R(n,p,c.series&&c.series.dataGrouping,c[e].dataGrouping,this.userOptions.dataGrouping,!f.isInternal&&h&&r(h.selected)&&h.buttonOptions[h.selected].dataGrouping)}});y(a,"afterSetScale",function(){this.series.forEach(function(f){f.hasProcessed=!1})});m.dataGrouping=N;"";return N});I(a,"Series/HLC/HLCPoint.js",[a["Core/Series/SeriesRegistry.js"]],function(a){var u=this&&this.__extends||function(){var a=function(m,g){a=
Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,g){a.__proto__=g}||function(a,g){for(var x in g)g.hasOwnProperty(x)&&(a[x]=g[x])};return a(m,g)};return function(m,g){function A(){this.constructor=m}a(m,g);m.prototype=null===g?Object.create(g):(A.prototype=g.prototype,new A)}}();return function(a){function m(){var g=null!==a&&a.apply(this,arguments)||this;g.close=void 0;g.high=void 0;g.low=void 0;g.options=void 0;g.plotClose=void 0;g.series=void 0;return g}u(m,a);return m}(a.seriesTypes.column.prototype.pointClass)});
I(a,"Series/HLC/HLCSeries.js",[a["Series/HLC/HLCPoint.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,u,y){var m=this&&this.__extends||function(){var a=function(b,t){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var l in b)b.hasOwnProperty(l)&&(d[l]=b[l])};return a(b,t)};return function(b,t){function d(){this.constructor=b}a(b,t);b.prototype=null===t?Object.create(t):(d.prototype=t.prototype,new d)}}(),g=u.seriesTypes.column,
A=y.extend,E=y.merge;y=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;b.yData=void 0;return b}m(b,a);b.prototype.extendStem=function(b,d,a){var l=b[0];b=b[1];"number"===typeof l[2]&&(l[2]=Math.max(a+d,l[2]));"number"===typeof b[2]&&(b[2]=Math.min(a-d,b[2]))};b.prototype.getPointPath=function(b,d){d=d.strokeWidth();var a=b.series,l=d%2/2,t=Math.round(b.plotX)-l,g=Math.round(b.shapeArgs.width/2);var J=[["M",t,Math.round(b.yBottom)],
["L",t,Math.round(b.plotHigh)]];null!==b.close&&(b=Math.round(b.plotClose)+l,J.push(["M",t,b],["L",t+g,b]),a.extendStem(J,d/2,b));return J};b.prototype.drawSinglePoint=function(b){var d=b.series,a=d.chart,l=b.graphic,t=!l;"undefined"!==typeof b.plotY&&(l||(b.graphic=l=a.renderer.path().add(d.group)),a.styledMode||l.attr(d.pointAttribs(b,b.selected&&"select")),d=d.getPointPath(b,l),l[t?"attr":"animate"]({d:d}).addClass(b.getClassName(),!0))};b.prototype.drawPoints=function(){this.points.forEach(this.drawSinglePoint)};
b.prototype.init=function(){a.prototype.init.apply(this,arguments);this.options.stacking=void 0};b.prototype.pointAttribs=function(b,d){b=a.prototype.pointAttribs.call(this,b,d);delete b.fill;return b};b.prototype.toYData=function(b){return[b.high,b.low,b.close]};b.prototype.translate=function(){var b=this,d=b.yAxis,g=this.pointArrayMap&&this.pointArrayMap.slice()||[],l=g.map(function(b){return"plot"+(b.charAt(0).toUpperCase()+b.slice(1))});l.push("yBottom");g.push("low");a.prototype.translate.apply(b);
b.points.forEach(function(a){g.forEach(function(t,J){t=a[t];null!==t&&(b.dataModify&&(t=b.dataModify.modifyValue(t)),a[l[J]]=d.toPixels(t,!0))});a.tooltipPos[1]=a.plotHigh+d.pos-b.chart.plotTop})};b.defaultOptions=E(g.defaultOptions,{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0});return b}(g);A(y.prototype,
{animate:null,directTouch:!1,pointArrayMap:["high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});y.prototype.pointClass=a;u.registerSeriesType("hlc",y);"";return y});I(a,"Series/OHLC/OHLCPoint.js",[a["Core/Series/SeriesRegistry.js"]],function(a){var u=this&&this.__extends||function(){var a=function(m,g){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,g){a.__proto__=g}||function(a,g){for(var m in g)g.hasOwnProperty(m)&&(a[m]=
g[m])};return a(m,g)};return function(m,g){function A(){this.constructor=m}a(m,g);m.prototype=null===g?Object.create(g):(A.prototype=g.prototype,new A)}}();return function(a){function m(){var g=null!==a&&a.apply(this,arguments)||this;g.open=void 0;g.options=void 0;g.plotOpen=void 0;g.series=void 0;return g}u(m,a);m.prototype.getClassName=function(){return a.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")};m.prototype.resolveUpColor=function(){this.open<
this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)};m.prototype.resolveColor=function(){a.prototype.resolveColor.call(this);this.resolveUpColor()};m.prototype.getZone=function(){var g=a.prototype.getZone.call(this);this.resolveUpColor();return g};m.prototype.applyOptions=function(){a.prototype.applyOptions.apply(this,arguments);this.resolveColor&&this.resolveColor();return this};return m}(a.seriesTypes.hlc.prototype.pointClass)});I(a,"Series/OHLC/OHLCSeries.js",
[a["Series/OHLC/OHLCPoint.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,u,y){var m=this&&this.__extends||function(){var b=function(d,l){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,d){b.__proto__=d}||function(b,d){for(var l in d)d.hasOwnProperty(l)&&(b[l]=d[l])};return b(d,l)};return function(d,l){function a(){this.constructor=d}b(d,l);d.prototype=null===l?Object.create(l):(a.prototype=l.prototype,new a)}}(),g=u.series,A=u.seriesTypes.hlc,E=y.addEvent,
x=y.extend,b=y.merge,t=function(d){function a(){var b=null!==d&&d.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}m(a,d);a.prototype.getPointPath=function(b,a){var l=d.prototype.getPointPath.call(this,b,a);a=a.strokeWidth();var t=a%2/2,g=Math.round(b.plotX)-t,r=Math.round(b.shapeArgs.width/2);null!==b.open&&(b=Math.round(b.plotOpen)+t,l.push(["M",g,b],["L",g-r,b]),d.prototype.extendStem.call(this,l,a/2,b));return l};a.prototype.pointAttribs=function(b,a){a=d.prototype.pointAttribs.call(this,
b,a);var l=this.options;delete a.fill;!b.options.color&&l.upColor&&b.open<b.close&&(a.stroke=l.upColor);return a};a.prototype.toYData=function(b){return[b.open,b.high,b.low,b.close]};a.defaultOptions=b(A.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'}});return a}(A);x(t.prototype,{pointArrayMap:["open","high","low","close"]});t.prototype.pointClass=
a;u.registerSeriesType("ohlc",t);E(g,"init",function(b){b=b.options;b.useOhlcData&&"highcharts-navigator-series"!==b.id&&x(this,{pointValKey:t.prototype.pointValKey,pointArrayMap:t.prototype.pointArrayMap,toYData:t.prototype.toYData})});E(g,"afterSetOptions",function(b){b=b.options;var d=b.dataGrouping;d&&b.useOhlcData&&"highcharts-navigator-series"!==b.id&&(d.approximation="ohlc")});"";return t});I(a,"Series/Candlestick/CandlestickSeries.js",[a["Core/DefaultOptions.js"],a["Core/Series/SeriesRegistry.js"],
a["Core/Utilities.js"]],function(a,u,y){var m=this&&this.__extends||function(){var b=function(a,d){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,d){b.__proto__=d}||function(b,d){for(var a in d)d.hasOwnProperty(a)&&(b[a]=d[a])};return b(a,d)};return function(a,d){function g(){this.constructor=a}b(a,d);a.prototype=null===d?Object.create(d):(g.prototype=d.prototype,new g)}}(),g=a.defaultOptions;a=u.seriesTypes;var A=a.column,E=a.ohlc,x=y.merge;y=function(b){function a(){var a=null!==
b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(a,b);a.prototype.pointAttribs=function(b,a){var d=A.prototype.pointAttribs.call(this,b,a),g=this.options,t=b.open<b.close,J=g.lineColor||this.color,D=b.color||this.color;d["stroke-width"]=g.lineWidth;d.fill=b.options.color||(t?g.upColor||D:D);d.stroke=b.options.lineColor||(t?g.upLineColor||J:J);a&&(b=g.states[a],d.fill=b.color||d.fill,d.stroke=b.lineColor||d.stroke,d["stroke-width"]=b.lineWidth||d["stroke-width"]);
return d};a.prototype.drawPoints=function(){var b=this,a=b.chart,l=b.yAxis.reversed;b.points.forEach(function(d){var g=d.graphic,t=!g;if("undefined"!==typeof d.plotY){g||(d.graphic=g=a.renderer.path().add(b.group));b.chart.styledMode||g.attr(b.pointAttribs(d,d.selected&&"select")).shadow(b.options.shadow);var D=g.strokeWidth()%2/2;var r=Math.round(d.plotX)-D;var m=d.plotOpen;var L=d.plotClose;var F=Math.min(m,L);m=Math.max(m,L);var A=Math.round(d.shapeArgs.width/2);L=l?m!==d.yBottom:Math.round(F)!==
Math.round(d.plotHigh);var k=l?Math.round(F)!==Math.round(d.plotHigh):m!==d.yBottom;F=Math.round(F)+D;m=Math.round(m)+D;D=[];D.push(["M",r-A,m],["L",r-A,F],["L",r+A,F],["L",r+A,m],["Z"],["M",r,F],["L",r,L?Math.round(l?d.yBottom:d.plotHigh):F],["M",r,m],["L",r,k?Math.round(l?d.plotHigh:d.yBottom):m]);g[t?"attr":"animate"]({d:D}).addClass(d.getClassName(),!0)}})};a.defaultOptions=x(E.defaultOptions,g.plotOptions,{states:{hover:{lineWidth:2}},tooltip:g.plotOptions.ohlc.tooltip,threshold:null,lineColor:"#000000",
lineWidth:1,upColor:"#ffffff",stickyTracking:!0});return a}(E);u.registerSeriesType("candlestick",y);"";return y});I(a,"Series/Flags/FlagsPoint.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,u){var y=this&&this.__extends||function(){var a=function(g,m){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var g in b)b.hasOwnProperty(g)&&(a[g]=b[g])};return a(g,m)};return function(g,m){function A(){this.constructor=g}a(g,
m);g.prototype=null===m?Object.create(m):(A.prototype=m.prototype,new A)}}(),m=u.isNumber;return function(a){function g(){var g=null!==a&&a.apply(this,arguments)||this;g.options=void 0;g.series=void 0;return g}y(g,a);g.prototype.isValid=function(){return m(this.y)||"undefined"===typeof this.y};g.prototype.hasNewShapeType=function(){var a=this.options.shape||this.series.options.shape;return this.graphic&&a&&a!==this.graphic.symbolKey};return g}(a.seriesTypes.column.prototype.pointClass)});I(a,"Series/OnSeriesComposition.js",
[a["Series/Column/ColumnSeries.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,u,y){var m=a.prototype,g=u.prototype,A=y.defined,E=y.stableSort,x;(function(b){function a(){return g.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)}function d(){m.translate.apply(this);var b=this,a=b.options,d=b.chart,g=b.points,D=a.onSeries,r=(D=D&&d.get(D))&&D.options.step,t=D&&D.points,L=d.inverted,F=b.xAxis,x=b.yAxis;d=g.length-1;var k;a=a.onKey||"y";var u=t&&
t.length,q=0,G;if(D&&D.visible&&u){q=(D.pointXOffset||0)+(D.barW||0)/2;var f=D.currentDataGrouping;var e=t[u-1].x+(f?f.totalRange:0);E(g,function(c,h){return c.x-h.x});for(a="plot"+a[0].toUpperCase()+a.substr(1);u--&&g[d];){var c=t[u];f=g[d];f.y=c.y;if(c.x<=f.x&&"undefined"!==typeof c[a]){if(f.x<=e&&(f.plotY=c[a],c.x<f.x&&!r&&(G=t[u+1])&&"undefined"!==typeof G[a])){var p=(f.x-c.x)/(G.x-c.x);f.plotY+=p*(G[a]-c[a]);f.y+=p*(G.y-c.y)}d--;u++;if(0>d)break}}}g.forEach(function(c,h){c.plotX+=q;if("undefined"===
typeof c.plotY||L)0<=c.plotX&&c.plotX<=F.len?L?(c.plotY=F.translate(c.x,0,1,0,1),c.plotX=A(c.y)?x.translate(c.y,0,0,0,1):0):c.plotY=(F.opposite?0:b.yAxis.len)+F.offset:c.shapeArgs={};if((k=g[h-1])&&k.plotX===c.plotX){"undefined"===typeof k.stackIndex&&(k.stackIndex=0);var v=k.stackIndex+1}c.stackIndex=v});this.onSeries=D}var x=[];b.compose=function(b){if(-1===x.indexOf(b)){x.push(b);var g=b.prototype;g.getPlotBox=a;g.translate=d}return b};b.getPlotBox=a;b.translate=d})(x||(x={}));return x});I(a,"Series/Flags/FlagsSymbols.js",
[a["Core/Renderer/RendererRegistry.js"],a["Core/Renderer/SVG/SVGRenderer.js"]],function(a,u){function y(a){m[a+"pin"]=function(g,u,x,b,t){var d=t&&t.anchorX;t=t&&t.anchorY;"circle"===a&&b>x&&(g-=Math.round((b-x)/2),x=b);var A=m[a](g,u,x,b);if(d&&t){var l=d;"circle"===a?l=g+x/2:(g=A[0],x=A[1],"M"===g[0]&&"L"===x[0]&&(l=(g[1]+x[1])/2));A.push(["M",l,u>t?u:u+b],["L",d,t]);A=A.concat(m.circle(d-1,t-1,2,2))}return A}}var m=u.prototype.symbols;m.flag=function(a,u,y,x,b){var g=b&&b.anchorX||a;b=b&&b.anchorY||
u;var d=m.circle(g-1,b-1,2,2);d.push(["M",g,b],["L",a,u+x],["L",a,u],["L",a+y,u],["L",a+y,u+x],["L",a,u+x],["Z"]);return d};y("circle");y("square");a=a.getRendererType();a!==u&&(a.prototype.symbols.circlepin=m.circlepin,a.prototype.symbols.flag=m.flag,a.prototype.symbols.squarepin=m.squarepin);return m});I(a,"Series/Flags/FlagsSeries.js",[a["Series/Flags/FlagsPoint.js"],a["Core/Globals.js"],a["Series/OnSeriesComposition.js"],a["Core/Renderer/RendererUtilities.js"],a["Core/Series/SeriesRegistry.js"],
a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,u,y,m,g,A,E){var x=this&&this.__extends||function(){var b=function(a,d){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var d in a)a.hasOwnProperty(d)&&(b[d]=a[d])};return b(a,d)};return function(a,d){function r(){this.constructor=a}b(a,d);a.prototype=null===d?Object.create(d):(r.prototype=d.prototype,new r)}}();u=u.noop;var b=m.distribute,t=g.series,d=g.seriesTypes.column,
M=E.addEvent,l=E.defined;m=E.extend;var K=E.merge,H=E.objectEach,J=E.wrap;E=function(a){function r(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}x(r,a);r.prototype.animate=function(b){b&&this.setClip()};r.prototype.drawPoints=function(){var a=this.points,d=this.chart,r=d.renderer,g=d.inverted,k=this.options,t=k.y,q,m=this.yAxis,f={},e=[];for(q=a.length;q--;){var c=a[q];var p=(g?c.plotY:c.plotX)>this.xAxis.len;var n=c.plotX;var h=c.stackIndex;
var v=c.options.shape||k.shape;var w=c.plotY;"undefined"!==typeof w&&(w=c.plotY+t-("undefined"!==typeof h&&h*k.stackDistance));c.anchorX=h?void 0:c.plotX;var P=h?void 0:c.plotY;var Q="flag"!==v;h=c.graphic;"undefined"!==typeof w&&0<=n&&!p?(h&&c.hasNewShapeType()&&(h=h.destroy()),h||(h=c.graphic=r.label("",null,null,v,null,null,k.useHTML).addClass("highcharts-point").add(this.markerGroup),c.graphic.div&&(c.graphic.div.point=c),h.isNew=!0),h.attr({align:Q?"center":"left",width:k.width,height:k.height,
"text-align":k.textAlign}),d.styledMode||h.attr(this.pointAttribs(c)).css(K(k.style,c.style)).shadow(k.shadow),0<n&&(n-=h.strokeWidth()%2),v={y:w,anchorY:P},k.allowOverlapX&&(v.x=n,v.anchorX=c.anchorX),h.attr({text:c.options.title||k.title||"A"})[h.isNew?"attr":"animate"](v),k.allowOverlapX||(f[c.plotX]?f[c.plotX].size=Math.max(f[c.plotX].size,h.width):f[c.plotX]={align:Q?.5:0,size:h.width,target:n,anchorX:n}),c.tooltipPos=[n,w+m.pos-d.plotTop]):h&&(c.graphic=h.destroy())}if(!k.allowOverlapX){var B=
100;H(f,function(h){h.plotX=h.anchorX;e.push(h);B=Math.max(h.size,B)});b(e,g?m.len:this.xAxis.len,B);a.forEach(function(h){var c=h.plotX,v=h.graphic;(c=v&&f[c])&&v&&(l(c.pos)?v[v.isNew?"attr":"animate"]({x:c.pos+(c.align||0)*c.size,anchorX:h.anchorX}).show().isNew=!1:v.hide().isNew=!0)})}k.useHTML&&J(this.markerGroup,"on",function(h){return A.prototype.on.apply(h.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})};r.prototype.drawTracker=function(){var b=this.points;a.prototype.drawTracker.call(this);
b.forEach(function(a){var d=a.graphic;d&&(a.unbindMouseOver&&a.unbindMouseOver(),a.unbindMouseOver=M(d.element,"mouseover",function(){0<a.stackIndex&&!a.raised&&(a._y=d.y,d.attr({y:a._y-8}),a.raised=!0);b.forEach(function(b){b!==a&&b.raised&&b.graphic&&(b.graphic.attr({y:b._y}),b.raised=!1)})}))})};r.prototype.pointAttribs=function(b,a){var d=this.options,r=b&&b.color||this.color,k=d.lineColor,g=b&&b.lineWidth;b=b&&b.fillColor||d.fillColor;a&&(b=d.states[a].fillColor,k=d.states[a].lineColor,g=d.states[a].lineWidth);
return{fill:b||r,stroke:k||r,"stroke-width":g||d.lineWidth||0}};r.prototype.setClip=function(){t.prototype.setClip.apply(this,arguments);!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])};r.defaultOptions=K(d.defaultOptions,{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",
fillColor:"#ccd6eb"}},style:{fontSize:"11px",fontWeight:"bold"}});return r}(d);y.compose(E);m(E.prototype,{allowDG:!1,forceCrop:!0,invertible:!1,noSharedTooltip:!0,pointClass:a,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],buildKDTree:u,init:t.prototype.init,invertGroups:u});g.registerSeriesType("flags",E);"";"";return E});I(a,"Core/Axis/ScrollbarAxis.js",[a["Core/Utilities.js"]],function(a){var u=a.addEvent,y=a.defined,m=a.pick;return function(){function a(){}a.compose=function(g,
E){if(-1===a.composed.indexOf(g))a.composed.push(g);else return g;var x=function(b){var a=m(b.options&&b.options.min,b.min),d=m(b.options&&b.options.max,b.max);return{axisMin:a,axisMax:d,scrollMin:y(b.dataMin)?Math.min(a,b.min,b.dataMin,m(b.threshold,Infinity)):a,scrollMax:y(b.dataMax)?Math.max(d,b.max,b.dataMax,m(b.threshold,-Infinity)):d}};u(g,"afterInit",function(){var b=this;b.options&&b.options.scrollbar&&b.options.scrollbar.enabled&&(b.options.scrollbar.vertical=!b.horiz,b.options.startOnTick=
b.options.endOnTick=!1,b.scrollbar=new E(b.chart.renderer,b.options.scrollbar,b.chart),u(b.scrollbar,"changed",function(a){var d=x(b),g=d.axisMax,l=d.scrollMin,m=d.scrollMax-l;y(d.axisMin)&&y(g)&&(b.horiz&&!b.reversed||!b.horiz&&b.reversed?(d=l+m*this.to,l+=m*this.from):(d=l+m*(1-this.from),l+=m*(1-this.to)),this.shouldUpdateExtremes(a.DOMType)?b.setExtremes(l,d,!0,"mousemove"!==a.DOMType&&"touchmove"!==a.DOMType,a):this.setRange(this.from,this.to))}))});u(g,"afterRender",function(){var b=x(this),
a=b.scrollMin,d=b.scrollMax;b=this.scrollbar;var g=this.axisTitleMargin+(this.titleOffset||0),l=this.chart.scrollbarsOffsets,m=this.options.margin||0;b&&(this.horiz?(this.opposite||(l[1]+=g),b.position(this.left,this.top+this.height+2+l[1]-(this.opposite?m:0),this.width,this.height),this.opposite||(l[1]+=m),g=1):(this.opposite&&(l[0]+=g),b.position(b.options.opposite?this.left+this.width+2+l[0]-(this.opposite?0:m):this.opposite?0:m,this.top,this.width,this.height),this.opposite&&(l[0]+=m),g=0),l[g]+=
b.size+b.options.margin,isNaN(a)||isNaN(d)||!y(this.min)||!y(this.max)||this.min===this.max?b.setRange(0,1):(l=(this.min-a)/(d-a),a=(this.max-a)/(d-a),this.horiz&&!this.reversed||!this.horiz&&this.reversed?b.setRange(l,a):b.setRange(1-a,1-l)))});u(g,"afterGetOffset",function(){var b=this.scrollbar&&!this.scrollbar.options.opposite;b=this.horiz?2:b?3:1;var a=this.scrollbar;a&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[b]+=a.size+a.options.margin)});return g};a.composed=[];return a}()});
I(a,"Core/ScrollbarDefaults.js",[a["Core/Globals.js"]],function(a){return{height:a.isTouchDevice?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:1,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"#333333",trackBackgroundColor:"#f2f2f2",trackBorderColor:"#f2f2f2",trackBorderWidth:1}});I(a,"Core/Scrollbar.js",
[a["Core/DefaultOptions.js"],a["Core/Globals.js"],a["Core/Axis/ScrollbarAxis.js"],a["Core/ScrollbarDefaults.js"],a["Core/Utilities.js"]],function(a,u,y,m,g){var A=a.defaultOptions,E=g.addEvent,x=g.correctFloat,b=g.defined,t=g.destroyObjectProperties,d=g.fireEvent,M=g.merge,l=g.pick,K=g.removeEvent;a=function(){function a(a,b,d){this._events=[];this.chart=void 0;this.from=this.chartY=this.chartX=0;this.scrollbar=this.renderer=this.options=this.group=void 0;this.scrollbarButtons=[];this.scrollbarGroup=
void 0;this.scrollbarLeft=0;this.scrollbarRifles=void 0;this.scrollbarStrokeWidth=1;this.to=this.size=this.scrollbarTop=0;this.track=void 0;this.trackBorderWidth=1;this.userOptions=void 0;this.y=this.x=0;this.init(a,b,d)}a.compose=function(b){y.compose(b,a)};a.swapXY=function(a,b){b&&a.forEach(function(a){for(var b=a.length,d,r=0;r<b;r+=2)d=a[r+1],"number"===typeof d&&(a[r+1]=a[r+2],a[r+2]=d)});return a};a.prototype.addEvents=function(){var a=this.options.inverted?[1,0]:[0,1],b=this.scrollbarButtons,
d=this.scrollbarGroup.element,g=this.track.element,l=this.mouseDownHandler.bind(this),m=this.mouseMoveHandler.bind(this),t=this.mouseUpHandler.bind(this);a=[[b[a[0]].element,"click",this.buttonToMinClick.bind(this)],[b[a[1]].element,"click",this.buttonToMaxClick.bind(this)],[g,"click",this.trackClick.bind(this)],[d,"mousedown",l],[d.ownerDocument,"mousemove",m],[d.ownerDocument,"mouseup",t]];u.hasTouch&&a.push([d,"touchstart",l],[d.ownerDocument,"touchmove",m],[d.ownerDocument,"touchend",t]);a.forEach(function(a){E.apply(null,
a)});this._events=a};a.prototype.buttonToMaxClick=function(a){var b=(this.to-this.from)*l(this.options.step,.2);this.updatePosition(this.from+b,this.to+b);d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.buttonToMinClick=function(a){var b=x(this.to-this.from)*l(this.options.step,.2);this.updatePosition(x(this.from-b),x(this.to-b));d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.cursorToScrollbarPosition=function(a){var b=
this.options;b=b.minWidth>this.calculatedWidth?b.minWidth:0;return{chartX:(a.chartX-this.x-this.xOffset)/(this.barWidth-b),chartY:(a.chartY-this.y-this.yOffset)/(this.barWidth-b)}};a.prototype.destroy=function(){var a=this,b=a.chart.scroller;a.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(b){a[b]&&a[b].destroy&&(a[b]=a[b].destroy())});b&&a===b.scrollbar&&(b.scrollbar=null,t(b.scrollbarButtons))};a.prototype.drawScrollbarButton=function(b){var d=this.renderer,
r=this.scrollbarButtons,g=this.options,l=this.size,m=d.g().add(this.group);r.push(m);m=d.rect().addClass("highcharts-scrollbar-button").add(m);this.chart.styledMode||m.attr({stroke:g.buttonBorderColor,"stroke-width":g.buttonBorderWidth,fill:g.buttonBackgroundColor});m.attr(m.crisp({x:-.5,y:-.5,width:l+1,height:l+1,r:g.buttonBorderRadius},m.strokeWidth()));m=d.path(a.swapXY([["M",l/2+(b?-1:1),l/2-3],["L",l/2+(b?-1:1),l/2+3],["L",l/2+(b?2:-2),l/2]],g.vertical)).addClass("highcharts-scrollbar-arrow").add(r[b]);
this.chart.styledMode||m.attr({fill:g.buttonArrowColor})};a.prototype.init=function(a,b,d){this.scrollbarButtons=[];this.renderer=a;this.userOptions=b;this.options=M(m,A.scrollbar,b);this.chart=d;this.size=l(this.options.size,this.options.height);b.enabled&&(this.render(),this.addEvents())};a.prototype.mouseDownHandler=function(a){a=this.chart.pointer.normalize(a);a=this.cursorToScrollbarPosition(a);this.chartX=a.chartX;this.chartY=a.chartY;this.initPositions=[this.from,this.to];this.grabbedCenter=
!0};a.prototype.mouseMoveHandler=function(a){var b=this.chart.pointer.normalize(a),g=this.options.vertical?"chartY":"chartX",l=this.initPositions||[];!this.grabbedCenter||a.touches&&0===a.touches[0][g]||(b=this.cursorToScrollbarPosition(b)[g],g=this[g],g=b-g,this.hasDragged=!0,this.updatePosition(l[0]+g,l[1]+g),this.hasDragged&&d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a}))};a.prototype.mouseUpHandler=function(a){this.hasDragged&&d(this,"changed",{from:this.from,
to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a});this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null};a.prototype.position=function(a,b,d,g){var l=this.options.vertical,r=this.rendered?"animate":"attr",m=g,k=0;this.group.show();this.x=a;this.y=b+this.trackBorderWidth;this.width=d;this.height=g;this.xOffset=m;this.yOffset=k;l?(this.width=this.yOffset=d=k=this.size,this.xOffset=m=0,this.barWidth=g-2*d,this.x=a+=this.options.margin):(this.height=this.xOffset=g=m=this.size,this.barWidth=
d-2*g,this.y+=this.options.margin);this.group[r]({translateX:a,translateY:this.y});this.track[r]({width:d,height:g});this.scrollbarButtons[1][r]({translateX:l?0:d-m,translateY:l?g-k:0})};a.prototype.removeEvents=function(){this._events.forEach(function(a){K.apply(null,a)});this._events.length=0};a.prototype.render=function(){var b=this.renderer,d=this.options,g=this.size,l=this.chart.styledMode,m=b.g("scrollbar").attr({zIndex:d.zIndex}).hide().add();this.group=m;this.track=b.rect().addClass("highcharts-scrollbar-track").attr({x:0,
r:d.trackBorderRadius||0,height:g,width:g}).add(m);l||this.track.attr({fill:d.trackBackgroundColor,stroke:d.trackBorderColor,"stroke-width":d.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=b.g().add(m);this.scrollbar=b.rect().addClass("highcharts-scrollbar-thumb").attr({height:g,width:g,r:d.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=b.path(a.swapXY([["M",-3,g/4],["L",-3,2*g/3],["M",0,g/4],
["L",0,2*g/3],["M",3,g/4],["L",3,2*g/3]],d.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);l||(this.scrollbar.attr({fill:d.barBackgroundColor,stroke:d.barBorderColor,"stroke-width":d.barBorderWidth}),this.scrollbarRifles.attr({stroke:d.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)};a.prototype.setRange=
function(a,d){var g=this.options,l=g.vertical,m=g.minWidth,t=this.barWidth,u=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(b(t)){var k=t*Math.min(d,1);a=Math.max(a,0);var y=Math.ceil(t*a);this.calculatedWidth=k=x(k-y);k<m&&(y=(t-m+k)*a,k=m);m=Math.floor(y+this.xOffset+this.yOffset);t=k/2-.5;this.from=a;this.to=d;l?(this.scrollbarGroup[u]({translateY:m}),this.scrollbar[u]({height:k}),this.scrollbarRifles[u]({translateY:t}),this.scrollbarTop=
m,this.scrollbarLeft=0):(this.scrollbarGroup[u]({translateX:m}),this.scrollbar[u]({width:k}),this.scrollbarRifles[u]({translateX:t}),this.scrollbarLeft=m,this.scrollbarTop=0);12>=k?this.scrollbarRifles.hide():this.scrollbarRifles.show();!1===g.showFull&&(0>=a&&1<=d?this.group.hide():this.group.show());this.rendered=!0}};a.prototype.shouldUpdateExtremes=function(a){return l(this.options.liveRedraw,u.svg&&!u.isTouchDevice&&!this.chart.isBoosting)||"mouseup"===a||"touchend"===a||!b(a)};a.prototype.trackClick=
function(a){var b=this.chart.pointer.normalize(a),g=this.to-this.from,l=this.y+this.scrollbarTop,m=this.x+this.scrollbarLeft;this.options.vertical&&b.chartY>l||!this.options.vertical&&b.chartX>m?this.updatePosition(this.from+g,this.to+g):this.updatePosition(this.from-g,this.to-g);d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.update=function(a){this.destroy();this.init(this.chart.renderer,M(!0,this.options,a),this.chart)};a.prototype.updatePosition=function(a,
b){1<b&&(a=x(1-x(b-a)),b=1);0>a&&(b=x(b-a),a=0);this.from=a;this.to=b};a.defaultOptions=m;return a}();A.scrollbar=M(!0,a.defaultOptions,A.scrollbar);return a});I(a,"Core/Axis/NavigatorAxis.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,u){var y=a.isTouchDevice,m=u.addEvent,g=u.correctFloat,A=u.defined,E=u.isNumber,x=u.pick,b=function(){function a(a){this.axis=a}a.prototype.destroy=function(){this.axis=void 0};a.prototype.toFixedRange=function(a,b,l,m){var d=this.axis,t=d.chart;t=t&&
t.fixedRange;var u=(d.pointRange||0)/2;a=x(l,d.translate(a,!0,!d.horiz));b=x(m,d.translate(b,!0,!d.horiz));d=t&&(b-a)/t;A(l)||(a=g(a+u));A(m)||(b=g(b-u));.7<d&&1.3>d&&(m?a=b-t:b=a+t);E(a)&&E(b)||(a=b=void 0);return{min:a,max:b}};return a}();return function(){function a(){}a.compose=function(a){a.keepProps.push("navigatorAxis");m(a,"init",function(){this.navigatorAxis||(this.navigatorAxis=new b(this))});m(a,"zoom",function(a){var b=this.chart.options,d=b.navigator,g=this.navigatorAxis,m=b.chart.pinchType,
t=b.rangeSelector;b=b.chart.zoomType;this.isXAxis&&(d&&d.enabled||t&&t.enabled)&&("y"===b?a.zoomed=!1:(!y&&"xy"===b||y&&"xy"===m)&&this.options.range&&(d=g.previousZoom,A(a.newMin)?g.previousZoom=[this.min,this.max]:d&&(a.newMin=d[0],a.newMax=d[1],g.previousZoom=void 0)));"undefined"!==typeof a.zoomed&&a.preventDefault()})};a.AdditionsClass=b;return a}()});I(a,"Core/Navigator.js",[a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Axis/NavigatorAxis.js"],
a["Core/DefaultOptions.js"],a["Core/Renderer/RendererRegistry.js"],a["Core/Scrollbar.js"],a["Core/Series/Series.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,u,y,m,g,A,E,x,b,t,d){y=y.parse;var M=m.hasTouch,l=m.isTouchDevice,K=A.defaultOptions,H=d.addEvent,J=d.clamp,D=d.correctFloat,r=d.defined,I=d.destroyObjectProperties,L=d.erase,F=d.extend,N=d.find,k=d.isArray,O=d.isNumber,q=d.merge,G=d.pick,f=d.removeEvent,e=d.splat,c=function(c){for(var h=[],a=1;a<arguments.length;a++)h[a-
1]=arguments[a];h=[].filter.call(h,O);if(h.length)return Math[c].apply(0,h)};A="undefined"===typeof t.seriesTypes.areaspline?"line":"areaspline";F(K,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:y("#6685c2").setOpacity(.3).get(),outlineColor:"#cccccc",outlineWidth:1,series:{type:A,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",
enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",
tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#999999"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});E.getRendererType().prototype.symbols["navigator-handle"]=function(c,h,a,b,e){c=(e&&e.width||0)/2;h=Math.round(c/3)+.5;e=e&&e.height||0;return[["M",
-c-1,.5],["L",c,.5],["L",c,e+.5],["L",-c-1,e+.5],["L",-c-1,.5],["M",-h,4],["L",-h,e-3],["M",h-1,4],["L",h-1,e-3]]};var p=function(){function b(h){this.zoomedMin=this.zoomedMax=this.yAxis=this.xAxis=this.top=this.size=this.shades=this.rendered=this.range=this.outlineHeight=this.outline=this.opposite=this.navigatorSize=this.navigatorSeries=this.navigatorOptions=this.navigatorGroup=this.navigatorEnabled=this.left=this.height=this.handles=this.chart=this.baseSeries=void 0;this.init(h)}b.prototype.drawHandle=
function(h,c,a,b){var v=this.navigatorOptions.handles.height;this.handles[c][b](a?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(h,10)+.5-v)}:{translateX:Math.round(this.left+parseInt(h,10)),translateY:Math.round(this.top+this.height/2-v/2-1)})};b.prototype.drawOutline=function(h,c,a,b){var e=this.navigatorOptions.maskInside,v=this.outline.strokeWidth(),d=v/2,w=v%2/2;v=this.outlineHeight;var n=this.scrollbarHeight||0,p=this.size,f=this.left-n,g=this.top;a?
(f-=d,a=g+c+w,c=g+h+w,w=[["M",f+v,g-n-w],["L",f+v,a],["L",f,a],["L",f,c],["L",f+v,c],["L",f+v,g+p+n]],e&&w.push(["M",f+v,a-d],["L",f+v,c+d])):(h+=f+n-w,c+=f+n-w,g+=d,w=[["M",f,g],["L",h,g],["L",h,g+v],["L",c,g+v],["L",c,g],["L",f+p+2*n,g]],e&&w.push(["M",h-d,g],["L",c+d,g]));this.outline[b]({d:w})};b.prototype.drawMasks=function(h,c,a,b){var e=this.left,v=this.top,d=this.height;if(a){var w=[e,e,e];var n=[v,v+h,v+c];var p=[d,d,d];var f=[h,c-h,this.size-c]}else w=[e,e+h,e+c],n=[v,v,v],p=[h,c-h,this.size-
c],f=[d,d,d];this.shades.forEach(function(c,h){c[b]({x:w[h],y:n[h],width:p[h],height:f[h]})})};b.prototype.renderElements=function(){var h=this,c=h.navigatorOptions,a=c.maskInside,b=h.chart,e=b.renderer,d,n={cursor:b.inverted?"ns-resize":"ew-resize"};h.navigatorGroup=d=e.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!a,a,!a].forEach(function(a,v){var w=e.rect().addClass("highcharts-navigator-mask"+(1===v?"-inside":"-outside")).add(d);b.styledMode||(w.attr({fill:a?c.maskFill:"rgba(0,0,0,0)"}),
1===v&&w.css(n));h.shades[v]=w});h.outline=e.path().addClass("highcharts-navigator-outline").add(d);b.styledMode||h.outline.attr({"stroke-width":c.outlineWidth,stroke:c.outlineColor});c.handles.enabled&&[0,1].forEach(function(a){c.handles.inverted=b.inverted;h.handles[a]=e.symbol(c.handles.symbols[a],-c.handles.width/2-1,0,c.handles.width,c.handles.height,c.handles);h.handles[a].attr({zIndex:7-a}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][a]).add(d);if(!b.styledMode){var v=
c.handles;h.handles[a].attr({fill:v.backgroundColor,stroke:v.borderColor,"stroke-width":v.lineWidth}).css(n)}})};b.prototype.update=function(c){(this.series||[]).forEach(function(c){c.baseSeries&&delete c.baseSeries.navigatorSeries});this.destroy();q(!0,this.chart.options.navigator,this.options,c);this.init(this.chart)};b.prototype.render=function(c,a,b,e){var h=this.chart,v=this.scrollbarHeight,d,n=this.xAxis,w=n.pointRange||0;var p=n.navigatorAxis.fake?h.xAxis[0]:n;var f=this.navigatorEnabled,g,
k=this.rendered;var q=h.inverted;var l=h.xAxis[0].minRange,m=h.xAxis[0].options.maxRange;if(!this.hasDragged||r(b)){c=D(c-w/2);a=D(a+w/2);if(!O(c)||!O(a))if(k)b=0,e=G(n.width,p.width);else return;this.left=G(n.left,h.plotLeft+v+(q?h.plotWidth:0));this.size=g=d=G(n.len,(q?h.plotHeight:h.plotWidth)-2*v);h=q?v:d+2*v;b=G(b,n.toPixels(c,!0));e=G(e,n.toPixels(a,!0));O(b)&&Infinity!==Math.abs(b)||(b=0,e=h);c=n.toValue(b,!0);a=n.toValue(e,!0);var P=Math.abs(D(a-c));P<l?this.grabbedLeft?b=n.toPixels(a-l-w,
!0):this.grabbedRight&&(e=n.toPixels(c+l+w,!0)):r(m)&&D(P-w)>m&&(this.grabbedLeft?b=n.toPixels(a-m-w,!0):this.grabbedRight&&(e=n.toPixels(c+m+w,!0)));this.zoomedMax=J(Math.max(b,e),0,g);this.zoomedMin=J(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(b,e),0,g);this.range=this.zoomedMax-this.zoomedMin;g=Math.round(this.zoomedMax);b=Math.round(this.zoomedMin);f&&(this.navigatorGroup.attr({visibility:"inherit"}),k=k&&!this.hasDragged?"animate":"attr",this.drawMasks(b,g,q,k),this.drawOutline(b,
g,q,k),this.navigatorOptions.handles.enabled&&(this.drawHandle(b,0,q,k),this.drawHandle(g,1,q,k)));this.scrollbar&&(q?(q=this.top-v,p=this.left-v+(f||!p.opposite?0:(p.titleOffset||0)+p.axisTitleMargin),v=d+2*v):(q=this.top+(f?this.height:-v),p=this.left-v),this.scrollbar.position(p,q,h,v),this.scrollbar.setRange(this.zoomedMin/(d||1),this.zoomedMax/(d||1)));this.rendered=!0}};b.prototype.addMouseEvents=function(){var c=this,a=c.chart,b=a.container,e=[],d,n;c.mouseMoveHandler=d=function(a){c.onMouseMove(a)};
c.mouseUpHandler=n=function(a){c.onMouseUp(a)};e=c.getPartsEvents("mousedown");e.push(H(a.renderTo,"mousemove",d),H(b.ownerDocument,"mouseup",n));M&&(e.push(H(a.renderTo,"touchmove",d),H(b.ownerDocument,"touchend",n)),e.concat(c.getPartsEvents("touchstart")));c.eventsToUnbind=e;c.series&&c.series[0]&&e.push(H(c.series[0].xAxis,"foundExtremes",function(){a.navigator.modifyNavigatorAxisExtremes()}))};b.prototype.getPartsEvents=function(c){var a=this,h=[];["shades","handles"].forEach(function(b){a[b].forEach(function(e,
v){h.push(H(e.element,c,function(c){a[b+"Mousedown"](c,v)}))})});return h};b.prototype.shadesMousedown=function(c,a){c=this.chart.pointer.normalize(c);var h=this.chart,b=this.xAxis,e=this.zoomedMin,v=this.left,d=this.size,n=this.range,p=c.chartX;h.inverted&&(p=c.chartY,v=this.top);if(1===a)this.grabbedCenter=p,this.fixedWidth=n,this.dragOffset=p-e;else{c=p-v-n/2;if(0===a)c=Math.max(0,c);else if(2===a&&c+n>=d)if(c=d-n,this.reversedExtremes){c-=n;var f=this.getUnionExtremes().dataMin}else var g=this.getUnionExtremes().dataMax;
c!==e&&(this.fixedWidth=n,a=b.navigatorAxis.toFixedRange(c,c+n,f,g),r(a.min)&&h.xAxis[0].setExtremes(Math.min(a.min,a.max),Math.max(a.min,a.max),!0,null,{trigger:"navigator"}))}};b.prototype.handlesMousedown=function(c,a){this.chart.pointer.normalize(c);c=this.chart;var h=c.xAxis[0],b=this.reversedExtremes;0===a?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=b?h.min:h.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=b?h.max:h.min);c.fixedRange=
null};b.prototype.onMouseMove=function(c){var a=this,b=a.chart,h=a.left,e=a.navigatorSize,d=a.range,n=a.dragOffset,p=b.inverted;c.touches&&0===c.touches[0].pageX||(c=b.pointer.normalize(c),b=c.chartX,p&&(h=a.top,b=c.chartY),a.grabbedLeft?(a.hasDragged=!0,a.render(0,0,b-h,a.otherHandlePos)):a.grabbedRight?(a.hasDragged=!0,a.render(0,0,a.otherHandlePos,b-h)):a.grabbedCenter&&(a.hasDragged=!0,b<n?b=n:b>e+n-d&&(b=e+n-d),a.render(0,0,b-n,b-n+d)),a.hasDragged&&a.scrollbar&&G(a.scrollbar.options.liveRedraw,
m.svg&&!l&&!this.chart.isBoosting)&&(c.DOMType=c.type,setTimeout(function(){a.onMouseUp(c)},0)))};b.prototype.onMouseUp=function(c){var a=this.chart,b=this.xAxis,h=this.scrollbar,e=c.DOMEvent||c,d=a.inverted,n=this.rendered&&!this.hasDragged?"animate":"attr";if(this.hasDragged&&(!h||!h.hasDragged)||"scrollbar"===c.trigger){h=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var p=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var f=this.fixedExtreme;this.zoomedMax===
this.size&&(f=this.reversedExtremes?h.dataMin:h.dataMax);0===this.zoomedMin&&(p=this.reversedExtremes?h.dataMax:h.dataMin);b=b.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,p,f);r(b.min)&&a.xAxis[0].setExtremes(Math.min(b.min,b.max),Math.max(b.min,b.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:e})}"mousemove"!==c.DOMType&&"touchmove"!==c.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=
this.hasDragged=this.dragOffset=null);this.navigatorEnabled&&O(this.zoomedMin)&&O(this.zoomedMax)&&(a=Math.round(this.zoomedMin),c=Math.round(this.zoomedMax),this.shades&&this.drawMasks(a,c,d,n),this.outline&&this.drawOutline(a,c,d,n),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(a,0,d,n),this.drawHandle(c,1,d,n)))};b.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(c){c()}),this.eventsToUnbind=
void 0);this.removeBaseSeriesEvents()};b.prototype.removeBaseSeriesEvents=function(){var c=this.baseSeries||[];this.navigatorEnabled&&c[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&c.forEach(function(c){f(c,"updatedData",this.updatedDataHandler)},this),c[0].xAxis&&f(c[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))};b.prototype.init=function(b){var h=b.options,e=h.navigator,d=e.enabled,n=h.scrollbar,p=n.enabled;h=d?e.height:0;var f=p?n.height:0;this.handles=[];this.shades=[];this.chart=
b;this.setBaseSeries();this.height=h;this.scrollbarHeight=f;this.scrollbarEnabled=p;this.navigatorEnabled=d;this.navigatorOptions=e;this.scrollbarOptions=n;this.outlineHeight=h+f;this.opposite=G(e.opposite,!(d||!b.inverted));var k=this;d=k.baseSeries;n=b.xAxis.length;p=b.yAxis.length;var l=d&&d[0]&&d[0].xAxis||b.xAxis[0]||{options:{}};b.isDirtyBox=!0;k.navigatorEnabled?(k.xAxis=new a(b,q({breaks:l.options.breaks,ordinal:l.options.ordinal},e.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,
type:"datetime",index:n,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},b.inverted?{offsets:[f,0,-f,0],width:h}:{offsets:[0,-f,0,f],height:h})),k.yAxis=new a(b,q(e.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:p,isInternal:!0,reversed:G(e.yAxis&&e.yAxis.reversed,b.yAxis[0]&&b.yAxis[0].reversed,!1),zoomEnabled:!1},b.inverted?{width:h}:{height:h})),d||e.series.data?k.updateNavigatorSeries(!1):0===b.series.length&&(k.unbindRedraw=
H(b,"beforeRedraw",function(){0<b.series.length&&!k.series&&(k.setBaseSeries(),k.unbindRedraw())})),k.reversedExtremes=b.inverted&&!k.xAxis.reversed||!b.inverted&&k.xAxis.reversed,k.renderElements(),k.addMouseEvents()):(k.xAxis={chart:b,navigatorAxis:{fake:!0},translate:function(a,h){var e=b.xAxis[0],d=e.getExtremes(),n=e.len-2*f,v=c("min",e.options.min,d.dataMin);e=c("max",e.options.max,d.dataMax)-v;return h?a*e/n+v:n*(a-v)/e},toPixels:function(c){return this.translate(c)},toValue:function(c){return this.translate(c,
!0)}},k.xAxis.navigatorAxis.axis=k.xAxis,k.xAxis.navigatorAxis.toFixedRange=g.AdditionsClass.prototype.toFixedRange.bind(k.xAxis.navigatorAxis));b.options.scrollbar.enabled&&(b.scrollbar=k.scrollbar=new x(b.renderer,q(b.options.scrollbar,{margin:k.navigatorEnabled?0:10,vertical:b.inverted}),b),H(k.scrollbar,"changed",function(c){var a=k.size,b=a*this.to;a*=this.from;k.hasDragged=k.scrollbar.hasDragged;k.render(0,0,a,b);this.shouldUpdateExtremes(c.DOMType)&&setTimeout(function(){k.onMouseUp(c)})}));
k.addBaseSeriesEvents();k.addChartEvents()};b.prototype.getUnionExtremes=function(a){var b=this.chart.xAxis[0],h=this.xAxis,e=h.options,d=b.options,n;a&&null===b.dataMin||(n={dataMin:G(e&&e.min,c("min",d.min,b.dataMin,h.dataMin,h.min)),dataMax:G(e&&e.max,c("max",d.max,b.dataMax,h.dataMax,h.max))});return n};b.prototype.setBaseSeries=function(c,a){var b=this.chart,h=this.baseSeries=[];c=c||b.options&&b.options.navigator.baseSeries||(b.series.length?N(b.series,function(c){return!c.options.isInternal}).index:
0);(b.series||[]).forEach(function(a,b){a.options.isInternal||!a.options.showInNavigator&&(b!==c&&a.options.id!==c||!1===a.options.showInNavigator)||h.push(a)});this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,a)};b.prototype.updateNavigatorSeries=function(c,a){var b=this,h=b.chart,d=b.baseSeries,n,v,p=b.navigatorOptions.series,g,l={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,
isInternal:!0,states:{inactive:{opacity:1}}},m=b.series=(b.series||[]).filter(function(c){var a=c.baseSeries;return 0>d.indexOf(a)?(a&&(f(a,"updatedData",b.updatedDataHandler),delete a.navigatorSeries),c.chart&&c.destroy(),!1):!0});d&&d.length&&d.forEach(function(c){var f=c.navigatorSeries,w=F({color:c.color,visible:c.visible},k(p)?K.navigator.series:p);f&&!1===b.navigatorOptions.adaptToUpdatedData||(l.name="Navigator "+d.length,n=c.options||{},g=n.navigatorOptions||{},w.dataLabels=e(w.dataLabels),
v=q(n,l,w,g),v.pointRange=G(w.pointRange,g.pointRange,K.plotOptions[v.type||"line"].pointRange),w=g.data||w.data,b.hasNavigatorData=b.hasNavigatorData||!!w,v.data=w||n.data&&n.data.slice(0),f&&f.options?f.update(v,a):(c.navigatorSeries=h.initSeries(v),c.navigatorSeries.baseSeries=c,m.push(c.navigatorSeries)))});if(p.data&&(!d||!d.length)||k(p))b.hasNavigatorData=!1,p=e(p),p.forEach(function(c,a){l.name="Navigator "+(m.length+1);v=q(K.navigator.series,{color:h.series[a]&&!h.series[a].options.isInternal&&
h.series[a].color||h.options.colors[a]||h.options.colors[0]},l,c);v.data=c.data;v.data&&(b.hasNavigatorData=!0,m.push(h.initSeries(v)))});c&&this.addBaseSeriesEvents()};b.prototype.addBaseSeriesEvents=function(){var c=this,a=c.baseSeries||[];a[0]&&a[0].xAxis&&a[0].eventsToUnbind.push(H(a[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes));a.forEach(function(a){a.eventsToUnbind.push(H(a,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)}));a.eventsToUnbind.push(H(a,"hide",
function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)}));!1!==this.navigatorOptions.adaptToUpdatedData&&a.xAxis&&a.eventsToUnbind.push(H(a,"updatedData",this.updatedDataHandler));a.eventsToUnbind.push(H(a,"remove",function(){this.navigatorSeries&&(L(c.series,this.navigatorSeries),r(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)};b.prototype.getBaseSeriesMin=function(c){return this.baseSeries.reduce(function(c,a){return Math.min(c,
a.xData&&a.xData.length?a.xData[0]:c)},c)};b.prototype.modifyNavigatorAxisExtremes=function(){var c=this.xAxis,a;"undefined"!==typeof c.getExtremes&&(!(a=this.getUnionExtremes(!0))||a.dataMin===c.min&&a.dataMax===c.max||(c.min=a.dataMin,c.max=a.dataMax))};b.prototype.modifyBaseAxisExtremes=function(){var c=this.chart.navigator,a=this.getExtremes(),b=a.dataMin,e=a.dataMax;a=a.max-a.min;var d=c.stickToMin,n=c.stickToMax,p=G(this.options.overscroll,0),f=c.series&&c.series[0],g=!!this.setExtremes;if(!this.eventArgs||
"rangeSelectorButton"!==this.eventArgs.trigger){if(d){var k=b;var q=k+a}n&&(q=e+p,d||(k=Math.max(b,q-a,c.getBaseSeriesMin(f&&f.xData?f.xData[0]:-Number.MAX_VALUE))));g&&(d||n)&&O(k)&&(this.min=this.userMin=k,this.max=this.userMax=q)}c.stickToMin=c.stickToMax=null};b.prototype.updatedDataHandler=function(){var c=this.chart.navigator,a=this.navigatorSeries;c.stickToMax=c.reversedExtremes?0===Math.round(c.zoomedMin):Math.round(c.zoomedMax)>=Math.round(c.size);c.stickToMin=c.shouldStickToMin(this,c);
a&&!c.hasNavigatorData&&(a.options.pointStart=this.xData[0],a.setData(this.options.data,!1,null,!1))};b.prototype.shouldStickToMin=function(c,a){a=a.getBaseSeriesMin(c.xData[0]);var b=c.xAxis;c=b.max;var h=b.min;b=b.options.range;return O(c)&&O(h)?b&&0<c-a?c-a<b:h<=a:!1};b.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(H(this.chart,"redraw",function(){var c=this.navigator,a=c&&(c.baseSeries&&c.baseSeries[0]&&c.baseSeries[0].xAxis||this.xAxis[0]);
a&&c.render(a.min,a.max)}),H(this.chart,"getMargins",function(){var c=this.navigator,a=c.opposite?"plotTop":"marginBottom";this.inverted&&(a=c.opposite?"marginRight":"plotLeft");this[a]=(this[a]||0)+(c.navigatorEnabled||!this.inverted?c.outlineHeight:0)+c.navigatorOptions.margin}))};b.prototype.destroy=function(){this.removeEvents();this.xAxis&&(L(this.chart.xAxis,this.xAxis),L(this.chart.axes,this.xAxis));this.yAxis&&(L(this.chart.yAxis,this.yAxis),L(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(c){c.destroy&&
c.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(c){this[c]&&this[c].destroy&&this[c].destroy();this[c]=null},this);[this.handles].forEach(function(c){I(c)},this)};return b}();m.Navigator||(m.Navigator=p,g.compose(a),H(u,"beforeShowResetZoom",function(){var c=this.options,a=c.navigator,b=c.rangeSelector;if((a&&a.enabled||b&&b.enabled)&&(!l&&"x"===c.chart.zoomType||l&&"x"===c.chart.pinchType))return!1}),
H(u,"beforeRender",function(){var c=this.options;if(c.navigator.enabled||c.scrollbar.enabled)this.scroller=this.navigator=new p(this)}),H(u,"afterSetChartSize",function(){var c=this.legend,a=this.navigator;if(a){var b=c&&c.options;var e=a.xAxis;var d=a.yAxis;var p=a.scrollbarHeight;this.inverted?(a.left=a.opposite?this.chartWidth-p-a.height:this.spacing[3]+p,a.top=this.plotTop+p):(a.left=G(e.left,this.plotLeft+p),a.top=a.navigatorOptions.top||this.chartHeight-a.height-p-this.spacing[2]-(this.rangeSelector&&
this.extraBottomMargin?this.rangeSelector.getHeight():0)-(b&&"bottom"===b.verticalAlign&&"proximate"!==b.layout&&b.enabled&&!b.floating?c.legendHeight+G(b.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0));e&&d&&(this.inverted?e.options.left=d.options.left=a.left:e.options.top=d.options.top=a.top,e.setAxisSize(),d.setAxisSize())}}),H(u,"update",function(c){var a=c.options.navigator||{},b=c.options.scrollbar||{};this.navigator||this.scroller||!a.enabled&&!b.enabled||(q(!0,this.options.navigator,
a),q(!0,this.options.scrollbar,b),delete c.options.navigator,delete c.options.scrollbar)}),H(u,"afterUpdate",function(c){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new p(this),G(c.redraw,!0)&&this.redraw(c.animation))}),H(u,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),H(b,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,
!1)}),u.prototype.callbacks.push(function(c){var a=c.navigator;a&&c.xAxis[0]&&(c=c.xAxis[0].getExtremes(),a.render(c.min,c.max))}));m.Navigator=p;return m.Navigator});I(a,"Extensions/RangeSelector.js",[a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/Globals.js"],a["Core/DefaultOptions.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,u,y,m,g,A){function E(a){if(-1!==a.indexOf("%L"))return"text";var c="aAdewbBmoyY".split("").some(function(c){return-1!==a.indexOf("%"+
c)}),b="HkIlMS".split("").some(function(c){return-1!==a.indexOf("%"+c)});return c&&b?"datetime-local":c?"date":b?"time":"text"}var x=m.defaultOptions,b=A.addEvent,t=A.createElement,d=A.css,M=A.defined,l=A.destroyObjectProperties,K=A.discardElement,H=A.extend,J=A.find,D=A.fireEvent,r=A.isNumber,I=A.merge,L=A.objectEach,F=A.pad,N=A.pick,k=A.pInt,O=A.splat;H(x,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,
height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#335cad",cursor:"pointer"},labelStyle:{color:"#666666"}}});H(x.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"\u2192"});var q=
function(){function e(c){this.buttons=void 0;this.buttonOptions=e.prototype.defaultButtons;this.initialButtonGroupWidth=0;this.options=void 0;this.chart=c;this.init(c)}e.prototype.clickButton=function(c,e){var d=this.chart,h=this.buttonOptions[c],p=d.xAxis[0],f=d.scroller&&d.scroller.getUnionExtremes()||p||{},g=f.dataMin,k=f.dataMax,q=p&&Math.round(Math.min(p.max,N(k,p.max))),l=h.type;f=h._range;var m,t=h.dataGrouping;if(null!==g&&null!==k){d.fixedRange=f;this.setSelected(c);t&&(this.forcedDataGrouping=
!0,a.prototype.setDataGrouping.call(p||{chart:this.chart},t,!1),this.frozenStates=h.preserveDataGrouping);if("month"===l||"year"===l)if(p){l={range:h,max:q,chart:d,dataMin:g,dataMax:k};var u=p.minFromRange.call(l);r(l.newMax)&&(q=l.newMax)}else f=h;else if(f)u=Math.max(q-f,g),q=Math.min(u+f,k);else if("ytd"===l)if(p)"undefined"===typeof k&&(g=Number.MAX_VALUE,k=Number.MIN_VALUE,d.series.forEach(function(c){c=c.xData;g=Math.min(c[0],g);k=Math.max(c[c.length-1],k)}),e=!1),q=this.getYTDExtremes(k,g,
d.time.useUTC),u=m=q.min,q=q.max;else{this.deferredYTDClick=c;return}else"all"===l&&p&&(d.navigator&&d.navigator.baseSeries[0]&&(d.navigator.baseSeries[0].xAxis.options.range=void 0),u=g,q=k);M(u)&&(u+=h._offsetMin);M(q)&&(q+=h._offsetMax);this.dropdown&&(this.dropdown.selectedIndex=c+1);if(p)p.setExtremes(u,q,N(e,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:h});else{var x=O(d.options.xAxis)[0];var y=x.range;x.range=f;var G=x.min;x.min=m;b(d,"load",function(){x.range=y;x.min=G})}D(this,
"afterBtnClick")}};e.prototype.setSelected=function(c){this.selected=this.options.selected=c};e.prototype.init=function(c){var a=this,e=c.options.rangeSelector,h=e.buttons||a.defaultButtons.slice(),d=e.selected,f=function(){var c=a.minInput,b=a.maxInput;c&&c.blur&&D(c,"blur");b&&b.blur&&D(b,"blur")};a.chart=c;a.options=e;a.buttons=[];a.buttonOptions=h;this.eventsToUnbind=[];this.eventsToUnbind.push(b(c.container,"mousedown",f));this.eventsToUnbind.push(b(c,"resize",f));h.forEach(a.computeButtonRange);
"undefined"!==typeof d&&h[d]&&this.clickButton(d,!1);this.eventsToUnbind.push(b(c,"load",function(){c.xAxis&&c.xAxis[0]&&b(c.xAxis[0],"setExtremes",function(b){this.max-this.min!==c.fixedRange&&"rangeSelectorButton"!==b.trigger&&"updatedData"!==b.trigger&&a.forcedDataGrouping&&!a.frozenStates&&this.setDataGrouping(!1,!1)})}))};e.prototype.updateButtonStates=function(){var c=this,a=this.chart,b=this.dropdown,e=a.xAxis[0],d=Math.round(e.max-e.min),f=!e.hasVisibleSeries,g=a.scroller&&a.scroller.getUnionExtremes()||
e,k=g.dataMin,q=g.dataMax;a=c.getYTDExtremes(q,k,a.time.useUTC);var l=a.min,m=a.max,t=c.selected,u=r(t),x=c.options.allButtonsEnabled,y=c.buttons;c.buttonOptions.forEach(function(a,h){var n=a._range,p=a.type,g=a.count||1,v=y[h],w=0,r=a._offsetMax-a._offsetMin;a=h===t;var B=n>q-k,z=n<e.minRange,C=!1,P=!1;n=n===d;("month"===p||"year"===p)&&d+36E5>=864E5*{month:28,year:365}[p]*g-r&&d-36E5<=864E5*{month:31,year:366}[p]*g+r?n=!0:"ytd"===p?(n=m-l+r===d,C=!a):"all"===p&&(n=e.max-e.min>=q-k,P=!a&&u&&n);p=
!x&&(B||z||P||f);g=a&&n||n&&!u&&!C||a&&c.frozenStates;p?w=3:g&&(u=!0,w=2);v.state!==w&&(v.setState(w),b&&(b.options[h+1].disabled=p,2===w&&(b.selectedIndex=h+1)),0===w&&t===h&&c.setSelected())})};e.prototype.computeButtonRange=function(c){var a=c.type,b=c.count||1,e={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(e[a])c._range=e[a]*b;else if("month"===a||"year"===a)c._range=864E5*{month:30,year:365}[a]*b;c._offsetMin=N(c.offsetMin,0);c._offsetMax=N(c.offsetMax,0);c._range+=
c._offsetMax-c._offsetMin};e.prototype.getInputValue=function(c){c="min"===c?this.minInput:this.maxInput;var a=this.chart.options.rangeSelector,b=this.chart.time;return c?("text"===c.type&&a.inputDateParser||this.defaultInputDateParser)(c.value,b.useUTC,b):0};e.prototype.setInputValue=function(c,a){var b=this.options,e=this.chart.time,d="min"===c?this.minInput:this.maxInput;c="min"===c?this.minDateBox:this.maxDateBox;if(d){var f=d.getAttribute("data-hc-time");f=M(f)?Number(f):void 0;M(a)&&(M(f)&&
d.setAttribute("data-hc-time-previous",f),d.setAttribute("data-hc-time",a),f=a);d.value=e.dateFormat(this.inputTypeFormats[d.type]||b.inputEditDateFormat,f);c&&c.attr({text:e.dateFormat(b.inputDateFormat,f)})}};e.prototype.setInputExtremes=function(c,a,b){if(c="min"===c?this.minInput:this.maxInput){var e=this.inputTypeFormats[c.type],d=this.chart.time;e&&(a=d.dateFormat(e,a),c.min!==a&&(c.min=a),b=d.dateFormat(e,b),c.max!==b&&(c.max=b))}};e.prototype.showInput=function(c){var a="min"===c?this.minDateBox:
this.maxDateBox;if((c="min"===c?this.minInput:this.maxInput)&&a&&this.inputGroup){var b="text"===c.type,e=this.inputGroup,f=e.translateX;e=e.translateY;var g=this.options.inputBoxWidth;d(c,{width:b?a.width+(g?-2:20)+"px":"auto",height:b?a.height-2+"px":"auto",border:"2px solid silver"});b&&g?d(c,{left:f+a.x+"px",top:e+"px"}):d(c,{left:Math.min(Math.round(a.x+f-(c.offsetWidth-a.width)/2),this.chart.chartWidth-c.offsetWidth)+"px",top:e-(c.offsetHeight-a.height)/2+"px"})}};e.prototype.hideInput=function(c){(c=
"min"===c?this.minInput:this.maxInput)&&d(c,{top:"-9999em",border:0,width:"1px",height:"1px"})};e.prototype.defaultInputDateParser=function(c,a,b){var e=c.split("/").join("-").split(" ").join("T");-1===e.indexOf("T")&&(e+="T00:00");if(a)e+="Z";else{var d;if(d=y.isSafari)d=e,d=!(6<d.length&&(d.lastIndexOf("-")===d.length-6||d.lastIndexOf("+")===d.length-6));d&&(d=(new Date(e)).getTimezoneOffset()/60,e+=0>=d?"+"+F(-d)+":00":"-"+F(d)+":00")}e=Date.parse(e);r(e)||(c=c.split("-"),e=Date.UTC(k(c[0]),k(c[1])-
1,k(c[2])));b&&a&&r(e)&&(e+=b.getTimezoneOffset(e));return e};e.prototype.drawInput=function(c){function a(){var a=g.getInputValue(c),e=b.xAxis[0],d=b.scroller&&b.scroller.xAxis?b.scroller.xAxis:e,h=d.dataMin;d=d.dataMax;var f=g.maxInput,n=g.minInput;a!==Number(u.getAttribute("data-hc-time-previous"))&&r(a)&&(u.setAttribute("data-hc-time-previous",a),m&&f&&r(h)?a>Number(f.getAttribute("data-hc-time"))?a=void 0:a<h&&(a=h):n&&r(d)&&(a<Number(n.getAttribute("data-hc-time"))?a=void 0:a>d&&(a=d)),"undefined"!==
typeof a&&e.setExtremes(m?a:e.min,m?e.max:a,void 0,void 0,{trigger:"rangeSelectorInput"}))}var b=this.chart,e=this.div,f=this.inputGroup,g=this,k=b.renderer.style||{},q=b.renderer,l=b.options.rangeSelector,m="min"===c,z=x.lang[m?"rangeSelectorFrom":"rangeSelectorTo"]||"";z=q.label(z,0).addClass("highcharts-range-label").attr({padding:z?2:0,height:z?l.inputBoxHeight:0}).add(f);q=q.label("",0).addClass("highcharts-range-input").attr({padding:2,width:l.inputBoxWidth,height:l.inputBoxHeight,"text-align":"center"}).on("click",
function(){g.showInput(c);g[c+"Input"].focus()});b.styledMode||q.attr({stroke:l.inputBoxBorderColor,"stroke-width":1});q.add(f);var u=t("input",{name:c,className:"highcharts-range-selector"},void 0,e);u.setAttribute("type",E(l.inputDateFormat||"%b %e, %Y"));b.styledMode||(z.css(I(k,l.labelStyle)),q.css(I({color:"#333333"},k,l.inputStyle)),d(u,H({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:k.fontSize,fontFamily:k.fontFamily,
top:"-9999em"},l.inputStyle)));u.onfocus=function(){g.showInput(c)};u.onblur=function(){u===y.doc.activeElement&&a();g.hideInput(c);g.setInputValue(c);u.blur()};var G=!1;u.onchange=function(){G||(a(),g.hideInput(c),u.blur())};u.onkeypress=function(c){13===c.keyCode&&a()};u.onkeydown=function(c){G=!0;38!==c.keyCode&&40!==c.keyCode||a()};u.onkeyup=function(){G=!1};return{dateBox:q,input:u,label:z}};e.prototype.getPosition=function(){var a=this.chart,b=a.options.rangeSelector;a="top"===b.verticalAlign?
a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+b.buttonPosition.y,inputTop:a+b.inputPosition.y-10}};e.prototype.getYTDExtremes=function(a,b,e){var c=this.chart.time,d=new c.Date(a),f=c.get("FullYear",d);e=e?c.Date.UTC(f,0,1):+new c.Date(f,0,1);b=Math.max(b,e);d=d.getTime();return{max:Math.min(a||d,d),min:b}};e.prototype.render=function(a,b){var c=this.chart,e=c.renderer,d=c.container,f=c.options,g=f.rangeSelector,p=N(f.chart.style&&f.chart.style.zIndex,0)+1;f=g.inputEnabled;if(!1!==g.enabled){this.rendered||
(this.group=e.g("range-selector-group").attr({zIndex:7}).add(),this.div=t("div",void 0,{position:"relative",height:0,zIndex:p}),this.buttonOptions.length&&this.renderButtons(),d.parentNode&&d.parentNode.insertBefore(this.div,d),f&&(this.inputGroup=e.g("input-group").add(this.group),e=this.drawInput("min"),this.minDateBox=e.dateBox,this.minLabel=e.label,this.minInput=e.input,e=this.drawInput("max"),this.maxDateBox=e.dateBox,this.maxLabel=e.label,this.maxInput=e.input));if(f&&(this.setInputValue("min",
a),this.setInputValue("max",b),a=c.scroller&&c.scroller.getUnionExtremes()||c.xAxis[0]||{},M(a.dataMin)&&M(a.dataMax)&&(c=c.xAxis[0].minRange||0,this.setInputExtremes("min",a.dataMin,Math.min(a.dataMax,this.getInputValue("max"))-c),this.setInputExtremes("max",Math.max(a.dataMin,this.getInputValue("min"))+c,a.dataMax)),this.inputGroup)){var k=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(a){if(a){var c=a.getBBox().width;c&&(a.attr({x:k}),k+=c+g.inputSpacing)}})}this.alignElements();
this.rendered=!0}};e.prototype.renderButtons=function(){var a=this,e=this.buttons,d=this.options,h=x.lang,f=this.chart.renderer,g=I(d.buttonTheme),k=g&&g.states,q=g.width||28;delete g.width;delete g.states;this.buttonGroup=f.g("range-selector-buttons").add(this.group);var l=this.dropdown=t("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:.0001},this.div);b(l,"touchstart",function(){l.style.fontSize="16px"});[[y.isMS?"mouseover":
"mouseenter"],[y.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(c){var d=c[0],h=c[1];b(l,d,function(){var c=e[a.currentButtonIndex()];c&&D(c.element,h||d)})});this.zoomText=f.label(h&&h.rangeSelectorZoom||"",0).attr({padding:d.buttonTheme.padding,height:d.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup);this.chart.styledMode||(this.zoomText.css(d.labelStyle),g["stroke-width"]=N(g["stroke-width"],0));t("option",{textContent:this.zoomText.textStr,disabled:!0},
void 0,l);this.buttonOptions.forEach(function(c,b){t("option",{textContent:c.title||c.text},void 0,l);e[b]=f.button(c.text,0,0,function(e){var d=c.events&&c.events.click,h;d&&(h=d.call(c,e));!1!==h&&a.clickButton(b);a.isActive=!0},g,k&&k.hover,k&&k.select,k&&k.disabled).attr({"text-align":"center",width:q}).add(a.buttonGroup);c.title&&e[b].attr("title",c.title)})};e.prototype.alignElements=function(){var a=this,b=this.buttonGroup,e=this.buttons,d=this.chart,f=this.group,g=this.inputGroup,k=this.options,
q=this.zoomText,l=d.options,m=l.exporting&&!1!==l.exporting.enabled&&l.navigation&&l.navigation.buttonOptions;l=k.buttonPosition;var r=k.inputPosition,u=k.verticalAlign,t=function(c,b){return m&&a.titleCollision(d)&&"top"===u&&"right"===b.align&&b.y-c.getBBox().height-12<(m.y||0)+(m.height||0)+d.spacing[0]?-40:0},x=d.plotLeft;if(f&&l&&r){var y=l.x-d.spacing[3];if(b){this.positionButtons();if(!this.initialButtonGroupWidth){var G=0;q&&(G+=q.getBBox().width+5);e.forEach(function(a,c){G+=a.width;c!==
e.length-1&&(G+=k.buttonSpacing)});this.initialButtonGroupWidth=G}x-=d.spacing[3];this.updateButtonStates();q=t(b,l);this.alignButtonGroup(q);f.placed=b.placed=d.hasLoaded}b=0;g&&(b=t(g,r),"left"===r.align?y=x:"right"===r.align&&(y=-Math.max(d.axisOffset[1],-b)),g.align({y:r.y,width:g.getBBox().width,align:r.align,x:r.x+y-2},!0,d.spacingBox),g.placed=d.hasLoaded);this.handleCollision(b);f.align({verticalAlign:u},!0,d.spacingBox);g=f.alignAttr.translateY;b=f.getBBox().height+20;t=0;"bottom"===u&&(t=
(t=d.legend&&d.legend.options)&&"bottom"===t.verticalAlign&&t.enabled&&!t.floating?d.legend.legendHeight+N(t.margin,10):0,b=b+t-20,t=g-b-(k.floating?0:k.y)-(d.titleOffset?d.titleOffset[2]:0)-10);if("top"===u)k.floating&&(t=0),d.titleOffset&&d.titleOffset[0]&&(t=d.titleOffset[0]),t+=d.margin[0]-d.spacing[0]||0;else if("middle"===u)if(r.y===l.y)t=g;else if(r.y||l.y)t=0>r.y||0>l.y?t-Math.min(r.y,l.y):g-b;f.translate(k.x,k.y+Math.floor(t));l=this.minInput;r=this.maxInput;g=this.dropdown;k.inputEnabled&&
l&&r&&(l.style.marginTop=f.translateY+"px",r.style.marginTop=f.translateY+"px");g&&(g.style.marginTop=f.translateY+"px")}};e.prototype.alignButtonGroup=function(a,b){var c=this.chart,e=this.buttonGroup,d=this.options.buttonPosition,f=c.plotLeft-c.spacing[3],g=d.x-c.spacing[3];"right"===d.align?g+=a-f:"center"===d.align&&(g-=f/2);e&&e.align({y:d.y,width:N(b,this.initialButtonGroupWidth),align:d.align,x:g},!0,c.spacingBox)};e.prototype.positionButtons=function(){var a=this.buttons,b=this.chart,e=this.options,
d=this.zoomText,f=b.hasLoaded?"animate":"attr",g=e.buttonPosition,k=b.plotLeft,q=k;d&&"hidden"!==d.visibility&&(d[f]({x:N(k+g.x,k)}),q+=g.x+d.getBBox().width+5);this.buttonOptions.forEach(function(c,b){if("hidden"!==a[b].visibility)a[b][f]({x:q}),q+=a[b].width+e.buttonSpacing;else a[b][f]({x:k})})};e.prototype.handleCollision=function(a){var c=this,b=this.chart,e=this.buttonGroup,d=this.inputGroup,f=this.options,g=f.buttonPosition,k=f.dropdown,q=f.inputPosition;f=function(){var a=0;c.buttons.forEach(function(c){c=
c.getBBox();c.width>a&&(a=c.width)});return a};var l=function(c){if(d&&e){var b=d.alignAttr.translateX+d.alignOptions.x-a+d.getBBox().x+2,f=d.alignOptions.width,h=e.alignAttr.translateX+e.getBBox().x;return h+c>b&&b+f>h&&g.y<q.y+d.getBBox().height}return!1},m=function(){d&&e&&d.attr({translateX:d.alignAttr.translateX+(b.axisOffset[1]>=-a?0:-a),translateY:d.alignAttr.translateY+e.getBBox().height+10})};if(e){if("always"===k){this.collapseButtons(a);l(f())&&m();return}"never"===k&&this.expandButtons()}d&&
e?q.align===g.align||l(this.initialButtonGroupWidth+20)?"responsive"===k?(this.collapseButtons(a),l(f())&&m()):m():"responsive"===k&&this.expandButtons():e&&"responsive"===k&&(this.initialButtonGroupWidth>b.plotWidth?this.collapseButtons(a):this.expandButtons())};e.prototype.collapseButtons=function(a){var c=this.buttons,b=this.buttonOptions,e=this.chart,d=this.dropdown,f=this.options,g=this.zoomText,k=e.userOptions.rangeSelector&&e.userOptions.rangeSelector.buttonTheme||{},q=function(a){return{text:a?
a+" \u25be":"\u25be",width:"auto",paddingLeft:N(f.buttonTheme.paddingLeft,k.padding,8),paddingRight:N(f.buttonTheme.paddingRight,k.padding,8)}};g&&g.hide();var l=!1;b.forEach(function(a,b){b=c[b];2!==b.state?b.hide():(b.show(),b.attr(q(a.text)),l=!0)});l||(d&&(d.selectedIndex=0),c[0].show(),c[0].attr(q(this.zoomText&&this.zoomText.textStr)));b=f.buttonPosition.align;this.positionButtons();"right"!==b&&"center"!==b||this.alignButtonGroup(a,c[this.currentButtonIndex()].getBBox().width);this.showDropdown()};
e.prototype.expandButtons=function(){var a=this.buttons,b=this.buttonOptions,e=this.options,d=this.zoomText;this.hideDropdown();d&&d.show();b.forEach(function(c,b){b=a[b];b.show();b.attr({text:c.text,width:e.buttonTheme.width||28,paddingLeft:N(e.buttonTheme.paddingLeft,"unset"),paddingRight:N(e.buttonTheme.paddingRight,"unset")});2>b.state&&b.setState(0)});this.positionButtons()};e.prototype.currentButtonIndex=function(){var a=this.dropdown;return a&&0<a.selectedIndex?a.selectedIndex-1:0};e.prototype.showDropdown=
function(){var a=this.buttonGroup,b=this.buttons,e=this.chart,f=this.dropdown;if(a&&f){var g=a.translateX;a=a.translateY;b=b[this.currentButtonIndex()].getBBox();d(f,{left:e.plotLeft+g+"px",top:a+.5+"px",width:b.width+"px",height:b.height+"px"});this.hasVisibleDropdown=!0}};e.prototype.hideDropdown=function(){var a=this.dropdown;a&&(d(a,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)};e.prototype.getHeight=function(){var a=this.options,b=this.group,e=a.y,d=a.buttonPosition.y,
f=a.inputPosition.y;if(a.height)return a.height;this.alignElements();a=b?b.getBBox(!0).height+13+e:0;b=Math.min(f,d);if(0>f&&0>d||0<f&&0<d)a+=Math.abs(b);return a};e.prototype.titleCollision=function(a){return!(a.options.title.text||a.options.subtitle.text)};e.prototype.update=function(a){var c=this.chart;I(!0,c.options.rangeSelector,a);this.destroy();this.init(c);this.render()};e.prototype.destroy=function(){var a=this,b=a.minInput,d=a.maxInput;a.eventsToUnbind&&(a.eventsToUnbind.forEach(function(a){return a()}),
a.eventsToUnbind=void 0);l(a.buttons);b&&(b.onfocus=b.onblur=b.onchange=null);d&&(d.onfocus=d.onblur=d.onchange=null);L(a,function(c,b){c&&"chart"!==b&&(c instanceof g?c.destroy():c instanceof window.HTMLElement&&K(c));c!==e.prototype[b]&&(a[b]=null)},this)};return e}();q.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},
{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];q.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"};a.prototype.minFromRange=function(){var a=this.range,c=a.type,b=this.max,d=this.chart.time,f=function(a,b){var e="year"===c?"FullYear":"Month",f=new d.Date(a),g=d.get(e,f);d.set(e,f,g+b);g===d.get(e,f)&&d.set("Date",f,0);return f.getTime()-a};if(r(a)){var g=b-a;var k=a}else g=b+f(b,-a.count),this.chart&&(this.chart.fixedRange=
b-g);var q=N(this.dataMin,Number.MIN_VALUE);r(g)||(g=q);g<=q&&(g=q,"undefined"===typeof k&&(k=f(g,a.count)),this.newMax=Math.min(g+k,this.dataMax));r(b)||(g=void 0);return g};if(!y.RangeSelector){var G=[],f=function(a){function c(){d&&(e=a.xAxis[0].getExtremes(),f=a.legend,k=d&&d.options.verticalAlign,r(e.min)&&d.render(e.min,e.max),f.display&&"top"===k&&k===f.options.verticalAlign&&(g=I(a.spacingBox),g.y="vertical"===f.options.layout?a.plotTop:g.y+d.getHeight(),f.group.placed=!1,f.align(g)))}var e,
d=a.rangeSelector,f,g,k;d&&(J(G,function(c){return c[0]===a})||G.push([a,[b(a.xAxis[0],"afterSetExtremes",function(a){d&&d.render(a.min,a.max)}),b(a,"redraw",c)]]),c())};b(u,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new q(this))});b(u,"beforeRender",function(){var a=this.axes,c=this.rangeSelector;c&&(r(c.deferredYTDClick)&&(c.clickButton(c.deferredYTDClick),delete c.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),
this.getAxisMargins(),c.render(),a=c.options.verticalAlign,c.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))});b(u,"update",function(a){var c=a.options.rangeSelector;a=this.rangeSelector;var b=this.extraBottomMargin,d=this.extraTopMargin;c&&c.enabled&&!M(a)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=a=new q(this));this.extraTopMargin=this.extraBottomMargin=!1;a&&(f(this),c=c&&c.verticalAlign||a.options&&
a.options.verticalAlign,a.options.floating||("bottom"===c?this.extraBottomMargin=!0:"middle"!==c&&(this.extraTopMargin=!0)),this.extraBottomMargin!==b||this.extraTopMargin!==d)&&(this.isDirtyBox=!0)});b(u,"render",function(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))});b(u,"getMargins",function(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=
a),this.extraBottomMargin&&(this.marginBottom+=a))});u.prototype.callbacks.push(f);b(u,"destroy",function(){for(var a=0;a<G.length;a++){var c=G[a];if(c[0]===this){c[1].forEach(function(a){return a()});G.splice(a,1);break}}});y.RangeSelector=q}return q});I(a,"Core/Chart/StockChart.js",[a["Core/Animation/AnimationUtilities.js"],a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/FormatUtilities.js"],a["Core/DefaultOptions.js"],a["Core/Series/Series.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],
function(a,u,y,m,g,A,E,x){function b(a,b){return"xAxis"===a?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:"yAxis"===a?{labels:{y:-2},opposite:F(b.opposite,!0),showLastLabel:!(!b.categories&&"category"!==b.type),title:{text:null}}:{}}function t(a,b){if("xAxis"===a){a=l();var d={type:"datetime",categories:void 0};F(b.navigator&&b.navigator.enabled,a.navigator.enabled,!0)&&(d.startOnTick=!1,d.endOnTick=!1);return d}return{}}var d=this&&
this.__extends||function(){var a=function(b,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)b.hasOwnProperty(d)&&(a[d]=b[d])};return a(b,d)};return function(b,d){function g(){this.constructor=b}a(b,d);b.prototype=null===d?Object.create(d):(g.prototype=d.prototype,new g)}}(),I=m.format,l=g.getOptions;a=x.addEvent;var K=x.clamp,H=x.defined,J=x.extend,D=x.find,r=x.isNumber,N=x.isString,L=x.merge,F=x.pick,S=x.splat;x=function(a){function g(){return null!==
a&&a.apply(this,arguments)||this}d(g,a);g.prototype.init=function(d,g){var f=l(),e=d.xAxis,c=d.yAxis,k=F(d.navigator&&d.navigator.enabled,f.navigator.enabled,!0);d.xAxis=d.yAxis=void 0;k=L({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:k},scrollbar:{enabled:F(f.scrollbar&&f.scrollbar.enabled,!0)},rangeSelector:{enabled:F(f.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:F(f.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},d,{isStock:!0});d.xAxis=e;d.yAxis=
c;k.xAxis=S(d.xAxis||{}).map(function(a,c){return L(b("xAxis",a),f.xAxis,f.xAxis&&f.xAxis[c],a,t("xAxis",d))});k.yAxis=S(d.yAxis||{}).map(function(a,c){return L(b("yAxis",a),f.yAxis,f.yAxis&&f.yAxis[c],a)});a.prototype.init.call(this,k,g)};g.prototype.createAxis=function(d,g){g.axis=L(b(d,g.axis),g.axis,t(d,this.userOptions));return a.prototype.createAxis.call(this,d,g)};return g}(y);(function(a){a.stockChart=function(b,d,g){return new a(b,d,g)}})(x||(x={}));a(A,"setOptions",function(a){var b;this.chart.options.isStock&&
(this.is("column")||this.is("columnrange")?b={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(b={marker:{enabled:!1,radius:2}}),b&&(a.plotOptions[this.type]=L(a.plotOptions[this.type],b)))});a(u,"autoLabelAlign",function(a){var b=this.chart,d=this.options;b=b._labelPanes=b._labelPanes||{};var g=this.options.labels;this.chart.options.isStock&&"yAxis"===this.coll&&(d=d.top+","+d.height,!b[d]&&g.enabled&&(15===g.x&&(g.x=0),"undefined"===typeof g.align&&(g.align="right"),b[d]=this,a.align=
"right",a.preventDefault()))});a(u,"destroy",function(){var a=this.chart,b=this.options&&this.options.top+","+this.options.height;b&&a._labelPanes&&a._labelPanes[b]===this&&delete a._labelPanes[b]});a(u,"getPlotLinePath",function(a){function b(a){var b="xAxis"===a?"yAxis":"xAxis";a=d.options[b];return r(a)?[f[b][a]]:N(a)?[f.get(a)]:g.map(function(a){return a[b]})}var d=this,g=this.isLinked&&!this.series?this.linkedParent.series:this.series,f=d.chart,e=f.renderer,c=d.left,k=d.top,l,h,m,t,u=[],x=[],
y=a.translatedValue,A=a.value,z=a.force;if(f.options.isStock&&!1!==a.acrossPanes&&"xAxis"===d.coll||"yAxis"===d.coll){a.preventDefault();x=b(d.coll);var E=d.isXAxis?f.yAxis:f.xAxis;E.forEach(function(a){if(H(a.options.id)?-1===a.options.id.indexOf("navigator"):1){var b=a.isXAxis?"yAxis":"xAxis";b=H(a.options[b])?f[b][a.options[b]]:f[b][0];d===b&&x.push(a)}});var I=x.length?[]:[d.isXAxis?f.yAxis[0]:f.xAxis[0]];x.forEach(function(a){-1!==I.indexOf(a)||D(I,function(b){return b.pos===a.pos&&b.len===a.len})||
I.push(a)});var J=F(y,d.translate(A,null,null,a.old));r(J)&&(d.horiz?I.forEach(function(a){var b;h=a.pos;t=h+a.len;l=m=Math.round(J+d.transB);"pass"!==z&&(l<c||l>c+d.width)&&(z?l=m=K(l,c,c+d.width):b=!0);b||u.push(["M",l,h],["L",m,t])}):I.forEach(function(a){var b;l=a.pos;m=l+a.len;h=t=Math.round(k+d.height-J);"pass"!==z&&(h<k||h>k+d.height)&&(z?h=t=K(h,k,k+d.height):b=!0);b||u.push(["M",l,h],["L",m,t])}));a.path=0<u.length?e.crispPolyLine(u,a.lineWidth||1):null}});E.prototype.crispPolyLine=function(a,
b){for(var d=0;d<a.length;d+=2){var g=a[d],f=a[d+1];g[1]===f[1]&&(g[1]=f[1]=Math.round(g[1])-b%2/2);g[2]===f[2]&&(g[2]=f[2]=Math.round(g[2])+b%2/2)}return a};a(u,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});a(u,"afterDrawCrosshair",function(a){var b,d;if(this.crosshair&&this.crosshair.label&&this.crosshair.label.enabled&&this.cross&&r(this.min)&&r(this.max)){var g=this.chart,f=this.logarithmic,e=this.crosshair.label,c=this.horiz,k=this.opposite,l=this.left,
h=this.top,m=this.crossLabel,t=e.format,u="",x="inside"===this.options.tickPosition,y=!1!==this.crosshair.snap,A=0,z=a.e||this.cross&&this.cross.e;a=a.point;var D=this.min,E=this.max;f&&(D=f.lin2log(D),E=f.lin2log(E));f=c?"center":k?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";m||(m=this.crossLabel=g.renderer.label("",0,void 0,e.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(a?a.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:e.align||
f,padding:F(e.padding,8),r:F(e.borderRadius,3),zIndex:2}).add(this.labelGroup),g.styledMode||m.attr({fill:e.backgroundColor||a&&a.series&&a.series.color||"#666666",stroke:e.borderColor||"","stroke-width":e.borderWidth||0}).css(J({color:"#ffffff",fontWeight:"normal",fontSize:"11px",textAlign:"center"},e.style||{})));c?(f=y?(a.plotX||0)+l:z.chartX,h+=k?0:this.height):(f=k?this.width+l:0,h=y?(a.plotY||0)+h:z.chartY);t||e.formatter||(this.dateTime&&(u="%b %d, %Y"),t="{value"+(u?":"+u:"")+"}");u=y?this.isXAxis?
a.x:a.y:this.toValue(c?z.chartX:z.chartY);y=a?a.series.isPointInside(a):r(u)&&u>D&&u<E;z="";t?z=I(t,{value:u},g):e.formatter&&r(u)&&(z=e.formatter.call(this,u));m.attr({text:z,x:f,y:h,visibility:y?"inherit":"hidden"});e=m.getBBox();if(r(m.y))if(c){if(x&&!k||!x&&k)h=m.y-e.height}else h=m.y-e.height/2;c?(b=l-e.x,d=l+this.width-e.x):(b="left"===this.labelAlign?l:0,d="right"===this.labelAlign?l+this.width:g.chartWidth);m.translateX<b&&(A=b-m.translateX);m.translateX+e.width>=d&&(A=-(m.translateX+e.width-
d));m.attr({x:f+A,y:h,anchorX:c?f:this.opposite?0:g.chartWidth,anchorY:c?this.opposite?g.chartHeight:0:h+e.height/2})}});A.prototype.forceCropping=function(){var a=this.chart,b=this.options.dataGrouping;return!1!==this.allowDG&&b&&F(b.enabled,a.options.isStock)};a(y,"update",function(a){a=a.options;"scrollbar"in a&&this.navigator&&(L(!0,this.options.scrollbar,a.scrollbar),this.navigator.update({},!1),delete a.scrollbar)});return x});I(a,"masters/modules/stock.src.js",[a["Core/Globals.js"],a["Core/Axis/OrdinalAxis.js"],
a["Series/DataModifyComposition.js"],a["Core/Scrollbar.js"],a["Core/Chart/StockChart.js"]],function(a,u,y,m,g){a.Scrollbar=m;a.StockChart=a.stockChart=g.stockChart;m.compose(a.Axis);u.compose(a.Axis,a.Series,a.Chart);y.compose(a.Series,a.Axis,a.Point)})});
//# sourceMappingURL=stock.js.map