let locationBtn        = null;
let createBtn          = null;
let cancleBtn          = null;
let missBtn            = null;
let incdCfrmBtn        = null;
let incdInfoCfrmBtn    = null;
let refreshBtn         = null;
let incdEndBtn         = null;
let prcdIncdTable      = null;
let newIncdTable       = null;
let endIncdTable       = null;
let commonUri          = '/api/manage/incident';
let autoIncdTable      = null;
let prcdLinkBtn        = null;
let searchBtn          = null;
let closeBtn           = null;
let vmsListBtn         = null;
const _pageName        = '돌발';
let tab                = null;

//신규 돌발 등록 관련
let newIncdOccrId         = null;
let newRgstDt             = null;
let newIncdOrgnCd         = null;
let newOcrrLctnNm         = null;
let newIncdExpl           = null;
let newCmtrGradCd         = null;
let newIfmrNm             = null;
let newIncdCnfmMthdCd     = null;
let newIncdSernCd         = null;
let newIncdTypeCd         = null;
let newIncdCnfmDt         = null;
let newIncdTypeClsfCd     = null;
let newIncdTitl           = null;
let newIncdStrtDt         = null;
let newIncdEndPrarDt      = null;

//돌발 진행상황 처리 관련
let prcdIncdOccrId        = null;
let prcdRgstDt            = null;
let prcdIncdOrgnCd        = null;
let prcdOcrrLctnNm        = null;
let prcdIncdExpl          = null;
let prcdCmtrGradCd        = null;
let prcdIfmrNm            = null;
let prcdIncdCnfmMthdCd    = null;
let prcdIncdSernCd        = null;
let prcdIncdTypeCd        = null;
let prcdIncdTypeClsfCd    = null;
let prcdIncdTitl          = null;
let prcdIncdStrtDt        = null;
let prcdIncdEndPrarDt     = null;
let prcdLinkId            = null;
let prcdXcrdn             = null;
let prcdYcrdn             = null;
let prcdVmsDsplYn         = null;
let prcdStrtLctnNm        = null;
let prcdEndLctnNm         = null;
let prcdVmsIncdTypeCd     = null;
let prcdVmsIncdDetlTypeCd = null;
let prcdIncdOcrrLane0     = null;
let prcdIncdOcrrLane1     = null;
let prcdIncdOcrrLane2     = null;
let prcdIncdOcrrLane3     = null;
let prcdIncdOcrrLane4     = null;
let prcdIncdOcrrLane5     = null;
let prcdIncdClsrLane0     = null;
let prcdIncdClsrLane1     = null;
let prcdIncdClsrLane2     = null;
let prcdIncdClsrLane3     = null;
let prcdIncdClsrLane4     = null;
let prcdIncdClsrLane5     = null;
let prcdSmltVhclUnum      = null;
let prcdMdltVhclUnum      = null;
let prcdInjrPnum          = null;
let prcdFtltPnum          = null;
let prcdDelyLngt          = null;
let prcdIncdLngt          = null;
let prcdWthrCd            = null;
let prcdRespLvlCd         = null;
let prcdTrubVhclYn        = null;
let prcdFaltYn            = null;
let prcdFrwtYn            = null;
let procData              = [];
let incdOcrrLaneArr       = [];
let incdClsrLaneArr       = [];

//돌발 종료 처리 관련
let endIncdOccrId        = null;
let endRgstDt            = null;
let endIncdOrgnCd        = null;
let endOcrrLctnNm        = null;
let endIncdExpl          = null;
let endCmtrGradCd        = null;
let endIfmrNm            = null;
let endIncdCnfmMthdCd    = null;
let endIncdSernCd        = null;
let endIncdTypeCd        = null;
let endIncdTypeClsfCd    = null;
let endIncdTitl          = null;
let endIncdStrtDt        = null;
let endIncdEndPrarDt     = null;
let endLinkId            = null;
let endXcrdn             = null;
let endYcrdn             = null;
let endRespLvlCd         = null;
let endIncdEndCnfmMthdCd = null;
let endIncdEndDt         = null;
let endRecrCont          = null;
let endMblzEqpmCont      = null;
let endMblzPnum          = null;
let endRecrPerd          = null;
let endData              = [];

//코드 관련
let incdOrgnCdData        = [];
let cmtrGradCdData        = [];
let incdCnfmMthdCdData    = [];
let incdSernCdData        = [];
let incdTypeCdData        = [];
let incdTypeClsfCdData    = [];
let respLvlCdData         = [];
let wthrCdData            = [];
let incdEndCnfmMthdCdData = [];
let trvlLmntTypeCdData    = [];
let vmsCdData             = [];
let vmsClsfCdData         = [];

//이력조회 관련
let historyCheck          = null;
let historyStrtDt         = null;
let historyStrtTime       = null;
let historyEndDt          = null;
let historyEndTime        = null;
let historySearchBtn      = null;

//pop-up
const listOption     = 'width = 800, height = 900, top = 40, left = 500, resizable=yes, scrollbars=no';
const vmsListOption  = 'width = 600, height = 600, top = 200, left = 660, resizable=yes, scrollbars=no';
const mapOption      = 'width = 1700, height = 900, top = 40, left = 100, resizable=yes, scrollbars=no';
const _multiSelct    = false;
const _linkLevel     = 1;

const getParam = {
    MultiSelect : _multiSelct,
    LinkLevel   : _linkLevel,
    LinkInfo    : [],
};
//데이트 컬럼
const dateColumns = ['rgst_dt','incd_end_prar_dt', 'incd_cnfm_dt', 'incd_strt_dt', 'incd_end_dt', 'detc_dt'];

incdOrgnCdData            = getCodeData( incdOrgnCdData, '/ist');
cmtrGradCdData            = getCodeData( cmtrGradCdData, '/ltcu');
incdCnfmMthdCdData        = getCodeData( incdCnfmMthdCdData, '/icm');
incdSernCdData            = getCodeData( incdSernCdData, '/srlu');
incdTypeClsfCdData        = getCodeData( incdTypeClsfCdData, '/idtu');
if (incdTypeClsfCdData.length > 0) {
    incdTypeCdData = getCodeData(incdTypeCdData, '/idtu/' + encodeURIComponent(incdTypeClsfCdData[0].code));
}
respLvlCdData             = getCodeData(respLvlCdData, '/rsl');
wthrCdData                = getCodeData(wthrCdData, '/wetu');
incdEndCnfmMthdCdData     = getCodeData(incdEndCnfmMthdCdData, '/icm');
trvlLmntTypeCdData        = getCodeData(trvlLmntTypeCdData, '/prtu');
vmsClsfCdData             = getCodeData( vmsClsfCdData, '/vit');


//신규 돌발 등록 input
const newInputArr = [
    //돌발 ID
    newIncdOccrId = {
        box      : null,
        type     : 'text',
        column   : 'incd_ocrr_id',
        readOnly : true,
        width    : 200,
    },
    //등록일시
    newRgstDt = {
        box      : null,
        type     : 'datetime',
        column   : 'rgst_dt',
        displayFormat : 'yyyy-MM-dd HH:mm:ss',
        readOnly : true,
        width    : 200,
    },
    //돌발구분코드
    newIncdOrgnCd = {
        box         : null,
        type        : 'select',
        column      : 'incd_orgn_cd',
        width       : 180,
        items       : incdOrgnCdData,
        max         : 100,
    },
    //발생위치설명
    newOcrrLctnNm = {
        box    : null,
        type   : 'text',
        column : 'ocrr_lctn_nm',
        width  : 500,
        must   : true,
        label  : '발생위치설명',
        max    : 100,
    },
    //돌발상황설명
    newIncdExpl = {
        box    : null,
        type   : 'text',
        column : 'incd_expl',
        width  : 500,
        must   : true,
        label  : '돌발상황설명',
        max    : 600,
    },
    //소통상황코드
    newCmtrGradCd = {
        box         : null,
        type        : 'select',
        column      : 'cmtr_grad_cd',
        items       : cmtrGradCdData,
        width       : 300,
    },
    //제보자명
    newIfmrNm = {
        box    : null,
        type   : 'text',
        column : 'ifmr_nm',
        width  : 250,
        label  : '제보자명',
        max    : 20,
    },
    //확인방법 코드
    newIncdCnfmMthdCd = {
        box         : null,
        type        : 'select',
        column      : 'incd_cnfm_mthd_cd',
        items       : incdCnfmMthdCdData,
        width       : 250,
    },
    //심각도 코드
    newIncdSernCd = {
        box         : null,
        column      : 'incd_sern_cd',
        items       : incdSernCdData,
        type        : 'select',
        width       : 250,
    },
    //돌발 세부 유형 코드
    newIncdTypeCd = {
        box         : null,
        column      : 'incd_type_cd',
        items       : incdTypeCdData,
        type        : 'select',
        width       : 180,
    },
    //돌발확인시각
    newIncdCnfmDt = {
        box            : null,
        type           : 'datetime',
        column         : 'incd_cnfm_dt',
        width          : 170,
        displayFormat  : 'yyyy-MM-dd HH:mm:ss',
        value          : new Date(),
        must           : true,
        label          : '돌발확인시각'
    },
    //돌발 유형 코드
    newIncdTypeClsfCd = {
        box         : null,
        column      : 'incd_type_clsf_cd',
        items       : incdTypeClsfCdData,
        type        : 'select',
        width       : 180,
        method      : function(){
            incdTypeCdData = setDetailCd( incdTypeCdData, newIncdTypeCd, newIncdTypeClsfCd, 'idtu');
        }
    },
    //돌발제목
    newIncdTitl = {
        box    : null,
        column : 'incd_titl',
        type   : 'text',
        width  : 500,
        max    : 400,
        must   : true,
        label  : '돌발제목',
    },
    //돌발시작시각
    newIncdStrtDt = {
        box            : null,
        type           : 'datetime',
        column         : 'incd_strt_dt',
        width          : 170,
        displayFormat : 'yyyy-MM-dd HH:mm:ss',
        value          : new Date()
    },
    //종료예정시각
    newIncdEndPrarDt = {
        box            : null,
        type           : 'datetime',
        column         : 'incd_end_prar_dt',
        width          : 170,
        displayFormat : 'yyyy-MM-dd HH:mm:ss',
        value          : new Date(new Date().setDate(new Date().getDate()+1)),
    },
]


//진행상황처리
const prcdInputArr = [
    //돌발 ID
    prcdIncdOccrId = {
        box      : null,
        type     : 'text',
        column   : 'incd_ocrr_id',
        readOnly : true,
        width    : 200,
    },
    //등록일시
    prcdRgstDt = {
        box            : null,
        type           : 'datetime',
        column         : 'rgst_dt',
        readOnly       : true,
        displayFormat : 'yyyy-MM-dd HH:mm:ss',
        width          : 200,
    },
    //돌발구분코드
    prcdIncdOrgnCd = {
        box         : null,
        type        : 'select',
        column      : 'incd_orgn_cd',
        width       : 180,
        items       : incdOrgnCdData,
        label       : '돌발구분',
        must        : true,
    },
    //발생위치설명
    prcdOcrrLctnNm = {
        box    : null,
        type   : 'text',
        column : 'ocrr_lctn_nm',
        width  : 500,
        must   : true,
        label  : '발생위치설명',
        max    : 100,
    },
    //돌발상황설명
    prcdIncdExpl = {
        box    : null,
        type   : 'text',
        column : 'incd_expl',
        width  : 600,
        must   : true,
        label  : '돌발상황설명',
        max    : 600,
    },
    //소통상황코드
    prcdCmtrGradCd = {
        box         : null,
        type        : 'select',
        column      : 'cmtr_grad_cd',
        items       : cmtrGradCdData,
        width       : 180,
    },
    //제보자명
    prcdIfmrNm = {
        box    : null,
        type   : 'text',
        column : 'ifmr_nm',
        width  : 250,
        max    : 20,
        label  : '제보자명',
    },
    //확인방법 코드
    prcdIncdCnfmMthdCd = {
        box         : null,
        type        : 'select',
        column      : 'incd_cnfm_mthd_cd',
        items       : incdCnfmMthdCdData,
        width       : 250,
        label       : '확인방법',
        must        : true,
    },
    //심각도 코드
    prcdIncdSernCd = {
        box         : null,
        column      : 'incd_sern_cd',
        items       : incdSernCdData,
        type        : 'select',
        width       : 250,
        must        : '심각도',
    },
    //돌발 세부 유형 코드
    prcdIncdTypeCd = {
        box         : null,
        column      : 'incd_type_cd',
        items       : incdTypeCdData,
        type        : 'select',
        width       : 200,
        must        : '돌발세부유형',
    },
    //돌발 유형 코드
    prcdIncdTypeClsfCd = {
        box         : null,
        column      : 'incd_type_clsf_cd',
        items       : incdTypeClsfCdData,
        type        : 'select',
        width       : 200,
        must        : true,
        label       : '돌발유형',
        method      : function(){
            incdTypeCdData = setDetailCd( incdTypeCdData, prcdIncdTypeCd, prcdIncdTypeClsfCd, 'idtu');
        }
    },
    //돌발제목
    prcdIncdTitl = {
        box    : null,
        column : 'incd_titl',
        type   : 'text',
        width  : 600,
        label  : '돌발제목',
        must   : true,
        max    : 400,
    },
    //돌발시작시각
    prcdIncdStrtDt = {
        box            : null,
        type           : 'datetime',
        column         : 'incd_strt_dt',
        width          : 170,
        displayFormat  : 'yyyy-MM-dd',
        must           : true,
        label          : '돌발시작시각',
    },
    //종료예정시각
    prcdIncdEndPrarDt = {
        box            : null,
        type           : 'datetime',
        column         : 'incd_end_prar_dt',
        width          : 170,
        displayFormat  : 'yyyy-MM-dd',
        label          : '종료예정시각',
        must           : true,
    },
    //링크ID
    prcdLinkId = {
        box            : null,
        type           : 'text',
        column         : 'link_id',
        width          : 280,
        readOnly       : true,
        label          : '발생구간(링크)',
        must           : true,
    },
    //x좌표
    prcdXcrdn = {
        box            : null,
        type           : 'text',
        column         : 'x_crdn',
        width          : 170,
        value          : '0.000000',
        must           : true,
        label          : '발생좌표(X)',
        max            : 12,
        method         : function(text){
            crdnChanges(text, 3);
        },
    },
    //y좌표
    prcdYcrdn = {
        box            : null,
        type           : 'text',
        column         : 'y_crdn',
        width          : 170,
        value          : '0.000000',
        label          : '발생좌표(Y)',
        must           : true,
        max            : 11,
        method         : function(text){
            crdnChanges(text, 2);
        },
    },
    //vms 표출여부
    prcdVmsDsplYn = {
        box            : null,
        type           : 'check',
        value          : false,
        column         : 'vms_dspl_yn',
        text           : 'VMS 표출',
        width          : 170,
        method         : function(){
            const checkYn = getValue(prcdVmsDsplYn.box)
            vmsListBtn.option('disabled', !checkYn);
            prcdStrtLctnNm.box.option('disabled', !checkYn);
            prcdEndLctnNm.box.option('disabled', !checkYn);
            prcdVmsIncdTypeCd.box.option('disabled', !checkYn);
            prcdVmsIncdDetlTypeCd.box.option('disabled', !checkYn);

        }
    },
    //vms 시점명
    prcdStrtLctnNm = {
        box            : null,
        type           : 'text',
        column         : 'strt_lctn_nm',
        width          : 120,
        placeholder    : '시점명',
        label          : '시점명',
        max            : 10,
    },
    //vms 종점명
    prcdEndLctnNm = {
        box            : null,
        type           : 'text',
        column         : 'end_lctn_nm',
        width          : 120,
        placeholder    : '종점명',
        label          : '종점명',
        max            : 10,
    },
    //vms 돌발유형
    prcdVmsIncdTypeCd = {
        box            : null,
        type           : 'select',
        items          : vmsClsfCdData,
        column         : 'vms_incd_type_cd',
        width          : 150,
        method      : function(){
            vmsCdData = setDetailCd( vmsCdData, prcdVmsIncdDetlTypeCd, prcdVmsIncdTypeCd, 'vit');
        }
    },
    //vms 돌발 세부유형
    prcdVmsIncdDetlTypeCd = {
        box            : null,
        type           : 'select',
        items          : [],
        column         : 'vms_incd_detl_type_cd',
        width          : 150,
    },
    //발생차로 갓길
    prcdIncdOcrrLane0 = {
        box            : null,
        type           : 'check',
        column         : 'incd_ocrr_lane_0',
        value          : false,
        width          : 170,
        text           : '갓길'
    },
    //발생차로 1
    prcdIncdOcrrLane1 = {
        box            : null,
        type           : 'check',
        column         : 'incd_ocrr_lane_1',
        value          : false,
        width          : 170,
        text           : '1'
    },
    //발생차로 2
    prcdIncdOcrrLane2 = {
        box            : null,
        type           : 'check',
        column         : 'incd_ocrr_lane_2',
        value          : false,
        width          : 170,
        text           : '2'
    },
    //발생차로 3
    prcdIncdOcrrLane3 = {
        box            : null,
        type           : 'check',
        column         : 'incd_ocrr_lane_3',
        value          : false,
        width          : 170,
        text           : '3'
    },
    //발생차로 4
    prcdIncdOcrrLane4 = {
        box            : null,
        type           : 'check',
        column         : 'incd_ocrr_lane_4',
        value          : false,
        width          : 4,
        text           : '4'
    },
    //발생차로 5
    prcdIncdOcrrLane5 = {
        box            : null,
        type           : 'check',
        column         : 'incd_ocrr_lane_5',
        value          : false,
        width          : 5,
        text           : '5'
    },
    //폐쇄차로 갓길
    prcdIncdClsrLane0 = {
        box            : null,
        type           : 'check',
        column         : 'incd_clsr_lane_0',
        value          : false,
        text           : '갓길'
    },
    //폐쇄차로 1
    prcdIncdClsrLane1 = {
        box            : null,
        type           : 'check',
        column         : 'incd_clsr_lane_1',
        value          : false,
        text           : '1'
    },
    //폐쇄차로 2
    prcdIncdClsrLane2 = {
        box            : null,
        type           : 'check',
        column         : 'incd_clsr_lane_2',
        value          : false,
        text           : '2'
    },
    //폐쇄차로 3
    prcdIncdClsrLane3 = {
        box            : null,
        type           : 'check',
        column         : 'incd_clsr_lane_3',
        value          : false,
        text           : '3'
    },
    //폐쇄차로 4
    prcdIncdClsrLane4 = {
        box            : null,
        type           : 'check',
        column         : 'incd_clsr_lane_4',
        value          : false,
        text           : '4'
    },
    //폐쇄차로 5
    prcdIncdClsrLane5 = {
        box            : null,
        type           : 'check',
        column         : 'incd_clsr_lane_5',
        value          : false,
        text           : '5'
    },
    //소형차량대수
    prcdSmltVhclUnum = {
        box            : null,
        type           : 'number',
        column         : 'smlt_vhcl_unum',
        value          : '0',
        width          : 80,
    },
    //중대형차량대수
    prcdMdltVhclUnum = {
        box            : null,
        type           : 'number',
        column         : 'mdlt_vhcl_unum',
        value          : '0',
        width          : 80,
    },
    //부상자수
    prcdInjrPnum = {
        box            : null,
        type           : 'number',
        column         : 'injr_pnum',
        value          : '0',
        width          : 80,
    },
    //사망자수
    prcdFtltPnum = {
        box            : null,
        type           : 'number',
        column         : 'ftlt_pnum',
        value          : '0',
        width          : 80,
    },
    //지체길이
    prcdDelyLngt = {
        box            : null,
        type           : 'number',
        column         : 'dely_lngt',
        value          : '0',
        width          : 90,
    },
    //발생길이
    prcdIncdLngt = {
        box            : null,
        type           : 'number',
        column         : 'incd_lngt',
        value          : '0',
        width          : 90,
    },
    //기상조건 코드
    prcdWthrCd = {
        box            : null,
        type           : 'select',
        column         : 'wthr_cd',
        items          : wthrCdData,
        width          : 110,
    },
    //대응수준 코드
    prcdRespLvlCd = {
        box            : null,
        type           : 'select',
        column         : 'resp_lvl_cd',
        items          : respLvlCdData,
        width          : 110,
    },
    //고장차량여부
    prcdTrubVhclYn = {
        box            : null,
        type           : 'check',
        column         : 'trub_vhcl_yn',
        value          : false,
        width          : 100,
        text           : '고장차량'
    },
    //낙하물여부
    prcdFaltYn = {
        box            : null,
        type           : 'check',
        column         : 'falt_yn',
        value          : false,
        width          : 100,
        text           : '낙하물'
    },
    //화재위험물여부
    prcdFrwtYn = {
        box            : null,
        type           : 'check',
        column         : 'frwt_yn',
        value          : false,
        width          : 100,
        text           : '화재위험물'
    },
]

//돌빌 종료 처리 input
const endInputArr = [
    //돌발 ID
    endIncdOccrId = {
        box      : null,
        type     : 'text',
        column   : 'incd_ocrr_id',
        readOnly : true,
        width    : 200,
    },
    //등록일시
    endRgstDt = {
        box           : null,
        type          : 'datetime',
        column        : 'rgst_dt',
        displayFormat : 'yyyy-MM-dd HH:mm:ss',
        readOnly      : true,
        width         : 200,
    },
    //돌발구분코드
    endIncdOrgnCd = {
        box         : null,
        type        : 'select',
        column      : 'incd_orgn_cd',
        readOnly    : true,
        width       : 180,
        items       : incdOrgnCdData,
    },
    //발생위치설명
    endOcrrLctnNm = {
        box      : null,
        type     : 'text',
        readOnly : true,
        column   : 'ocrr_lctn_nm',
        width    : 500,
    },
    //돌발상황설명
    endIncdExpl = {
        box      : null,
        type     : 'text',
        readOnly : true,
        column   : 'incd_expl',
        width    : 600,
    },
    //소통상황코드
    endCmtrGradCd = {
        box         : null,
        type        : 'select',
        column      : 'cmtr_grad_cd',
        readOnly    : true,
        items       : cmtrGradCdData,
        width       : 180,
    },
    //대응수준코드
    endRespLvlCd = {
        box         : null,
        type        : 'select',
        column      : 'resp_lvl_cd',
        readOnly    : true,
        items       : respLvlCdData,
        width       : 180,
    },
    //링크ID
    endLinkId = {
        box            : null,
        type           : 'text',
        column         : 'link_id',
        readOnly       : true,
        width          : 280,
        readOnly       : true,
    },
    //x좌표
    endXcrdn = {
        box            : null,
        type           : 'text',
        column         : 'x_crdn',
        readOnly       : true,
        width          : 170,
        value          : '0.000000',
    },
    //y좌표
    endYcrdn = {
        box            : null,
        type           : 'text',
        column         : 'y_crdn',
        readOnly       : true,
        width          : 170,
        value          : '0.000000',
    },
    //제보자명
    endIfmrNm = {
        box      : null,
        type     : 'text',
        column   : 'ifmr_nm',
        readOnly : true,
        width    : 250,
    },
    //확인방법 코드
    endIncdCnfmMthdCd = {
        box         : null,
        type        : 'select',
        column      : 'incd_cnfm_mthd_cd',
        readOnly    : true,
        items       : incdCnfmMthdCdData,
        width       : 250,
    },
    //심각도 코드
    endIncdSernCd = {
        box         : null,
        column      : 'incd_sern_cd',
        readOnly    : true,
        items       : incdSernCdData,
        type        : 'select',
        width       : 250,
    },
    //돌발 세부 유형 코드
    endIncdTypeCd = {
        box         : null,
        column      : 'incd_type_cd',
        readOnly    : true,
        items       : incdTypeCdData,
        type        : 'select',
        width       : 200,
    },
    //돌발 유형 코드
    endIncdTypeClsfCd = {
        box         : null,
        column      : 'incd_type_clsf_cd',
        readOnly    : true,
        items       : incdTypeClsfCdData,
        type        : 'select',
        width       : 200,
        method      : function(){
            incdTypeCdData = setDetailCd( incdTypeCdData, endIncdTypeCd, endIncdTypeClsfCd, 'idtu');
        }
    },
    //돌발제목
    endIncdTitl = {
        box      : null,
        column   : 'incd_titl',
        readOnly : true,
        type     : 'text',
        width    : 500,
    },
    //돌발시작시각
    endIncdStrtDt = {
        box            : null,
        type           : 'datetime',
        column         : 'incd_strt_dt',
        width          : 170,
        readOnly       : true,
        displayFormat : 'yyyy-MM-dd',
    },
    //종료예정시각
    endIncdEndPrarDt = {
        box            : null,
        type           : 'datetime',
        column         : 'incd_end_prar_dt',
        width          : 170,
        readOnly       : true,
        displayFormat : 'yyyy-MM-dd',
    },
    //돌발 종료 확인 방법 코드
    endIncdEndCnfmMthdCd = {
        box         : null,
        column      : 'incd_end_cnfm_mthd_cd',
        items       : incdEndCnfmMthdCdData,
        type        : 'select',
        must        : true,
        label       : '돌발종료확인방법',
        width       : 250,
    },
    //돌발종료시각
    endIncdEndDt = {
        box            : null,
        type           : 'datetime',
        column         : 'incd_end_dt',
        width          : 250,
        label          : '돌발종료시각',
        must           : true,
        displayFormat : 'yyyy-MM-dd HH:mm:ss',
    },
    //출동장비내용
    endMblzEqpmCont = {
        box    : null,
        column : 'mblz_eqpm_cont',
        type   : 'text',
        label  : '출동장비내역',
        max    : 400,
        width  : 500,
    },
    //복구 내용
    endRecrCont = {
        box    : null,
        column : 'recr_cont',
        type   : 'text',
        width  : 500,
        label  : '돌발복구내역',
        max    : 400,
    },
    //출동 인원수
    endMblzPnum = {
        box            : null,
        type           : 'number',
        column         : 'mblz_pnum',
        width          : 80,
        value          : '0',
        max            : 99999,
    },
    //복구기간
    endRecrPerd = {
        box            : null,
        type           : 'number',
        column         : 'recr_perd',
        width          : 80,
        value          : '0',
        max            : 99999,
    },
]

//버튼 배열
const btnArr = [
    locationBtn = {
        box          : null,
        text         : '위치보기',
        class        : 'location-btn',
        icon         : 'globe',
        new          : {
            visible  : true,
            disabled : true,
            click    : {visible:true, disabled:true},
            cancle   : {visible:true, disabled:true},
        },
        prcd         : {
            visible  : true,
            disabled : true,
        },
        end          : {
            visible  : true,
            disabled : true,
        },
    },
    createBtn = {
        box          : null,
        text         : '신규등록',
        icon         : 'plus',
        new          : {
            visible  : true,
            disabled : false,
            click    : {visible:false, disabled:false},
            cancle   : {visible:true, disabled:false},
        },
        prcd         : {
            visible  : false,
            disabled : false,
        },
        end          : {
            visible  : false,
            disabled : false,
        },
        class        : 'create-btn',
        method      : function(){
            dsblOnBtn(tab);

            newDataInit();
            setValue(newIncdEndPrarDt.box, new Date(new Date().setDate(new Date().getDate()+1)));
            btnArr.map((item)=>{
                if(item.new.click){
                    item.box.option('disabled', item.new.click.disabled);
                    item.box.option('visible', item.new.click.visible);
                }
            })

            eventOn( newInputArr );
        }
    },
    cancleBtn = {
        box          : null,
        text         : '등록취소',
        icon         : 'undo',
        new          : {
            visible  : false,
            disabled : false,
            click    : {visible:true, disabled:false},
            cancle   : {visible:false, disabled:false},
        },
        prcd         : {
            visible  : false,
            disabled : false,
        },
        end          : {
            visible  : false,
            disabled : false,
        },
        class        : 'cancle-btn',
        method      : function(){
            eventOff(newInputArr);

            btnArr.map((item)=>{
                if(item.new.cancle){
                    item.box.option('visible', item.new.cancle.visible);
                    item.box.option('disabled', item.new.cancle.disabled);
                }
            })
        }
    },
    missBtn = {
        box          : null,
        text         : '오보판정',
        icon         : 'edit',
        class        : 'miss-btn',
        new          : {
            visible  : true,
            disabled : true,
            click    : {visible:true, disabled:true},
            cancle   : {visible:true, disabled:true},
        },
        prcd         : {
            visible  : true,
            disabled : true,
            click    : {visible:true, disabled:false},
            cancle   : {visible:true, disabled:true},
        },
        end          : {
            visible  : false,
            disabled : true,
        },
    },
    incdCfrmBtn = {
        box          : null,
        text         : '돌발확정',
        icon         : 'save',
        new          : {
            visible  : true,
            disabled : true,
            click    : {visible:true, disabled:false},
            cancle   : {visible:true, disabled:true},
        },
        prcd         : {
            visible  : false,
            disabled : true,
        },
        end          : {
            visible  : false,
            disabled : true,
        },
        class        : 'incd-cfrm-btn',
        method      : function(){
            let updateData = {};
            for(let idx in newInputArr){
                const input = newInputArr[idx];
                const box   = input.box;
                const value = getValue(input.box);
                const empty = nullChecker(value) === "";
                const label = input.label;
                const max   = input.max;
                if (empty) {
                    if (input.must) {
                        return alertWarning('필수 항목을 입력해주세요. [' + label + ']', null, input.box);
                    }
                }
                else  {
                    if (max && getByteLength(value) > max) {
                        return alertWarning( max + ' 바이트 이내로 입력해주세요. [ ' + label + ' ]', null, box);
                    }
                    updateData[input.column] = value;
                }
            }
            updateData['incd_prgr_step_cd'] = 'ISS2';
            updateData['utis_cnct_yn'] = 'N';

            sendDateFormat(updateData);
            let result = postInsertUpdate(commonUri + '/' + encodeURIComponent(getValue(newIncdOccrId.box)), updateData);
            if (result > 0) {
                insResultMsg('신규' + _pageName);
                fetchBaseData();

                eventOff(newInputArr);
            }

        }
    },
    incdInfoCfrmBtn = {
        box          : null,
        text         : '정보등록',
        icon         : 'save',
        new          : {
            visible  : false,
            disabled : false,
        },
        prcd         : {
            visible  : true,
            disabled : true,
        },
        end          : {
            visible  : false,
            disabled : false,
        },
        class        : 'incd-info-cfrm-btn',
        method      : function(){
            const vmsData = [
                'cmtr_grad_cd',
                'end_lctn_nm',
                'incd_end_prar_dt',
                'incd_ocrr_id',
                'incd_prgr_step_cd',
                'incd_strt_dt',
                'link_id',
                'ocrr_lctn_nm',
                'strt_lctn_nm',
                'vms_incd_detl_type_cd',
                'vms_incd_type_cd',
                'vms_dspl_yn',
            ];

            let error            = false;
            let updateCheck      = [ 'falt_yn', 'frwt_yn', 'trub_vhcl_yn', 'vms_dspl_yn' ];
            let vmsUpdateData    = {};
            let updateData = {...getInstance(prcdIncdTable).getSelectedRowsData()[0]};
            for (let idx in prcdInputArr) {
                const input = prcdInputArr[idx];
                const box = input.box;
                const value = getValue(box);
                const empty = nullChecker(value) === "";
                const column = input.column;
                const max    = input.max;
                const label  = input.label;
                if (empty) {
                    if (input.must) {
                        return alertWarning('필수 항목을 입력해주세요. [' + label + ']', null, box);
                    }
                } else {
                    if (max && getByteLength(value) > max) {
                        return alertWarning(max + ' 바이트 이내로 입력해주세요. [' + label + ']', null, box);
                    }
                }

                if (input.type === 'check') {
                    if (updateCheck.includes(column)) updateData[column] = getCheckData(box);
                    if (vmsData.includes(column)) vmsUpdateData[column] = getCheckData(box);
                } else {
                    updateData[column] = value;
                    if (vmsData.includes(column)) vmsUpdateData[column] = value;
                }
            }

            updateData['incd_ocrr_lane'] = getLaneVal(incdOcrrLaneArr);
            updateData['incd_clsr_lane'] = getLaneVal(incdClsrLaneArr);
            vmsUpdateData['incd_clsr_lane'] = updateData['incd_clsr_lane'];
            if (isNaN(updateData.link_id)){
                updateData.link_id = Number(updateData.link_id.substring(updateData.link_id.indexOf('[')+1,updateData.link_id.indexOf(']')));
                vmsUpdateData.link_id = updateData.link_id
            };

            updateData = sendDateFormat(updateData);
            vmsUpdateData = sendDateFormat(vmsUpdateData);
            let resultCnt = 0;

            if (updateData.vms_dspl_yn){
                resultCnt = postInsertUpdate(commonUri + '/vms/incd/'+ encodeURIComponent(vmsUpdateData.incd_ocrr_id), vmsUpdateData);
            }

            resultCnt += postInsertUpdate(commonUri + '/' + encodeURIComponent(updateData.incd_ocrr_id), updateData);
            if (resultCnt > 0) {
                insResultMsg(_pageName + '진행상황');
                fetchBaseData();
                eventOff(prcdInputArr);
            }
        }
    },
    refreshBtn      = {
        box          : null,
        text         : '초기화',
        icon         : 'refresh',
        new          : {
            visible  : false,
            disabled : false,
        },
        prcd         : {
            visible  : true,
            disabled : true,
        },
        end          : {
            visible  : true,
            disabled : true,
        },
        class       : 'refresh-btn',
    },
    incdEndBtn      = {
        box          : null,
        text         : '돌발종료',
        icon         : 'save',
        new          : {
            visible  : false,
            disabled : false,
        },
        prcd         : {
            visible  : false,
            disabled : false,
        },
        end          : {
            visible  : true,
            disabled : true,
        },
        class        : 'incd-end-btn',
        method      : function(){
            let updateData = {...getInstance(endIncdTable).getSelectedRowsData()[0]};
            let endColumns = [
                'incd_end_dt',
                'incd_end_cnfm_mthd_cd',
                'mblz_eqpm_cont',
                'recr_cont',
                'mblz_pnum',
                'recr_perd'
            ];

            for(let idx in endInputArr){
                const input = endInputArr[idx];
                const box   = input.box;
                const value = getValue(box);
                const empty = nullChecker(value) === "";
                const column = input.column;
                const label  = input.label;
                const max    = input.max;
                if (empty) {
                    if (input.must) {
                        return  alertWarning('필수 항목을 입력해주세요. [' + label + ']', null, box);
                    }
                }
                else {
                    if (max && getByteLength(value) > max) {
                        return alertWarning( max + ' 바이트 이내로 입력해주세요. [' + label + ']', null, box);
                    }
                    if (endColumns.includes(column)) {
                        updateData[column] = value;
                    }
                }
            }
            updateData['incd_prgr_step_cd'] = 'ISS3';
            if (isNaN(updateData.link_id)){
                updateData.link_id = Number(updateData.link_id.substring(updateData.link_id.indexOf('[')+1, updateData.link_id.indexOf(']')));
            };
            updateData = sendDateFormat(updateData);
            let resultCnt = 0;

            resultCnt += postInsertUpdate(commonUri + '/' + encodeURIComponent(updateData.incd_ocrr_id), updateData);

            if (resultCnt > 0) {
                insResultMsg(_pageName + '종료 처리');
                fetchBaseData();
                eventOff(endInputArr);
            }
        }
    },

]

//이력 조회 배열
const historyArr = [
    historyCheck     = {
        class    : 'history-check',
        box      : null,
        text     : '이력조회',
        disabled : false,
        type     : 'check',
        method   : function(e){
            historyArr.map((item)=>{
                if(item.class !== 'history-check') item.box.option('disabled', !item.box.option('disabled'));
            })
            if(!getValue(historyCheck.box)) endIncdTable.dxDataGrid('instance').option('dataSource', getInstance(prcdIncdTable).option('dataSource'));
        }
    },
    historyStrtDt    = {
        class         : 'history-strt-dt',
        type          : 'date',
        width         : 120,
        box           : null,
        displayFormat : 'yyyy-MM-dd',
        value         : new Date().setMonth( new Date().getMonth() - 1),
    },
    historyStrtTime  = {
        class         : 'history-strt-time',
        type          : 'time',
        displayFormat : 'HH',
        width         : 70,
        interval      : 60,
        value         : firstSettingTime,
        box           : null,
    },
    historyEndDt     = {
        class         : 'history-end-dt',
        type          : 'date',
        width         : 120,
        box           : null,
        displayFormat : 'yyyy-MM-dd',
        value         : new Date(),
    },
    historyEndTime   = {
        class         : 'history-end-time',
        box           : null,
        width         : 70,
        type          : 'time',
        displayFormat : 'HH',
        value         : new Date().getTime(),
        interval      : 60,
    },
    historySearchBtn = {
        class         : 'history-search-btn',
        box           : null,
        icon          : 'refresh',
        type          : 'button',
        text          : '조회',
        method        : function(){
            historySearchBtnClick();
        }
    },
]

const toggleArr = [
    {
        box    : null,
        formNm : 'new',
        formToggle : 'toggle-down',
        tabToggle  : 'toggle'
    },
    {
        box    : null,
        formNm : 'prcd',
        formToggle : 'toggle-down',
        tabToggle  : 'toggle'
    },
    {
        box    : null,
        formNm : 'end',
        formToggle : 'end-toggle-down',
        tabToggle  : 'end-toggle'
    }
]



$(()=>{
    init();

    $('body').on('click',function(){
        $(".add-select-btn").addClass('dpl-none');
    })

    //추가 버튼 목록에서 선택
    $(".add-select-btn > div:nth-child(1)").on('click',function(){
        event.stopPropagation();
        window.open('./incident-popup-link.html', '목록 구간', listOption);
        $(".add-select-btn").addClass('dpl-none');
    })

    //추가 버튼 맵에서 선택
    $(".add-select-btn > div:nth-child(2)").on('click',function(){
        event.stopPropagation();
        window.open('./incident-popup-map.html', '지도 구간', mapOption);
        $(".add-select-btn").addClass('dpl-none');
    })

})

function init(){

    //화면 텍스트 상자 세팅
    setViewInputArray( newInputArr, 'new' );
    setViewInputArray( prcdInputArr, 'prcd' );
    setViewInputArray( endInputArr, 'end' );

    //차로 정보 Array
    incdOcrrLaneArr.push(prcdIncdOcrrLane0, prcdIncdOcrrLane1, prcdIncdOcrrLane2, prcdIncdOcrrLane3, prcdIncdOcrrLane4, prcdIncdOcrrLane5);
    incdClsrLaneArr.push(prcdIncdClsrLane0, prcdIncdClsrLane1, prcdIncdClsrLane2, prcdIncdClsrLane3, prcdIncdClsrLane4, prcdIncdClsrLane5);

    //이력 정보 세팅
    historyArr.map((item)=>{
        switch (item.type) {
            case 'date':
                item.box = $("." + item.class).dxDateBox({
                    width               : item.width,
                    stylingMode         : 'outlined',
                    height              : 25,
                    type                : item.type,
                    readOnly            : item.readOnly,
                    displayFormat       : item.displayFormat,
                    value               : item.value,
                    invalidDateMessage  : '형식에 맞게 입력해주세요',
                    disabled            : true,
                }).dxDateBox('instance');
                break;
            case 'time':
                item.box = $("." + item.class).dxDateBox({
                    width               : item.width,
                    stylingMode         : 'outlined',
                    height              : 25,
                    type                : item.type,
                    readOnly            : item.readOnly,
                    displayFormat       : item.displayFormat,
                    invalidDateMessage  : '형식에 맞게 입력해주세요',
                    value               : item.value,
                    interval            : item.interval,
                    disabled            : true,
                }).dxDateBox('instance');
                break;
            case 'button':
                item.box = $("." + item.class).dxButton({
                    stylingMode    : 'outlined',
                    icon           : item.icon,
                    height         : 27,
                    disabled       : true,
                    text           : item.text,
                    onClick(){
                        if(item.method){
                            item.method();
                        }
                    }
                }).dxButton('instance');
                break;
            case 'check':
                item.box = $("." + item.class).dxCheckBox({
                    stylingMode     : 'outlined',
                    text            : item.text,
                    onValueChanged(){
                        if(item.method){
                            item.method();
                        }
                    }
                }).dxCheckBox('instance');
                break;
            default:
                break;
        }
    })

    prcdLinkBtn = $(".prcd-link-btn").dxButton({
        text        : '선택',
        icon        : 'todo',
        stylingMode : 'outlined',
        disabled    : true,
        onClick(){
            event.stopPropagation();
            $('.add-select-btn').toggleClass('dpl-none');
        }
    }).dxButton('instance');

    searchBtn = $(".search-btn").dxButton({
        stylingMode : 'outlined',
        text        : '조회',
        icon        : 'refresh',
        onClick(){
            fetchBaseData();
        }
    }).dxButton('instance');

    closeBtn = $(".close-btn").dxButton({
        stylingMode : 'outlined',
        text        : '닫기',
        icon        : 'close',
        onClick(){
            window.close();
        }
    }).dxButton('instance');

    vmsListBtn = $(".vms-list-btn").dxButton({
        stylingMode : 'outlined',
        text        : 'VMS 목록',
        disabled    : true,
        onClick(){
            window.open('./incident-popup-vms.html', '돌발구간 VMS 정보', vmsListOption);
        }
    }).dxButton('instance');

    btnArr.map((item)=>{
        item.box = $('.' + item.class).dxButton({
            stylingMode  : 'outlined',
            text         : item.text,
            icon         : item.icon,
            visible      : item.new.visible,
            disabled     : item.new.disabled,
        }).dxButton('instance');
        if (item.method) {
            item.box.on('click', ()=>item.method());
        }
    });

    missBtn.box.on('click', () => missEvent(newIncdTable));

    prcdIncdTable    = $('<div class="prcd-incd-table b1 b3 b4">').width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        noDataText              : '표출할 정보가 없습니다.',
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        keyExpr                 : ['incd_ocrr_id', 'rgst_dt'],
        selection: {
            mode: 'single',
        },
        filterRow: {
            visible: false,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible: false,
        },
        grouping: {
            autoExpandAll: true,
        },
        groupPanel:{
            visible: false,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        columns:[
            {
                dataField : "incd_ocrr_id",
                caption   : "ID",
                alignment : "center",
                sortIndex : 0,
                cssClass  : 'padding-5'
            },
            {
                dataField : "rgst_dt",
                caption   : "등록 일시",
                alignment : "center",
                dataType  : 'datetime',
                format    : 'yyyy-MM-dd HH:mm:ss',
                cssClass  : 'padding-5'
            },
            {
                dataField : "incd_orgn_cd",
                caption   : "돌발상황 구분",
                alignment : "center",
                cssClass  : 'padding-5',
                lookup    : {
                    dataSource  : incdOrgnCdData,
                    displayExpr : 'desc',
                    valueExpr   : 'code',
                }
            },
            {
                dataField : "incd_titl",
                caption   : "돌발상황 제목",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "incd_type_clsf_desc",
                caption   : "돌발유형",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "incd_type_desc",
                caption   : "돌발세부유형",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "ocrr_lctn_nm",
                caption   : "발생 위치 설명",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "incd_expl",
                caption   : "돌발상황 상황 설명",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "cmtr_grad_cd",
                caption   : "소통 등급",
                alignment : "center",
                cssClass  : 'padding-5',
                lookup    : {
                    dataSource  : cmtrGradCdData,
                    displayExpr : 'desc',
                    valueExpr   : 'code',
                }
            },
            {
                dataField : "ifmr_nm",
                caption   : "제보자",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "incd_cnfm_mthd_cd",
                caption   : "돌발상황 확인 방법",
                alignment : "center",
                cssClass  : 'padding-5',
                lookup    : {
                    dataSource  : incdCnfmMthdCdData,
                    displayExpr : 'desc',
                    valueExpr   : 'code',
                }
            },
            {
                dataField : "incd_sern_desc",
                caption   : "심각도",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "incd_cnfm_dt",
                caption   : "돌발상황 확인일시",
                alignment : "center",
                dataType  : 'datetime',
                format    : 'yyyy-MM-dd HH:mm:ss',
                cssClass  : 'padding-5',
            },
            {
                dataField : "incd_strt_dt",
                caption   : "시작 일시",
                alignment : "center",
                cssClass  : 'padding-5',
                dataType  : 'datetime',
                format    : 'yyyy-MM-dd HH:mm:ss'
            },
            {
                dataField : "incd_end_prar_dt",
                caption   : "종료 예정 일시",
                alignment : "center",
                cssClass  : 'padding-5',
                dataType  : 'datetime',
                format    : 'yyyy-MM-dd HH:mm:ss'
            },
            {
                dataField : "link_id",
                caption   : "구간 ID",
                cssClass  : 'padding-5',
                alignment : "center",
            },
            {
                dataField : "x_crdn",
                caption   : "X 좌표",
                cssClass  : 'padding-5',
                alignment : "center",
            },
            {
                dataField : "y_crdn",
                caption   : "Y 좌표",
                cssClass  : 'padding-5',
                alignment : "center",
            },
            {
                dataField : "incd_ocrr_lane",
                caption   : "발생 차로",
                cssClass  : 'padding-5',
                alignment : "center",
            },
            {
                dataField : "incd_clsr_lane",
                caption   : "차단 차로",
                cssClass  : 'padding-5',
                alignment : "center",
            },
            {
                dataField : "dely_lngt",
                caption   : "지체 길이",
                cssClass  : 'padding-5',
                alignment : "center",
            },
            {
                dataField : "incd_lngt",
                caption   : "돌발상황 길이",
                cssClass  : 'padding-5',
                alignment : "center",
            },
            {
                dataField : "smlt_vhcl_unum",
                caption   : "소형 차량 대수",
                cssClass  : 'padding-5',
                alignment : "center",
            },
            {
                dataField : "mdlt_vhcl_unum",
                caption   : "중대형 차량 대수",
                cssClass  : 'padding-5',
                alignment : "center",
            },
            {
                dataField : "injr_pnum",
                caption   : "부상자",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "ftlt_pnum",
                caption   : "사망자",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "wthr_cd",
                caption   : "기상 상태",
                alignment : "center",
                cssClass  : 'padding-5',
                lookup    : {
                    dataSource  : wthrCdData,
                    displayExpr : 'desc',
                    valueExpr   : 'code',
                }
            },
            {
                dataField : "resp_lvl_cd",
                caption   : "대응수준",
                alignment : "center",
                cssClass  : 'padding-5',
                lookup    : {
                    dataSource  : respLvlCdData,
                    displayExpr : 'desc',
                    valueExpr   : 'code',
                }
            },
            {
                dataField : "utis_cnct_yn",
                caption   : "UTIS연계여부",
                cssClass  : 'padding-5',
                alignment : "center",
            },
            {
                dataField : "trub_vhcl_yn",
                caption   : "고장차량여부",
                cssClass  : 'padding-5',
                alignment : "center",
            },
            {
                dataField : "falt_yn",
                caption   : "낙하물여부",
                cssClass  : 'padding-5',
                alignment : "center",
            },
            {
                dataField : "frwt_yn",
                caption   : "화재위험물여부",
                cssClass  : 'padding-5',
                alignment : "center",
            },
            {
                dataField : "trvl_lmnt_type_cd",
                caption   : "통행제한유형",
                cssClass  : 'padding-5',
                alignment : "center",
                lookup    : {
                    dataSource  : trvlLmntTypeCdData,
                    displayExpr : 'desc',
                    valueExpr   : 'code',
                }
            },
            {
                dataField : "vms_dspl_yn",
                caption   : "VMS표출여부",
                cssClass  : 'padding-5',
                alignment : "center",
            },
        ],
        onRowDblClick(e){
            let linkVal  = "";
            let linkData = [];
            let cdData   = [];
            cdData   = getCodeData(cdData,'/idtu/' + encodeURIComponent(e.data.incd_type_clsf_cd));
            prcdIncdTypeCd.box.option('items', cdData);

            if (e.data.link_id) {
                linkVal = setLookLocation(e.data.link_id);
            }

            prcdInputArr.map((item)=>{
                if (item.type !== 'check'){
                    let data = e.data[item.column];
                    if ( linkVal !== "" && item.column === 'link_id') return item.box.option('value', linkVal);
                    setValue(item.box, data);
                    return
                }
                if ( e.data[item.column] === 'Y' ) return setValue(item.box, true);
                if ( e.data[item.column] === 'N' ) return setValue(item.box, false);;
            })
            let vmsData = [];
            vmsCdData   = [];
            getData(commonUri + '/vms/incd/' + encodeURIComponent(e.data.incd_ocrr_id), vmsData);

            if (vmsData.length > 0){
                setValue(prcdStrtLctnNm.box, vmsData[0].strt_lctn_nm);
                setValue(prcdEndLctnNm.box, vmsData[0].end_lctn_nm);
                setValue(prcdVmsIncdTypeCd.box, vmsData[0].vms_incd_type_cd);
                vmsCdData = setDetailCd( vmsCdData, prcdVmsIncdDetlTypeCd, prcdVmsIncdTypeCd, 'vit');
                setValue(prcdVmsIncdDetlTypeCd.box, vmsData[0].vms_incd_detl_type_cd)
            }


            setLaneVal(e.data.incd_ocrr_lane, incdOcrrLaneArr);
            setLaneVal(e.data.incd_clsr_lane, incdClsrLaneArr);

            eventOn(prcdInputArr);

            if (!getValue(prcdVmsDsplYn.box)){
                dsblOnBtn(prcdVmsIncdDetlTypeCd.box);
                dsblOnBtn(prcdVmsIncdTypeCd.box);
                dsblOnBtn(prcdStrtLctnNm.box);
                dsblOnBtn(prcdEndLctnNm.box);
            }
        }
    });

    newIncdTable = $('<div class="b1 b3 b4">').width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        keyExpr                 : ['incd_ocrr_id', 'rgst_dt'],
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode: 'single',
        },
        filterRow: {
            visible: false,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible: false,
        },
        grouping: {
            autoExpandAll: true,
        },
        groupPanel:{
            visible: false,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        columns:[
            {
                dataField : "incd_ocrr_id",
                caption   : "ID",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "rgst_dt",
                caption   : "등록 일시",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "incd_orgn_cd",
                caption   : "돌발상황 구분",
                alignment : "center",
                cssClass  : 'padding-5',
                lookup    :{
                    dataSource  : incdOrgnCdData,
                    displayExpr : 'desc',
                    value       : 'code',
                }
            },
            {
                dataField : "ocrr_lctn_nm",
                caption   : "발생 위치 설명",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "incd_expl",
                caption   : "돌발 상황 설명",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "cmtr_grad_cd",
                caption   : "소통 등급",
                alignment : "center",
                cssClass  : 'padding-5',
                lookup    :{
                    dataSource  : cmtrGradCdData,
                    displayExpr : 'desc',
                    value       : 'code',
                }
            },
            {
                dataField : "ifmr_nm",
                caption   : "제보자",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "incd_cnfm_mthd_cd",
                caption   : "돌발상황 확인 방법",
                alignment : "center",
                cssClass  : 'padding-5',
                lookup    :{
                    dataSource  : incdCnfmMthdCdData,
                    displayExpr : 'desc',
                    value       : 'code',
                }
            },
            {
                dataField : "incd_sern_cd",
                caption   : "심각도",
                alignment : "center",
                cssClass  : 'padding-5',
                lookup    :{
                    dataSource  : incdSernCdData,
                    displayExpr : 'desc',
                    value       : 'code',
                }
            },
            {
                dataField : "incd_type_clsf_desc",
                caption   : "돌발상황 유형 분류",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "incd_type_desc",
                caption   : "돌발상황 유형 세부 분류",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "incd_cnfm_dt",
                caption   : "돌발상황 확인일시",
                alignment : "center",
                cssClass  : 'padding-5',
                dataType  : 'datetime',
                format    : 'yyyy-MM-dd HH:mm:ss',
            },
            {
                dataField : "incd_strt_dt",
                caption   : "시작 일시",
                alignment : "center",
                cssClass  : 'padding-5',
                dataType  : 'datetime',
                format    : 'yyyy-MM-dd HH:mm:ss',
            },
            {
                dataField : "incd_end_prar_dt",
                caption   : "종료 예정 일시",
                alignment : "center",
                cssClass  : 'padding-5',
                dataType  : 'datetime',
                format    : 'yyyy-MM-dd HH:mm:ss',
            },
        ],
        onRowClick(){
            rowClickEvent('new');
        },
        onRowDblClick(e){
            let cdData  = [];
            cdData      = getCodeData(cdData,'/idtu/' + encodeURIComponent(e.data.incd_type_clsf_cd));
            newIncdTypeCd.box.option('items', cdData);
            if (e.data.link_id) {
                setLookLocation(e.data.link_id);
            }

            newInputArr.map((item)=>{
                item.box.option('disabled', false);
                let data = e.data[item.column];
                setValue(item.box, data);
            });
        }
    });

    autoIncdTable = $('<div class="b1 b2 b3 b4">').width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        visible                 : false,
        focusedRowEnabled       : true,
        keyExpr                 : ['link_id', 'detc_dt'],
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode: 'single',
        },
        filterRow: {
            visible: false,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible: false,
        },
        grouping: {
            autoExpandAll: true,
        },
        groupPanel:{
            visible: false,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        columns:[
            {
                dataField : "link_id",
                caption   : "링크 ID",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "detc_dt",
                caption   : "검지 시각",
                alignment : "center",
                cssClass  : 'padding-5',
                dataType  : 'datetime',
                format    : 'yyyy-MM-dd HH:mm:ss',
            },
            {
                dataField : "clct_sped_avrg",
                caption   : "수집 평균 속도",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "estm_sped_avrg",
                caption   : "예상 평균 속도",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "road_name",
                caption   : "도로명",
                cssClass  : 'padding-5',
                alignment : "center",
                cellTemplate(c,e){
                    c.css('text-align','left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "from_node",
                caption   : "시점명",
                cssClass  : 'padding-5',
                alignment : "center",
                cellTemplate(c,e){
                    c.css('text-align','left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "to_node",
                caption   : "종점명",
                cssClass  : 'padding-5',
                alignment : "center",
                cellTemplate(c,e){
                    c.css('text-align','left');
                    c.text(e.displayValue);
                }
            },
        ],
        onRowClick(){
            rowClickEvent('new');
        },
        onRowDblClick(info) {
            newDataInit();
            setValue(newOcrrLctnNm.box, info.data.road_name);
            setValue(newIncdEndPrarDt.box, new Date());
            setValue(newRgstDt.box, info.data.detc_dt);
            if (info.data.link_id) {
                setLookLocation(info.data.link_id);
            }
            newInputArr.map((item)=>{
                item.box.option('disabled', false);
            });
        }
    });

    endIncdTable = $('<div class="b1 b3 b4">').width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        keyExpr                 : ['incd_ocrr_id', 'rgst_dt'],
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode: 'single',
        },
        filterRow: {
            visible: false,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible: false,
        },
        grouping: {
            autoExpandAll: true,
        },
        groupPanel:{
            visible: false,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        columns:[
            {
                dataField : "incd_ocrr_id",
                caption   : "ID",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "rgst_dt",
                caption   : "등록 일시",
                alignment : "center",
                cssClass  : 'padding-5',
                dataType  : 'datetime',
                format    : 'yyyy-MM-dd HH:mm:ss'
            },
            {
                dataField : "incd_orgn_desc",
                caption   : "돌발상황 구분",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "incd_titl",
                caption   : "돌발상황 제목",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "incd_type_clsf_desc",
                caption   : "돌발유형",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "incd_type_desc",
                caption   : "돌발세부유형",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "ocrr_lctn_nm",
                caption   : "발생 위치 설명",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "incd_expl",
                caption   : "돌발상황 상황 설명",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "cmtr_grad_cd",
                caption   : "소통 등급",
                alignment : "center",
                cssClass  : 'padding-5',
                lookup    : {
                    dataSource  : cmtrGradCdData,
                    displayExpr : 'desc',
                    valueExpr   : 'code',
                }
            },
            {
                dataField : "ifmr_nm",
                caption   : "제보자",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "incd_cnfm_mthd_cd",
                caption   : "돌발상황 확인 방법",
                alignment : "center",
                cssClass  : 'padding-5',
                lookup    : {
                    dataSource  : incdCnfmMthdCdData,
                    displayExpr : 'desc',
                    valueExpr   : 'code',
                }
            },
            {
                dataField : "incd_sern_cd",
                caption   : "심각도",
                alignment : "center",
                cssClass  : 'padding-5',
                lookup    : {
                    dataSource  : incdSernCdData,
                    displayExpr : 'desc',
                    valueExpr   : 'code',
                }
            },
            {
                dataField : "incd_cnfm_dt",
                caption   : "돌발상황 확인일시",
                alignment : "center",
                cssClass  : 'padding-5',
                dataType  : 'datetime',
                format    : 'yyyy-MM-dd HH:mm:ss'
            },
            {
                dataField : "incd_strt_dt",
                caption   : "시작 일시",
                alignment : "center",
                cssClass  : 'padding-5',
                dataType  : 'datetime',
                format    : 'yyyy-MM-dd HH:mm:ss'
            },
            {
                dataField : "incd_end_prar_dt",
                caption   : "종료 예정 일시",
                alignment : "center",
                cssClass  : 'padding-5',
                dataType  : 'datetime',
                format    : 'yyyy-MM-dd HH:mm:ss'
            },
            {
                dataField : "incd_end_cnfm_mthd_cd",
                caption   : "돌발상황 종료 확인방법",
                alignment : "center",
                cssClass  : 'padding-5',
                lookup    : {
                    dataSource  : incdEndCnfmMthdCdData,
                    displayExpr : 'desc',
                    valueExpr   : 'code',
                }
            },
            {
                dataField : "incd_end_dt",
                caption   : "돌발상황 종료일시",
                alignment : "center",
                cssClass  : 'padding-5',
                dataType  : 'datetime',
                format    : 'yyyy-MM-dd HH:mm:ss'
            },
            {
                dataField : "mblz_eqpm_cont",
                caption   : "출동장비내용",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "mblz_pnum",
                caption   : "출동인원수",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "recr_cont",
                caption   : "복구내용",
                alignment : "center",
                cssClass  : 'padding-5',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : "recr_perd",
                caption   : "복구기간(분)",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "link_id",
                caption   : "구간 ID",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "x_crdn",
                caption   : "X 좌표",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "y_crdn",
                caption   : "Y 좌표",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "incd_ocrr_lane",
                caption   : "발생 차로",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "incd_clsr_lane",
                caption   : "차단 차로",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "dely_lngt",
                caption   : "지체 길이",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "incd_lngt",
                caption   : "돌발상황 길이",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "smlt_vhcl_unum",
                caption   : "소형 차량 대수",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "mdlt_vhcl_unum",
                caption   : "중대형 차량 대수",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "injr_pnum",
                caption   : "부상자",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "ftlt_pnum",
                caption   : "사망자",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "wthr_cd",
                caption   : "기상 상태",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "resp_lvl_cd",
                caption   : "대응수준",
                cssClass  : 'padding-5',
                alignment : "center",
                lookup    : {
                    dataSource  : respLvlCdData,
                    displayExpr : 'desc',
                    valueExpr   : 'code',
                }
            },
            {
                dataField : "utis_cnct_yn",
                caption   : "UTIS연계여부",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "trub_vhcl_yn",
                caption   : "고장차량여부",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "falt_yn",
                caption   : "낙하물여부",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "frwt_yn",
                caption   : "화재위험물여부",
                alignment : "center",
                cssClass  : 'padding-5',
            },
            {
                dataField : "trvl_lmnt_type_cd",
                caption   : "통행제한유형",
                alignment : "center",
                cssClass  : 'padding-5',
                lookup    : {
                    dataSource  : trvlLmntTypeCdData,
                    displayExpr : 'desc',
                    valueExpr   : 'code',
                }
            },
            {
                dataField : "vms_dspl_yn",
                caption   : "VMS표출여부",
                alignment : "center",
                cssClass  : 'padding-5',
            },
        ],
        onRowDblClick(e){
            let cdData   = [];
            let linkVal  = '';
            cdData = getCodeData(cdData, '/idtu/' + encodeURIComponent(e.data.incd_type_clsf_cd));
            if (e.data.link_id) {
                linkVal = setLookLocation(e.data.link_id);
            }


            endIncdTypeCd.box.option('items', cdData);
            endInputArr.map((item)=>{
                let data = e.data[item.column];
                if ( linkVal !== "" && item.column === 'link_id') return item.box.option('value', linkVal);
                if( data === 'Y') return setValue(item.box, true);
                if( data === 'N') return setValue(item.box, false);
                setValue(item.box, data);
            })
            endIncdEndDt.box.option('value', new Date());
            eventOn(endInputArr);
        },
    });

    const newContainer = $(`
        <div class='tab-container'>
            <div class='table-tabs b1 b2 b3'>
                <div class='selected-tabs'>외부연계기관 돌발</div>
                    <div>자동 돌발</div>
                </div>
                <div class='tab-table-box'>
            </div>
        </div>
    `);

    const newTbLctn = $(newContainer).children().eq(1);
    const pcrdCont = $('<div style="width:100%; height : calc(100% - 30px); padding:3px;"></div>');
    const EndCont = $('<div style="width:100%; height : calc(100% - 30px); padding:3px;"></div>');

    toggleArr.map((item)=>{
        item.box = setToggleBtn(item.formNm, item.formToggle, item.tabToggle);
    })

    //돌발상황정보 탭
    tab = $('.incident-tabs').dxTabPanel({
        dataSource:[
            {
                id        : 'new',
                array     : newInputArr,
                name      : '신규 돌발 등록',
                title     : '외부연계기관',
                table     : [newIncdTable, autoIncdTable],
                form      : $(".new-incd-form"),
                lctn      : newTbLctn,
                container : newContainer,
                sizeClass : 'new-incd-height',
                click     : true,
            },
            {
                id        : 'prcd',
                array     : prcdInputArr,
                name      : '돌발 진행상황 처리',
                table     : [prcdIncdTable],
                title     : '등록된',
                form      : $(".prcd-incd-form"),
                lctn      : $(pcrdCont),
                container : pcrdCont,
                sizeClass : 'prcd-incd-height',
                click     : false,
            },
            {
                id        : 'end',
                array     : endInputArr,
                name      : '돌발 종료 처리',
                table     : [endIncdTable],
                title     : '등록된',
                container : EndCont,
                lctn      : $(EndCont),
                form      : $(".end-incd-form"),
                sizeClass : 'end-incd-height',
                click     : false,
            },
        ],
        selectIndex:0,
        loop:false,
        animationEnabled: true,
        swipeEnabled: false,
        itemTitleTemplate: function(e){
            return $('<div style="height:29px; line-height:29px;">'+e.name+'</div>')
        },
        itemTemplate: function( e, idx, c ){
            c.css({width:'100%',height: '100%'})
            let div = $(`<div class="tab-serve-title b1 b2">${e.title} 돌발목록&nbsp; (목록에서 더블클릭으로 돌발정보 선택)</div>`);

            e.table.map((item)=>{
                e.lctn.append(item);
            })
            e.container.append(e.lctn);
            c.append(div, e.container);

            if(e.click){
                tabEvent( e.container, div, 0, e.table[0], e.table[1]);
                tabEvent( e.container, div, 1, e.table[1], e.table[0]);
            }


        },
        onSelectionChanged(e){
            //화면 전환 인덱스
            $('.selected-index').text(e.component.option('selectedIndex') + 1);

            //토글 상태 초기화
            toggleInit();

            //선택 화면 데이터
            const selectItem = e.addedItems[0];

            //전 화면 데이터
            const beforeItem = e.removedItems[0];

            //탭 테이블
            const table = getInstance(selectItem.table[0]);

            //탭에 따른 폼 변경 및 높이 세팅
            beforeItem.form.css('display', 'none');
            selectItem.form.css('display', 'block');

            $('.incident-tabs').addClass(selectItem.sizeClass);
            $('.incident-tabs').removeClass(beforeItem.sizeClass);

            //첫번째 탭일때 탭 내부 탭 초기화
            if( selectItem.click ){
                selectItem.container.children().eq(0).children().eq(0).click();
            }

            //탭에 따른 버튼 보이기/감추기
            btnArr.map((item)=>{
                item.box.option('visible', item[selectItem.id].visible);
                item.box.option('disabled', item[selectItem.id].disabled);
            })

            //이벤트 초기화
            eventOff(selectItem.array);
            setDetailCd(incdTypeCdData, newIncdTypeCd, newIncdTypeClsfCd, 'idtu' );
            setBtnEvent(table, selectItem.array);
            table.clearSelection();
            table.option('focusedRowIndex', -1);
        },
    }).dxTabPanel('instance');

    fetchBaseData();
}

function fetchBaseData(){
    fetchFormatData( '/auto', [autoIncdTable] );
    fetchFormatData( '/progress', [prcdIncdTable, endIncdTable] );
    fetchFormatData( '/registered', [newIncdTable] );
}

function getInstance(box){
    return box.dxDataGrid('instance');
}

function arrayInit(array){
    array.map((item)=>{
        item.box.option('value', item.value);
    });
}

function eventOn(array){
    array.map((item)=>{
        item.box.option('disabled', false);
    });

    dsblOffBtn(prcdLinkBtn);

    if (array === newInputArr) {
        btnArr.map((item)=>{
            if (item.new.click){
                item.box.option('visible', item.new.click.visible);
                item.box.option('disabled', item.new.click.disabled);
            }
        })

        array.map((item)=>{
            if (item.type === 'select' && item.items) {
                setValue(item.box, item.items[0].code);
            }
        });
    }
    else {
        btnArr.map((item)=>{
            item.box.option('disabled', false);
        })
    }
}

function eventOff(array){
    array.map((item)=>{
        item.box.option('disabled', true);
    })
    arrayInit(array);

    dsblOnBtn(prcdLinkBtn);

    if (array === newInputArr) {
        btnArr.map((item)=>{
            if(item.new.cancle){
                item.box.option('visible', item.new.cancle.visible);
                item.box.option('disabled', item.new.cancle.disabled);
            }
        });
        dsblOffBtn(tab);
    }
    else {
        btnArr.map((item)=>{
            item.box.option('disabled', true);
        })
    }
}

function codeSorting(array){
    array.sort(function(a, b) {
        if(!isNaN(a.code))return Number(a.code) < Number(b.code) ? -1 : Number(a.code) > Number(b.code) ? 1 : 0;
        return a.code < b.code ? -1 : a.code > b.code ? 1 : 0;
    });
}

function getCodeData(array, uri){
    getData( commonUri + '/code' + uri, array);
    if(array.length > 0 ){
        codeSorting(array[0]);
        return array[0];
    }
    return array
}

/**
 * 텍스트 상자 화면 세팅
 * @param {*} array 텍스트 상자 배열
 * @param {*} classNm 클래스 이름
 */
function setViewInputArray( array, classNm ){
    array.map((item)=>{

        switch (item.type) {
            case 'text':
                item.box = $("." + classNm + "_" + item.column).dxTextBox({
                    width       : item.width,
                    height      : 30,
                    stylingMode : 'outlined',
                    readOnly    : item.readOnly,
                    value       : item.value,
                    placeholder : item.placeholder,
                    disabled    : true,
                    maxLength   : item.max,
                    onValueChanged(e){
                        if(item.method){
                            item.method(e);
                        }
                    }
                }).dxTextBox('instance');
                break;
            case 'datetime':
                item.box = $("." + classNm + "_" + item.column).dxDateBox({
                    width               : item.width,
                    stylingMode         : 'outlined',
                    height              : 30,
                    type                : item.type,
                    readOnly            : item.readOnly,
                    displayFormat       : item.displayFormat,
                    value               : item.value,
                    disabled            : true,
                    invalidDateMessage  : '형식에 맞게 입력해주세요',
                }).dxDateBox('instance');
                break;
            case 'select':
                item.box = $("." + classNm + "_" + item.column).dxSelectBox({
                    width          : item.width,
                    stylingMode    : 'outlined',
                    height         : 30,
                    readOnly       : item.readOnly,
                    items          : item.items,
                    displayExpr    : 'desc',
                    valueExpr      : 'code',
                    disabled       : true,

                }).dxSelectBox('instance')

                //if(item.items.length > 0) item.box.option('value',item.items[0].code);
                if(item.method)item.box.on('itemClick',()=>{
                    item.method();
                })
                break;
            case 'number':
                item.box = $("." + classNm + "_" + item.column).dxNumberBox({
                    stylingMode     : 'outlined',
                    showSpinButtons : true,
                    readOnly        : item.readOnly,
                    width           : item.width,
                    mode            : "text",
                    height          : 30,
                    disabled        : true,
                    min             : 0,
                    max             : 99999,
                }).dxNumberBox('instance');
                item.box.on('valueChanged',(e)=>{
                    if(e.value === null) setValue(e.component,'0')
                })
                break;
            case 'check':
                item.box = $("." + classNm + "_" + item.column).dxCheckBox({
                    stylingMode     : 'outlined',
                    text            : item.text,
                    readOnly        : item.readOnly,
                    disabled        : true,
                    onValueChanged(){
                        if(item.method){
                            item.method();
                        }
                    }
                }).dxCheckBox('instance');

                break;
            default:
                break;
        }
    })
}

function historySearchBtnClick() {
    if (!validationCheck(historyStrtDt.box, historyEndDt.box, historyStrtTime.box, historyEndTime.box)) {
        return false;
    }
    let FROM_DT = getDate(getValue(historyStrtDt.box), getValue(historyStrtTime.box)).substring(0,10);
    let TO_DT = getDate(getValue(historyEndDt.box), getValue(historyEndTime.box)).substring(0,10);
    let searchData = {};
    searchData['FROM_DT'] = FROM_DT;
    searchData['TO_DT'] = TO_DT;
    fetchFormatData('', [endIncdTable], searchData);
}

function setDetailCd( detailCdData, detailCdBox, cdBox, uri){
    detailCdData = [];
    detailCdData = getCodeData(detailCdData, '/' + uri + '/' + encodeURIComponent(getValue(cdBox.box)));
    detailCdBox.box.option('items', detailCdData);
    //if(detailCdData.length > 0) setValue(detailCdBox.box, detailCdData[0].code);
    return detailCdData;
}


function fetchFormatData(uri, table, param){
    getDataAsync(commonUri + uri, (jsonData)=>{
        if (jsonData.length > 0) {
            jsonData.map((item)=>{
                for(idx in dateColumns) {
                    if(item[dateColumns[idx]])item[dateColumns[idx]] = new Date(getParseDateTime(item[dateColumns[idx]]));
                }
            });
        }
        for (let idx in table){
            table[idx].dxDataGrid('instance').option('dataSource', jsonData);
        }
    }, null, param);
};

function toggleInit(){
    toggleArr.map((item)=>{
        item.box.option('icon','chevrondown');
        $('.' + item.formNm + '-form').removeClass('dpl-none');
        $('.' + item.formNm + '-incd-form').removeClass(item.formToggle);
        $('.incident-tabs').removeClass(item.tabToggle);
    })
}

/**
 * 입력정보 보이기/감추기 버튼 세팅
 * @param {*} frontNm 토글 버튼 이름
 * @param {*} formToggle 폼 토글
 * @param {*} tabToggle 탭 토글
 * @returns
 */
function setToggleBtn( frontNm, formToggle, tabToggle){
    let toggleBtn = $('.' + frontNm + '-toggle-btn').dxButton({
        icon        : 'chevrondown',
        stylingMode : 'text',
        onClick(e){
            let icon = e.component.option('icon') === 'chevrondown'? 'chevronup':'chevrondown';
            e.component.option( 'icon', icon );
            $('.' + frontNm + '-incd-form').toggleClass(formToggle);
            $('.' + frontNm + '-form').toggleClass('dpl-none');
            $('.incident-tabs').toggleClass(tabToggle);
        }
    }).dxButton('instance');
    return toggleBtn
}

/**
 * 탭 클릭 시 목록명 변경 및 테이블 클릭 상태 변경
 * @param {*} container
 * @param {*} div
 * @param {*} num
 * @param {*} showTb
 * @param {*} hideTb
 */
function tabEvent( container, div, num, showTb, hideTb){
    container.children().eq(0).children().eq(num).on('click',function(){
        div.html($(this).text() + '목록&nbsp; (목록에서 더블클릭으로 돌발정보 선택)');
        $(this).addClass('selected-tabs');
        if(num === 0){
            $(this).next().removeClass('selected-tabs');
            setBtnEvent(getInstance(newIncdTable));
        }
        else{
            $(this).prev().removeClass('selected-tabs');
            setBtnEvent(getInstance(autoIncdTable));
        }
        showTb.dxDataGrid('instance').clearSelection();
        showTb.dxDataGrid('instance').option('focusedRowIndex', -1);
        showBtn(showTb.dxDataGrid('instance'));
        hideBtn(hideTb.dxDataGrid('instance'));
    })
}

/**
 * 발생 차로 차단 차로 값 체크 박스 세팅 함수
 * @param laneData 차로 데이터
 * @param laneArr  체크박스 배열
 */
function setLaneVal(laneData, laneArr){
    if(laneData !== null && !isNaN(laneData)){
        const lane = laneData.split('');
        for(let idx in lane){
            const value = lane[idx] === '1' ? true : false;
            laneArr[idx].box.option('value', value);
        }
    }
}

/**
 * 위치보기 이벤트
 * @param {*} linkId 링크 아이디
 */
function lookLocation(linkId){
    try {
        window.opener.selectLink(linkId);
    } catch (err) {
        console.error(err);
    }
}

function sendDateFormat(data){
    for(let idx in dateColumns) {
        if(data[dateColumns[idx]]) data[dateColumns[idx]] = getSendDate(data[dateColumns[idx]]);
    }
    return data;
}

function missEvent(table, array) {
    let selectedData = table.getSelectedRowsData();

    if (selectedData <= 0) return notSelectMsg('돌발정보');
    const id = selectedData[0].incd_ocrr_id;
    const result = postInsertUpdate(commonUri + '/mis-info/' + encodeURIComponent(id))

    if (result > 0 ) {
        insResultMsg('오보 판정');
        fetchBaseData();
    }

    if(array){
        eventOff(array);
    }
}

function setBtnEvent(table, array){
    refreshBtn.box.off('click');
    refreshBtn.box.on('click', () => {
        eventOff(array);
        table.clearSelection();
    });

    // locationBtn.box.off('click');
    // locationBtn.box.on('click', () => lookLocation(table));

    missBtn.box.off('click');
    missBtn.box.on('click', () => missEvent(table, array));
}

function rowClickEvent(type){
    btnArr.map((item)=>{
        if(item[type].visible){
            dsblOffBtn(item.box);
        }
    });
}

function getCheckData(box){
    return getValue(box)?'Y':'N';
}

function getLaneVal(array){
    let value = '';
    array.map((item)=>{
        let result = getValue(item.box) ? '1':'0'
        value += result;
    })
    return value;
}

function getParams(){
    const id = getValue(prcdLinkId.box)
    const xCrdn = getValue(prcdXcrdn.box)
    const yCrdn = getValue(prcdYcrdn.box)
    getParam.LinkInfo = [];
    getParam.LinkInfo.push({
        link_color : 1,
        id : id,
        coordX : xCrdn,
        coordY : yCrdn,
    });
    return getParam;
}

function inserLinkText(popupData){
    setValue(prcdLinkId.box, popupData[0].id);
    setValue(prcdXcrdn.box, popupData[0].coordX);
    setValue(prcdYcrdn.box, popupData[0].coordY);
}


function crdnChanges(text, num){
    let value = text.value;
    const textBox = text.component
    if(value === null  || isNaN(value)) return setValue(textBox, '0.0000000');

    value = value.toString();

    if(value.length <= num) return setValue(textBox, value + ".0000000");

    if (!value.includes(".")){
        let front = value.substr(0, num);
        let end = value.substr(num, value.length);
        let zero = "";
        if (end.length < 7) {
            for (let ii = 0; ii < 7 - end.length; ii++) {
                zero += "0";
            }
        }
        if (end.length > 7) end = end.substring(0, 7);
        setValue(textBox, front + "." + end + zero);
    }
    else{
        switch (true) {
            case value.substring(0, value.indexOf(".")) === "":
                setValue(textBox, "0" + value);
                break;
            case value.substring(value.indexOf("."), value.length) === "":
                setValue(textBox, value + "0000000");
                break;
            case value.substring(value.indexOf("."), value.length).length < 7:
                let zero = "";
                for (let ii = 0; ii < 7 - value.substring(value.indexOf(".") + 1, value.length).length; ii++) {
                    zero += "0";
                }
                setValue(textBox, value.substring(0, value.indexOf(".")) + value.substring(value.indexOf("."), value.length) + zero);
                break;

            default:
                break;
        }
    }

}

function newDataInit() {
    newInputArr.map((item)=>{
        setValue(item.box, null);
    });

    //id 조회 필요
    let newId =[];
    getData('/api/manage/incident/new-id', newId);
    setValue(newIncdOccrId.box, newId[0].incd_ocrr_id)
    setValue(newRgstDt.box, new Date());
    setValue(newIncdCnfmDt.box, new Date());
    setValue(newIncdStrtDt.box, new Date());
}

function setLookLocation(link_id){
    let val      = "";
    let linkData = [];
    getData('/api/database/link/' + encodeURIComponent(link_id), linkData );
    if (linkData[0]) {
        val = '[' + linkData[0].link_id + '] ' + linkData[0].from_node + ' > ' + linkData[0].to_node;
        locationBtn.box.off('click');
        locationBtn.box.on('click', ()=>lookLocation(link_id));
    }
    else {
        locationBtn.box.off('click');
        locationBtn.box.on('click', ()=>{
            return alertWarning('링크 ID : ' + link_id + '<br>해당 링크의 위치를 찾을 수 없습니다.');
        });
    }
    return val;
}

function getTrafficMap(){
    return _trafficMap;
}