let facilityData     = [];
let updatedData      = [];
let failPairTable    = null;
let listTable        = null;
let failHsTable      = [];
let failHsData       = [];
let failPairData     = [];
let failListBtn      = null;
let hsAddBtn         = null;
let hsDelBtn         = null;
let hsEditBtn        = null;
let hsCancelBtn      = null;
let hsApplyBtn       = null;
let pairAddBtn       = null;
let pairApplyBtn     = null;
let pairDelBtn       = null;
let pairCancelBtn    = null;
let pairEditBtn      = null;

const commonUri      = '/api/facility';
const _pageName      = '시설물 장애관리';
const pariUri        = '/fail-pair'
const pairMsg        = '장애 조치 내역'
const hsUri          = '/fail-hs'
const hsMsg          = '장애 내역'

let failTypeData     = [];
let pairUpdatedData  = [];
let pairDelData      = null;
let hsDelData        = null;
let hsUpdatedData    = [];

const _userId        = window.opener.$userId;

//장애 내역 버튼 배열
const failHsBtnArr =[
    hsAddBtn = {
        class        : 'hs-add-btn',
        box          : null,
        stylingMode  : 'outlined',
        icon         : 'plus',
        text         : '추가',
        edit         : {
            visible  : true,
            disabled : false
        },
        add          : {
            visible  : true,
            disabled : true,
        },
        cancel       : {
            visible  : true,
            disabled : true,
        },
        del          : {
            visible  : true,
            disabled : true,
        },
        method       : function(){
            hsAddBtnClick();
        },
    },
    hsDelBtn = {
        class        : 'hs-del-btn',
        box          : null,
        icon         : 'minus',
        stylingMode  : 'outlined',
        text         : '삭제',
        edit         : {
            visible  : true,
            disabled : false
        },
        add          : {
            visible  : true,
            disabled : true
        },
        cancel       : {
            visible  : true,
            disabled : true,
        },
        del          : {
            visible  : true,
            disabled : true,
        },

        method       : function() {
            hsDelBtnClick();
        },
    },
    hsEditBtn = {
        class        : 'hs-edit-btn',
        box          : null,
        stylingMode  : 'outlined',
        text         : '편집',
        icon         : 'edit',
        edit         : {
            visible  : false,
            disabled : false
        },
        add          : {
            visible  : false,
            disabled : false
        },
        cancel       : {
            visible  : true,
            disabled : false,
        },
        del          : {
            visible  : false,
            disabled : false,
        },
        method       : function(){
            hsEditBtnClick();
        },
    },
    hsCancelBtn = {
        class        : 'hs-edit-cancel-btn',
        box          : null,
        stylingMode  : 'outlined',
        icon         : 'close',
        text         : '취소',
        edit         : {
            visible  : true,
            disabled : false
        },
        add          : {
            visible  : true,
            disabled : false
        },
        cancel       : {
            visible  : false,
            disabled : false,
        },
        del          : {
            visible  : true,
            disabled : false,
        },
        method       : function(){
            //편집 취소
            eventOff( failHsTable, failHsBtnArr, failPairTable );
        },
    },
    hsApplyBtn = {
        class        : 'hs-apply-btn',
        box          : null,
        stylingMode  : 'outlined',
        icon         : 'save',
        text         : '적용',
        edit         : {
            visible  : true,
            disabled : false
        },
        add          : {
            visible  : true,
            disabled : false
        },
        cancel       : {
            visible  : true,
            disabled : true,
        },
        del          : {
            visible  : true,
            disabled : false,
        },
    },
];

//장애 조치 내역 버튼 배열
const failPairBtnArr =[
    pairAddBtn = {
        class        : 'pair-add-btn',
        box          : null,
        stylingMode  : 'outlined',
        icon         : 'plus',
        text         : '추가',
        edit         : {
            visible  : true,
            disabled : false
        },
        add          : {
            visible  : true,
            disabled : true,
        },
        cancel       : {
            visible  : true,
            disabled : true,
        },
        del          : {
            visible  : true,
            disabled : true,
        },
        method       : function(){
            pairAddBtnClick();
        },
    },
    pairDelBtn = {
        class        : 'pair-del-btn',
        box          : null,
        stylingMode  : 'outlined',
        icon         : 'minus',
        text         : '삭제',
        edit         : {
            visible  : true,
            disabled : false
        },
        add          : {
            visible  : true,
            disabled : true
        },
        cancel       : {
            visible  : true,
            disabled : true,
        },
        del          : {
            visible  : true,
            disabled : true,
        },
        method       : function (){
            pairDelBtnClick();
        },
    },
    pairEditBtn = {
        class        : 'pair-edit-btn',
        box          : null,
        stylingMode  : 'outlined',
        text         : '편집',
        icon         : 'edit',
        edit         : {
            visible  : false,
            disabled : false
        },
        add          : {
            visible  : false,
            disabled : false
        },
        cancel       : {
            visible  : true,
            disabled : false,
        },
        del          : {
            visible  : false,
            disabled : false,
        },
        method       : function (){
            pairEditBtnClick();
        },
    },
    pairCancelBtn = {
        class        : 'pair-edit-cancel-btn',
        box          : null,
        stylingMode  : 'outlined',
        text         : '취소',
        icon         : 'close',
        edit         : {
            visible  : true,
            disabled : false
        },
        add          : {
            visible  : true,
            disabled : false
        },
        cancel       : {
            visible  : false,
            disabled : false,
        },
        del          : {
            visible  : true,
            disabled : false,
        },
        method       : function(){
            eventOff( failPairTable, failPairBtnArr, failHsTable );
        },
    },
    pairApplyBtn = {
        class        : 'pair-apply-btn',
        box          : null,
        stylingMode  : 'outlined',
        text         : '적용',
        icon         : 'save',
        edit         : {
            visible  : true,
            disabled : false
        },
        add          : {
            visible  : true,
            disabled : false
        },
        cancel       : {
            visible  : true,
            disabled : true,
        },
        del          : {
            visible  : true,
            disabled : false,
        },
    },
];

$(()=>{

    //상단 장애내역조회
    failListBtn = $('.fail-hs-list-btn').dxButton({
        stylingMode:'outlined',
        text:'장애내역조회',
        icon:'refresh',
        height:'30px',
        width: '140px',
        onClick(){
            failListBtnClick();
        }
    }).dxButton('instance');

    //상단 조회 버튼
    searchBtn = $('.search-button').dxButton({
        stylingMode:'outlined',
        text:'조회',
        icon:'refresh',
        height:'30px',
        width: '80px',
        onClick(){
            fetchBaseData();
        }
    }).dxButton('instance');

    //상단 닫기 버튼
    $('.cancel-button').dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton('instance');

    //버튼 배열 화면 세팅
    btnSettings(failHsBtnArr);

    btnSettings(failPairBtnArr);

    //좌측 등록 시설물 테이블
    listTable = $('.facility-infr-table').width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'fclt_id',
        selection: {
            mode : 'single',
        },
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible : true,
        },
        grouping: {
            autoExpandAll : true,
        },
        scrolling: {
            mode : 'virtual',
        },
        groupPanel:{
            visible         : true,
            emptyPanelText  : '그룹 지을 항목을 여기에 끌어다 놓으세요'
        },
        export:{
            enabled : true,
            texts   : {
                exportAll :'엑셀 파일',
            },
        },
        onExporting(e){
            gridExcellExporting(e, _pageName + '_등록시설물');
        },
        columns:[
            {
                dataField    : 'fclt_type',
                caption      : '유형',
                allowEditing : false,
                alignment    : 'center',
            },
            {
                dataField    : 'fclt_id',
                caption      : '시설물 ID',
                alignment    : 'center',
                allowEditing : false,
                sortOrder    : 'asc',
                sortIndex    : 0,

            },
            {
                dataField    : 'fclt_lctn',
                caption      : '시설물 위치',
                alignment    : 'center',
                allowEditing : false,
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    return  c.text(nullChecker(e.displayValue));
                }
            },
        ],
        onRowClick(info){
            listTableClick(info);
        },
    }).dxDataGrid('instance');

    //장애 내역 테이블
    failHsTable = $('.fail-hs-table').width('100%').height('100%').dxDataGrid({
        dataSource              : [],
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : ['ocrr_dt','fail_hs_seq'],
        selection: {
            mode                 : 'single',
            showCheckBoxesMode   : 'onClick'
        },
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible : true,
        },
        grouping: {
            autoExpandAll : true,
        },
        scrolling: {
            mode : 'virtual',
        },
        groupPanel:{
            visible         : true,
            emptyPanelText  : '그룹 지을 항목을 여기에 끌어다 놓으세요'
        },
        export:{
            enabled : true,
            texts   : {
                exportAll :'엑셀 파일',
            },
        },
        onExporting(e){
            gridExcellExporting(e, _pageName + '_' + hsMsg);
        },
        columns:[
            {
                dataField    : 'fail_hs_seq',
                caption      : '장애일련번호',
                alignment    : 'center',
                allowEditing : false,
                sortOrder    : 'asc',
                sortIndex    : 0,
            },
            {
                dataField    : 'ocrr_dt',
                caption      : '발생일시',
                alignment    : 'center',
                dataType     : 'datetime',
                format       : 'yyyy-MM-dd HH:mm:ss'
            },
            {
                dataField   : 'rcpr_nm',
                caption     : '접수자명',
                alignment   : 'center',
                editorOptions :{
                    dataType : 'string',
                    maxLength : 30,
                }
            },
            {
                dataField   : 'fail_type',
                caption     : '장애 유형',
                alignment   : 'center',
                lookup      : {
                    dataSource  : [],
                    valueExpr   : 'fail_type',
                    displayExpr : 'fail_desc'
                }
            },
            {
                dataField   : 'fail_cont',
                caption     : '장애 내용',
                alignment   : 'center',
                editorOptions :{
                    dataType : 'string',
                    maxLength : 600,
                }
            },
        ],
        onContentReady(e) {
            if (!e.component.getSelectedRowKeys().length) {
                e.component.selectRowsByIndexes(0);
                e.component.option('focusedRowIndex', 0);
            }
        },
        onRowClick(e){
            failPairData = [];
            getData(commonUri + pariUri + '/' + encodeURIComponent(e.data.fail_hs_seq), failPairData);
            if( failPairData[0].length > 0 ){
                failPairData[0].map((item)=>{
                    if(item)tableDateFormat(item)
                })
            }
            failPairTable.option('dataSource', failPairData[0]);
        },
        onSelectionChanged(e){
            let delData = [];
            e.selectedRowsData.map((item)=>{
                delData.push(item.fail_hs_seq)
            })
            hsDelData = delData;
        }
    }).dxDataGrid('instance');

    //장애 조치 내역 테이블
    failPairTable = $('.fail-pair-table').width('100%').height('100%').dxDataGrid({
        dataSource              : [],
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : ['crtn_dt','fail_hs_seq'],
        selection: {
            mode                 : 'single',
            showCheckBoxesMode   : 'onClick'
        },
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible : true,
        },
        grouping: {
            autoExpandAll : true,
        },
        scrolling: {
            mode : 'virtual',
        },
        groupPanel:{
            visible         : true,
            emptyPanelText  : '그룹 지을 항목을 여기에 끌어다 놓으세요'
        },
        export:{
            enabled : true,
            texts   : {
                exportAll :'엑셀 파일',
            },
        },
        onExporting(e){
            gridExcellExporting(e, _pageName + '_' + pairMsg);
        },
        columns:[
            {
                dataField    : 'crtn_dt',
                caption      : '생성일시',
                alignment    : 'center',
                sortOrder    : 'asc',
                sortIndex    : 0,
                allowEditing : false,
                dataType     : 'datetime',
                format       : 'yyyy-MM-dd HH:mm:ss'
            },
            {
                dataField    : 'fail_hs_seq',
                caption      : '장애일련번호',
                alignment    : 'center',
                allowEditing : false,
            },
            {
                dataField    : 'wrkr_nm',
                caption      : '작업자명',
                alignment    : 'center',
                editorOptions :{
                    dataType : 'string',
                    maxLength : 30,
                }
            },
            {
                dataField    : 'work_cont',
                caption      : '작업내용',
                alignment    : 'center',
                editorOptions :{
                    dataType : 'string',
                    maxLength : 600,
                }
            },
            {
                dataField    : 'work_strt_dt',
                caption      : '작업 시작일시',
                alignment    : 'center',
                dataType     : 'datetime',
                format       : 'yyyy-MM-dd HH:mm:ss'
            },
            {
                dataField    : 'work_end_dt',
                caption      : '작업 종료일시',
                alignment    : 'center',
                dataType     : 'datetime',
                format       : 'yyyy-MM-dd HH:mm:ss'
            },
            {
                dataField    : 'work_fins_yn',
                caption      : '작업완료여부',
                alignment    : 'center',
                width        : 170,
                lookup       : {
                    dataSource: ['Y','N'],
                }
            },
        ],
        onContentReady(e) {
            if (!e.component.getSelectedRowKeys().length) {
                e.component.selectRowsByIndexes(0);
                e.component.option('focusedRowIndex', 0);
            }
        },
        onSelectionChanged(e){
            let delData = [];
            e.selectedRowsData.map((item)=>{
                delData.push({
                    crtndt    : item.crtn_dt,
                    failhsseq : item.fail_hs_seq
                })
            })
            pairDelData = delData;
        }
    }).dxDataGrid('instance');

    fetchBaseData();
    fetchTypeData();
})

function fetchTypeData(){
    getDataAsync( commonUri + '/fail-hs/fail-type', recvTypeFunc);
}

function recvTypeFunc(jsonData){
    failTypeData = jsonData;
    failHsTable.option('columns[3].lookup.dataSource', failTypeData);
}

//장애 조치 내역 추가 버튼 클릭 함수
function pairAddBtnClick(){
    const tableData = failHsTable.getSelectedRowsData();
    let addData     = [];
    addData['fail_hs_seq']  = tableData[0].fail_hs_seq;
    addData['crtn_dt']      = new Date();
    //추후 로그인 값으로 변경 예정
    addData['wrkr_nm']      = _userId;
    addData['chng_nm']      = _userId;
    addData['adtn_nm']      = _userId;

    addData['work_strt_dt'] = new Date();
    addData['work_end_dt']  = new Date();
    addData['chng_dt']      = new Date();
    addData['work_cont']    = '';
    addData['work_fins_yn'] = 'N';

    addRowEvent(failPairTable, failPairBtnArr, addData);
    pairApplyBtn.box.off('click');
    pairApplyBtn.box.on('click', () => {
        editEvent(
            failPairTable,
            pariUri,
            failPairBtnArr,
            failHsTable.getSelectedRowsData()[0].fail_hs_seq,
            pairMsg
        );
    });
}

//장애 조치 내역 편집 버튼 클릭 함수
function pairEditBtnClick(){
    eventOn( failPairTable, failPairBtnArr, failHsTable, hsEditBtn );

    if (failPairTable.option('dataSource').length <= 0) dsblOnBtn(pairDelBtn.box);

    pairApplyBtn.box.off('click');
    pairApplyBtn.box.on('click', () => {
        editEvent(
            failPairTable,
            pariUri,
            failPairBtnArr,
            failHsTable.getSelectedRowsData()[0].fail_hs_seq,
            pairMsg
        );
    });
}

//장애 조치 내역 삭제 버튼 클릭 함수
function pairDelBtnClick() {
    btnEvent(failPairBtnArr, 'del');

    failPairTable.option('selection', {
        mode: 'multiple'
    });

    failPairTable.option('editing', {
        allowUpdating: false,
    });

    pairApplyBtn.box.off('click');

    pairApplyBtn.box.on('click', () => {
        delEvent(failPairTable, pairDelData, pariUri, '장애 조치',
            failHsTable.getSelectedRowsData()[0].fail_hs_seq, failPairData,
            failPairBtnArr);
    })
}

//상단 장애내역 조회 버튼 클릭 함수
function failListBtnClick(){
    let name   = '시설물 장애내역';
    let page   =  './fail-hs-pop-up.html';
    let option = 'width = 1000, height = 800, top = 100, left = 400, resizable=yes, scrollbars=no';
    window.open(page, name, option);
}

//장애 내역 추가 함수
function hsAddBtnClick(){
    let seq     = [];
    let addData = [];

    //추가 될 데이터 세팅
    getData(commonUri + '/fail-hs/new-hs-seq', seq);
    addData['fail_hs_seq'] = seq[0];
    addData['ocrr_dt']     = new Date();
    addData['adtn_dt']     = new Date();
    addData['chng_dt']     = new Date();
    addData['rcpr_nm']     = _userId;
    addData['adtn_nm']     = _userId;
    addData['chng_nm']     = _userId;

    addData['fail_cont']     = "";
    addData['fclt_id']     = listTable.getSelectedRowsData()[0].fclt_id;
    addData['fail_type']   = failTypeData[0].fail_type;
    addRowEvent(failHsTable, failHsBtnArr, addData);

    //버튼 이벤트 변경
    hsApplyBtn.box.off('click');
    hsApplyBtn.box.on('click',()=>{
        editEvent(
            failHsTable,
            hsUri,
            failHsBtnArr,
            listTable.getSelectedRowsData()[0].fclt_id,
            hsMsg
        );
    });
}

//장애 내역 편집 버튼 클릭 함수
function hsEditBtnClick(){
    //편집 이벤트 시작
    eventOn( failHsTable, failHsBtnArr, failPairTable, pairEditBtn );

    //장애 내역 데이터가 없을 시 삭제 버튼 막기
    if (failHsTable.option('dataSource').length <= 0) dsblOnBtn(hsDelBtn.box)

    //적용 버튼 변경
    hsApplyBtn.box.off('click');
    hsApplyBtn.box.on('click',()=>{
        editEvent(
            failHsTable,
            hsUri,
            failHsBtnArr,
            listTable.getSelectedRowsData()[0].fclt_id,
            hsMsg
        );
    });
}

//장애 내역 삭제 버튼 클릭 함수
function hsDelBtnClick(){
    //삭제 버튼 클릭 시 버튼 활성화
    btnEvent( failHsBtnArr, 'del' );
    //다중 선택 변경
    failHsTable.option('selection',{
        mode:'multiple'
    });
    //수정 중단
    failHsTable.option('editing',{
        allowUpdating : false,
    });
    //적용 클릭 이벤트 변경
    hsApplyBtn.box.off('click');
    hsApplyBtn.box.on('click',()=>{
        delEvent( failHsTable, hsDelData, hsUri, hsMsg,
            listTable.getSelectedRowsData()[0].fclt_id,
            failHsData, failHsBtnArr );
    });
}

//상단 조회 버튼 클릭 함수
function fetchBaseData() {
    getDataAsync(commonUri + '/manager/info', fetchListData);
    failHsTable.option('dataSource', []);
    failPairTable.option('dataSource', []);
    dsblOnBtn(pairEditBtn.box);
    dsblOnBtn(hsEditBtn.box);
    listTable.clearSelection();
    listTable.option('focusedRowIndex', -1);
};
function fetchListData(jsonData){
    facilityData = jsonData
    listTable.option('dataSource', facilityData);
}

//좌측 리스트 테이블 클릭
function listTableClick(info) {
    btnEvent(failHsBtnArr, 'cancel');
    btnInit(failPairBtnArr);
    fetchRightLists();
}

//편집 시작
function eventOn(table, array, dsblTable, dsblBtn){
    dsblOnBtn(listTable);
    dsblOnBtn(dsblTable);
    dsblOnBtn(dsblBtn.box);

    table.option('editing',{
        mode                    : 'batch',
        allowUpdating           : true,
        selectTextOnEditStart   : true,
    })

    btnEvent( array, 'edit' );

}

//편집 종료
function eventOff(table, array, dsblTable){
    if ( table.hasEditData() || ( table.option('selection.mode') === 'multiple' &&  table.getSelectedRowsData().length > 0 )){
        confirmMessage('변경 하신 데이터가 있습니다. 취소 하시겠습니까?').done((yes)=>{
            if ( yes === true ){
                resetState(table, array, dsblTable)
            }
        })
    }
    else {
        resetState(table, array, dsblTable)
    }
}

function resetState(table, array, dsblTable){
    table.option('editing',{
        allowUpdating : false,
    });

    table.option('selection',{
        mode : 'single'
    })

    btnEvent( array, 'cancel' );

    dsblOffBtn(listTable);
    dsblOffBtn(dsblTable);
    dsblOffBtn(hsEditBtn.box);
    if (failHsTable.option('dataSource').length > 0) dsblOffBtn(pairEditBtn.box);
}

//테이블 로우 추가 기능
function addRowEvent(table, array, data ){
    btnEvent( array, 'add' );

    table.addRow();

    table.option('editing.changes',[{
        key  : table.option('editing.editRowKey'),
        data : data,
        type : "insert",
    }]);
}

//데이터에 맞게 시간 포맷
function updateDateFormat(data){
    if(data.ocrr_dt)data.ocrr_dt = getSendDate(data.ocrr_dt);
    if(data.crtn_dt)data.crtn_dt = getSendDate(data.crtn_dt);
    if(data.adtn_dt)data.adtn_dt = getSendDate(data.adtn_dt);
    if(data.chng_dt)data.chng_dt = getSendDate(data.chng_dt);
    if(data.work_strt_dt)data.work_strt_dt = getSendDate(data.work_strt_dt);
    if(data.work_end_dt)data.work_end_dt = getSendDate(data.work_end_dt);
    if(data.crtndt)data.crtndt = getSendDate(data.crtndt);
}

//테이블에 맞게 시각 포맷
function tableDateFormat(data){
    if(data.ocrr_dt)data.ocrr_dt = new Date(getParseDateTime(data.ocrr_dt));
    if(data.crtn_dt)data.crtn_dt = new Date(getParseDateTime(data.crtn_dt));
    if(data.adtn_dt)data.adtn_dt = new Date(getParseDateTime(data.adtn_dt));
    if(data.chng_dt)data.chng_dt = new Date(getParseDateTime(data.chng_dt));
    if(data.work_strt_dt)data.work_strt_dt = new Date(getParseDateTime(data.work_strt_dt));
    if(data.work_end_dt)data.work_end_dt = new Date(getParseDateTime(data.work_end_dt));
}

//테이블에 데이터 세팅
function tbDataSet(table, uri){
    getDataAsync(uri, (jsonData)=>{
        let listData = jsonData;
        if (listData.length > 0){
            listData.map((item)=>{
                tableDateFormat(item)
            });
        }
        table.option('dataSource', listData);
    });
}

//화면에 버튼 세팅
function btnSettings(array){
    array.map((item)=>{
        item.box = $('.' + item.class).dxButton({
            stylingMode : item.stylingMode,
            text        : item.text,
            icon        : item.icon,
            visible     : item.cancel.visible,
            disabled    : true,
            onClick(){
                if(item.method){
                    item.method();
                }
            }
        }).dxButton('instance');
    })
}

//버튼 유형에 따라 활성화 / 비활성화 이벤트
function btnEvent( array, type ){
    array.map((item) => {
        item.box.option('visible',item[type].visible);
        item.box.option('disabled',item[type].disabled);
    })
}

//버튼 비활성화
function btnInit( array ){
    array.map((item) => {
        item.box.option('visible', item['cancel'].visible);
        dsblOnBtn(item.box);
    })
}

//편집 또는 추가 후 적용 시 이벤트
function editEvent(table, uri, btnArr, id, str){
    let result = 0;
    let editArr = table.option('editing.changes');
    let updateData = [];

    if (!table.hasEditData()){
        return alertWarning('변경 된 ' + str + '이 없습니다.');
    }

    editArr.map((item)=>{
        table.byKey(item.key).done((obj)=>{
            let updateObj = {...obj}
            updateObj.chng_dt = new Date();
            updateObj.chng_nm = _userId;
            updateData.push(updateObj);
        });
    });


    if (uri === hsUri) {
        for (let obj of updateData) {
            const msg = '장애일련번호 : '+ obj.fail_hs_seq
            if (!datetimeCheck(obj.ocrr_dt, msg, '발생일시')) {
                return false;
            }
            else if (!validation(obj.rcpr_nm, '접수자명', msg, 30 )) {
                return false;
            }
            else if (!validation(obj.fail_cont, '장애 내용', msg, 600)) {
                return false;
            }
            else {
                updateDateFormat(obj);
            }
        }
    }
    else {
        for (let obj of updateData) {
            const msg = '생성일시 : ' + dateTimeFormmater(obj.crtn_dt);
            if (!validation(obj.wrkr_nm, '작업자명', msg, 30)) {
                return false;
            }
            else if (!validation(obj.work_cont, '작업 내용', msg, 600)) {
                return false;
            }
            else if (!datetimeCheck(obj.work_strt_dt, msg, '작업 시작일시')) {
                return false;
            }
            else if (!datetimeCheck(obj.work_end_dt, msg, '작업 종료일시')) {
                return false;
            }
            else if (!datetimeCheck(obj.work_end_dt, msg, '작업 종료일시')) {
                return false;
            }
            else {
                updateDateFormat(obj);
            }
        }
    }
    result = postInsertUpdate( commonUri + uri, updateData);

    if ( result > 0 ) {

        insResultMsg( str );
        btnEvent( btnArr, 'cancel' );

        dsblOffBtn(listTable);
        dsblOffBtn(failPairTable);
        dsblOffBtn(failHsTable);
        tbDataSet(table, commonUri + uri + '/' + encodeURIComponent(id));
        dsblOffBtn(pairEditBtn.box);
        dsblOffBtn(hsEditBtn.box);
        if (table === failHsTable) {
            const selectedRowData = failHsTable.getSelectedRowsData()[0];
            if (selectedRowData) {
                tbDataSet(failPairTable, commonUri + pariUri + '/' + encodeURIComponent(selectedRowData.fail_hs_seq));
            }
        }

        table.option('editing',{
            allowUpdating : false,
        });
    }
}

//삭제 적용 이벤트
function delEvent( table, delData, uri, str, id, tableData, btnArr ){

    // 삭제 선택 데이터가 있는지 체크
    if ( delData === null ) {
        return alertWarning('선택하신 ' + str + '이 없습니다. ' + str + ' 내역을 선택해 주세요')
    }

    //날짜 형식 문자로 변환
    delData.map((item)=>{
        updateDateFormat(item);
    })

    //삭제 데이터 전송
    let result = deleteDataIds( commonUri + uri, delData );

    //삭제 됐을 시
    if (result > 0) {

        //삭제 메시지
        delResultMsg(str);

        //선택 모드 싱글 변환
        table.option('selection',{
            mode : 'single'
        })

        //테이블 및 버튼 활성화/비활성화
        btnEvent( btnArr, 'cancel' );
        dsblOffBtn(listTable);
        dsblOffBtn(failHsTable);
        dsblOffBtn(failPairTable);
        dsblOffBtn(hsEditBtn.box);

        failHsData = [];
        //선택 된 리스트의 장애내역 조회

        //테이블 종류에 따라 다르게 데이터 처리
        if (table === failHsTable) {
            fetchRightLists();
        }
        else if(table === failPairTable) {
            //장애 내역 선택 된 데이터로 다시 조회
            const failHsSeq = failHsTable.getSelectedRowsData()[0].fail_hs_seq;
            tbDataSet(failPairTable, commonUri + pariUri + '/' + encodeURIComponent(failHsSeq));
        }
    }
}

function fetchRightLists() {
    let uri = commonUri + hsUri + '/' + encodeURIComponent(listTable.getSelectedRowsData()[0].fclt_id);
    getDataAsync(uri, (jsonData) =>{
        let listData = jsonData;
        if (listData.length > 0){
            listData.map((item)=>{
                tableDateFormat(item)
            });
        }
        failHsTable.option('dataSource', listData);
        //장애 내역 데이터가 있을 때
        failHsTable.refresh().done(() => {
            if (listData.length > 0) {
                //선택 된 데이터가 지워졌으니 첫번째 값으로 테이블 데이터 세팅
                failHsTable.selectRowsByIndexes(0);
                failHsTable.option('focusedRowIndex', 0);
                const failHsSeq = failHsTable.cellValue(0, "fail_hs_seq");
                tbDataSet(failPairTable, commonUri + pariUri + '/' + encodeURIComponent(failHsSeq));
                dsblOffBtn(pairEditBtn.box);
            }
            else {
                failPairTable.option('dataSource', []);
            }
        });
    }, null, null, true);
}

function validation(value, text, id, byte) {
    if (nullChecker(value) === '') {
        alertWarning( id + '<br>'+ text + '을 입력해주세요');
        return false;
    }
    else if (getByteLength(value) > byte) {
        alertWarning( id + '<br>'+ text + '을 '+byte+' 바이트 이내로 입력해주세요');
        return false;
    }
    else {
        return true;
    }
}

function datetimeCheck(date, id, column){
    if (
        nullChecker(date) === "" ||
        !date instanceof Date ||
        date.getFullYear() < 1000 ||
        date.getFullYear() >= 10000
    ) {
        alertWarning( id + '<br>' + column + ' 값이 없거나 형식에 맞지않습니다.');
        return false;
    }
    else {
        return true;
    }
}
