//우측 섹션 관련
let ptrnData       = [];
let ptrnTable      = null;
let ptrnChart      = null;

//좌측 섹션 관련
let ptrnStartDate  = null;
let ptrnEndDate    = null;
let ptrnStartTime  = null;
let ptrnEndTime    = null;
let ptrnSearchBtn  = null;
let ptrnSelect     = null;
let ptrnDaySelect  = null;
let dayTypeData    = [];
let ptrnSelectData = [];
let linkData       = _trafficMap.get('link');
let ifscData       = _trafficMap.get('ifsc');
let roadData       = _trafficMap.get('road');
let linkTable      = null;
let ifscTable      = null;
let roadTable      = null;
let linkTabs       = null;

//차트 관련
let series               = [];
let xAxis                = [];
let yAxisTitle           = null;
let xAxisTitle           = '패턴시각';

//공통 uri
let commonUri            = '/api/analysis/ptrn-data/';
const _pageName          = '패턴데이터 분석';
let OFFR_TYPE            = 'LINK';

//기본 날짜 세팅
const strtDate = new Date().setMonth(new Date().getMonth()-2);
const endDate = new Date().setMonth(new Date().getMonth()-1);
ptrnSelectData = [
    {
        display     : '5분 패턴',
        PTRN_DATA   : '5M',
    },
    {
        display     : '15분 패턴',
        PTRN_DATA   : '15M',
    },
]

//chart series
series = [
    {
        id   : 'base_sped',
        name : '기준월 속도(km/h)',
        color: '#2aeb2a',
        data : [],
    },
    {
        id   : 'comp_sped',
        name : '비교월 속도(km/h)',
        color: '#e7be1b',
        data : [],
    },
    {
        id   : 'diff_sped',
        name : '속도 차이(km/h)',
        color: 'skyblue',
        data : [],
    },
    {
        id   : 'base_trvl_hh',
        name : '기준월 통행시간(초)',
        color: 'navy',
        data : [],
    },
    {
        id   : 'comp_trvl_hh',
        name : '비교월 통행시간(초)',
        color: 'yellow',
        data : [],
    },
    {
        id   : 'diff_trvl_hh',
        name : '차이 통행시간(초)',
        color: 'purple',
        data : [],
    },
]

$(()=>{



    //검색시작일시 년월일
    ptrnStartDate =  $('.strt-date').dxDateBox({
        type                : 'date',
        value               : strtDate,
        width               : 112.5,
        height              : '28px',
        stylingMode         : 'outlined',
        displayFormat       : 'yyyy년 MM월',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000년 00월',
    }).dxDateBox('instance');

    //검색 시작일시 시간
    ptrnStartTime =  $('.strt-time').dxDateBox({
        type                : 'time',
        value               : 1645110000000,
        width               : 112.5,
        interval            : 10,
        height              : '28px',
        stylingMode         : 'outlined',
        displayFormat       : 'HH:mm',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
    }).dxDateBox('instance');

    //검색종료일시 년월일
    ptrnEndDate =  $('.end-date').dxDateBox({
        type                : 'date',
        value               : endDate,
        width               : 112.5,
        height              : '28px',
        stylingMode         :'outlined',
        displayFormat       : 'yyyy년 MM월',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000년 00월',
    }).dxDateBox('instance');

    //검색종료일시 시간
    ptrnEndTime =  $('.end-time').dxDateBox({
        type                : 'time',
        value               : 1645196399000,
        width               : 112.5,
        interval            : 10,
        height              : '28px',
        stylingMode         : 'outlined',
        displayFormat       : 'HH:mm',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
    }).dxDateBox('instance');

    //링크레벨구분
    ptrnSelect = $('.ptrn-select').dxSelectBox({
        stylingMode     : 'outlined',
        items           : ptrnSelectData,
        displayExpr     : 'display',
        value           : ptrnSelectData[0],
        width           : 100,
        height          : 28,
        onItemClick(e){

        }
    }).dxSelectBox('instance');

    if(ptrnSelectData.length > 0){
        setValue(ptrnSelect, ptrnSelectData[0])
    }

    //패턴 요일 구분
    ptrnDaySelect = $('.ptrn-day-select').dxSelectBox({
        stylingMode     : 'outlined',
        items           : null,
        displayExpr     : 'day_type_desc',
        valueExpr       : 'day_type_cd',
        width           : 125,
        height          : 28,
        onItemClick(e){

        }
    }).dxSelectBox('instance');

    //상단 조회 버튼
    ptrnSearchBtn = $('.ptrn-data-search-btn').dxButton({
        stylingMode:'outlined',
        text:'조회',
        icon:'refresh',
        width: '80px',
        onClick(){
            offrResultEvent();
        }
    }).dxButton("instance")

    //차트 이지미 저장 버튼
    $(".export-button").dxButton({
        stylingMode : 'outlined',
        text        : '차트 저장',
        icon        : 'export',
        height      : '40px',
        width       : '110px',
        onClick(){
            if( ptrnData.length <= 0 || ptrnData[0].length <= 0 ){
                alertWarning("저장하실 차트 데이터가 없습니다.");
                return false;
            }

            confirmMessage(_pageName + " 차트를 파일로 저장 하시겠습니까?").done((yes)=>{
                if (yes){
                    ptrnChart.exportChartLocal({
                        filename: _pageName + '_' + excellTime()
                    });
                }
            });
        }
    })

    //차트 변경 버튼
    $(".chart-change").dxMenu({
        dataSource: chartDataSource,
        hideSubmenuOnMouseLeave: true,
        cssClass:'menu-border',
        height: 40,
        showFirstSubmenuMode: {
            name: "onClick",
            delay: { show: 0, hide: 100 },
        },
        displayExpr: "name",
        submenuDirection: "auto",
        visible: true,
        onItemClick(info){
            const item = info.itemData;
            if(item.type){
                const dataSource = [...info.component.option('dataSource')]
                dataSource[0].name = item.name
                dataSource[0].icon = item.type
                info.component.option('dataSource', dataSource);
                ptrnChart.update({
                    chart: {
                        type: item.type,
                    }
                })
            }
        }
    }).dxMenu("instance");

    //교통정보 제공결과분석 통계 차트
    ptrnChart = Highcharts.chart('ptrn-data-chart', {
        chart: {
            type: 'line',
            height: 342,
            backgroundColor: '#3f3f4b',
            zoomType: 'x',
        },
        title: {
            text: null
        },
        xAxis: {
            categories: null,
            title: {
                text: xAxisTitle,
                style:{
                    color:'#fff',
                }
            },
            labels:{
                style:{
                    color:'#fff',
                }
            }
        },

        yAxis: {
            min: 0,
            title: {
                style:{
                    color:'#fff',
                },
                text: yAxisTitle,
            },
            labels: {
                overflow: 'justify',
                style:{
                    color: '#fff',
                },
                format: '{value:,.0f}'
            },
        },
        plotOptions: {
            bar: {
                dataLabels: {
                    enabled: true
                }
            },
            series: {
                lineWidth: 2
            }
        },
        legend: {
            layout: 'vertical',
            align: 'right',
            verticalAlign: 'top',
            floating: false,
            y: 50,
            borderWidth: 1,
            itemStyle:{
                color:'#fff',
            },
            backgroundColor:
                Highcharts.defaultOptions.legend.backgroundColor || '#525260',
            shadow: true,
            borderColor:'#534b4b',
        },
        exporting: {
            chartOptions: { // specific options for the exported image
                plotOptions: {
                    series: {
                        dataLabels: {
                            enabled: true
                        }
                    }
                }
            },
            enabled: false,
            fallbackToExportServer: false,
        },
        credits : {
            enabled : false
        },
        series : series
    });

    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton("instance")


    //교통정보 제공결과분석 통계 테이블
    ptrnTable = $(".ptrn-data-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode: 'single',
        },
        keyExpr :'prcn_dt',
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible: true,
        },
        grouping: {
            autoExpandAll: true,
        },
        scrolling: {
            mode: 'virtual',
        },
        groupPanel:{
            visible: true,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        export:{
            enabled: true,
            texts: {
                exportAll:"엑셀 파일",
            },
        },
        columns:[
            {
                dataField    : "prcn_dt",
                caption      : "제공일시",
                alignment    : "center",
                sortIndex    : 0,
                sortOrder    : "asc",
            },
            {
                dataField    : "tot_cnt",
                caption      : "총링크수",
                alignment    : "center",
                format       : '#,###,##0',
            },
            {
                dataField    : "offr_cnt",
                caption      : "생성수",
                alignment    : "center",
                format       : '#,###,##0',
            },
            {
                dataField    : "ltc1_cnt",
                caption      : "원활",
                alignment    : "center",
                format       : '#,###,##0',
            },
            {
                dataField    : "ltc2_cnt",
                caption      : "지체",
                alignment    : "center",
                format       : '#,###,##0',
            },
            {
                dataField    : "ltc3_cnt",
                caption      : "정체",
                alignment    : "center",
                format       : '#,###,##0',
            },
            {
                dataField    : "ltc0_cnt",
                caption      : "정보없음",
                alignment    : "center",
                format       : '#,###,##0',
            },
        ],
        onExporting(e){
            gridExcellExporting(e, _pageName);
        },

    }).dxDataGrid("instance");



    //링크 테이블
    linkTable = $("<div>").width('100%').height('100%').dxDataGrid({
        dataSource              : linkData,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        focusedRowEnabled       : true,
        keyExpr                 : 'link_id',
        selection: {
            mode: 'single',
        },
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible: true,
        },
        grouping: {
            autoExpandAll: true,
        },
        scrolling: {
            mode: 'virtual',
        },
        groupPanel:{
            visible: true,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        columns:[
            {
                dataField    : "link_id",
                caption      : "링크 ID",
                alignment    : "center",
                dataType     : 'string',
                cssClass     : 'link-padding',
                allowEditing : false,
                width        : 120,
                sortIndex    : 0,
                sortOrder    : "asc",
            },

            {
                dataField    : "from_node",
                caption      : "시작노드",
                cssClass     : 'link-padding',
                alignment    : "center",
                cellTemplate(c,e){
                    let result = nullChecker(e.data.from_node);
                    return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
                }
            },
            {
                dataField    : "to_node",
                caption      : "종료노드",
                cssClass     : 'link-padding',
                alignment    : "center",
                cellTemplate(c,e){
                    let result = nullChecker(e.data.to_node);
                    return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
                }
            },
            // {
            //     dataField:"link_leng",
            //     caption:"길이(m)",
            //     alignment:"center",
            // },
            // {
            //     dataField:"road_name",
            //     caption:"도로명",
            //     alignment:"center",
            //     cellTemplate(c,e){
            //         let result = nullChecker(e.data.road_name);
            //         return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
            //     }
            // },
            // {
            //     dataField:"road_no",
            //     caption:"도로번호",
            //     alignment:"center",
            // },
            // {
            //     dataField:"road_rank_desc",
            //     caption:"도로등급",
            //     alignment:"center",
            //     cellTemplate(c,e){
            //         let result = nullChecker(e.data.road_rank_desc);
            //         return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
            //     }
            // },
            // {
            //     dataField:"road_type_desc",
            //     caption:"도로유형",
            //     alignment:"center",
            // },
            // {
            //     dataField:"road_use_desc",
            //     caption:"도로사용여부",
            //     alignment:"center",
            // },
            // {
            //     dataField:"lanes",
            //     caption:"차로수",
            //     alignment:"center",
            // },
            // {
            //     dataField:"max_spd",
            //     caption:"최고제한속도",
            //     alignment:"center",
            // },

            // {
            //     dataField:"sect_grad_cd_desc",
            //     caption:"구간등급코드",
            //     alignment:"center",
            //     cellTemplate(c,e){
            //         let result = nullChecker(e.data.sect_grad_cd_desc);
            //         return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
            //     }
            // }

        ],
    })

    //서비스링크 테이블
    ifscTable = $("<div>").width('100%').height('100%').dxDataGrid({
        dataSource              : ifscData,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        focusedRowEnabled       : true,
        keyExpr                 : 'ifsc_id',
        selection: {
            mode: 'single',
        },
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible: true,
        },
        grouping: {
            autoExpandAll: true,
        },
        scrolling: {
            mode: 'virtual',
        },
        groupPanel:{
            visible: true,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        columns:[
            {
                dataField    : "ifsc_id",
                caption      : "ID",
                alignment    : "center",
                dataType     : 'string',
                cssClass     : 'link-padding',
                allowEditing : false,
                sortIndex    : 0,
                width        : 100,
                sortOrder    : "asc",
            },

            {
                dataField    : "from_node",
                caption      : "시작노드",
                cssClass     : 'link-padding',
                alignment    : "center",
                cellTemplate(c,e){
                    let result = nullChecker(e.data.from_node);
                    return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
                }
            },
            {
                dataField    : "to_node",
                caption      : "종료노드",
                cssClass     : 'link-padding',
                alignment    : "center",
                cellTemplate(c,e){
                    let result = nullChecker(e.data.to_node);
                    return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
                }
            },

            // {
            //     dataField:"ifsc_name",
            //     caption:"명칭",
            //     alignment:"center",
            //     cellTemplate(c,e){
            //         let result = nullChecker(e.data.road_name);
            //         return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
            //     }
            // },
            // {
            //     dataField:"drct_cd_desc",
            //     caption:"방향",
            //     alignment:"center",
            // },
            // {
            //     dataField:"link_leng",
            //     caption:"길이(m)",
            //     alignment:"center",
            // },
            // {
            //     dataField:"sect_grad_cd_desc",
            //     caption:"구간등급코드",
            //     alignment:"center",
            //     cellTemplate(c,e){
            //         let result = nullChecker(e.data.sect_grad_cd_desc);
            //         return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
            //     }
            // }
            // {
            //     dataField:"rmrk",
            //     caption:"비고",
            //     alignment:"center",
            // },
            // {
            //     dataField:"extr_cnct_sect_yn",
            //     caption:"외부연계",
            //     alignment:"center",
            // },

        ],
    })

    //로드 테이블
    roadTable = $("<div>").width('100%').height('100%').dxDataGrid({
        dataSource              : roadData,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        keyExpr                 : 'road_id',
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode: 'single',
        },
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible: true,
        },
        grouping: {
            autoExpandAll: true,
        },
        scrolling: {
            mode: 'virtual',
        },
        groupPanel:{
            visible: true,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        columns:[
            {
                dataField    : "road_id",
                caption      : "ID",
                alignment    : "center",
                dataType     : 'string',
                cssClass     : 'link-padding',
                allowEditing : false,
                sortIndex    : 0,
                width        : 100,
                sortOrder    : "asc",
            },

            {
                dataField    : "from_node",
                caption      : "시작노드",
                cssClass     : 'link-padding',
                alignment    : "center",
                cellTemplate(c,e){
                    let result = nullChecker(e.data.from_node);
                    return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
                }
            },
            {
                dataField    : "to_node",
                caption      : "종료노드",
                cssClass     : 'link-padding',
                alignment    : "center",
                cellTemplate(c,e){
                    let result = nullChecker(e.data.to_node);
                    return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
                }
            },
            // {
            //     dataField:"link_leng",
            //     caption:"길이(m)",
            //     alignment:"center",
            // },
            // {
            //     dataField:"road_name",
            //     caption:"도로명",
            //     alignment:"center",
            //     cellTemplate(c,e){
            //         let result = nullChecker(e.data.road_name);
            //         return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
            //     }
            // },
            // {
            //     dataField:"drct_cd_desc",
            //     caption:"방향",
            //     alignment:"center",
            // },
        ],
    })

    //링크 tabs
    linkTabs = $('.link-tabs').width('100%').height('100%').dxTabPanel({
        dataSource:[
            {
                id     : 'LINK',
                name   : '링크(레벨1)',
                table  : linkTable,
                column : 'linkColumns',

            },
            {
                id     : 'IFSC',
                name   : '정보제공구간(레벨2)',
                table  : ifscTable,
                column : 'ifscColumns',
            },
            {
                id     : 'ROAD',
                name   : '도로(레벨3)',
                table  : roadTable,
                column : 'roadColumns',
            },
        ],
        selectIndex:0,
        loop:false,
        animationEnabled: true,
        swipeEnabled: false,
        itemTitleTemplate: function(e){
            return $('<div style="height:29px; line-height:29px;">'+e.name+'</div>')
        },
        itemTemplate: function(e){
            const div = $('<div class="table-container">');
            div.append(e.table);
            return div;
        },
        onSelectionChanged(e){
            e.addedItems[0].table.dxDataGrid('instance').clearSelection();
            e.addedItems[0].table.dxDataGrid('instance').option('focusedRowIndex', -1);
        },
    }).dxTabPanel('instance');

    fetchBaseData();
})

function fetchBaseData(){
    getDataAsync(commonUri + 'day-type', fetchSelectData);
}
function fetchSelectData(jsonData){
    dayTypeData = jsonData;
    ptrnDaySelect.option('dataSource', dayTypeData);

    if (dayTypeData) {
        setValue(ptrnDaySelect, dayTypeData[0].day_type_cd);
    }
}

//구간별 데이터 세팅
function offrResultEvent() {

    let PTRN_DATA     = ptrnSelect.option('value').PTRN_DATA;
    let PTRN_WEEK     = ptrnDaySelect.option('value');
    let PTRN_TYPE     = linkTabs.option('selectedItems')[0].id;
    let BASE_MN       = null;
    let COMP_MN       = null;
    let FROM_HM       = null;
    let TO_HM         = null;
    let ID            = null;
    let selectedTable = linkTabs.option('selectedItems')[0].table.dxDataGrid('instance');
    let updateData    = {};

    //링크 체크 여부
    if( selectedTable.getSelectedRowsData().length <=0 ){
        const name = linkTabs.option('selectedItem').name
        alertWarning(name.substring(0,name.indexOf("(")) + " 목록을 선택해주세요");
        return false;
    }

    //월,시각 null값 체크
    if ( !validationCheck( ptrnStartDate, ptrnEndDate, ptrnStartTime, ptrnEndTime )) return false;

    BASE_MN = dateFormmater(new Date(ptrnStartDate.option('value'))).substring(0,6);
    COMP_MN = dateFormmater(new Date(ptrnEndDate.option('value'))).substring(0,6);
    FROM_HM = timeSetup(ptrnStartTime.option('value')).substring(0,4);
    TO_HM   = timeSetup(ptrnEndTime.option('value')).substring(0,4);

    //월 비교 값이 같거나 앞에 값이 클경우 체크
    if( BASE_MN > COMP_MN ){
        alertWarning('검색 시작 시각이 검색 종료 시각보다 큽니다.', null, ptrnStartDate);
        return false;
    }
    else if( BASE_MN === COMP_MN ){
        alertWarning('기준월과 비교월이 같습니다. 다르게 선택 하세요', null, ptrnStartDate)
        return false;
    }


    ID = selectedTable.getSelectedRowsData()[0][PTRN_TYPE.toLowerCase()+"_id"]

    updateData[ 'PTRN_DATA' ] = PTRN_DATA;
    updateData[ 'PTRN_WEEK' ] = PTRN_WEEK
    updateData[ 'PTRN_TYPE' ] = PTRN_TYPE;
    updateData[ 'BASE_MN' ]   = BASE_MN;
    updateData[ 'COMP_MN' ]   = COMP_MN;
    updateData[ 'FROM_HM' ]   = FROM_HM;
    updateData[ 'TO_HM' ]     = TO_HM;
    updateData[ 'ID' ]        = ID;
    finalEvent( commonUri, updateData );
}

//테이블 및 차트 세팅
function finalEvent( uri, updateData ){
    ptrnData = [];
    xAxis    = [];

    //getData( uri, ptrnData, updateData );
    getDataAsync(uri, (jsonData)=>{
        ptrnData = jsonData;

        for( key in series){
            series[key].data = [];
        }

        if ( ptrnData ) {
            ptrnData.map((item)=>{
                if(nullChecker(item.prcn_dt) !== ""){
                    item.prcn_dt = getParseDateTime(prcn_dt)
                    xAxis.push(item.prcn_dt)
                    for(let ii = 0 ; ii < series.length; ii++ ){
                        series[ii].data.push(item[series[ii].id])
                    }
                }
            })
        }

        ptrnTable.option( 'dataSource', ptrnData );

        ptrnChart.update({
            xAxis :{
                categories: xAxis
            },
            series:series
        })

        pageNation(ptrnChart, xAxis);

        alertConfirm('데이터 조회가 완료 되었습니다. [' + ptrnData.length + '건]');
    }, null, updateData);
}
