let _listTable    = null;
let _listData     = [];
let _cctvInfoMap   = new Map();
let _presetMap    = new Map();
let _editBtn      = null;
let _addBtn       = null;
let _delBtn       = null;
let _cancelBtn    = null;
let _saveBtn      = null;
let _cctvMngmNmbr  = null;
let _schdHm      = null;
let _psetNmbr    = null;
let _useYn        = null;
const _apiUri     = "/api/cctv/pset_ctrl_scnr";


$(()=>{

    //상단 닫기 버튼
    creatBtn($('.close-btn'), 'close', '닫기', '닫기', 'outlined', () => window.close(), 80, false, true, 30);
    creatBtn($('.search-btn'), 'refresh', '조회', '조회', 'outlined', () => search(), 80, false, true, 30);

    //하단 편집 버튼들
    _editBtn   = creatBtn($('.edit-btn'), 'edit', '편집', '편집', 'outlined', editEvent, null, true, true);
    _cancelBtn = creatBtn($('.cancel-btn'), 'edit', '취소', '취소', 'outlined', cancelEvent, null, false, false);
    _addBtn    = creatBtn($('.add-btn'), 'plus', '추가', '추가', 'outlined', addEvent, null, false, true);
    _delBtn    = creatBtn($('.del-btn'), 'minus', '삭제', '삭제', 'outlined', delEvent, null, true, true);
    _saveBtn   = creatBtn($('.save-btn'), 'save', '저장', '저장', 'outlined', null, null, true, true);

    //CCTV 관리번호 셀렉트 박스
    _cctvMngmNmbr = $('.cctv_mngm_nmbr').dxSelectBox({
        stylingMode : 'outlined',
        dataSource  : [],
        width       : 400,
        height      : 30,
        disabled    : true,
        displayExpr : 'cctv_mngm_nmbr_desc',
        valueExpr   : 'cctv_mngm_nmbr',
        onItemClick : (e)=>{
            setPsetValue(e.itemData.cctv_mngm_nmbr);
        }
    }).dxSelectBox('instance');

    //제어 스케줄 시각
    _schdHm = $('.schd_hm').dxDateBox({
        stylingMode         : 'outlined',
        width               : 100,
        height              : 30,
        displayFormat       : 'HH:mm',
        type                : 'time',
        interval            : 10,
        value               : firstSettingTime,
        readOnly            : true,
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
    }).dxDateBox('instance');

    //프리셋 번호
    _psetNmbr = $('.pset_nmbr').dxSelectBox({
        stylingMode : 'outlined',
        dataSource  : [],
        width       : 400,
        height      : 30,
        displayExpr : 'pset_desc',
        valueExpr   : 'pset_nmbr',
        readOnly    : true,
    }).dxSelectBox('instance');

    //CCTV use_yn 셀렉트 박스
    _useYn = $('.use_yn').dxSelectBox({
        stylingMode : 'outlined',
        dataSource  : [
            {
                use_desc : '[Y] 사용',
                use_yn   : 'Y',
            },
            {
                use_desc : '[N] 사용안함',
                use_yn   : 'N',
            }
        ],
        width       : 150,
        height      : 30,
        readOnly    : true,
        displayExpr : 'use_desc',
        valueExpr   : 'use_yn',
        value       : 'Y',
    }).dxSelectBox('instance');

    //VMS 리스트 테이블
    _listTable = $(".list-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : ['cctv_mngm_nmbr', 'pset_nmbr', 'schd_hm'],
        selection: {
            mode : 'single',
        },
        grouping: {
            autoExpandAll : true,
        },
        scrolling: {
            mode : 'standard',
        },
        paging : {
            pageSize : 1000,
        },
        sorting : {
            showSortIndexes : false,
        },
        groupPanel : {
            visible         : true,
            emptyPanelText  : "그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        columns:[
            // {   
            //     dataField    : "cctv_mngm_nmbr",
            //     caption      : "CCTV 관리번호",
            //     alignment    : "center",
            //     allowEditing : false,
            //     sortIndex    : 0, 
            //     sortOrder    : "asc",
            //     groupIndex   : 0,
            //     cssClass     : 'padding-ctrl',
            //     cellTemplate(c,e){
            //         let result = nullChecker(e.displayValue);
            //         return  $('<div style="text-align: left;">'+result+'</div>')
            //     },
            // },
            {
                dataField    : "cctv_ctlr_id",
                caption      : "CCTV ID",
                alignment    : "center",
                sortIndex    : 0,
                sortOrder    : "asc",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "istl_lctn_nm",
                caption      : "CCTV 명칭",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                },
            },
            {
                dataField    : "pset_nmbr",
                caption      : "프리셋 번호",
                alignment    : "center",
                sortIndex    : 1,
                sortOrder    : "asc",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "schd_hm",
                caption      : "제어 스케줄 시각",
                alignment    : "center",
                sortIndex    : 2,
                sortOrder    : "asc",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "use_yn",
                caption      : "사용여부",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
                lookup       : {
                    dataSource : [
                        {
                            use_yn : 'Y',
                            use_yn_desc : '[Y] 사용',
                        },
                        {
                            use_yn : 'N',
                            use_yn_desc : '[N] 사용안함',
                        }
                    ],
                    displayExpr : 'use_yn_desc',
                    valueExpr   : 'use_yn',
                }
            },
            {
                dataField    : "ctrl_dt",
                caption      : "마지막 제어 시각",
                alignment    : "center",
                dataType     : 'datetime',
                format       : 'yyyy-MM-dd HH:mm:ss',
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "ctrl_res_yn",
                caption      : "마지막 제어 결과",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
                lookup       : {
                    dataSource : [
                        {
                            ctrl_res_yn : 'Y',
                            ctrl_res_desc : '성공',
                        },
                        {
                            ctrl_res_yn : 'N',
                            ctrl_res_desc : '실패',
                        }
                    ],
                    displayExpr : 'ctrl_res_desc',
                    valueExpr   : 'ctrl_res_yn',
                },
                cellTemplate(c,e){
                    let result = e.displayValue
                    if(!result){
                        result = '-';
                    }
                    if(result === '실패'){
                        c.css('background-color', '#ff0000');
                    }
                    return  $('<div>' + result + '</div>')
                },
            },

        ],
        onRowClick(info){
            if(!info.groupIndex && info.groupIndex !== 0){
                listRowClick(info.data);
            }
        },
    }).dxDataGrid("instance");

    fetchBaseData();
})

function search() {
    boxInit();
    _listTable.clearSelection();
    _listTable.option('focusedRowIndex', -1);
    fetchBaseData();
}

/*
* 리스트, 프리셋 데이터 수신
*/
function fetchBaseData(){
    let listData   = [];
    let dataSource = [];
    let presetData = [];
    let cctvData   = [];
    //_cctvInfoMap   = new Map();
    _presetMap     = new Map();

    getData(_apiUri, listData);
    getData('/api/cctv/pset', presetData);
    getData('/api/cctv/common/cctv-list', cctvData);
    if (cctvData[0].length > 0) {
        let cctvComboData = [];
        cctvData[0].map((item)=>{
            let val = '[' + item.cctv_mngm_nmbr + '] ' + item.cctv_ctlr_id + ' ' + item.istl_lctn_nm;
            cctvComboData.push({
                cctv_mngm_nmbr      : item.cctv_mngm_nmbr,
                cctv_mngm_nmbr_desc : val,
            });
        })
        _cctvMngmNmbr.option('dataSource', cctvComboData);
        setValue(_cctvMngmNmbr, cctvComboData[0].cctv_mngm_nmbr);
    }

    if (listData[0].length > 0){
        listData[0].map((item)=>{
            let cctv = cctvData[0].filter( cctv => cctv.cctv_mngm_nmbr === item.cctv_mngm_nmbr )
            if (cctv[0]) {
                item.cctv_ctlr_id = cctv[0].cctv_ctlr_id;
                item.istl_lctn_nm = cctv[0].istl_lctn_nm;
            }
            //if (!_cctvInfoMap.get(item.cctv_mngm_nmbr)){
            //    _cctvInfoMap.set(item.cctv_mngm_nmbr, item);
            //}
            if (item.ctrl_dt) item.ctrl_dt = new Date(getParseDateTime(item.ctrl_dt));
        });

        _listData = listData[0];

        _listData.sort(function(a,b){
            return a.cctv_mngm_nmbr - b.cctv_mngm_nmbr;
        });

        _listTable.option('dataSource', _listData);
    }


    if (presetData[0].length > 0){
        presetData[0].map((item)=>{
            if (!_presetMap.get(item.cctv_mngm_nmbr)){
                _presetMap.set(item.cctv_mngm_nmbr, new Array());
            }

            if (item.pset_nm){
                let val = '[' + item.pset_nmbr + '] ' + item.pset_nm;

                _presetMap.get(item.cctv_mngm_nmbr).push({
                    pset_nmbr      : item.pset_nmbr,
                    pset_nm        : item.pset_nm,
                    pset_desc      : val,
                });
            }
        });

        if (cctvData[0].length > 0) {
            setPsetValue(cctvData[0][0].cctv_mngm_nmbr);
        }
    }

}

/**
 * 리스트 테이블 클릭 이벤트
 * @param {*} rowData : 클릭한 로우의 데이터
 * @returns {void}
 */
function listRowClick(rowData){
    setValue(_cctvMngmNmbr, rowData.cctv_mngm_nmbr);
    let timeVal = rowData.schd_hm;
    let now = nowTime();
    timeVal =  now.substring(0,10) +' '+ timeVal.substring(0,2) + ':' + timeVal.substring(2,4)+ ':00';
    timeVal = new Date(timeVal).getTime();
    let psetDataSource = Array.from(_presetMap.get(rowData.cctv_mngm_nmbr));
    _psetNmbr.option('dataSource', psetDataSource);
    setValue(_schdHm, timeVal);
    setValue(_psetNmbr, rowData.pset_nmbr);
    setValue(_useYn, rowData.use_yn);
    dsblOffBtn(_editBtn);
    dsblOffBtn(_delBtn);
}

/**
 * 편집 버튼 클릭 이벤트
 */
function editEvent(){
    eventOn();
    textOption('edit');
    _saveBtn.off('click');
    _saveBtn.on('click', () => saveEvent('edit'));
}

/**
 * 추가 버튼 클릭 이벤트
 */
function addEvent(){
    eventOn();
    boxInit();
    textOption('add');
    _saveBtn.off('click');
    _saveBtn.on('click', () => saveEvent());
}

/**
 * 취소 버튼 클릭 이벤트
 */
function cancelEvent(){
    eventOff();
    textOption('cancel');
}

/**
 * 저장 버튼 클릭 이벤트
 * @param type 저장 버튼 클릭 시 수정 or 추가
 */
function saveEvent(type){
    let cctv_mngm_nmbr = getValue(_cctvMngmNmbr);
    let selectedData   = _listTable.getSelectedRowsData();
    let updateData = {
        cctv_mngm_nmbr: cctv_mngm_nmbr,
        old_pset_nmbr: null,
        old_schd_hm: null,
        pset_nmbr: getValue(_psetNmbr),
        schd_hm: null,
        use_yn: getValue(_useYn),

    }

    if(_schdHm.option('validationError')){
        alertWarning('제어 스케줄 시각을 형식에 맞게 입력해주세요.', null, _schdHm);
        return;
    }
    else if(!getValue(_schdHm)){
        alertWarning('제어 스케줄 시각을 입력해주세요.', null, _schdHm);
        return;
    }

    updateData.schd_hm = getSendTime(getValue(_schdHm));

    if (type === 'edit'){
        updateData.old_pset_nmbr = selectedData[0].pset_nmbr;
        updateData.old_schd_hm = selectedData[0].schd_hm;
    }
    else {
        updateData.old_pset_nmbr = updateData.pset_nmbr;
        updateData.old_schd_hm = updateData.schd_hm;
    }

    let result = postInsertUpdate(_apiUri, [updateData]);

    if(result > 0){
        alertConfirm('프리셋 제어 스케줄 정보저장<br>프리셋 제어 스케줄 정보를 저장 하였습니다.');
        fetchBaseData();
        _listTable.refresh().done(()=>{
            const cctvNum = updateData.cctv_mngm_nmbr;
            const psetNum = updateData.pset_nmbr;
            const schdHm  = updateData.schd_hm;
            _listTable.clearSelection();
            const key = [{
                cctv_mngm_nmbr : cctvNum,
                pset_nmbr 	   : psetNum,
                schd_hm        : schdHm,
            }];
            _listTable.selectRows(key, true);
            const idx = _listTable.getRowIndexByKey(key[0]);
            _listTable.option('focusedRowIndex', idx);
            eventOff();
            textOption('cancel');
        });
    }

}

/**
 * 삭제 버튼 클릭 이벤트
 */
function delEvent(){
    let selectedData = _listTable.getSelectedRowsData()[0];
    confirmMessage('CCTV 관리번호: '
        + selectedData.cctv_mngm_nmbr
        + '<br>프리셋 번호: '
        + selectedData.pset_nmbr
        + '<br>제어시각: '
        + selectedData.schd_hm
        +'<br>선택하신 프리셋 제어 스케줄 정보를 삭제하시겠습니까?').done((yes)=>{
        if (yes === true){
            let delData = [
                {
                    cctv_mngm_nmbr: selectedData.cctv_mngm_nmbr,
                    pset_nmbr: selectedData.pset_nmbr,
                    schd_hm: selectedData.schd_hm
                }
            ]

            let result = deleteDataIds(_apiUri, delData);

            if(result > 0){
                alertConfirm('프리셋 스케줄 정보삭제<br>프리셋 제어 스케줄 정보를 삭제 하였습니다.');
                let delIndex = _listData.findIndex(item => item.cctv_mngm_nmbr === selectedData.cctv_mngm_nmbr
                    && item.schd_hm === selectedData.schd_hm
                    && item.pset_nmbr === selectedData.pset_nmbr);
                _listData.splice(delIndex, 1);
                _listTable.option('dataSource', _listData);
                _listTable.clearSelection();
                _listTable.option('focusedRowIndex', -1);
                eventOff();
                textOption('cancel');
            }
        }
    });
}

/**
 * 이벤트 실행시 버튼 옵션 함수
 */
function eventOn(){
    showBtn(_cancelBtn);
    hideBtn(_editBtn);
    dsblOnBtn(_addBtn);
    dsblOnBtn(_delBtn);
    dsblOffBtn(_saveBtn);
    dsblOnBtn(_listTable);
}

/**
 * 이벤트 종료시 버튼 옵션 및 텍스트 상자 값 설정 함수
 */
function eventOff(){
    hideBtn(_cancelBtn);
    showBtn(_editBtn);
    dsblOffBtn(_addBtn);
    dsblOnBtn(_delBtn);
    dsblOnBtn(_saveBtn);
    dsblOnBtn(_editBtn);
    dsblOffBtn(_listTable);
    const selectedData = _listTable.getSelectedRowsData();
    if (selectedData.length > 0) {
        dsblOffBtn(_editBtn);
        dsblOffBtn(_delBtn);
        boxInit(selectedData[0]);
    }
    else {
        boxInit();
    }
}

/**
 * 텍스트 상자 값 초기화 함수
 * @param {*} data 리스트 선택된 데이터
 */
function boxInit(data){
    if (data){
        setValue(_cctvMngmNmbr, data.cctv_mngm_nmbr);
        setValue(_useYn, data.use_yn);
        let timeVal = data.schd_hm;
        let now = nowTime();
        timeVal =  now.substring(0,10) +' '+ timeVal.substring(0,2) + ':' + timeVal.substring(2,4)+ ':00';
        timeVal = new Date(timeVal).getTime();
        setValue(_schdHm, timeVal);
        setPsetValue(data.cctv_mngm_nmbr);
        setValue(_psetNmbr, data.pset_nmbr);
    }
    else {
        setValue(_cctvMngmNmbr, _cctvMngmNmbr.option('dataSource')[0].cctv_mngm_nmbr);
        setValue(_useYn, 'Y');
        setValue(_schdHm, firstSettingTime);
        setPsetValue(getValue(_cctvMngmNmbr));
    }
}

/**
 * 텍스트 상자 옵션 설정 함수
 * @param {*} type : 편집/추가/취소
 */
function textOption(type){
    if (type === 'edit'){
        _useYn.option('readOnly', false);
        _psetNmbr.option('readOnly', false);
        _schdHm.option('readOnly', false);
    }
    else if (type === 'add'){
        dsblOffBtn(_cctvMngmNmbr);
        _schdHm.option('readOnly', false);
        _useYn.option('readOnly', false);
        _psetNmbr.option('readOnly', false);
    }
    else if (type === 'cancel'){
        dsblOnBtn(_cctvMngmNmbr);
        _schdHm.option('readOnly', true);
        _useYn.option('readOnly', true);
        _psetNmbr.option('readOnly', true);
    }
}

/**
 * 프리셋 셀렉트 박스 옵션 설정 함수
 * @param {*} cctv_mngm_nmbr : 선택된 cctv 관리번호
 */
function setPsetValue(cctv_mngm_nmbr){
    _psetNmbr.option('dataSource', Array.from(_presetMap.get(cctv_mngm_nmbr)));
    if (_psetNmbr.option('dataSource').length > 0) {
        setValue(_psetNmbr, _psetNmbr.option('dataSource')[0].pset_nmbr);
    }
}

/**
 * 기존 리스트에 있는 항목인지 체크하는 함수
 * @param {*} data : 비교 데이터
 * @returns selectedIdx : 선택된 인덱스
 */
function getFindIndex(data){
    let findIndex = _listData.findIndex(item => item.cctv_mngm_nmbr === data.cctv_mngm_nmbr
        && item.schd_hm === data.schd_hm
        && item.pset_nmbr === data.pset_nmbr);
    return findIndex;
}