let cancleBtn = null;
let searchBtn = null;
let sttsData  = [];
let sttsTable = null;
const commonUri = '/api/vms/monitoring/stts';

$(()=>{
    creatBtn($(".close-btn"), "close", "닫기", "닫기", "outlined", () => window.close());
    creatBtn($(".search-btn"), "refresh", "조회", "조회", "outlined", () => fetchListData());

    //CCTV 상태 전체조회 테이블
    sttsTable = $(".stts-table").width('100%').height('100%').dxDataGrid({
        dataSource              : sttsData,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        headerFilter: {
            visible: true,
        },
        selection  : {
            mode :'single'
        },
        keyExpr : 'vms_ctlr_nmbr',
        paging: {
            enabled: false,
            pageSize: 1000,
        },
        scrolling: {
            mode: 'standard',
        },
        columns:[
            {
                caption   : 'VMS 정보',
                alignment : 'center',
                cssClass  : 'padding-ctrl',
                columns   : [
                    {
                        dataField    : "vms_ctlr_nmbr",
                        caption      : "VMS 번호",
                        alignment    : "center",
                        cssClass     : 'padding-ctrl',
                        sortIndex    : 0, 
                        sortOrder    : "asc",
                        width        : 130,
                    },
                    {
                        dataField    : "vms_ctlr_id",
                        caption      : "VMS ID",
                        alignment    : "center",
                        cssClass     : 'padding-ctrl',
                    },
                    {
                        dataField    : "vms_nm",
                        caption      : "VMS 명칭",
                        alignment    : "center",
                        cssClass     : 'padding-ctrl',
                        cellTemplate(c,e){
                            c.css('text-align','left');
                            c.text(e.displayValue)
                        }
                    },
                    {
                        dataField    : "vms_usag_type_desc",
                        caption      : "유형",
                        alignment    : "center",
                        cssClass     : 'padding-ctrl',
                    },
                    {
                        dataField    : "vms_type_desc",
                        caption      : "크기",
                        alignment    : "center",
                        cssClass     : 'padding-ctrl',
                    },
                ]
            },
            {
                caption   : '메세지 표출',
                cssClass  : 'padding-ctrl',
                alignment : 'center',
                columns   : [
                    {
                        dataField    : "oper_mode_desc",
                        caption      : "운영모드",
                        alignment    : "center",
                        width        : '120',
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let val = e.displayValue;
                            let classNm = '';
                            if ( val === '자동' ){
                                classNm = 'green';
                            }
                            else if (val === '자동'){
                                classNm = 'red';
                            }
                            else {
                                classNm = 'yellow';
                            }
                            const div = $('<div class='+classNm+'>')
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                    {
                        dataField    : "updt_dt",
                        caption      : "제공시각",
                        alignment    : "center",
                        dataType     : "date",
                        format       : "yyyy-MM-dd HH:mm:ss",
                    },
                    {
                        dataField    : "provide_cnt",
                        caption      : "제공",
                        alignment    : "center",
                    },
                    {
                        dataField    : "auto",
                        caption      : "자동",
                        alignment    : "center",
                    },
                    {
                        dataField    : "fixed",
                        caption      : "고정",
                        alignment    : "center",
                    },
                    {
                        dataField    : "basic",
                        caption      : "기본",
                        alignment    : "center",
                    },
                ]
            },
            {
                caption   : '통신',
                alignment : 'center',
                cssClass  : 'padding-ctrl',
                columns   : [
                    {
                        dataField    : "cmnc_stts_desc",
                        caption      : "통신",
                        alignment    : "center",
                        width        : 100,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = e.data.cmnc_stts_cd;
                            if(!e.data.cmnc_stts_cd){
                                classNm = 'gray'
                            }
                            const div = $('<div class='+e.data.cmnc_stts_cd+'>')
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                ]
            },
            {
                caption   : '모듈',
                alignment : 'center',
                cssClass  : 'padding-ctrl',
                columns   : [
                    {
                        dataField    : "modl_stts_desc",
                        caption      : "모듈상태",
                        alignment    : "center",
                        width        : 110,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = e.data.modl_stts_cd;
                            if(!e.data.modl_stts_cd){
                                classNm = 'gray'
                            }
                            const div = $('<div class='+classNm+'>');
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                    {
                        dataField    : "pwer_stts_desc",
                        caption      : "전원상태",
                        alignment    : "center",
                        width        : 110,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = e.data.pwer_stts_cd;
                            if(!e.data.pwer_stts_cd){
                                classNm = 'gray'
                            }
                            const div = $('<div class='+classNm+'>')
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                    {
                        dataField    : "brgh_val",
                        caption      : "화면휘도",
                        alignment    : "center",
                        width        : 110,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let val = e.displayValue;
                            let classNm = '';
                            if (!e.displayValue) {
                                val = '-';
                                classNm = 'gray'
                            } 
                            const div = $('<div class='+classNm+'>')
                            div.text(val);
                            return c.append(div);
                        }
                    },
                ]
            },
            {
                caption   : '함체',
                alignment : 'center',
                columns   : [
                    {
                        dataField    : "cbox_door_stts_desc",
                        caption      : "도어",
                        alignment    : "center",
                        width        : 100,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = e.data.cbox_door_stts_cd;
                            if(!e.data.cbox_door_stts_cd){
                                classNm = 'gray'
                            }
                            const div = $('<div class='+classNm+'>');
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                    {
                        dataField    : "fan_stts_desc",
                        caption      : "팬상태",
                        alignment    : "center",
                        width        : 100,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = e.data.fan_stts_cd;
                            if(!e.data.fan_stts_cd){
                                classNm = 'gray'
                            }
                            const div = $('<div class='+classNm+'>');
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                    {
                        dataField    : "hetr_stts_desc",
                        caption      : "히터상태",
                        alignment    : "center",
                        width        : 110,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = e.data.hetr_stts_cd;
                            if(!e.data.hetr_stts_cd){
                                classNm = 'gray'
                            }
                            const div = $('<div class='+classNm+'>');
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                    {
                        dataField    : "cbox_tmpr",
                        caption      : "온도",
                        alignment    : "center",
                        width        : 100,
                        cellTemplate(c,e){
                            let classNm = null;
                            let cdData  = e.displayValue;
                            c.css('padding','2px');
                            c.css('height','1px');
                            if (e.data.cbox_tmpr === null || e.data.cbox_tmpr === 255) {
                                classNm = 'gray'
                                cdData = "-";
                            }
                            const div = $('<div class='+classNm+'>');
                            div.text(cdData);
                            return c.append(div);
                        }
                    },
                ]
            },
            {
                caption   : '함체환경설정정보',
                alignment : 'center',
                cssClass  : 'padding-ctrl',
                columns   : [
                    {
                        dataField    : "vms_cmnc_err_bass_val",
                        caption      : "모듈정지온도",
                        alignment    : "center",
                    },
                    {
                        dataField    : "fan_mtns_tmpr",
                        caption      : "팬동작온도",
                        alignment    : "center",
                    },
                    {
                        dataField    : "hetr_mtns_tmpr",
                        caption      : "히터동작온도",
                        alignment    : "center",
                    },
                    {
                        dataField    : "vms_modl_err_rate",
                        caption      : "모듈장애율",
                        alignment    : "center",
                    },
                ]
            },
            {
                caption   : '전광판',
                alignment : 'center',
                cssClass  : 'padding-ctrl',
                columns   : [
                    {
                        dataField    : "panl_on_time",
                        caption      : "ON",
                        alignment    : "center",
                    },
                    {
                        dataField    : "panl_off_time",
                        caption      : "OFF",
                        alignment    : "center",
                    },
                ]
            },
         
        ],
    }).dxDataGrid("instance");
    fetchListData();
})

function fetchListData(){
    getDataAsync(commonUri, (jsonData)=>{
        const listData = jsonData;
        if (listData.length > 0){

            listData.map((item)=>{
                if (item.updt_dt) item.updt_dt = getParseDateTime(item.updt_dt);
                item.auto = item.auto_used + '/' + item.auto_total;
                item.basic = item.basic_used + '/' + item.basic_total;
                item.fixed = item.fixed_used + '/' + item.fixed_total;
            })
        }
        sttsTable.option('dataSource', listData);
    });
}