let montList  = null;
let montBtn   = null;
let montData  = [];
let partData  = [];
let nameList  = [];
let _listData = [];
const _videoMap = new Map();
let commonUri = "/api/vms/monitoring/edit/scenario/camera"
let lange     = 0;

$(()=>{
    montList = $(".mont-list").dxSelectBox({
        width       : 300,
        dataSource  : [],
        displayExpr : 'monitoring_nm',
        valueExpr   : 'monitoring_nm',
        height      : 27,
        stylingMode : 'outlined',
        onItemClick(e){
            getDataAsync(commonUri + "/" + encodeURIComponent(e.itemData.monitoring_nm), montSection);
        }
    }).dxSelectBox('instance');

    montBtn = $(".mont-btn").dxButton({
        width       : 110,
        height      : 27,
        text        : '화면 관리',
        icon        : 'preferences',
        stylingMode : 'outlined',
        onClick(){
            window.open('./camera-popup-manager.html','모니터링 화면 관리','width = 1200, height = 650, top = 150, left = 300, resizable=yes, scrollbars=no')
        }
    });

    fetchBaseData();
})
function fetchBaseData(){
    getDataAsync(commonUri + '/list', recvListData);
}
function recvListData(jsonData){
    _listData = jsonData;
    montList.option('dataSource', _listData);
    if (_listData.length > 0) {
        setValue(montList, _listData[0].monitoring_nm);
        getDataAsync(commonUri + "/" + encodeURIComponent(_listData[0].monitoring_nm), montSection);
    }
}
function montSection(data){
    const montBox = $(".mont-box")
    montBox.empty();
    if (!data || data.length === 0) {
        let div = $("<div class='section'>")
        div.html(`<div class="mont-title serve-title">
            --Empty--</div>
            <div class="mont-body"><img src="/images/op/logo/empty_img.png"></div>`);
        return montBox.append(div);
    }
    if (!_videoMap.get('video')){
        _videoMap.set('video', new Map());
        _videoMap.set('info', new Map());
    }
    else {
        _videoMap.get('video').forEach( (obj, key)=> {
            obj.pause();
            obj.dispose();
        });
        _videoMap.clear();
        _videoMap.set('video', new Map());
        _videoMap.set('info', new Map());
    }
    data.sort(function(a,b){
        return a['monitoring_seq'] < b['monitoring_seq']? -1: a['monitoring_seq'] > b['monitoring_seq']? 1:0;
    })
    let width  = 0;
    let height = 0;
    const length = data.length;
    switch (true) {
        case length >= 0 && length <= 1:
            width  = 1;
            height = 1;
            break;
        case length >= 2 && length <= 4:
            width  = 2;
            height = 2;
            break;
        case length >= 5 && length <= 6:
            width  = 3;
            height = 2;
            break;
        case length >= 7 && length <= 9:
            width  = 3;
            height = 3;
            break;
        case length >= 10 && length <= 12:
            width  = 4;
            height = 3;
            break;
        case length >= 13 && length <= 16:
            width  = 4;
            height = 4;
            break;
        case length >= 17 && length <= 20:
            width  = 5;
            height = 4;
            break;
        case length >= 21 && length <= 24:
            width  = 6;
            height = 4;
            break;
        case length >= 25 && length <= 30:
            width  = 6;
            height = 5;
            break;
        default:
            if ( length <= 42 ){
                width  = 7;
                height = 6;
            }
            else if( length <= 56){
                width  = 8;
                height = 7;
            }
            else {
                width  = 8;
                height = 8;
            }
            break;
    }

    let divLineArr  = [];
    let divArr      = [];
    let montWidth   = 0;
    let cnt         = 0;
    montWidth = 100/width;
    montHeight = 100/height;

    for(let ii = 0 ; ii < width * height; ii++){
        let div = $("<div class='section'>")

        div.css('width',"calc(" + montWidth + "%)");
        if ( data[ii] ){
            div.html(`<div class="mont-title serve-title">
            ${data[ii].monitoring_seq} : ${data[ii].vms_nm}</div>
            <video id="video${data[ii].monitoring_seq}" class="mont-body video-js" style="object-fit:fill; width=100%; height=100%;"></video>`);
            _videoMap.get('info').set(data[ii].monitoring_seq, data[ii]);
        }
        else {
            div.html(`<div class="mont-title serve-title">--Empty--</div>
            <div class="mont-body"><img src="/images/op/logo/empty_img.png"></div>`);
        }
        divArr.push(div)
    }

    for( let ii = 0; ii < height; ii++ ){
        let div = $("<div>");
        div.css('width', "100%");
        div.css('height', "calc("+montHeight+"%)");
        div.css('display','flex');
        for(let jj  = 0; jj < width; jj++){
            div.append(divArr[cnt]);
            cnt++
        }
        divLineArr.push(div)
    }

    montBox.append(divLineArr);

    _videoMap.get('info').forEach( (obj, key)=> {
        console.log(obj);
        let player = videojs('video' + obj.monitoring_seq, {
            sources : [
                { src : obj.strm_http_addr, type : "application/x-mpegURL"},
            ],
            controls : true,
            playsinline : true,
            muted : true,
            autoplay: true,
            preload : "none",
            controlBar: {
                'liveDisplay': false,
                'pictureInPictureToggle': false
            }
        });
        _videoMap.get('video').set(obj.monitoring_seq, player);
        player.pause();
        player.play();
    });
}
