import { TMapMngr, TFclt } from "/js/vworld/map-mngr.js";
import { LayerType, LayerIndex, EditLinkColor } from "/js/vworld/map-const.js";
import { apiGet } from "/js/utils/restApi.js";

let _mapManager = null;
const _lyrType  = LayerType.IFSC;
const _lyrIdx   = LayerIndex.Ifsc1;
const _btnMap   = new Map();
const _textMap  = new Map();
const _apiUri   = "/api/vms/manager/vms-ifsc";
const gradColumns = ['grad1','grad2','grad3'];
class TIfscInfo {
    constructor(vms_ifsc_id, ifsc_id, ord, ifsc_nm, strt_nm, end_nm) {
        this.vms_ifsc_id = vms_ifsc_id;
        this.ifsc_id = ifsc_id;
        this.ord = ord;
        this.ifsc_nm = ifsc_nm;
        this.strt_nm = strt_nm;
        this.end_nm = end_nm;
    }
}

class TSelObj {
    constructor(obj, color) {
        this.vms_ifsc_id = obj.vms_ifsc_id;
        this.ifsc_id = obj.ifsc_id;
        this.ord = obj.ord;
        this.ifsc_nm = obj.ifsc_nm;
        this.strt_nm = obj.strt_nm;
        this.end_nm = obj.end_nm;
        this.color = color;
    }
}
const _selObjMap = new Map();
let _selIdx = 1;

let atrdData = [];
let _editTable = null;
let _listTable = null;
let _axisYn     = null;
let _dertId     = null;
const btnClasses = [
    "vms-info-edit-btn",
    "link-copy-btn",
    "link-del-btn",
    "add-btn",
    "del-btn",
    "edit-btn",
    "save-btn",
    "cancel-btn",
    "move-down-btn",
    "move-up-btn",
    "tot-apply-btn",
];

const textClasses = [
    "vms_ifsc_nm",
    "vms_ifsc_id",
    "dspl_strt_node_nm",
    "dspl_end_node_nm",
    "road_nm",
    "spot_nm",
    "bttm_vms_ifsc_id",
    "grad1_hghssped",
    "grad2_hghssped",
    "grad3_hghssped",
    "grad1_lwstsped",
    "grad2_lwstsped",
    "grad3_lwstsped",
];

getData(_apiUri, atrdData);
const dataSource = [...atrdData[0]];
const items = [{detr_id:0, detr_desc : '0. 없음'}];
dataSource.sort(function(a, b){
    return a['vms_ifsc_id'] < b['vms_ifsc_id'] ? -1 : 1;
})
dataSource.map((item)=>{
    items.push({
        detr_id: item.vms_ifsc_id,
        detr_desc : item.vms_ifsc_id + '. ' + item.vms_ifsc_nm
    });
})
$(() => {
    _axisYn = $(".axis_yn")
        .dxCheckBox({
            text     : "축정보 생성용",
            readOnly : true,
        })
        .dxCheckBox("instance");

    _dertId = $(".detr_id")
        .dxSelectBox({
            stylingMode : "outlined",
            items       : items,
            value       : items[0].detr_id,
            displayExpr : 'detr_desc',
            valueExpr   : 'detr_id',
            height      : 25,
            width       : 250,
        })
        .dxSelectBox("instance");

    //상단 닫기 버튼
    creatBtn($(".close-btn"), "close", "닫기", null, "outlined", () => window.close());

    //VMS정보제공구간 리스트 테이블
    _listTable = $(".vms-ifsc-table")
        .width("100%")
        .height("100%")
        .dxDataGrid({
            dataSource: atrdData[0],
            allowColumnReordering: true,
            showColumnLines: true,
            allowColumnResizing: true,
            showBorders: true,
            rowAlternationEnabled: true,
            columnAutoWidth: true,
            noDataText: "표출할 정보가 없습니다.",
            focusedRowEnabled: true,
            keyExpr: "vms_ifsc_id",
            selection: {
                mode: "single",
            },
            scrolling: {
                mode: "standard",
            },
            paging: {
                enabled: true,
                pageSize: 1000,
            },
            headerFilter: {
                visible: true,
            },
            columns: [
                {
                    dataField: "vms_ifsc_id",
                    caption: "구간 ID",
                    alignment: "center",
                    sortIndex: 0,
                    sortOrder: "asc",
                    cssClass: "no-padding",
                },
                {
                    dataField: "vms_ifsc_nm",
                    caption: "제공구간명",
                    alignment: "center",
                    cssClass: "no-padding",
                    cellTemplate(c, e) {
                        let result = nullChecker(e.displayValue);
                        return $('<div style="text-align: left;">' + result + "</div>");
                    },
                },
                {
                    dataField: "dspl_strt_node_nm",
                    caption: "시점명",
                    alignment: "center",
                    cssClass: "no-padding",
                    cellTemplate(c, e) {
                        let result = nullChecker(e.displayValue);
                        return $('<div style="text-align: left;">' + result + "</div>");
                    },
                },
                {
                    dataField: "dspl_end_node_nm",
                    caption: "종점명",
                    alignment: "center",
                    cssClass: "no-padding",
                    cellTemplate(c, e) {
                        let result = nullChecker(e.displayValue);
                        return $('<div style="text-align: left;">' + result + "</div>");
                    },
                },
            ],
            onRowDblClick(row) {
                listTableDblClick(row);
            },
        })
        .dxDataGrid("instance");

    //VMS 정보제공구간 구성정보 편집 테이블
    _editTable = $(".link-edit-table")
        .width("100%")
        .height("100%")
        .dxDataGrid({
            dataSource: null,
            allowColumnReordering: true,
            showColumnLines: true,
            allowColumnResizing: true,
            showBorders: true,
            rowAlternationEnabled: true,
            focusedRowEnabled: true,
            columnAutoWidth: true,
            noDataText: "표출할 정보가 없습니다.",
            keyExpr: "ifsc_id",
            editing: {
                confirmDelete : false,
            },
            scrolling: {
                mode: "standard",
            },
            sorting: {
                mode: "none",
            },
            paging: {
                enabled: true,
                pageSize: 1000,
            },
            selection: {
                mode: "single",
            },
            columns: [
                {
                    dataField: "color",
                    caption: "-",
                    alignment: "center",
                    cssClass: "no-padding",
                    cellTemplate(c, e) {
                        c.css("background-color", EditLinkColor[e.displayValue]);
                    },
                },
                {
                    dataField: "ifsc_id",
                    caption: "구간 ID",
                    alignment: "center",
                    cssClass: "no-padding",
                },
                {
                    dataField: "ifsc_nm",
                    caption: "구간명",
                    alignment: "center",
                    cssClass: "no-padding",
                    cellTemplate(c, e) {
                        let result = nullChecker(e.displayValue);
                        return $('<div style="text-align: left;">' + result + "</div>");
                    },
                },
                {
                    dataField: "strt_nm",
                    caption: "시점명",
                    alignment: "center",
                    cssClass: "no-padding",
                    cellTemplate(c, e) {
                        let result = nullChecker(e.displayValue);
                        return $('<div style="text-align: left;">' + result + "</div>");
                    },
                },

                {
                    dataField: "end_nm",
                    caption: "종점명",
                    alignment: "center",
                    cssClass: "no-padding",
                    cellTemplate(c, e) {
                        let result = nullChecker(e.displayValue);
                        return $('<div style="text-align: left;">' + result + "</div>");
                    },
                },
            ],
            onRowDblClick(row) {
                editTableDblClick(row);
            },
        })
        .dxDataGrid("instance");

    //버튼 화면 세팅;
    fetchButtons();

    //텍스트 박스 세팅;
    fetchTextBoxes();
    //맵 세팅
    doMap();
});

/**
 * 지도
 */
function doMap() {
    _mapManager = new TMapMngr("map", "tooltip");
    _mapManager.setEditMode(LayerIndex.Vms, true);
    _mapManager.showLayer(LayerIndex.Vms, true);
    _mapManager.showFcltObjectText(LayerIndex.Vms, true);
    _mapManager.onSelectObjFunc = onSelectObjFunc; // 객체 선택 이벤트 반환
    _mapManager.setLayerVisible(_lyrIdx, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19);
    _mapManager.setEditMode(_lyrIdx, true);
    _mapManager.setSelectMode(true);
    _mapManager.setZoom(15);

    fetchBaseData();
    fetchMapIconBar($(".map-menu"), _mapManager, _lyrIdx, "VMS 정보제공구간 관리");
    _mapManager.toggleBaseMap(true);
}

function onSelectObjFunc(ALyrIdx, ALyrName, ANmbr, ACoordX, ACoordY, X, Y) {
    if (ALyrIdx != _lyrIdx) {
        return;
    }

    // 추가 또는 편집 모드가 아니면 리턴
    if(!_btnMap.get('cancel-btn').get('btn').option('visible')) return;

    let selObj = _selObjMap.get(ANmbr);
    if (selObj) {
        console.log("이미 등록된 도로 정보임....");
        return;
    }

    const ifsc = _mapManager.findIfscObject(ANmbr);
    if (ifsc) {
        const vmsIfscId = getValue(_textMap.get('vms_ifsc_id').get('text'));
        const ifscInfo = new TIfscInfo(vmsIfscId, ifsc.ID, _selObjMap.size + 1, ifsc.NAME, ifsc.STRT_NM, ifsc.END_NM);
        _selObjMap.set(ifsc.ID, new TSelObj(ifscInfo, _selIdx));

        _mapManager.updateEditLink(_lyrIdx, ifsc.ID, _selIdx, true);
        _selIdx++;
        if (_selIdx === 19) _selIdx = 1;
        const data = Array.from(_selObjMap.values());
        data.sort(function(a,b){
            return a['ord'] < b['ord'] ? -1 : 1;
        })
        _editTable.option("dataSource", data);
    }
}

async function fetchBaseData() {
    console.time("***** fetchBaseData: ");

    const road = apiGet("/api/database/ifsc/list"); // 정보제공구간정보 요청
    const vrtx = apiGet("/api/manage/main/map/vrtx/ifsc/4");
    const vms = apiGet("/api/vms/manager/info");
    Promise.all([road, vrtx, vms])
        .then((results) => Promise.all(results.map((r) => r.json())))
        .then((values) => {
            _mapManager.makeTrafficObject(_lyrType, values[0]);
            _mapManager.makeLayer(_lyrIdx, values[1]);

            //시설물 객체를 지도에 그린다.
            const objs = new Array();
            values[2].forEach((obj) => {
                const item = new TFclt(obj.vms_ctlr_nmbr, obj.vms_nm, obj.x_crdn, obj.y_crdn);
                objs.push(item);
            });
            _mapManager.initFcltObject(LayerIndex.Vms, objs);

            console.log(`BaseData, IFSC(${values[0].length}), VRTX(${values[1].length}), VMS(${values[2].length})`);
        })
        .catch((err) => {
            console.error(`Error in fetchBaseData ${err}`);
        })
        .finally(() => console.timeEnd("***** fetchBaseData: "));
}

function getNewNmbr(){
    let jsonData = [];
    getData(_apiUri + '/new-id', jsonData);
    return jsonData[0].new_id;
}

function fetchVmsIfscRltn(AVmsIfscId) {
    // 전역데이터 초기화
    if(_selObjMap.size > 0){
        _selObjMap.forEach((ifsc) => {
            _mapManager.updateEditLink(_lyrIdx, ifsc.ifsc_id, 0, false);
        });
    };
    _selObjMap.clear();
    _selIdx = 1;
    return fetchVmsIfscRltnAdd(AVmsIfscId);
}

function fetchVmsIfscRltnAdd(AVmsIfscId) {
    // 기존 데이터 지도 선택 클리어
    _selObjMap.forEach((obj) => {
        _mapManager.updateEditLink(_lyrIdx, obj.ifsc_id, 0, false);
    });

    // VMS정보제공구간에 속한 정보제공구간정보 조회
    let vmsIfscInfo = [];
    getData( _apiUri + "/" + encodeURIComponent(AVmsIfscId), vmsIfscInfo);
    if(vmsIfscInfo.length > 0){
        const insertData = {...vmsIfscInfo[0]};

        vmsIfscInfo[0].ifscs.sort(function(a,b){
            return  a['ord'] < b['ord'] ? -1 : 1;
        });
        _selObjMap.clear();
        vmsIfscInfo[0].ifscs.forEach((ifsc) => {
            _selObjMap.set(ifsc.ifsc_id, new TSelObj(ifsc, _selIdx));
            _mapManager.updateEditLink(_lyrIdx, ifsc.ifsc_id, _selIdx, false);
            _selIdx++;
            if (_selIdx === 19) _selIdx = 1;
        });

        const data = Array.from(_selObjMap.values());
        _editTable.option("dataSource", data);
        _mapManager.extentLayerObject(
            _lyrIdx,
            data.map((obj) => obj.ifsc_id)
        );
        return insertData;
    }
}
/**
 * 버튼 이벤트
 */
//편집 버튼 이벤트
function editEvent() {
    eventOn();
}

//취소 버튼 이벤트
function cancelEvent() {
    eventOff();
}

//추가 버튼 이벤트
function addEvent() {
    if(_editTable.option("dataSource")){
        _editTable.option("dataSource", []);
    }

    textBoxInit();

    if (_selObjMap.size > 0) {
        _selObjMap.forEach((obj) => {
            _mapManager.updateEditLink(_lyrIdx, obj.ifsc_id, 0, false);
        });
    };
    _selObjMap.clear();

    setValue( _textMap.get('vms_ifsc_id').get('text'),getNewNmbr());
    eventOn();
}

//이벤트 활성화
function eventOn() {
    dsblOnBtn(_listTable);
    textClasses.forEach((textClass) => {
        const textBox = _textMap.get(textClass).get("text");
        textBox.option("readOnly", false);
        if(textClass === "vms_ifsc_id") textBox.option("readOnly", true);
    });

    _axisYn.option("readOnly", false);

    btnClasses.forEach((btnClass) => {
        const btnBox = _btnMap.get(btnClass);
        if (btnBox.get("on")) {
            let visible = btnBox.get("on")[0];
            let disabled = btnBox.get("on")[1];
            btnBox.get("btn").option("visible", visible);
            btnBox.get("btn").option("disabled", disabled);
        }
    });
}

//이벤트 비활성화
function eventOff() {

    //테이블을 클릭 가능 원복
    dsblOffBtn(_listTable);
    let data = [];
    let selectedRow = null;
    let state = true;
    let vms_ifsc_id = null;

    //텍스트 박스 가리기
    textClasses.forEach((textClass) => {
        const textBox = _textMap.get(textClass).get("text");
        if (_textMap.get(textClass).get('readOnly')){
            textBox.option("readOnly", false);
        }
        else {
            textBox.option("readOnly", true);
        }
    })
    //체크 박스 가리기 
    _axisYn.option("readOnly", true);

    //선택 리스트 유무 확인
    if (_listTable.getSelectedRowsData().length > 0) {
        //선택한 로우
        selectedRow = _listTable.getRowIndexByKey(_listTable.getSelectedRowKeys()[0]);
        vms_ifsc_id = _listTable.getSelectedRowsData()[0].vms_ifsc_id;

        //id값으로 불러온다 
        const insertData = fetchVmsIfscRltn(vms_ifsc_id);
        fetchTextBoxData(insertData);
        _editTable.clearSelection();
        _editTable.option("focusedRowIndex", -1);
        state = true;
    } else {
        if(_editTable.option("dataSource") && _editTable.option("dataSource").length > 0){
            _editTable.option("dataSource", []);
        }
        textBoxInit();
        state = false;
    }

    btnClasses.forEach((btnClass) => {
        const btnBox = _btnMap.get(btnClass);
        if (btnBox.get("off")) {
            let visible = btnBox.get("off")[0];
            let unselect = btnBox.get("off")[1];
            let select = btnBox.get("off")[2];
            btnBox.get("btn").option("visible", visible);
            let disabled = state ? select : unselect;
            btnBox.get("btn").option("disabled", disabled);
        }
    });

    getData(_apiUri, data);
    _listTable.option("dataSource", data[0]);
    if (selectedRow) {
        _listTable.refresh().done(() => {
            _listTable.selectRows(vms_ifsc_id, true);
            _listTable.option("focusedRowIndex", selectedRow);
        });
    }

    btnOn = false;
}

//링크 삭제 이벤트
function linkDelBtnClick() {
    const ifscId = _editTable.getSelectedRowsData()[0].ifsc_id;

    if (ifscId) {
        _selObjMap.delete(ifscId);
        let dataSource = Array.from(_selObjMap.values())
        dataSource.sort(function(a,b){
            return a["ord"] - b["ord"];
        })
        _editTable.option('dataSource', dataSource);
        _mapManager.updateEditLink(_lyrIdx, ifscId, 0, false);
        _editTable.refresh().done(() => {
            if (nullChecker(_editTable.option("focusedRowIndex")) !== "") {
                _editTable.selectRows(_editTable.getKeyByRowIndex(_editTable.option("focusedRowIndex")), true);
            }
        });
    }
}

//위, 아래 리스트 이동 이벤트
let isMove = true;
function listMove(changeNum) {
    if (!isMove) {
        console.log("dup click. move dn");
        return;
    }
    const selRowKeys = _editTable.getSelectedRowKeys();
    if (selRowKeys == 0) {
        console.log("unselected: ", _editTable.getSelectedRowsData().length);
        return;
    }
    const selectKey = selRowKeys[0];
    const selectRow = _editTable.getRowIndexByKey(selectKey);
    const changeRow = selectRow + changeNum;
    let result = false;
    if (changeNum === 1) {
        result = changeRow < _editTable.option("dataSource").length ? true : false;
    } else {
        result = changeRow >= 0 ? true : false;
    }

    if (result) {
        isMove = false;
        const dataSource = [..._editTable.option("dataSource")];
        dataSource.sort(function (a, b) {
            return a["ord"] - b["ord"];
        });
        const selectData = { ...dataSource[selectRow] };
        const changeData = { ...dataSource[changeRow] };
        const columns = ["ifsc_id", "color", "end_nm", "f_node_id", "ifsc_nm", "road_id", "vms_ifsc_id", "road_name", "sect_lngt", "strt_nm", "t_node_id"];
        columns.forEach((column) => {
            dataSource[selectRow][column] = changeData[column];
            dataSource[changeRow][column] = selectData[column];
        });
        _selObjMap.set(dataSource[selectRow].ifsc_id, dataSource[selectRow]);
        _selObjMap.set(dataSource[changeRow].ifsc_id, dataSource[changeRow]);
        _editTable.option("dataSource", dataSource);

        _editTable.refresh().done(() => {
            _editTable.clearSelection();
            _editTable.selectRowsByIndexes(changeRow);
            _editTable.option("focusedRowIndex", changeRow);
            isMove = true;
        });
    }
}

//버튼 생성 및 화면 세팅
function fetchButtons() {
    btnClasses.forEach((btnClass) => {
        _btnMap.set(btnClass, new Map());
        const btnBox = _btnMap.get(btnClass);
        switch (btnClass) {
            case "vms-info-edit-btn":
                btnBox.set("btn", creatBtn($("." + btnClass), "edit", "VMS 정보제공구간 설정", null, "outlined", vmsIfscRltnOpen));
                btnBox.set("on", [true, false]);
                btnBox.set("off", [true, true, true]);
                break;
            case "link-del-btn":
                btnBox.set("btn", creatBtn($("." + btnClass), "minus", "삭제", null, "outlined", linkDelBtnClick, null, true, true));
                btnBox.set("on", [true, false]);
                btnBox.set("off", [true, true, true]);
                break;
            case "link-copy-btn":
                btnBox.set("btn", creatBtn($("." + btnClass), "plus", "링크복사", null, "outlined", linkCopy, null, true, true));
                btnBox.set("on", [true, false]);
                btnBox.set("off", [true, true, true]);
                break;
            case "add-btn":
                btnBox.set("btn", creatBtn($("." + btnClass), "add", "추가", null, "outlined", addEvent, null, false, true));
                btnBox.set("on", [true, true]);
                btnBox.set("off", [true, false, false]);
                break;
            case "del-btn":
                btnBox.set("btn", creatBtn($("." + btnClass), "minus", "삭제", null, "outlined", delEvent, null, true, true));
                btnBox.set("on", [true, true]);
                btnBox.set("off", [true, true, false]);
                btnBox.set("dbl", true);
                break;
            case "edit-btn":
                btnBox.set("btn", creatBtn($("." + btnClass), "edit", "편집", null, "outlined", editEvent, null, true, true));
                btnBox.set("dbl", true);
                btnBox.set("off", [true, true, false]);
                btnBox.set("on", [false, false]);
                break;
            case "save-btn":
                btnBox.set("btn", creatBtn($("." + btnClass), "save", "저장", null, "outlined", saveEvent, null, true, true));
                btnBox.set("on", [true, false]);
                btnBox.set("off", [true, true, true]);
                break;
            case "cancel-btn":
                btnBox.set("btn", creatBtn($("." + btnClass), "close", "취소", null, "outlined", cancelEvent, null, false, false));
                btnBox.set("on", [true, false]);
                btnBox.set("off", [false, false, false]);
                break;
            case "move-up-btn":
                btnBox.set("btn",creatBtn($("." + btnClass),"spinup",null,"위로","outlined",() => {listMove(-1); },null,true,true));
                btnBox.set("on", [true, false]);
                btnBox.set("off", [true, true, true]);
                break;
            case "move-down-btn":
                btnBox.set("btn",creatBtn($("." + btnClass),"spindown",null,"아래로","outlined",() => {listMove(1);},null,true,true));
                btnBox.set("on", [true, false]);
                btnBox.set("off", [true, true, true]);
                break;
            case "tot-apply-btn":
                btnBox.set("btn",creatBtn($("." + btnClass),"save",'전체 구간 적용', null,"outlined", totSaveEvent));
                btnBox.set("on", [true, false]);
                btnBox.set("off", [true, false, false]);
                break;
            default:
                break;
        }
    });
}

//텍스트 박스 생성 및 화면 세팅
function fetchTextBoxes() {
    textClasses.forEach((textClass) => {
        _textMap.set(textClass, new Map());
        const textBox  = _textMap.get(textClass);
        switch (textClass) {
            case "vms_ifsc_id":
                textBox.set("text", createText(textClass, 150, 25, true, null, 10, true,'제공구간'));
                break;
            case "vms_ifsc_nm":
                textBox.set("text", createText(textClass, 250, 25, true, null, 60, true,'제공구간명'));
                break;
            case "dspl_strt_node_nm":
                textBox.set("text", createText(textClass, 250, 25, true, null, 30, true, '표출명(시점)'));
                break;
            case "dspl_end_node_nm":
                textBox.set("text", createText(textClass, 250, 25, true, null, 30, true, '표출명(종점)'));
                break;
            case "road_nm":
                textBox.set("text", createText(textClass, 250, 25, true, null, 30, false, '도로명'));
                break;
            case "spot_nm":
                textBox.set("text", createText(textClass, 250, 25, true, null, 30, false, '지점명'));
                break;
            case "bttm_vms_ifsc_id":
                textBox.set("text", createNumberBox(textClass, 50, 25, true, null, 0, 9999999999, false, '제공구간'));
                break;
            case "grad1_hghssped":
                textBox.set("text", createNumberBox(textClass, 100, 25, false, '180', 0, 999, true, '원할 - 최고속도'));
                break;
            case "grad2_hghssped":
                textBox.set("text", createNumberBox(textClass, 100, 25, false, '30', 0, 999, true, '지체 - 최고속도'));
                break;
            case "grad3_hghssped":
                textBox.set("text", createNumberBox(textClass, 100, 25, false, '10', 0, 999, true, '정체 - 최고속도'));
                break;
            case "grad1_lwstsped":
                textBox.set("text", createNumberBox(textClass, 100, 25, false, '31', 0, 999, true, '원할 - 최저속도'));
                break;
            case "grad2_lwstsped":
                textBox.set("text", createNumberBox(textClass, 100, 25, false, '11', 0, 999, true, '지체 - 최저속도'));
                break;
            case "grad3_lwstsped":
                textBox.set("text", createNumberBox(textClass, 100, 25, false, '0', 0, 999, true, '정체 - 최저속도'));
                break;
            default:
                break;
        }
    });
}

//삭제 이벤트
function delEvent() {
    const vms_ifsc_id = _listTable.getSelectedRowsData()[0].vms_ifsc_id;
    confirmMessage("제공구간 : " + vms_ifsc_id + "<br>선택하신 VMS 정보제공구간 정보를 삭제하시겠습니까?").done((yes) => {
        if (yes === true) {
            const usage = []
            getData(_apiUri + '/usage/' + encodeURIComponent(vms_ifsc_id), usage);
            if( usage[0].count > 0) {
                return alertWarning('사용중인 VMS 정보제공구간은 삭제할 수 없습니다.');
            }
            const result = deleteData(_apiUri, vms_ifsc_id);
            if (result > 0) {
                delResultMsg("VMS 정보제공구간");
                _listTable.clearSelection();
                _listTable.option("focusedRowIndex", -1);
                eventOff();

                if (_selObjMap.size > 0) {
                    _selObjMap.forEach((obj) => {
                        _mapManager.updateEditLink(_lyrIdx, obj.ifsc_id, 0, false);
                    });
                };

                _selObjMap.clear();
                return;
            }
            //return alertConfirm("VMS 정보제공구간 정보가 삭제되지 않았습니다.");
        }
    });

}

//저장 이벤트
function saveEvent() {
    let updateData = {
        detr_id : getValue(_dertId),
        dspl_end_node_nm : null,
        dspl_strt_node_nm : null,
        road_nm : null,
        spot_nm : null,
        vms_ifsc_id : null,
        vms_ifsc_nm : null,
        axis_yn : null,
        edtn_cd : 'EDI0',
        grad1  : {
            hghssped : 0,
            lwstsped : 0,
        },
        grad2  : {
            hghssped : 0,
            lwstsped : 0,
        },
        grad3  : {
            hghssped : 0,
            lwstsped : 0,
        },
        ifscs: [],
    };

    const columns     = ['dspl_end_node_nm', 'dspl_strt_node_nm', 'road_nm', 'spot_nm', 'vms_ifsc_id', 'vms_ifsc_nm'];
    for(let textClass of textClasses){
        const textBox   = _textMap.get(textClass);
        const input     = textBox.get("text");
        const textVal   = getValue(input);
        const max       = textBox.get('max');
        const label     = textBox.get('label');
        const must      = textBox.get('must');
        const empty     = nullChecker(textVal) === "";
        if (empty) {
            if (must) {
                return alertWarning('필수 항목을 입력해주세요. [ ' + label + ' ]', null, input);
            }
        }
        else {
            if (max && getByteLength(textVal) > max) {
                return alertWarning(max+' 바이트 이내로 입력해주세요. [ ' + label + ' ]', null, input);
            }
        }
        if ( columns.includes(textClass) ){
            updateData[textClass] = textVal;
        }
    }

    updateData.axis_yn = getValue(_axisYn)? "Y": "N";
    const spedText = ['원할', '지체', '정체'];
    const frontContent = 'VMS 정보제공구간 ID : ' + updateData.vms_ifsc_id + ' (속도정보)<br>';
    let cnt = 0;
    for (let gradColumn of gradColumns) {
        const highSpeed = _textMap.get(gradColumn + "_hghssped").get("text");
        const lowSpeed  = _textMap.get(gradColumn + "_lwstsped").get("text");
        updateData[gradColumn].hghssped = Number(getValue(highSpeed));
        updateData[gradColumn].lwstsped = Number(getValue(lowSpeed));
        if (Number(getValue(lowSpeed)) >= Number(getValue(highSpeed))) {
            return alertWarning(frontContent + '소통등급 판정 [' + spedText[cnt] + '] : 최저속도가 최고속도보다 크거나 같습니다.', null, highSpeed);
        }
        cnt++;
    }

    const grad1LowSpeed = _textMap.get("grad1_lwstsped").get("text");
    const grad2Hghssped = _textMap.get("grad2_hghssped").get("text");
    const grad2LowSpeed = _textMap.get("grad2_lwstsped").get("text");
    const grad3Hghssped = _textMap.get("grad3_hghssped").get("text");

    if (Number(getValue(grad1LowSpeed)) !== Number(getValue(grad2Hghssped)) + 1) {
        return alertWarning(frontContent + '소통등급 판정 범위를 확인해주세요.', null, grad2Hghssped);
    }
    else if ( Number(getValue(grad2LowSpeed)) !== Number(getValue(grad3Hghssped)) + 1) {
        return alertWarning(frontContent + '소통등급 판정 범위를 확인해주세요.', null, grad3Hghssped);
    }
    const dataSource = _editTable.option("dataSource");

    if (dataSource && dataSource.length > 0) {
        dataSource.sort(function(a,b){
            a['color'] < b['color'] ? -1 : 1;
        })

        dataSource.map((item, idx) => {
            updateData.ifscs.push({
                ord: idx + 1,
                ifsc_id: item.ifsc_id,
            });
        });
    }

    const result = postInsertUpdate(_apiUri + '/' + encodeURIComponent(updateData.vms_ifsc_id), updateData);
    if (result > 0) {
        insResultMsg("VMS 정보제공구간");
        //테이블을 클릭 가능 원복
        dsblOffBtn(_listTable);

        //텍스트 박스 가리기
        textClasses.forEach((textClass) => {
            const textBox = _textMap.get(textClass).get("text");
            if (_textMap.get(textClass).get('readOnly')){
                textBox.option("readOnly", false);
            }
            else {
                textBox.option("readOnly", true);
            }
        })

        //체크 박스 가리기 
        _axisYn.option("readOnly", true);

        btnClasses.forEach((btnClass) => {
            const btnBox = _btnMap.get(btnClass);
            if (btnBox.get("off")) {
                let visible = btnBox.get("off")[0];
                let select = btnBox.get("off")[2];
                btnBox.get("btn").option("visible", visible);
                btnBox.get("btn").option("disabled", select);
            }
        });

        getDataAsync(_apiUri, (data)=>{
            _listTable.option("dataSource", data);
            _listTable.refresh().done(()=>{
                const key = updateData.vms_ifsc_id;
                _listTable.selectRows(key);
                _listTable.option('focusedRowKey', key);
                _listTable.navigateToRow(key)
            })
        });
    }
    //alertWarning("VMS 정보제공구간 정보가 저장되지 않았습니다.");
}

/**
 * 테이블 더블 클릭 이벤트
 */
let btnOn = false;
//간선도로 리스트 테이블 더블클릭
function listTableDblClick(row) {
    const insertData = fetchVmsIfscRltn(row.data.vms_ifsc_id);
    fetchTextBoxData(insertData);
    if (!btnOn) {
        btnClasses.forEach((btnClass) => {
            const btnBox = _btnMap.get(btnClass);
            if (btnBox.get("dbl")) {
                dsblOffBtn(btnBox.get("btn"));
            }
        });
        btnOn = true;
    }

    _editTable.option("focusedRowIndex", -1);
    _editTable.clearSelection();
}

//간선도로 편집 테이블 더블클릭
function editTableDblClick(row) {
    _mapManager.extentLayerObject(_lyrIdx, [row.data.ifsc_id]);
}

/**
 * 기타 이벤트
 */

//텍스트 상자 비우기
function textBoxInit() {
    textClasses.forEach((textClass)=>{
        const text = _textMap.get(textClass).get('text');
        setValue(text, _textMap.get(textClass).get('init'));
    })

}

//popup창 띄우기
function vmsIfscRltnOpen() {
    let name = "정보제공구간 설정";
    let page = "/application/op/06.vms/02.manager/02.vms-ifsc/02.vms-ifsc-rltn/vms-ifsc-rltn.html";
    let option = "width = 1500, height = 800, top = 100, left = 200, resizable=yes, scrollbars=no";
    window.open(page, name, option);
}

//텍스트 상자 생성
function createText(textClass, width, height, readOnly, value, maxLength, must, label) {
    const textBox  = _textMap.get(textClass);
    textBox.set('must', must);
    textBox.set('label', label);
    textBox.set('init', value);
    textBox.set('max', maxLength);
    const position = $("." + textClass);
    return position.dxTextBox({
                width       : width,
                height      : height,
                stylingMode : "outlined",
                readOnly    : readOnly,
                value       : value,
                maxLength   : maxLength,
            }).dxTextBox("instance");
}

//넘버 인풋 생성
function createNumberBox(textClass, width, height, readOnly, value, min, max, must, label) {
    const position = $("." + textClass);
    const textBox  = _textMap.get(textClass);
    textBox.set('must', must);
    textBox.set('label', label);
    textBox.set('init', value);
    textBox.set('max', max.length);
    if (!readOnly) {
        textBox.set('readOnly', true);
    }
    return position.dxNumberBox({
                width       : width,
                height      : height,
                stylingMode : "outlined",
                readOnly    : readOnly,
                value       : value,
                min         : min,
                max         : max,
            }).dxNumberBox('instance');
}

//링크 복사 이벤트
function linkCopy() {
    // TODO:화면에서 vms_ifsc_id 가지고 온다.
    const vmsIfscId = getValue(_textMap.get('bttm_vms_ifsc_id').get('text'));
    if(vmsIfscId){
        fetchVmsIfscRltnAdd(vmsIfscId);
    }
}

//전체 적용 이벤트
function totSaveEvent(){
    let ifscGradData = {
        grad1: {
            hghssped: 0,
            lwstsped: 0
        },
        grad2: {
            hghssped: 0,
            lwstsped: 0
        },
        grad3: {
            hghssped: 0,
            lwstsped: 0
        }
    };

    const frontContent = 'VMS 정보제공 구간 - 전체 구간 적용<br>';
    for(let gradColumn of gradColumns){
        const hghssped = getValue(_textMap.get(gradColumn+'_hghssped').get('text'));
        const lwstsped = getValue(_textMap.get(gradColumn+'_lwstsped').get('text'));
        ifscGradData[gradColumn].hghssped = hghssped;
        ifscGradData[gradColumn].lwstsped = lwstsped;
        if (Number(hghssped) <= Number(lwstsped)) {
            return alertWarning(frontContent + '최대속도는 최소속도보다 크거나 같을 수 없습니다.', null, _textMap.get(gradColumn+'_hghssped').get('text'));
        }
    };
    const grad1LowSpeed = _textMap.get("grad1_lwstsped").get("text");
    const grad2Hghssped = _textMap.get("grad2_hghssped").get("text");
    const grad2LowSpeed = _textMap.get("grad2_lwstsped").get("text");
    const grad3Hghssped = _textMap.get("grad3_hghssped").get("text");

    if (Number(getValue(grad1LowSpeed)) !== Number(getValue(grad2Hghssped)) + 1) {
        return alertWarning(frontContent + '소통등급 판정 범위를 확인해주세요.', null, grad2Hghssped);
    }
    else if ( Number(getValue(grad2LowSpeed)) !== Number(getValue(grad3Hghssped)) + 1) {
        return alertWarning(frontContent + '소통등급 판정 범위를 확인해주세요.', null, grad3Hghssped);
    }

    confirmMessage("VMS 정보제공구간 - 전체 구간\n소통등급 정보를 적용하시겠습니까?").done((yes) => {
        if (yes === true) {
            const result = postInsertUpdate( _apiUri + '/ifsc-grad', ifscGradData );
            if(result > 0){
                insResultMsg('VMS 정보제공구간 - 전체 구간<br>소통등급');
                eventOff();
                return;
            }
            //return alertWarning('VMS 정보제공구간 - 전체 구간<br>소통등급 정보가 저장되지 않았습니다.');
        }
    });
}

//리스트 개별 조회 내용 텍스트 상자 채우기
function fetchTextBoxData(selectData){
    if(selectData){
        textClasses.forEach((textClass) => {
            const textBox = _textMap.get(textClass).get("text");
            setValue(textBox, selectData[textClass]);
        });


        for(let gradColumn of gradColumns){
            if(selectData[gradColumn]){
                setValue(_textMap.get( gradColumn + "_hghssped").get("text"), selectData[gradColumn].hghssped);
                setValue(_textMap.get( gradColumn + "_lwstsped").get("text"), selectData[gradColumn].lwstsped);
            }
        }

        if (selectData.axis_yn) {
            let result = selectData.axis_yn === "Y" ? true : false;
            setValue(_axisYn, result);
        }
    }
}