let symblTable       = null;
let commonUri        = "/api/vms/manager/symbl-vmp0";
let symblData        = [];
let saveBtn          = null;
let cancleBtn        = null;
let addBtn           = null;
let delBtn           = null;
let editBtn          = null;
let imageNmText      = null;
let imageContentText = null;
let imageLinkText    = null;

//하단 버튼들
const btnArr    = [
    editBtn = {
        class        : "edit-btn", 
        box          : null, 
        option       : 80, 
        visible      : true, 
        disabled     : true, 
        selectdsb    : false, 
        click        : {
            visible  : true, 
            disabled : false, 
        }, 
        on           : {
            visible  : false, 
            disabled : false, 
        },
        addvsb       : false, 
        icon         : "edit", 
        text         : "편집", 
        method       : function(){
            editEvent();
        }
    }, 
    addBtn = {
        class        : "add-btn", 
        box          : null, 
        option       : 80, 
        visible      : true, 
        disabled     : false, 
        selectdsb    : false, 
        click        : {
            visible  : true, 
            disabled : false, 
        }, 
        on           : {
            visible  : true, 
            disabled : true, 
        },
        addvsb       : false, 
        icon         : "plus", 
        text         : "추가", 
        method       : function(){
            addEvent();
        }
    }, 
    delBtn = {
        class        : "del-btn", 
        box          : null, 
        option       : 80, 
        visible      : true, 
        disabled     : true, 
        selectdsb    : false, 
        click        : {
            visible  : true, 
            disabled : false, 
        }, 
        on           : {
            visible  : true, 
            disabled : true, 
        },
        addvsb       : false, 
        icon         : "minus", 
        text         : "삭제", 
        method       : function(){
            deleteEvent();
        }
    }, 
    cancleBtn = {
        class        : "cancle-btn", 
        box          : null, 
        option       : 80, 
        visible      : false, 
        disabled     : false, 
        selectdsb    : false, 
        click        : {
            visible  : false, 
            disabled : false, 
        }, 
        on           : {
            visible  : true, 
            disabled : false, 
        },
        addvsb       : true, 
        icon         : "close", 
        text         : "취소", 
        method       : function(){
            eventOff();
        }
    }, 
    saveBtn = {
        class        : "save-btn", 
        box          : null, 
        option       : 80, 
        disabled     : true, 
        selectdsb    : true, 
        click        : {
            visible  : true, 
            disabled : true, 
        }, 
        on           : {
            visible  : true, 
            disabled : false, 
        },
        adddsb       : false, 
        visible      : true, 
        icon         : "save", 
        text         : "저장",
        method       : function(){
            saveEvent();
        }
    }, 
   
]

//우측 버튼들
const textArr    = [
    imageNmText = {
        class       : "image-nm", 
        box         : null, 
        option      : 120, 
        disabled    : true, 
        method      : function(){
        }
    }, 
    imageContentText = {
        class       : "image-content", 
        box         : null, 
        option      : 250,
        maxLength   : 200,
        disabled    : true, 
        method      : function(){
        }
    },
    imageLinkText = {
        class       : "image-link-text", 
        box         : null, 
        option      : 200, 
        disabled    : true, 
        method      : function(){
        }
    },
]

getData(commonUri, symblData);

$(()=>{
    //심볼 테이블
    symblTable = $(".symbl-table").width('100%').height('100%').dxDataGrid({
        dataSource              : symblData[0], 
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'symb_lib_nmbr',
        sorting  : {
            showSortIndexes : false,
            mode            : 'none',
        },
        selection: {
            mode: 'single', 
        }, 
        scrolling: {
            mode: 'standard', 
        },
        paging :{
            enabled: true,
            pageSize : 1000,
        },
        columns:[
            {
                dataField    : "symb_lib_nmbr", 
                caption      : "번호", 
                alignment    : "center", 
                sortIndex    : 0, 
                sortOrder    : "asc",
                width        : 90,
            }, 
            {
                dataField    : "imag_data", 
                caption      : "이미지", 
                alignment    : "center",
                cellTemplate(c,e){
                    c.css('padding','3px')
                    const imgSrc = 'data:image/png;base64,'+ e.displayValue
                    return c.append($('<img src="'+imgSrc+'">'));
                }
            }, 
        ], 
      
        onRowClick(e){
            $('.symbl-image').attr('src', "data:image/png;base64," + e.data.imag_data );
            $('.image-download-link').attr('href', "data:image/png;base64," + e.data.imag_data);
            $('.image-download-link').attr('download', e.data.symb_lib_nmbr +'.bmp');
            setValue(imageNmText.box, e.data.symb_lib_nmbr);
            setValue(imageContentText.box, e.data.symb_expl);
            dsblOffBtn(imgDown);
            btnArr.map((item)=>{
                item.box.option('visible', item.click.visible);
                item.box.option('disabled', item.click.disabled);
            })
        }
    }).dxDataGrid("instance");
  
    //하단 버튼 세팅
    btnArr.map((item)=>{
        item.box = $("." + item.class).dxButton({
            icon              : item.icon, 
            width             : item.option, 
            text              : item.text, 
            visible           : item.visible, 
            disabled          : item.disabled,
            focusStateEnabled : false, 
            stylingMode       : 'outlined', 
            onClick(){
                if(item.method){
                    item.method();
                }
            }
        }).dxButton("instance")
    });

    //텍스트 상자 세팅
    textArr.map((item)=>{
        item.box = $("." + item.class).dxTextBox({
            width             : item.option, 
            disabled          : item.disabled, 
            stylingMode       : 'outlined',
            maxlength         : item.maxLength,
            height            : 30,
            onClick(){
                if(item.method){
                    item.method();
                }
            }
        }).dxTextBox("instance")
    });

    //이미지 다운로드 버튼
    imgDown = $('.image-download').dxButton({
        icon        : 'download',
        text        : '이미지 파일 저장',
        stylingMode : 'outlined',
        disabled    : true,
        onClick(){
            document.querySelector('.image-download-link').click();
        }
    }).dxButton('instance');

    //이미지 업로드 버튼
    imgLink = $(".image-link").height('31px').dxButton({
        text          : '이미지 업로드',
        icon          : 'upload',
        stylingMode   : 'outlined',
        disabled      : true,
        onClick(){
            $('#image-file').val('')
            $('#image-file').click();
        }

    }).dxButton('instance');

    closeBtn = $('.close-btn').dxButton({
        text        : '닫기',
        icon        : 'close',
        stylingMode : 'outlined',
        onClick(){
            window.close();
        }
    }).dxButton('instance');
    
    //이미지 파일 업로드 이벤트
    $('#image-file').on('change',function(){
        
        if ( $(this)[0].files[0] === undefined ) return false;

        if ( $(this)[0].files[0].size > 32000 ){
            $(this).val('');
            return alertWarning('파일 사이즈는 32KBytes를 넘을 수 없습니다. 파일 용량을 줄여주세요')
        };
        
        let reader = new FileReader();
        reader.onload = function(e) {
            var arrayBuffer = e.target.result;
            arrayBufferToBase64(arrayBuffer).then( (byte8) =>{
                $('.symbl-image').attr('src', "data:image/png;base64," + byte8 );
            })
        }
        
        reader.readAsArrayBuffer($(this)[0].files[0]);
        setValue(imageLinkText.box, $(this)[0].files[0].name); 
    });
});

//하단 편집 이벤트
function editEvent(){
    eventOn();
}

//하단 추가 이벤트
function addEvent(){
    eventOn();
    let newId = [];
    
    textArr.map((item)=>{
        setValue(item.box, ''); 
    });

    getData(commonUri + '/new-id', newId);
    console.log(newId[0]);
    setValue(imageNmText.box, newId[0].new_id);
    
    $('.symbl-image').attr('src', null);
    $('.image-download-link').attr('href', '');
    $('.image-download-link').attr('download', '');
   
}

//이벤트 시작
function eventOn(){

    btnArr.map((item)=>{
        item.box.option('visible', item.on.visible);
        item.box.option('disabled', item.on.disabled);
    });

    dsblOffBtn(imageContentText.box);
    dsblOnBtn(symblTable);
    dsblOnBtn(imgDown);
    dsblOffBtn(imgLink);

}

//이벤트 취소
function eventOff(){
    const selectedData = symblTable.getSelectedRowsData();
    
    textArr.map((item)=>{
        setValue(item.box, ''); 
    });

    btnArr.map((item)=>{
        item.box.option('visible', item.visible);
        item.box.option('disabled', item.disabled);
    });

    $('.symbl-image').attr('src', null );
    $('.image-download-link').attr('href', null);
    $('.image-download-link').attr('download', null);
    
    dsblOnBtn(imgLink);
    dsblOffBtn(symblTable);
    dsblOnBtn(imageContentText.box);
    dsblOnBtn(imgDown);
   
    if (selectedData.length > 0) {
        $('.symbl-image').attr('src', "data:image/png;base64," + selectedData[0].imag_data );
        $('.image-download-link').attr('href', "data:image/png;base64," + selectedData[0].imag_data);
        $('.image-download-link').attr('download', selectedData[0].symb_lib_nmbr +'.bmp');
        
        setValue(imageNmText.box, selectedData[0].symb_lib_nmbr);
        setValue(imageContentText.box, selectedData[0].symb_expl);
        dsblOffBtn(imgDown);

        btnArr.map((item)=>{
            item.box.option('visible', item.click.visible);
            item.box.option('disabled', item.click.disabled);
        });
    };
    
   
}

//삭제 이벤트 우측
function deleteEvent(){
    const selectedData = symblTable.getSelectedRowsData()[0];
    const id = selectedData.symb_lib_nmbr;
    let usageData = [];
    getData(commonUri + '/usage/' + encodeURIComponent(id), usageData);
    if(usageData[0] && usageData[0].count > 0){
        return alertWarning('삭제할 이미지가 VMS 폼에서 사용되고 있습니다.<br>먼저 해당 폼에서 삭제해주시기 바랍니다.');
    }
    
    const result = deleteData(commonUri, id);
    if(result > 0){
        delResultMsg('VMS 심볼 이미지');
        symblData = refresh( symblTable , symblData, commonUri );
        symblTable.refresh();
        symblTable.option('focusedRowIndex', -1);
        symblTable.clearSelection();
        eventOff();
        return false;
    }
    //return alertWarning('VMS 심볼 이미지 정보가 삭제 되지 않았습니다.')
}

//저장 이벤트
function saveEvent(){
    updateData = {};
    switch (true) {
        case nullChecker(getValue(imageNmText.box)) === "" :
            imageNmText.box.focus();
            alertWarning('이미지 번호를 입력해주세요', null, imageNmText.box);
            break;
        case nullChecker(getValue(imageContentText.box)) === "" :
            imageContentText.box.focus();
            alertWarning('이미지 설명을 입력해주세요', null, imageContentText.box);
            break;
        case getByteLength(getValue(imageContentText.box)) > imageContentText.maxLength :
            alertWarning('이미지 설명을 ' + imageContentText.maxLength + ' 바이트 이내로 입력해주세요', null, imageContentText.box);
            break;
        case nullChecker($('.symbl-image').attr('src')) === "" :
            imgLink.focus();
            alertWarning('이미지를 업로드 해주세요', null, imgLink);
            break;
        default:
            updateData['symb_lib_nmbr'] = getValue(imageNmText.box);
            updateData['symb_expl'] = getValue(imageContentText.box);
            updateData['imag_data'] = $('.symbl-image').attr('src').substring(22, $('.symbl-image').attr('src').length);
            updateData['rgst_dt'] = getSendDate(new Date());
            
            if (symblTable.getSelectedRowsData().length > 0) {
                const selectedData = symblTable.getSelectedRowsData()[0];
                updateData['rgst_dt'] = selectedData['rgst_dt'];
                let result = false;
                
                for(let key in updateData){
                    if(selectedData[key] !== updateData[key]) result = true;
                };

                if (!result){
                    alertWarning('변경 된 심볼 이미지 정보가 없습니다.');
                    break 
                } 
            }

            const result = postInsertUpdate(commonUri + '/' + encodeURIComponent(getValue(imageNmText.box)) , updateData);
            if ( result > 0 ){
                insResultMsg('VMS 심볼 이미지');
                symblData = [];
                getData(commonUri, symblData);
                symblTable.option('dataSource', symblData[0]);
                symblTable.refresh().done(() => {
                    const key = updateData.symb_lib_nmbr;
                    symblTable.clearSelection();
                    symblTable.selectRows(key, true);
                    symblTable.option('focusedRowKey', key);
                    symblTable.navigateToRow(key);
                    dsblOnBtn(imgLink);
                    dsblOffBtn(symblTable);
                    dsblOnBtn(imageContentText.box);
                    dsblOffBtn(imgDown);
                
                    btnArr.map((item)=>{
                        item.box.option('visible', item.click.visible);
                        item.box.option('disabled', item.click.disabled);
                    });
                });
                break;
            }

            //alertError('VMS 심볼 이미지 정보가 저장되지 않았습니다.');
            break;
    }

    
}

//바이트 변환 이벤트
function arrayBufferToBase64(buffer) {
    return new Promise( (succ,fail)=>{
        try {
            var binary = '';
            const bytes = new Uint8Array(buffer);
            const len = bytes.byteLength;
            for (let i = 0; i < len; i++) {
                binary += String.fromCharCode(bytes[i]);
            }
            succ( window.btoa(binary) );	    	
        } catch(e){
            console.log('to big....');
            fail(e);
        }	
    });
}



