const _apiUri         = '/api/vds/control';
let _listTable        = null;
let _listMap          = new Map();
let _selectedVdsNmber = null;
let _resetBtn         = null;
let _imgCallBtn       = null;
const _userId         = window.opener.$userId;

$(()=>{

    //CCTV 상태 전체조회 테이블
    _listTable = $(".stts-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        headerFilter: {
            visible: false,
        },
        selection  : {
            mode :'single'
        },
        keyExpr : 'ctlr_mngm_nmbr',
        paging: {
            enabled: false,
            pageSize: 1000,
        },
        selection : {
            mode  : 'single',
        },
        scrolling: {
            mode: 'standard',
        },
        columns:[
            {
                dataField    : "vds_ctlr_id",
                caption      : "제어기 ID",
                alignment    : "center",
                sortIndex    : 0,
                width        : 120,
                sortOrder    : "asc",
            },
            {
                dataField    : "vds_nm",
                caption      : "설치위치",
                alignment    : "center",
                cellTemplate(c,e){
                    c.css('text-align','left');
                    c.text(e.displayValue)
                }
            },
            {
                dataField    : "cmnc_stts_desc",
                caption      : "통신상태",
                alignment    : "center",
                width        : 80,
                cellTemplate(c,e){
                    c.css('padding','1px');
                    c.css('height','1px');
                    let classNm = e.data.cmnc_stts_cd;
                    if (!e.data.cmnc_stts_cd) {
                        classNm = 'gray';
                    }
                    const div = $("<div>");
                    div.addClass(classNm);
                    div.text(e.displayValue);
                    return c.append(div);
                }
            },
        ],
        onRowClick(info){
            listTableClick(info);
        },
    }).dxDataGrid("instance");

    _resetBtn = creatBtn($('.reset-btn'), null, '설정', '설정', 'outlined', resetEvent, 120, true, true);
    _imgCallBtn    = creatBtn($('.img-call-btn'), null, '이미지 전송 요청', '이미지 전송 요청', 'outlined', imgCallEvent, 140, true, true);
    creatBtn($(".close-btn"), "close", "닫기", "닫기", "outlined", () => window.close());

    fetchBaseData();
});

/**
 * VDS 정보 데이터 수신 함수
 * @returns
 */
function fetchBaseData(){
    let listData   = [];
    getData('/api/vds/monitoring/ctlr-stts', listData);

    if( listData.length > 0 ){
        console.log(listData);
        listData[0].map((item)=>{
            _listMap.set(item.ctlr_mngm_nmbr, item);
        });

        _listTable.option('dataSource', Array.from(_listMap.values()));
    }


};

/**
 * VDS 이미지 호출 함수
 * @returns
 */
function imgCallEvent(){
    const _vdsImg = $(".vds-img");
    let callData = {
        camera_no: 1,
        frame_no: 0,
        user_id: _userId,
    }
    getPostDataAsync(_apiUri + '/stop-image/' + _selectedVdsNmber, (jsonData)=>{
        console.log(jsonData);
        if (jsonData) {
            if (jsonData.error) {
                console.log()
                return alertError(jsonData.message);
            }
            else {
                if (jsonData.image){
                    _vdsImg.css('display', 'block');
                    _vdsImg.prop('src', 'data:image/jpg;base64,' + jsonData.image)
                
                }
            }
        }
    }, callData);

}

/**
 * VDS 제어기 리셋 함수
 * @returns
 */
function resetEvent(){
    confirmMessage('선택하신 VDS 제이기 상태를 초기화 하시겠습니까?').done((yes)=>{
        if (yes === true) {
            getPostDataAsync(_apiUri + '/reset/' + _selectedVdsNmber, (jsonData)=>{
                if (jsonData) {
                    if (jsonData.error) {
                        alertError(jsonData.message);
                    }
                    else {
                        alertConfirm(jsonData.message);
                    }
                }
            }, {user_id:_userId});
        }
    })
}

/**
 * CCTV 목록 클릭 함수
 * @returns
 */
function listTableClick(info){
    const _vdsImg = $(".vds-img");
    let selectedData = info.data;
    _selectedVdsNmber = selectedData.ctlr_mngm_nmbr;
    dsblOffBtn(_resetBtn);
    dsblOffBtn(_imgCallBtn);
    $('.vds-text').text(' [' + selectedData.vds_ctlr_id + '] - ' + selectedData.vds_nm);
    _vdsImg.css('display', 'none');
}
