/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbXMLInputStream;
import com.tmax.tibero.jdbc.TbXMLOutputStream;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TbSQLXML
implements SQLData {
    private TbConnection conn;
    private TbXMLInputStream contents;
    private TbXMLOutputStream outputStream;
    private Document docValue;
    private String strValue;
    private boolean isUsed;
    private boolean isFreed;

    public TbSQLXML(TbConnection tbConnection) {
        this.conn = tbConnection;
        this.contents = null;
        this.outputStream = null;
        this.docValue = null;
        this.strValue = null;
        this.isUsed = false;
        this.isFreed = false;
    }

    public TbSQLXML(TbConnection tbConnection, TbXMLInputStream tbXMLInputStream) {
        this.conn = tbConnection;
        this.contents = tbXMLInputStream;
        this.outputStream = null;
        this.docValue = null;
        this.strValue = null;
        this.isUsed = false;
        this.isFreed = false;
    }

    private void checkReadStatus() throws SQLException {
        if (this.strValue != null) {
            return;
        }
        if (this.contents == null) {
            throw TbError.newSQLException(-90921);
        }
        if (this.isUsed) {
            throw TbError.newSQLException(-90922);
        }
        try {
            this.contents.checkClosed();
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90920, iOException.getMessage());
        }
    }

    private void checkWriteStatus() throws SQLException {
        if (this.contents != null) {
            throw TbError.newSQLException(-90923);
        }
        if (this.isUsed) {
            throw TbError.newSQLException(-90924);
        }
    }

    private void checkXMLClosed() throws SQLException {
        if (this.isFreed || this.conn != null && this.conn.isClosed()) {
            throw TbError.newSQLException(-90920);
        }
    }

    public void free() throws SQLException {
        if (!this.isFreed) {
            this.isFreed = true;
            if (this.contents != null) {
                try {
                    this.contents.close();
                }
                catch (IOException iOException) {
                    throw TbError.newSQLException(-90925, iOException.getMessage());
                }
            }
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        this.checkXMLClosed();
        this.checkReadStatus();
        this.isUsed = true;
        return this.getValue();
    }

    public Reader getCharacterStream() throws SQLException {
        this.checkXMLClosed();
        this.checkReadStatus();
        this.isUsed = true;
        if (this.contents == null) {
            return new StringReader(this.strValue);
        }
        return new InputStreamReader(this.contents);
    }

    private final DOMSource getDOMSource() throws SQLException {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            try {
                document = documentBuilder.parse(this.contents);
            }
            catch (IOException iOException) {
                throw TbError.newSQLException(-90927, iOException.getMessage());
            }
            DOMSource dOMSource = new DOMSource(document);
            return dOMSource;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw TbError.newSQLException(-90926, parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw TbError.newSQLException(-90926, sAXException.getMessage());
        }
    }

    private final SAXSource getSAXSource() throws SQLException {
        try {
            InputSource inputSource = new InputSource(this.contents);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            SAXSource sAXSource = new SAXSource(xMLReader, inputSource);
            return sAXSource;
        }
        catch (SAXException sAXException) {
            throw TbError.newSQLException(-90926, sAXException.getMessage());
        }
    }

    public String getString() throws SQLException {
        this.checkXMLClosed();
        this.checkReadStatus();
        if (this.contents == null) {
            return this.strValue;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            while ((n = this.contents.read()) != -1) {
                stringBuffer.append((char)n);
            }
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
        return stringBuffer.toString();
    }

    public InputStream getValue() throws SQLException {
        ByteArrayInputStream byteArrayInputStream;
        this.checkXMLClosed();
        if (!this.isUsed) {
            throw TbError.newSQLException(-90929);
        }
        if (this.outputStream != null) {
            byteArrayInputStream = this.outputStream.getInputStream();
        } else if (this.docValue != null) {
            TbXMLOutputStream tbXMLOutputStream = new TbXMLOutputStream();
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                transformerFactory.newTransformer().transform(new DOMSource(this.docValue), new StreamResult(tbXMLOutputStream));
            }
            catch (TransformerException transformerException) {
                throw TbError.newSQLException(-90926, transformerException.getMessage());
            }
            byteArrayInputStream = tbXMLOutputStream.getInputStream();
        } else {
            byteArrayInputStream = new ByteArrayInputStream(this.strValue.getBytes());
        }
        this.isFreed = true;
        return byteArrayInputStream;
    }

    public OutputStream setBinaryStream() throws SQLException {
        this.checkXMLClosed();
        this.checkWriteStatus();
        this.isUsed = true;
        this.outputStream = new TbXMLOutputStream();
        return this.outputStream;
    }

    public Writer setCharacterStream() throws SQLException {
        this.checkXMLClosed();
        this.checkWriteStatus();
        this.outputStream = new TbXMLOutputStream();
        this.isUsed = true;
        return new OutputStreamWriter(this.outputStream);
    }

    public void setString(String string) throws SQLException {
        this.checkXMLClosed();
        this.checkWriteStatus();
        if (string == null) {
            throw TbError.newSQLException(-90930);
        }
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(string));
            try {
                document = documentBuilder.parse(inputSource);
            }
            catch (IOException iOException) {
                throw TbError.newSQLException(-90927, iOException.getMessage());
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw TbError.newSQLException(-90926, parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw TbError.newSQLException(-90926, sAXException.getMessage());
        }
        this.strValue = string;
        this.docValue = document;
        this.isUsed = true;
    }

    protected TbSQLXML() {
    }

    public String getSQLTypeName() throws SQLException {
        return "SYS.XMLTYPE";
    }

    public void readSQL(SQLInput sQLInput, String string) throws SQLException {
        TbClob tbClob = (TbClob)sQLInput.readClob();
        sQLInput.readString();
        sQLInput.readBlob();
        sQLInput.readBytes();
        sQLInput.readString();
        this.conn = tbClob.getConnection();
        this.contents = new TbXMLInputStream(tbClob);
        this.outputStream = null;
        this.docValue = null;
        this.strValue = null;
        this.isUsed = false;
        this.isFreed = false;
    }

    public void writeSQL(SQLOutput sQLOutput) throws SQLException {
        TbClob tbClob = this.conn.createTbClob();
        tbClob.setString(1L, this.strValue);
        sQLOutput.writeClob(tbClob);
        sQLOutput.writeString(null);
        sQLOutput.writeBlob(null);
        sQLOutput.writeBytes(null);
        sQLOutput.writeString(null);
    }
}

