/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter.method;

import org.springframework.core.MethodParameter;
import org.springframework.oxm.GenericMarshaller;
import org.springframework.oxm.GenericUnmarshaller;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.adapter.method.AbstractPayloadMethodProcessor;
import org.springframework.ws.support.MarshallingUtils;

public class MarshallingPayloadMethodProcessor
extends AbstractPayloadMethodProcessor {
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public MarshallingPayloadMethodProcessor() {
    }

    public MarshallingPayloadMethodProcessor(Marshaller marshaller) {
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        Assert.isInstanceOf(Unmarshaller.class, (Object)marshaller);
        this.setMarshaller(marshaller);
        this.setUnmarshaller((Unmarshaller)marshaller);
    }

    public MarshallingPayloadMethodProcessor(Marshaller marshaller, Unmarshaller unmarshaller) {
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        Assert.notNull((Object)unmarshaller, (String)"unmarshaller must not be null");
        this.setMarshaller(marshaller);
        this.setUnmarshaller(unmarshaller);
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    @Override
    protected boolean supportsRequestPayloadParameter(MethodParameter parameter) {
        Unmarshaller unmarshaller = this.getUnmarshaller();
        if (unmarshaller == null) {
            return false;
        }
        if (unmarshaller instanceof GenericUnmarshaller) {
            return ((GenericUnmarshaller)unmarshaller).supports(parameter.getGenericParameterType());
        }
        return unmarshaller.supports(parameter.getParameterType());
    }

    @Override
    public Object resolveArgument(MessageContext messageContext, MethodParameter parameter) throws Exception {
        Unmarshaller unmarshaller = this.getUnmarshaller();
        Assert.state((unmarshaller != null ? 1 : 0) != 0, (String)"unmarshaller must not be null");
        WebServiceMessage request = messageContext.getRequest();
        Object argument = MarshallingUtils.unmarshal(unmarshaller, request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Unmarshalled payload request to [" + argument + "]"));
        }
        return argument;
    }

    @Override
    protected boolean supportsResponsePayloadReturnType(MethodParameter returnType) {
        Marshaller marshaller = this.getMarshaller();
        if (marshaller == null) {
            return false;
        }
        if (marshaller instanceof GenericMarshaller) {
            GenericMarshaller genericMarshaller = (GenericMarshaller)marshaller;
            return genericMarshaller.supports(returnType.getGenericParameterType());
        }
        return marshaller.supports(returnType.getParameterType());
    }

    @Override
    public void handleReturnValue(MessageContext messageContext, MethodParameter returnType, Object returnValue) throws Exception {
        if (returnValue == null) {
            return;
        }
        Marshaller marshaller = this.getMarshaller();
        Assert.state((marshaller != null ? 1 : 0) != 0, (String)"marshaller must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Marshalling [" + returnValue + "] to response payload"));
        }
        WebServiceMessage response = messageContext.getResponse();
        MarshallingUtils.marshal(marshaller, returnValue, response);
    }
}

