const _textFont = [
    "bold 10px Verdana", // 0
    "bold 10px Verdana",
    "bold 10px Verdana",
    "bold 10px Verdana",
    "bold 10px Verdana",
    "bold 10px Verdana",
    "bold 10px Verdana",
    "bold 10px Verdana",
    "bold 10px Verdana",
    "bold 10px Verdana",
    "bold 10px Verdana", // 10
    "bold 10px Verdana",
    "bold 10px Verdana",
    "bold 10px Verdana",
    "bold 12px Verdana",
    "bold 12px Verdana",
    "bold 14px Verdana",
    "bold 14px Verdana",
    "bold 14px Verdana",
    "bold 16px Verdana",
    "bold 16px Verdana", // 20
    "bold 16px Verdana",
    "bold 16px Verdana",
    "bold 16px Verdana",
];
export class TPoi {
    constructor(ALyrInfo, ANmbr, AId, AName, AXCrdn, AYCrdn, AComm, ADoor, ATemp, AUpdDt) {
        this.lyrInfo = ALyrInfo;
        this.lyrIdx = ALyrInfo.lyrIdx;
        this.NMBR = ANmbr;
        this.ID = AId;
        this.NAME = AName;
        this.COMM = AComm;
        this.DOOR = ADoor;
        this.TEMP = ATemp;
        this.REG_DT = AUpdDt;
        this.LAT = Number(AXCrdn);
        this.LNG = Number(AYCrdn);
        this.marker = null;
        this.infoWin = null;
        this.edit = false;
        this.deleted = false;

        this.marker = new ol.Feature({
            obj: this,
            geometry: new ol.geom.Point([this.LAT, this.LNG]),
        });
    } // constructor

    // 상태정보 업데이트
    updateStts(AComm, AUpdDt) {
        const oldComm = this.COMM;
        this.COMM = AComm.slice(-1);
        this.REG_DT = AUpdDt;
        if (oldComm != this.COMM) {
            //상태가 변경되었거나 줌이 변경되었을때 업데이트 하도록 함
            this.setMarkerStyle(this.lyrInfo.zoom, true);
        }
    }

    // 시설물객체 스타일을 설정한다
    setMarkerStyle(ACurrZoom, AImmediate) {
        this.setEditMarkerStyle();
        // const currZoom = ACurrZoom; //this.lyrInfo.zoom;
        // console.log(_textFont[currZoom]);
        // let featureStyle = null;
        // if (this.lyrInfo.showText) {
        //     featureStyle = new ol.style.Style({
        //         image: new ol.style.Icon({
        //             anchor: [0.5, 0.5] /*아이콘 중앙*/,
        //             opacity: 1,
        //             size: [this.lyrInfo.imgW, this.lyrInfo.imgH],
        //             scale: this.lyrInfo.scales[currZoom],
        //             src: this.lyrInfo.image + this.COMM + ".png",
        //         }),
        //         text: new ol.style.Text({
        //             textAlign: "center",
        //             textBaseline: "top",
        //             font: _textFont[currZoom],
        //             //scale: 1.0,
        //             text: this.NMBR,
        //             //fill: new ol.style.Fill({ color: "#aa3300" }),
        //             //stroke: new ol.style.Stroke({ color: "#ffffff", width: 6 }),
        //             //offsetX: 0,
        //             //offsetY: (this.lyrInfo.imgW * this.lyrInfo.scales[currZoom]) / 2 - 4,
        //             placement: "Point",
        //         }),
        //     });
        // } else {
        //     featureStyle = new ol.style.Style({
        //         image: new ol.style.Icon({
        //             anchor: [0.5, 0.5] /*아이콘 중앙*/,
        //             opacity: 1,
        //             size: [this.lyrInfo.imgW, this.lyrInfo.imgH],
        //             scale: this.lyrInfo.scales[currZoom],
        //             src: this.lyrInfo.image + this.COMM + ".png",
        //         }),
        //     });
        // }
        // this.marker.setStyle(featureStyle);
    }
    // 편집용시설물객체 스타일을 설정한다
    setEditMarkerStyle() {
        const currZoom = this.lyrInfo.zoom;
        let featureStyle = null;
        if (this.lyrInfo.showText) {
            featureStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: [0.5, 0.5] /*아이콘 중앙*/,
                    opacity: 1,
                    size: [this.lyrInfo.imgW, this.lyrInfo.imgH],
                    scale: this.lyrInfo.scales[currZoom],
                    src: this.lyrInfo.image + this.COMM + ".png",
                }),
                text: new ol.style.Text({
                    textAlign: "center",
                    textBaseline: "top",
                    font: _textFont[currZoom],
                    scale: 1.0,
                    text: [this.NMBR, _textFont[currZoom]],
                    fill: new ol.style.Fill({ color: "white" }), //#aa3300
                    stroke: new ol.style.Stroke({ color: "black", width: 6 }), //#ffffff
                    backgroundFill: new ol.style.Fill({ color: "black" }),
                    offsetX: 2,
                    offsetY: (this.lyrInfo.imgW * this.lyrInfo.scales[currZoom]) / 2 + 2,
                    placement: "pooint",
                }),
            });
        } else {
            featureStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: [0.5, 0.5] /*아이콘 중앙*/,
                    opacity: 1,
                    size: [this.lyrInfo.imgW, this.lyrInfo.imgH],
                    scale: this.lyrInfo.scales[currZoom],
                    src: this.lyrInfo.image + this.COMM + ".png",
                }),
            });
        }
        this.marker.setStyle(featureStyle);
    }

    setEditObject(AIsEdit, AComm) {
        this.edit = AIsEdit;
        this.COMM = AComm;
        this.setMarkerStyle(this.lyrInfo.zoom, true);
    }
}

export class TNode extends TPoi {
    constructor(ALyrInfo, ADto) {
        super(ALyrInfo, ADto.node_id, ADto.node_id, ADto.node_name, ADto.x_crdn, ADto.y_crdn, "0", "0", 0, "");
        this.nodeType = ADto.node_type;
        this.turnP = ADto.turn_p;
        this.rmrk = ADto.rmrk;
        this.xCrdn = ADto.x_crdn;
        this.yCrdn = ADto.y_crdn;
    }
}

export class TCctv extends TPoi {
    constructor(ALyrInfo, ADto) {
        super(ALyrInfo, ADto.cctv_mngm_nmbr, ADto.cctv_ctlr_id, ADto.istl_lctn_nm, ADto.x_crdn, ADto.y_crdn, "1", "0", 0, "19700101000000");
        this.cctvCtlrIp = ADto.cctv_ctlr_ip;
        this.cctvCtlrPort = ADto.cctv_ctlr_port;
        this.cctvCaptIp = ADto.cctv_capt_ip;
        this.cctvCaptPort = ADto.cctv_capt_port;
        this.cctvFibrIp = ADto.cctv_fibr_ip;
        this.cctvEncdIp = ADto.cctv_encd_ip;
        this.strmSvrIp = ADto.strm_svr_ip;
        this.strmSvrPort = ADto.strm_svr_port;
        this.strmSesnNm = ADto.strm_sesn_nm;
        this.istlLctnAddr = ADto.istl_lctn_addr;
        this.cctvChnl = ADto.cctv_chnl;
        this.delYn = ADto.del_yn;
        this.linkId = ADto.link_id;
        this.nodeId = ADto.node_id;
        this.cctvId = ADto.cctv_id;
        this.relyPort = ADto.rely_port;
        this.strmRtspAddr = ADto.strm_rtsp_addr;
        this.strmRtmpAddr = ADto.strm_rtmp_addr;
        this.strmHttpAddr = ADto.strm_http_addr;
        this.strmStorAddr = ADto.strm_stor_addr;
        this.areaCd = ADto.area_cd;
        this.cctvType = ADto.cctv_type;
        this.cctvSbstImgn = ADto.cctv_sbst_imgn;
        this.cctvSbstDsplYn = ADto.cctv_sbst_dspl_yn;
        this.cctvAreaDvsn = ADto.cctv_area_dvsn;
        this.intrRtmpAddr = ADto.intr_rtmp_addr;
        this.syopCntlYn = ADto.syop_cntl_yn;
    }
}

export class TVms extends TPoi {
    constructor(ALyrInfo, ADto) {
        super(ALyrInfo, ADto.vms_ctlr_nmbr, ADto.vms_ctlr_id, ADto.vms_nm, ADto.x_crdn, ADto.y_crdn, "1", "0", 0, "19700101000000");
        this.vmsCtlrIp = ADto.vms_ctlr_ip;
        this.vmsUsagTypeCd = ADto.vms_usag_type_cd;
        this.vmsFrmTypeCd = ADto.vms_frm_type_cd;
        this.vmsTypeCd = ADto.vms_type_cd;
        this.vmsModlTypeCd = ADto.vms_modl_type_cd;
        this.vmsCmncPort = ADto.vms_cmnc_port;
        this.operMode = ADto.oper_mode;
        this.vmsCmncErrBassVal = ADto.vms_cmnc_err_bass_val;
        this.vmsNghtBrghStep = ADto.vms_nght_brgh_step;
        this.vmsWeekBrghStep = ADto.vms_week_brgh_step;
        this.vmsPhseChngCycl = ADto.vms_phse_chng_cycl;
        this.vmsModlErrRate = ADto.vms_modl_err_rate;
        this.cmncfailSlotNmbr = ADto.cmncfail_slot_nmbr;
        this.pwerFailSlotNmbr = ADto.pwer_fail_slot_nmbr;
        this.delYn = ADto.del_yn;
        this.cmtrinfrCnctYn = ADto.cmtrinfr_cnct_yn;
        this.wthrinfrCnctYn = ADto.wthrinfr_cnct_yn;
        this.envrinfrCnctYn = ADto.envrinfr_cnct_yn;
        this.vmsMaxPhseNum = ADto.vms_max_phse_num;
        this.panlOnTime = ADto.panl_on_time;
        this.panlOffTime = ADto.panl_off_time;
        this.panlPwerMode = ADto.panl_pwer_mode;
        this.brghMode = ADto.brgh_mode;
        this.webCmraIp = ADto.web_cmra_ip;
        this.istlLctnNm = ADto.istl_lctn_nm;
        this.trfcStrgUseYn = ADto.trfc_strg_use_yn;
        this.vmsLocIfscId = ADto.vms_loc_ifsc_id;
        this.fanMtnsTmpr = ADto.fan_mtns_tmpr;
        this.hetrMtnsTmpr = ADto.hetr_mtns_tmpr;
        this.webCmraPort = ADto.web_cmra_port;
        this.webCmraId = ADto.web_cmra_id;
        this.webCmraPwd = ADto.web_cmra_pwd;
        this.strmSesnNm = ADto.strm_sesn_nm;
        this.strmHttpAddr = ADto.strm_http_addr;
        this.strmRsptAddr = ADto.strm_rstp_addr;
    }
}

export class TVds extends TPoi {
    constructor(ALyrInfo, ADto) {
        super(ALyrInfo, ADto.ctlr_mngm_nmbr, ADto.vds_ctlr_id, ADto.lctn, ADto.x_crdn, ADto.y_crdn, "1", "0", 0, "19700101000000");
        this.ctlrTypeCd = ADto.ctlr_type_cd;
        this.valdYn = ADto.vald_yn;
        this.trmnIp = ADto.trmn_ip;
        this.trmnPort = ADto.trmn_port;
        this.ctlrClctCycl = ADto.ctlr_clct_cycl;
        this.ctlrSttsCycl = ADto.ctlr_stts_cycl;
        this.loopBordNum = ADto.loop_bord_num;
        this.delYn = ADto.del_yn;
    }
}

export class TRse extends TPoi {
    constructor(ALyrInfo, ADto) {
        super(ALyrInfo, ADto.rseid, ADto.rseid, ADto.location, ADto.coordx, ADto.coordy, "1", "0", 0, "19700101000000");
        this.instdt = ADto.instdt;
        this.citycd = ADto.citycd;
        this.regioncd = ADto.regioncd;
        this.areacd = ADto.areacd;
        this.rseip = ADto.rseip;
        this.radius1 = ADto.radius1;
        this.radius2 = ADto.radius2;
        this.compcd = ADto.compcd;
        this.rseconfigid = ADto.rseconfigid;
        this.obeparamid = ADto.obeparamid;
        this.port = ADto.port;
        this.bridge = ADto.bridge;
        this.comyn = ADto.comyn;
        this.commtype = ADto.commtype;
    }
}

export class TBit extends TPoi {
    constructor(ALyrInfo, ADto) {
        super(ALyrInfo, ADto.bitid, ADto.localno, ADto.bitname, ADto.coordx, ADto.coordy, "1", "0", 0, "19700101000000");
        this.instdt = ADto.regdate;
        this.address = ADto.address;
        // this.regioncd    = ADto.regioncd;
        // this.areacd      = ADto.areacd;
        // this.rseip       = ADto.rseip;
        // this.radius1     = ADto.radius1;
        // this.radius2     = ADto.radius2;
        // this.compcd      = ADto.compcd;
        // this.rseconfigid = ADto.rseconfigid;
        // this.obeparamid  = ADto.obeparamid;
        // this.port        = ADto.port;
        // this.bridge      = ADto.bridge;
        // this.comyn       = ADto.comyn;
        // this.commtype    = ADto.commtype;
    }
}

export class TStation extends TPoi {
    constructor(ALyrInfo, ADto) {
        const commStts = ADto.turnseq >= ADto.stationorder ? "0" : "1";
        super(ALyrInfo, ADto.stationid, ADto.stationid, ADto.stationname, ADto.coordx, ADto.coordy, commStts, "0", 0, "19700101000000");
        this.stationtype = ADto.stationtype;
    }
}
export class TBit2 extends TPoi {
    constructor(ALyrInfo, ADto) {
        super(ALyrInfo, ADto.bitid, ADto.localno, ADto.bitname, ADto.coordx, ADto.coordy, "1", "0", 0, "19700101000000");
    }
}
export class TBus extends TPoi {
    constructor(ALyrInfo, ADto, AOrder) {
        super(ALyrInfo, ADto.vehid, ADto.vehid, ADto.plateno, ADto.coordx, ADto.coordy, "0", "0", 0, "19700101000000");
        this.order = AOrder;
        this.instdt = ADto.collectdate;
        this.stationname = ADto.stationname;
    }
}

export class TPark extends TPoi {
    constructor(ALyrInfo, ADto) {
        super(ALyrInfo, ADto.parkingid, ADto.parkingid, ADto.parkingname, ADto.coordx, ADto.coordy, "0", "0", 0, "19700101000000");
        this.location = ADto.location;
        this.address = ADto.address;
        this.phone = ADto.phone;
        this.parkingCnt = ADto.parkingcnt;
        this.pisFlag = ADto.pisflag;
        this.districtId = ADto.districtid;
        this.parkingEName = ADto.parkingename;
        this.eLocation = ADto.elocation;
        this.eAddress = ADto.eaddress;
    }
}

export class TIncident extends TPoi {
    constructor(ALyrInfo, ADto) {
        super(ALyrInfo, ADto.incd_ocrr_id, ADto.incd_ocrr_id, ADto.incd_titl, ADto.x_crdn, ADto.y_crdn, ADto.incd_type_clsf_cd, 0, ADto.rgst_dt, ADto.rgst_dt);
        this.STR_DT = ADto.incd_strt_dt;
        this.END_DT = ADto.incd_end_prar_dt;
        this.TITLE = ADto.incd_titl;
        this.INCTYPENM = ADto.incd_type_clsf_desc;
        this.INCLOC = ADto.ocrr_lctn_nm;
        this.LINK_ID = ADto.link_id == null ? 0 : Number(ADto.link_id);
    }
}
